/*
 * Decompiled with CFR 0.152.
 */
package jpdf.attribute;

import java.io.Serializable;

public abstract class LengthSyntax
implements Serializable,
Cloneable {
    public static final int INCH = 25400;
    public static final int MM = 1000;
    private static final long serialVersionUID = 120L;
    private final int b;

    protected LengthSyntax(float f2, boolean bl) {
        this(f2, bl ? 25400 : 1000);
    }

    protected LengthSyntax(float f2, int n2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("The Length cannot be less than zero.");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("The Units Conversion Factor cannot be less than zero.");
        }
        this.b = (int)(f2 * (float)n2 + 0.5f);
    }

    public boolean equals(Object object) {
        if (!(object instanceof LengthSyntax)) {
            return false;
        }
        return this.b == ((LengthSyntax)object).getLengthInMicrons();
    }

    public float getLength(boolean bl) {
        return LengthSyntax.a(this.b, bl ? 25400 : 1000);
    }

    public float getLength(int n2) {
        return LengthSyntax.a(this.b, n2);
    }

    public int hashCode() {
        return this.b;
    }

    public String toString() {
        return this.b + " um" + " (" + LengthSyntax.a(this.b, 25400) + " inches)";
    }

    protected int getLengthInMicrons() {
        return this.b;
    }

    private static float a(int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("The Units Conversion Factor cannot be less than zero.");
        }
        return (float)n2 / (float)n3;
    }
}

