/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.BasicMarqueeHandler;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultCellViewFactory;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultGraphSelectionModel;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphSelectionModel;
import org.jgraph.graph.PortView;
import org.jgraph.plaf.GraphUI;
import org.jgraph.plaf.basic.BasicGraphUI;

public class JGraph
extends JComponent
implements Scrollable,
Accessible,
Serializable {
    public static final String VERSION = "JGraph (v5.7.4.5)";
    public static final int DOT_GRID_MODE = 0;
    public static final int CROSS_GRID_MODE = 1;
    public static final int LINE_GRID_MODE = 2;
    private static final String uiClassID = "GraphUI";
    protected transient GraphSelectionRedirector selectionRedirector;
    protected transient GraphModel graphModel;
    protected transient GraphLayoutCache graphLayoutCache;
    protected transient GraphSelectionModel selectionModel;
    protected transient BasicMarqueeHandler marquee;
    protected double scale = 1.0;
    protected boolean antiAliased = false;
    protected boolean editable = true;
    protected boolean selectionEnabled = true;
    protected boolean previewInvalidNullPorts = true;
    protected boolean gridVisible = false;
    protected double gridSize = 10.0;
    protected int gridMode = 0;
    protected boolean portsVisible = false;
    protected boolean portsScaled = true;
    protected boolean moveBelowZero = false;
    protected boolean autoResizeGraph = true;
    protected Color highlightColor = Color.green;
    protected Color handleColor;
    protected Color lockedHandleColor;
    protected Color marqueeColor;
    protected Color gridColor;
    protected boolean dragEnabled = false;
    protected boolean dropEnabled = true;
    protected int editClickCount = 2;
    protected boolean enabled = true;
    protected boolean gridEnabled = false;
    protected int handleSize = 3;
    protected int tolerance = 4;
    protected int minimumMove = 5;
    protected boolean isJumpToDefaultPort = false;
    protected boolean isMoveIntoGroups = false;
    protected boolean isMoveOutOfGroups = false;
    protected boolean disconnectOnMove = false;
    protected boolean moveable = true;
    protected boolean cloneable = false;
    protected boolean sizeable = true;
    protected boolean bendable = true;
    protected boolean connectable = true;
    protected boolean disconnectable = true;
    protected boolean invokesStopCellEditing;
    public static final String GRAPH_MODEL_PROPERTY = "model";
    public static final String GRAPH_LAYOUT_CACHE_PROPERTY = "view";
    public static final String MARQUEE_HANDLER_PROPERTY = "marquee";
    public static final String EDITABLE_PROPERTY = "editable";
    public static final String SELECTIONENABLED_PROPERTY = "selectionEnabled";
    public static final String SCALE_PROPERTY = "scale";
    public static final String ANTIALIASED_PROPERTY = "antiAliased";
    public static final String GRID_SIZE_PROPERTY = "gridSize";
    public static final String GRID_VISIBLE_PROPERTY = "gridVisible";
    public static final String GRID_COLOR_PROPERTY = "gridColor";
    public static final String HANDLE_COLOR_PROPERTY = "handleColor";
    public static final String HANDLE_SIZE_PROPERTY = "handleSize";
    public static final String LOCKED_HANDLE_COLOR_PROPERTY = "lockedHandleColor";
    public static final String PORTS_VISIBLE_PROPERTY = "portsVisible";
    public static final String PORTS_SCALED_PROPERTY = "portsScaled";
    public static final String SELECTION_MODEL_PROPERTY = "selectionModel";
    public static final String INVOKES_STOP_CELL_EDITING_PROPERTY = "invokesStopCellEditing";
    static /* synthetic */ Class class$org$jgraph$event$GraphSelectionListener;

    public static void addSampleData(GraphModel graphModel) {
        ConnectionSet connectionSet = new ConnectionSet();
        Hashtable<DefaultGraphCell, Map> hashtable = new Hashtable<DefaultGraphCell, Map>();
        AttributeMap attributeMap = new AttributeMap();
        GraphConstants.setLineBegin(attributeMap, 2);
        GraphConstants.setBeginSize(attributeMap, 10);
        GraphConstants.setDashPattern(attributeMap, new float[]{3.0f, 3.0f});
        GraphConstants.setFont(attributeMap, GraphConstants.DEFAULTFONT.deriveFont(10));
        AttributeMap attributeMap2 = new AttributeMap();
        GraphConstants.setLineBegin(attributeMap2, 2);
        GraphConstants.setBeginFill(attributeMap2, true);
        GraphConstants.setBeginSize(attributeMap2, 10);
        GraphConstants.setFont(attributeMap2, GraphConstants.DEFAULTFONT.deriveFont(10));
        AttributeMap attributeMap3 = new AttributeMap();
        GraphConstants.setLineBegin(attributeMap3, 9);
        GraphConstants.setBeginFill(attributeMap3, true);
        GraphConstants.setBeginSize(attributeMap3, 6);
        GraphConstants.setLineEnd(attributeMap3, 4);
        GraphConstants.setEndSize(attributeMap3, 8);
        GraphConstants.setLabelPosition(attributeMap3, new Point2D.Double(500.0, 0.0));
        GraphConstants.setFont(attributeMap3, GraphConstants.DEFAULTFONT.deriveFont(10));
        DefaultGraphCell defaultGraphCell = new DefaultGraphCell("GraphModel");
        hashtable.put(defaultGraphCell, JGraph.createBounds(new AttributeMap(), 20, 100, Color.blue));
        defaultGraphCell.addPort(null, "GraphModel/Center");
        DefaultGraphCell defaultGraphCell2 = new DefaultGraphCell("DefaultGraphModel");
        hashtable.put(defaultGraphCell2, JGraph.createBounds(new AttributeMap(), 20, 180, Color.blue));
        defaultGraphCell2.addPort(null, "DefaultGraphModel/Center");
        DefaultEdge defaultEdge = new DefaultEdge("implements");
        connectionSet.connect((Object)defaultEdge, (Object)defaultGraphCell.getChildAt(0), defaultGraphCell2.getChildAt(0));
        hashtable.put(defaultEdge, attributeMap);
        DefaultGraphCell defaultGraphCell3 = new DefaultGraphCell("ModelGroup");
        defaultGraphCell3.add(defaultGraphCell);
        defaultGraphCell3.add(defaultGraphCell2);
        defaultGraphCell3.add(defaultEdge);
        DefaultGraphCell defaultGraphCell4 = new DefaultGraphCell("JComponent");
        hashtable.put(defaultGraphCell4, JGraph.createBounds(new AttributeMap(), 180, 20, Color.green));
        defaultGraphCell4.addPort(null, "JComponent/Center");
        DefaultGraphCell defaultGraphCell5 = new DefaultGraphCell("JGraph");
        hashtable.put(defaultGraphCell5, JGraph.createBounds(new AttributeMap(), 180, 100, Color.green));
        defaultGraphCell5.addPort(null, "JGraph/Center");
        DefaultEdge defaultEdge2 = new DefaultEdge("extends");
        connectionSet.connect((Object)defaultEdge2, (Object)defaultGraphCell4.getChildAt(0), defaultGraphCell5.getChildAt(0));
        hashtable.put(defaultEdge2, attributeMap2);
        DefaultGraphCell defaultGraphCell6 = new DefaultGraphCell("ComponentUI");
        hashtable.put(defaultGraphCell6, JGraph.createBounds(new AttributeMap(), 340, 20, Color.red));
        defaultGraphCell6.addPort(null, "ComponentUI/Center");
        DefaultGraphCell defaultGraphCell7 = new DefaultGraphCell(uiClassID);
        hashtable.put(defaultGraphCell7, JGraph.createBounds(new AttributeMap(), 340, 100, Color.red));
        defaultGraphCell7.addPort(null, "GraphUI/Center");
        DefaultGraphCell defaultGraphCell8 = new DefaultGraphCell("BasicGraphUI");
        hashtable.put(defaultGraphCell8, JGraph.createBounds(new AttributeMap(), 340, 180, Color.red));
        defaultGraphCell8.addPort(null, "BasicGraphUI/Center");
        DefaultEdge defaultEdge3 = new DefaultEdge("extends");
        connectionSet.connect((Object)defaultEdge3, (Object)defaultGraphCell6.getChildAt(0), defaultGraphCell7.getChildAt(0));
        hashtable.put(defaultEdge3, attributeMap2);
        DefaultEdge defaultEdge4 = new DefaultEdge("implements");
        connectionSet.connect((Object)defaultEdge4, (Object)defaultGraphCell7.getChildAt(0), defaultGraphCell8.getChildAt(0));
        hashtable.put(defaultEdge4, attributeMap);
        DefaultGraphCell defaultGraphCell9 = new DefaultGraphCell("UIGroup");
        defaultGraphCell9.add(defaultGraphCell6);
        defaultGraphCell9.add(defaultGraphCell7);
        defaultGraphCell9.add(defaultGraphCell8);
        defaultGraphCell9.add(defaultEdge4);
        defaultGraphCell9.add(defaultEdge3);
        DefaultEdge defaultEdge5 = new DefaultEdge(GRAPH_MODEL_PROPERTY);
        connectionSet.connect((Object)defaultEdge5, (Object)defaultGraphCell5.getChildAt(0), defaultGraphCell.getChildAt(0));
        hashtable.put(defaultEdge5, attributeMap3);
        DefaultEdge defaultEdge6 = new DefaultEdge("ui");
        connectionSet.connect((Object)defaultEdge6, (Object)defaultGraphCell4.getChildAt(0), defaultGraphCell6.getChildAt(0));
        hashtable.put(defaultEdge6, attributeMap3);
        Object[] objectArray = new Object[]{defaultEdge5, defaultEdge6, defaultGraphCell3, defaultGraphCell4, defaultGraphCell5, defaultEdge2, defaultGraphCell9};
        graphModel.insert(objectArray, hashtable, connectionSet, null, null);
    }

    public static Map createBounds(AttributeMap attributeMap, int n, int n2, Color color) {
        GraphConstants.setBounds(attributeMap, attributeMap.createRect(n, n2, 90.0, 30.0));
        GraphConstants.setBorder(attributeMap, BorderFactory.createRaisedBevelBorder());
        GraphConstants.setBackground(attributeMap, color.darker().darker());
        GraphConstants.setGradientColor(attributeMap, color.brighter().brighter().brighter());
        GraphConstants.setForeground(attributeMap, Color.white);
        GraphConstants.setFont(attributeMap, GraphConstants.DEFAULTFONT.deriveFont(1, 12.0f));
        GraphConstants.setOpaque(attributeMap, true);
        return attributeMap;
    }

    public JGraph() {
        this((GraphModel)null);
    }

    public JGraph(GraphModel graphModel) {
        this(graphModel, (GraphLayoutCache)null);
    }

    public JGraph(GraphLayoutCache graphLayoutCache) {
        this(graphLayoutCache != null ? graphLayoutCache.getModel() : null, graphLayoutCache);
    }

    public JGraph(GraphModel graphModel, GraphLayoutCache graphLayoutCache) {
        this(graphModel, graphLayoutCache, new BasicMarqueeHandler());
    }

    public JGraph(GraphModel graphModel, BasicMarqueeHandler basicMarqueeHandler) {
        this(graphModel, null, basicMarqueeHandler);
    }

    public JGraph(GraphModel graphModel, GraphLayoutCache graphLayoutCache, BasicMarqueeHandler basicMarqueeHandler) {
        this.setDoubleBuffered(true);
        this.selectionModel = new DefaultGraphSelectionModel(this);
        this.setLayout(null);
        this.marquee = basicMarqueeHandler;
        if (graphModel == null) {
            graphModel = new DefaultGraphModel();
            this.setModel(graphModel);
            JGraph.addSampleData(graphModel);
        } else {
            this.setModel(graphModel);
        }
        if (graphLayoutCache == null) {
            graphLayoutCache = new GraphLayoutCache(graphModel, new DefaultCellViewFactory());
        }
        this.setGraphLayoutCache(graphLayoutCache);
        this.updateUI();
    }

    public GraphUI getUI() {
        return (GraphUI)this.ui;
    }

    public void setUI(GraphUI graphUI) {
        if ((GraphUI)this.ui != graphUI) {
            super.setUI(graphUI);
        }
    }

    public void updateUI() {
        this.setUI(new BasicGraphUI());
        this.invalidate();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public Object[] getRoots() {
        return DefaultGraphModel.getRoots(this.graphModel);
    }

    public Object[] getRoots(Rectangle rectangle) {
        CellView[] cellViewArray = this.graphLayoutCache.getRoots(rectangle);
        Object[] objectArray = new Object[cellViewArray.length];
        for (int i = 0; i < cellViewArray.length; ++i) {
            objectArray[i] = cellViewArray[i].getCell();
        }
        return objectArray;
    }

    public Object[] getDescendants(Object[] objectArray) {
        return DefaultGraphModel.getDescendants(this.getModel(), objectArray).toArray();
    }

    public Object[] order(Object[] objectArray) {
        return DefaultGraphModel.order(this.getModel(), objectArray);
    }

    public Map cloneCells(Object[] objectArray) {
        return this.graphModel.cloneCells(objectArray);
    }

    public CellView getTopmostViewAt(double d, double d2, boolean bl, boolean bl2) {
        int n;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, 1.0, 1.0);
        Object[] objectArray = this.getDescendants(this.getRoots());
        int n2 = n = bl ? objectArray.length - 1 : 0;
        while (n >= 0 && n < objectArray.length) {
            CellView cellView = this.getGraphLayoutCache().getMapping(objectArray[n], false);
            if (cellView != null && (!bl2 || cellView.isLeaf()) && (cellView.isLeaf() && cellView.intersects(this, double_) || !cellView.isLeaf() && cellView.getBounds().contains(d, d2))) {
                return cellView;
            }
            n += bl ? -1 : 1;
        }
        return null;
    }

    public Object getFirstCellForLocation(double d, double d2) {
        return this.getNextCellForLocation(null, d, d2);
    }

    public Object getNextCellForLocation(Object object, double d, double d2) {
        CellView cellView = this.graphLayoutCache.getMapping(object, false);
        CellView cellView2 = this.getNextViewAt(cellView, d, d2);
        if (cellView2 != null) {
            return cellView2.getCell();
        }
        return null;
    }

    public Rectangle2D getCellBounds(Object object) {
        CellView cellView = this.graphLayoutCache.getMapping(object, false);
        if (cellView != null) {
            return cellView.getBounds();
        }
        return null;
    }

    public Rectangle2D getCellBounds(Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            Rectangle2D rectangle2D = this.getCellBounds(objectArray[0]);
            Rectangle2D rectangle2D2 = rectangle2D != null ? (Rectangle2D)rectangle2D.clone() : null;
            for (int i = 1; i < objectArray.length; ++i) {
                rectangle2D = this.getCellBounds(objectArray[i]);
                if (rectangle2D == null) continue;
                if (rectangle2D2 == null) {
                    rectangle2D2 = rectangle2D != null ? (Rectangle2D)rectangle2D.clone() : null;
                    continue;
                }
                Rectangle2D.union(rectangle2D2, rectangle2D, rectangle2D2);
            }
            return rectangle2D2;
        }
        return null;
    }

    public CellView getNextViewAt(CellView cellView, double d, double d2) {
        return this.getNextViewAt(cellView, d, d2, false);
    }

    public CellView getNextViewAt(CellView cellView, double d, double d2, boolean bl) {
        CellView[] cellViewArray = AbstractCellView.getDescendantViews(this.getGraphLayoutCache().getRoots());
        return this.getNextViewAt(cellViewArray, cellView, d, d2, bl);
    }

    public CellView getNextSelectableViewAt(CellView cellView, double d, double d2) {
        CellView[] cellViewArray = this.getGraphLayoutCache().getMapping(this.getSelectionModel().getSelectables(), false);
        return this.getNextViewAt(cellViewArray, cellView, d, d2);
    }

    public CellView getNextViewAt(CellView[] cellViewArray, CellView cellView, double d, double d2) {
        return this.getNextViewAt(cellViewArray, cellView, d, d2, false);
    }

    public CellView getNextViewAt(CellView[] cellViewArray, CellView cellView, double d, double d2, boolean bl) {
        if (cellViewArray != null) {
            Rectangle2D rectangle2D = this.fromScreen(new Rectangle2D.Double(d - (double)this.tolerance, d2 - (double)this.tolerance, 2 * this.tolerance, 2 * this.tolerance));
            CellView cellView2 = null;
            boolean bl2 = cellView == null;
            for (int i = 0; i < cellViewArray.length; ++i) {
                if (cellViewArray[i] == null || bl && !cellViewArray[i].isLeaf() || !cellViewArray[i].intersects(this, rectangle2D)) continue;
                if (bl2 && !this.selectionModel.isChildrenSelected(cellViewArray[i].getCell())) {
                    return cellViewArray[i];
                }
                if (cellView2 == null) {
                    cellView2 = cellViewArray[i];
                }
                bl2 |= cellViewArray[i] == cellView;
            }
            if (cellView2 != null) {
                return cellView2;
            }
        }
        return null;
    }

    public CellView getLeafViewAt(double d, double d2) {
        return this.getNextViewAt(null, d, d2, true);
    }

    public Object getPortForLocation(double d, double d2) {
        PortView portView = this.getPortViewAt(d, d2, this.tolerance);
        if (portView != null) {
            return portView.getCell();
        }
        return null;
    }

    public PortView getPortViewAt(double d, double d2) {
        return this.getPortViewAt(d, d2, this.tolerance);
    }

    public PortView getPortViewAt(double d, double d2, int n) {
        double d3 = d / this.scale;
        double d4 = d2 / this.scale;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3 - (double)n, d4 - (double)n, 2 * n, 2 * n);
        PortView[] portViewArray = this.graphLayoutCache.getPorts();
        if (portViewArray != null) {
            for (int i = portViewArray.length - 1; i >= 0; --i) {
                if (portViewArray[i] == null || !portViewArray[i].intersects(this, double_)) continue;
                return portViewArray[i];
            }
            if (this.isJumpToDefaultPort()) {
                CellView cellView;
                CellView cellView2 = this.getNextViewAt(null, d, d2, true);
                if (cellView2 != null && this.graphModel.isEdge(cellView2.getCell())) {
                    cellView = this.getNextViewAt(cellView2, d, d2, true);
                    while (cellView != cellView2 && this.graphModel.isEdge(cellView.getCell())) {
                        cellView = this.getNextViewAt(cellView, d, d2, true);
                    }
                    cellView2 = cellView;
                }
                if (cellView2 != null) {
                    cellView = this.getDefaultPortForCell(cellView2.getCell());
                    return cellView;
                }
            }
        }
        return null;
    }

    public PortView getDefaultPortForCell(Object object) {
        if (object != null && !this.getModel().isEdge(object)) {
            int n = this.getModel().getChildCount(object);
            for (int i = 0; i < n; ++i) {
                Point2D point2D;
                Object object2 = this.getModel().getChild(object, i);
                CellView cellView = this.getGraphLayoutCache().getMapping(object2, false);
                if (!(cellView instanceof PortView) || (point2D = GraphConstants.getOffset(cellView.getAllAttributes())) != null && n != 1) continue;
                return (PortView)cellView;
            }
        }
        return null;
    }

    public String convertValueToString(Object object) {
        if (object instanceof CellView) {
            object = ((CellView)object).getCell();
        }
        return String.valueOf(object);
    }

    public Point2D snap(Point2D point2D) {
        if (this.gridEnabled && point2D != null) {
            double d = this.gridSize * this.getScale();
            point2D.setLocation(Math.round((double)Math.round(point2D.getX() / d) * d), Math.round((double)Math.round(point2D.getY() / d) * d));
        }
        return point2D;
    }

    public Rectangle2D snap(Rectangle2D rectangle2D) {
        if (this.gridEnabled && rectangle2D != null) {
            double d = this.gridSize * this.getScale();
            rectangle2D.setFrame(Math.round((double)Math.round(rectangle2D.getX() / d) * d), Math.round((double)Math.round(rectangle2D.getY() / d) * d), 1L + Math.round((double)Math.round(rectangle2D.getWidth() / d) * d), 1L + Math.round((double)Math.round(rectangle2D.getHeight() / d) * d));
        }
        return rectangle2D;
    }

    public Dimension2D snap(Dimension2D dimension2D) {
        if (this.gridEnabled && dimension2D != null) {
            double d = this.gridSize * this.getScale();
            dimension2D.setSize(1L + Math.round((double)Math.round(dimension2D.getWidth() / d) * d), 1L + Math.round((double)Math.round(dimension2D.getHeight() / d) * d));
        }
        return dimension2D;
    }

    public Point2D toScreen(Point2D point2D) {
        if (point2D == null) {
            return null;
        }
        point2D.setLocation(Math.round(point2D.getX() * this.scale), Math.round(point2D.getY() * this.scale));
        return point2D;
    }

    public Point2D fromScreen(Point2D point2D) {
        if (point2D == null) {
            return null;
        }
        point2D.setLocation(Math.round(point2D.getX() / this.scale), Math.round(point2D.getY() / this.scale));
        return point2D;
    }

    public Rectangle2D toScreen(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            return null;
        }
        rectangle2D.setFrame(rectangle2D.getX() * this.scale, rectangle2D.getY() * this.scale, rectangle2D.getWidth() * this.scale, rectangle2D.getHeight() * this.scale);
        return rectangle2D;
    }

    public Rectangle2D fromScreen(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            return null;
        }
        rectangle2D.setFrame(rectangle2D.getX() / this.scale, rectangle2D.getY() / this.scale, rectangle2D.getWidth() / this.scale, rectangle2D.getHeight() / this.scale);
        return rectangle2D;
    }

    public void updateAutoSize(CellView cellView) {
        if (cellView != null && !this.isEditing()) {
            Rectangle2D rectangle2D = cellView.getAttributes() != null ? GraphConstants.getBounds(cellView.getAttributes()) : null;
            AttributeMap attributeMap = this.getModel().getAttributes(cellView.getCell());
            if (rectangle2D == null) {
                rectangle2D = GraphConstants.getBounds(attributeMap);
            }
            if (rectangle2D != null) {
                boolean bl = GraphConstants.isAutoSize(cellView.getAllAttributes());
                boolean bl2 = GraphConstants.isResize(cellView.getAllAttributes());
                if (bl || bl2) {
                    Dimension2D dimension2D = this.getUI().getPreferredSize(this, cellView);
                    rectangle2D.setFrame(rectangle2D.getX(), rectangle2D.getY(), dimension2D.getWidth(), dimension2D.getHeight());
                    this.snap(rectangle2D);
                    if (bl2) {
                        if (cellView.getAttributes() != null) {
                            cellView.getAttributes().remove("resize");
                        }
                        attributeMap.remove("resize");
                    }
                    cellView.refresh(this.getModel(), this.getGraphLayoutCache(), false);
                }
            }
        }
    }

    public AttributeMap getAttributes(Object object) {
        CellView cellView = this.getGraphLayoutCache().getMapping(object, false);
        AttributeMap attributeMap = cellView != null ? cellView.getAllAttributes() : this.getModel().getAttributes(object);
        return attributeMap;
    }

    public int getEditClickCount() {
        return this.editClickCount;
    }

    public void setEditClickCount(int n) {
        this.editClickCount = n;
    }

    public boolean isDropEnabled() {
        return this.dropEnabled;
    }

    public void setDropEnabled(boolean bl) {
        this.dropEnabled = bl;
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean bl) {
        this.dragEnabled = bl;
    }

    public boolean isMoveable() {
        return this.moveable;
    }

    public void setMoveable(boolean bl) {
        this.moveable = bl;
    }

    public boolean isBendable() {
        return this.bendable;
    }

    public void setBendable(boolean bl) {
        this.bendable = bl;
    }

    public boolean isConnectable() {
        return this.connectable;
    }

    public void setConnectable(boolean bl) {
        this.connectable = bl;
    }

    public boolean isDisconnectable() {
        return this.disconnectable;
    }

    public void setDisconnectable(boolean bl) {
        this.disconnectable = bl;
    }

    public boolean isCloneable() {
        return this.cloneable;
    }

    public void setCloneable(boolean bl) {
        this.cloneable = bl;
    }

    public boolean isSizeable() {
        return this.sizeable;
    }

    public void setSizeable(boolean bl) {
        this.sizeable = bl;
    }

    public void setDisconnectOnMove(boolean bl) {
        this.disconnectOnMove = bl;
    }

    public boolean isDisconnectOnMove() {
        return this.disconnectOnMove && this.disconnectable;
    }

    public void setJumpToDefaultPort(boolean bl) {
        this.isJumpToDefaultPort = bl;
    }

    public boolean isJumpToDefaultPort() {
        return this.isJumpToDefaultPort;
    }

    public void setMoveIntoGroups(boolean bl) {
        this.isMoveIntoGroups = bl;
    }

    public boolean isMoveIntoGroups() {
        return this.isMoveIntoGroups;
    }

    public void setMoveOutOfGroups(boolean bl) {
        this.isMoveOutOfGroups = bl;
    }

    public boolean isMoveOutOfGroups() {
        return this.isMoveOutOfGroups;
    }

    public boolean isGridEnabled() {
        return this.gridEnabled;
    }

    public void setGridEnabled(boolean bl) {
        this.gridEnabled = bl;
    }

    public boolean isMoveBelowZero() {
        return this.moveBelowZero;
    }

    public void setMoveBelowZero(boolean bl) {
        this.moveBelowZero = bl;
    }

    public boolean isAutoResizeGraph() {
        return this.autoResizeGraph;
    }

    public void setAutoResizeGraph(boolean bl) {
        this.autoResizeGraph = bl;
    }

    public int getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(int n) {
        this.tolerance = n;
    }

    public int getHandleSize() {
        return this.handleSize;
    }

    public void setHandleSize(int n) {
        int n2 = this.handleSize;
        this.handleSize = n;
        this.firePropertyChange(HANDLE_SIZE_PROPERTY, n2, n);
    }

    public int getMinimumMove() {
        return this.minimumMove;
    }

    public void setMinimumMove(int n) {
        this.minimumMove = n;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color color) {
        Color color2 = this.gridColor;
        this.gridColor = color;
        this.firePropertyChange(GRID_COLOR_PROPERTY, color2, color);
    }

    public Color getHandleColor() {
        return this.handleColor;
    }

    public void setHandleColor(Color color) {
        Color color2 = this.handleColor;
        this.handleColor = color;
        this.firePropertyChange(HANDLE_COLOR_PROPERTY, color2, color);
    }

    public Color getLockedHandleColor() {
        return this.lockedHandleColor;
    }

    public void setLockedHandleColor(Color color) {
        Color color2 = this.lockedHandleColor;
        this.lockedHandleColor = color;
        this.firePropertyChange(LOCKED_HANDLE_COLOR_PROPERTY, color2, color);
    }

    public Color getMarqueeColor() {
        return this.marqueeColor;
    }

    public void setMarqueeColor(Color color) {
        this.marqueeColor = color;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color color) {
        this.highlightColor = color;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double d) {
        if (d > 0.0) {
            double d2 = this.scale;
            this.scale = d;
            this.firePropertyChange(SCALE_PROPERTY, d2, d);
        }
    }

    public double getGridSize() {
        return this.gridSize;
    }

    public int getGridMode() {
        return this.gridMode;
    }

    public void setGridSize(double d) {
        double d2 = this.gridSize;
        this.gridSize = d;
        this.firePropertyChange(GRID_SIZE_PROPERTY, d2, d);
    }

    public void setGridMode(int n) {
        if (n == 0 || n == 1 || n == 2) {
            this.gridMode = n;
            this.repaint();
        }
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public void setGridVisible(boolean bl) {
        boolean bl2 = this.gridVisible;
        this.gridVisible = bl;
        this.firePropertyChange(GRID_VISIBLE_PROPERTY, bl2, bl);
    }

    public boolean isPortsVisible() {
        return this.portsVisible;
    }

    public void setPortsVisible(boolean bl) {
        boolean bl2 = this.portsVisible;
        this.portsVisible = bl;
        this.firePropertyChange(PORTS_VISIBLE_PROPERTY, bl2, bl);
    }

    public boolean isPortsScaled() {
        return this.portsScaled;
    }

    public void setPortsScaled(boolean bl) {
        boolean bl2 = this.portsScaled;
        this.portsScaled = bl;
        this.firePropertyChange(PORTS_SCALED_PROPERTY, bl2, bl);
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public void setAntiAliased(boolean bl) {
        boolean bl2 = this.antiAliased;
        this.antiAliased = bl;
        this.firePropertyChange(ANTIALIASED_PROPERTY, bl2, bl);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        boolean bl2 = this.editable;
        this.editable = bl;
        this.firePropertyChange(EDITABLE_PROPERTY, bl2, bl);
    }

    public boolean isSelectionEnabled() {
        return this.selectionEnabled;
    }

    public void setSelectionEnabled(boolean bl) {
        boolean bl2 = this.editable;
        this.selectionEnabled = bl;
        this.firePropertyChange(SELECTIONENABLED_PROPERTY, bl2, bl);
    }

    public boolean isPreviewInvalidNullPorts() {
        return this.previewInvalidNullPorts;
    }

    public void setPreviewInvalidNullPorts(boolean bl) {
        this.previewInvalidNullPorts = bl;
    }

    public GraphModel getModel() {
        return this.graphModel;
    }

    public void setModel(GraphModel graphModel) {
        GraphModel graphModel2 = this.graphModel;
        this.graphModel = graphModel;
        this.firePropertyChange(GRAPH_MODEL_PROPERTY, graphModel2, this.graphModel);
        if (this.graphLayoutCache != null && this.graphLayoutCache.getModel() != this.graphModel) {
            this.graphLayoutCache.setModel(this.graphModel);
        }
        this.clearSelection();
        this.invalidate();
    }

    public GraphLayoutCache getGraphLayoutCache() {
        return this.graphLayoutCache;
    }

    public void setGraphLayoutCache(GraphLayoutCache graphLayoutCache) {
        GraphLayoutCache graphLayoutCache2 = this.graphLayoutCache;
        this.graphLayoutCache = graphLayoutCache;
        this.firePropertyChange(GRAPH_LAYOUT_CACHE_PROPERTY, graphLayoutCache2, this.graphLayoutCache);
        if (this.graphLayoutCache != null && this.graphLayoutCache.getModel() != this.getModel()) {
            this.setModel(this.graphLayoutCache.getModel());
        }
        this.invalidate();
    }

    public BasicMarqueeHandler getMarqueeHandler() {
        return this.marquee;
    }

    public void setMarqueeHandler(BasicMarqueeHandler basicMarqueeHandler) {
        BasicMarqueeHandler basicMarqueeHandler2 = this.marquee;
        this.marquee = basicMarqueeHandler;
        this.firePropertyChange(MARQUEE_HANDLER_PROPERTY, basicMarqueeHandler2, basicMarqueeHandler);
        this.invalidate();
    }

    public void setInvokesStopCellEditing(boolean bl) {
        boolean bl2 = this.invokesStopCellEditing;
        this.invokesStopCellEditing = bl;
        this.firePropertyChange(INVOKES_STOP_CELL_EDITING_PROPERTY, bl2, bl);
    }

    public boolean getInvokesStopCellEditing() {
        return this.invokesStopCellEditing;
    }

    public boolean isCellEditable(Object object) {
        CellView cellView;
        if (object != null && (cellView = this.graphLayoutCache.getMapping(object, false)) != null) {
            return this.isEditable() && GraphConstants.isEditable(cellView.getAllAttributes());
        }
        return false;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (mouseEvent != null) {
            Component component;
            Object object = this.getFirstCellForLocation(mouseEvent.getX(), mouseEvent.getY());
            CellView cellView = this.getGraphLayoutCache().getMapping(object, false);
            if (cellView != null && (component = cellView.getRendererComponent(this, false, false, false)) instanceof JComponent) {
                Rectangle2D rectangle2D = this.getCellBounds(object);
                Point2D point2D = this.fromScreen(mouseEvent.getPoint());
                mouseEvent = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), (int)(point2D.getX() - rectangle2D.getX()), (int)(point2D.getY() - rectangle2D.getY()), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                return ((JComponent)component).getToolTipText(mouseEvent);
            }
        }
        return super.getToolTipText(mouseEvent);
    }

    public void setSelectionModel(GraphSelectionModel graphSelectionModel) {
        if (graphSelectionModel == null) {
            graphSelectionModel = EmptySelectionModel.sharedInstance();
        }
        GraphSelectionModel graphSelectionModel2 = this.selectionModel;
        if (this.selectionModel != null && this.selectionRedirector != null) {
            this.selectionModel.removeGraphSelectionListener(this.selectionRedirector);
        }
        this.selectionModel = graphSelectionModel;
        if (this.selectionRedirector != null) {
            this.selectionModel.addGraphSelectionListener(this.selectionRedirector);
        }
        this.firePropertyChange(SELECTION_MODEL_PROPERTY, graphSelectionModel2, this.selectionModel);
    }

    public GraphSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void clearSelection() {
        this.getSelectionModel().clearSelection();
    }

    public boolean isSelectionEmpty() {
        return this.getSelectionModel().isSelectionEmpty();
    }

    public void addGraphSelectionListener(GraphSelectionListener graphSelectionListener) {
        this.listenerList.add(class$org$jgraph$event$GraphSelectionListener == null ? (class$org$jgraph$event$GraphSelectionListener = JGraph.class$("org.jgraph.event.GraphSelectionListener")) : class$org$jgraph$event$GraphSelectionListener, graphSelectionListener);
        if (this.listenerList.getListenerCount(class$org$jgraph$event$GraphSelectionListener == null ? (class$org$jgraph$event$GraphSelectionListener = JGraph.class$("org.jgraph.event.GraphSelectionListener")) : class$org$jgraph$event$GraphSelectionListener) != 0 && this.selectionRedirector == null) {
            this.selectionRedirector = new GraphSelectionRedirector();
            this.selectionModel.addGraphSelectionListener(this.selectionRedirector);
        }
    }

    public void removeGraphSelectionListener(GraphSelectionListener graphSelectionListener) {
        this.listenerList.remove(class$org$jgraph$event$GraphSelectionListener == null ? (class$org$jgraph$event$GraphSelectionListener = JGraph.class$("org.jgraph.event.GraphSelectionListener")) : class$org$jgraph$event$GraphSelectionListener, graphSelectionListener);
        if (this.listenerList.getListenerCount(class$org$jgraph$event$GraphSelectionListener == null ? (class$org$jgraph$event$GraphSelectionListener = JGraph.class$("org.jgraph.event.GraphSelectionListener")) : class$org$jgraph$event$GraphSelectionListener) == 0 && this.selectionRedirector != null) {
            this.selectionModel.removeGraphSelectionListener(this.selectionRedirector);
            this.selectionRedirector = null;
        }
    }

    protected void fireValueChanged(GraphSelectionEvent graphSelectionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$org$jgraph$event$GraphSelectionListener == null ? JGraph.class$("org.jgraph.event.GraphSelectionListener") : class$org$jgraph$event$GraphSelectionListener)) continue;
            ((GraphSelectionListener)objectArray[i + 1]).valueChanged(graphSelectionEvent);
        }
    }

    public void setSelectionCell(Object object) {
        this.getSelectionModel().setSelectionCell(object);
    }

    public void setSelectionCells(Object[] objectArray) {
        this.getSelectionModel().setSelectionCells(objectArray);
    }

    public void addSelectionCell(Object object) {
        this.getSelectionModel().addSelectionCell(object);
    }

    public void addSelectionCells(Object[] objectArray) {
        this.getSelectionModel().addSelectionCells(objectArray);
    }

    public void removeSelectionCell(Object object) {
        this.getSelectionModel().removeSelectionCell(object);
    }

    public Object getSelectionCell() {
        return this.getSelectionModel().getSelectionCell();
    }

    public Object[] getSelectionCells() {
        return this.getSelectionModel().getSelectionCells();
    }

    public Object[] getSelectionCells(Object[] objectArray) {
        if (objectArray != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                if (!this.isCellSelected(objectArray[i])) continue;
                arrayList.add(objectArray[i]);
            }
            return arrayList.toArray();
        }
        return null;
    }

    public Object getSelectionCellAt(Point2D point2D) {
        point2D = this.fromScreen((Point2D)point2D.clone());
        Object[] objectArray = this.getSelectionCells();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (!this.getCellBounds(objectArray[i]).contains(point2D.getX(), point2D.getY())) continue;
                return objectArray[i];
            }
        }
        return null;
    }

    public int getSelectionCount() {
        return this.getSelectionModel().getSelectionCount();
    }

    public boolean isCellSelected(Object object) {
        return this.getSelectionModel().isCellSelected(object);
    }

    public void scrollCellToVisible(Object object) {
        Rectangle2D rectangle2D = this.getCellBounds(object);
        if (rectangle2D != null) {
            Rectangle2D rectangle2D2 = this.toScreen((Rectangle2D)rectangle2D.clone());
            this.scrollRectToVisible(new Rectangle((int)rectangle2D2.getX(), (int)rectangle2D2.getY(), (int)rectangle2D2.getWidth(), (int)rectangle2D2.getHeight()));
        }
    }

    public void scrollPointToVisible(Point2D point2D) {
        if (point2D != null) {
            this.scrollRectToVisible(new Rectangle((int)point2D.getX(), (int)point2D.getY(), 1, 1));
        }
    }

    public boolean isEditing() {
        GraphUI graphUI = this.getUI();
        if (graphUI != null) {
            return graphUI.isEditing(this);
        }
        return false;
    }

    public boolean stopEditing() {
        GraphUI graphUI = this.getUI();
        if (graphUI != null) {
            return graphUI.stopEditing(this);
        }
        return false;
    }

    public void cancelEditing() {
        GraphUI graphUI = this.getUI();
        if (graphUI != null) {
            graphUI.cancelEditing(this);
        }
    }

    public void startEditingAtCell(Object object) {
        GraphUI graphUI = this.getUI();
        if (graphUI != null) {
            graphUI.startEditingAtCell(this, object);
        }
    }

    public Object getEditingCell() {
        GraphUI graphUI = this.getUI();
        if (graphUI != null) {
            return graphUI.getEditingCell(this);
        }
        return null;
    }

    public void graphDidChange() {
        this.revalidate();
        this.repaint();
    }

    public BufferedImage getImage(Color color, int n) {
        Object[] objectArray = this.getRoots();
        Rectangle2D rectangle2D = this.getCellBounds(objectArray);
        if (rectangle2D != null) {
            this.toScreen(rectangle2D);
            BufferedImage bufferedImage = new BufferedImage((int)rectangle2D.getWidth() + 2 * n, (int)rectangle2D.getHeight() + 2 * n, color != null ? 1 : 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            if (color != null) {
                graphics2D.setColor(color);
                graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            } else {
                graphics2D.setComposite(AlphaComposite.getInstance(1, 0.0f));
                graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
                graphics2D.setComposite(AlphaComposite.SrcOver);
            }
            graphics2D.translate((int)(-rectangle2D.getX() + (double)n), (int)(-rectangle2D.getY() + (double)n));
            this.print(graphics2D);
            return bufferedImage;
        }
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Vector<Object> vector = new Vector<Object>();
        objectOutputStream.defaultWriteObject();
        if (this.graphModel instanceof Serializable) {
            vector.addElement("graphModel");
            vector.addElement(this.graphModel);
        }
        if (this.graphLayoutCache instanceof Serializable) {
            vector.addElement("graphLayoutCache");
            vector.addElement(this.graphLayoutCache);
        }
        if (this.selectionModel instanceof Serializable) {
            vector.addElement(SELECTION_MODEL_PROPERTY);
            vector.addElement(this.selectionModel);
        }
        if (this.marquee instanceof Serializable) {
            vector.addElement(MARQUEE_HANDLER_PROPERTY);
            vector.addElement(this.marquee);
        }
        objectOutputStream.writeObject(vector);
        if (this.getUIClassID().equals(uiClassID) && this.ui != null) {
            this.ui.installUI(this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Vector vector = (Vector)objectInputStream.readObject();
        int n = 0;
        int n2 = vector.size();
        if (n < n2 && vector.elementAt(n).equals("graphModel")) {
            this.graphModel = (GraphModel)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals("graphLayoutCache")) {
            this.graphLayoutCache = (GraphLayoutCache)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals(SELECTION_MODEL_PROPERTY)) {
            this.selectionModel = (GraphSelectionModel)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals(MARQUEE_HANDLER_PROPERTY)) {
            this.marquee = (BasicMarqueeHandler)vector.elementAt(++n);
            ++n;
        }
        if (this.listenerList.getListenerCount(class$org$jgraph$event$GraphSelectionListener == null ? (class$org$jgraph$event$GraphSelectionListener = JGraph.class$("org.jgraph.event.GraphSelectionListener")) : class$org$jgraph$event$GraphSelectionListener) != 0) {
            this.selectionRedirector = new GraphSelectionRedirector();
            this.selectionModel.addGraphSelectionListener(this.selectionRedirector);
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            return 2;
        }
        return 4;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return n == 1 ? rectangle.height : rectangle.width;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    protected String paramString() {
        String string = this.editable ? "true" : "false";
        String string2 = this.invokesStopCellEditing ? "true" : "false";
        return super.paramString() + ",editable=" + string + ",invokesStopCellEditing=" + string2;
    }

    public static void main(String[] stringArray) {
        System.out.println(VERSION);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class GraphSelectionRedirector
    implements Serializable,
    GraphSelectionListener {
        protected GraphSelectionRedirector() {
        }

        public void valueChanged(GraphSelectionEvent graphSelectionEvent) {
            GraphSelectionEvent graphSelectionEvent2 = (GraphSelectionEvent)graphSelectionEvent.cloneWithSource(JGraph.this);
            JGraph.this.fireValueChanged(graphSelectionEvent2);
        }
    }

    public static class EmptySelectionModel
    extends DefaultGraphSelectionModel {
        protected static final EmptySelectionModel sharedInstance = new EmptySelectionModel();

        public EmptySelectionModel() {
            super(null);
        }

        public static EmptySelectionModel sharedInstance() {
            return sharedInstance;
        }

        public void setSelectionCells(Object[] objectArray) {
        }

        public void addSelectionCells(Object[] objectArray) {
        }

        public void removeSelectionCells(Object[] objectArray) {
        }
    }
}

