/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Png;
import com.lowagie.text.pdf.BadPdfFormatException;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class PdfImage
extends PdfStream {
    static final int TRANSFERSIZE = 4096;
    protected PdfName name;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PdfImage(Image var1_1, String var2_2, PdfIndirectReference var3_3) throws BadPdfFormatException {
        block102: {
            super();
            this.name = null;
            this.name = new PdfName(var2_2);
            this.put(PdfName.TYPE, PdfName.XOBJECT);
            this.put(PdfName.SUBTYPE, PdfName.IMAGE);
            this.put(PdfName.NAME, this.name);
            this.put(PdfName.WIDTH, new PdfNumber(var1_1.width()));
            this.put(PdfName.HEIGHT, new PdfNumber(var1_1.height()));
            if (var3_3 != null) {
                this.put(PdfName.MASK, var3_3);
            }
            if (var1_1.isMask() && var1_1.isInvertMask()) {
                this.put(PdfName.DECODE, new PdfLiteral("[1 0]"));
            }
            if (var1_1.isInterpolation()) {
                this.put(PdfName.INTERPOLATE, PdfBoolean.PDFTRUE);
            }
            var4_4 = null;
            try {
                try {
                    if (var1_1.isImgRaw()) {
                        var5_5 = var1_1.colorspace();
                        var6_8 = var1_1.getTransparency();
                        if (var6_8 != null && !var1_1.isMask() && var3_3 == null) {
                            var7_10 = "[";
                            var8_13 = 0;
                            while (true) {
                                if (var8_13 >= var6_8.length) {
                                    var7_10 = var7_10 + "]";
                                    this.put(PdfName.MASK, new PdfLiteral(var7_10));
                                    break;
                                }
                                var7_10 = var7_10 + var6_8[var8_13] + " ";
                                ++var8_13;
                            }
                        }
                        this.bytes = var1_1.rawData();
                        this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                        var7_11 = var1_1.bpc();
                        if (var7_11 > 255) {
                            if (!var1_1.isMask()) {
                                this.put(PdfName.COLORSPACE, PdfName.DEVICEGRAY);
                            }
                            this.put(PdfName.BITSPERCOMPONENT, new PdfNumber(1));
                            this.put(PdfName.FILTER, PdfName.CCITTFAXDECODE);
                            var8_13 = var7_11 - 257;
                            var9_16 = new PdfDictionary();
                            if (var8_13 != 0) {
                                var9_16.put(PdfName.K, new PdfNumber(var8_13));
                            }
                            if ((var5_5 & 1) != 0) {
                                var9_16.put(PdfName.BLACKIS1, PdfBoolean.PDFTRUE);
                            }
                            if ((var5_5 & 2) != 0) {
                                var9_16.put(PdfName.ENCODEDBYTEALIGN, PdfBoolean.PDFTRUE);
                            }
                            if ((var5_5 & 4) != 0) {
                                var9_16.put(PdfName.ENDOFLINE, PdfBoolean.PDFTRUE);
                            }
                            if ((var5_5 & 8) != 0) {
                                var9_16.put(PdfName.ENDOFBLOCK, PdfBoolean.PDFFALSE);
                            }
                            var9_16.put(PdfName.COLUMNS, new PdfNumber(var1_1.width()));
                            var9_16.put(PdfName.ROWS, new PdfNumber(var1_1.height()));
                            this.put(PdfName.DECODEPARMS, var9_16);
                        } else {
                            if (!var1_1.isMask()) {
                                switch (var5_5) {
                                    case 1: {
                                        this.put(PdfName.COLORSPACE, PdfName.DEVICEGRAY);
                                        break;
                                    }
                                    case 3: {
                                        this.put(PdfName.COLORSPACE, PdfName.DEVICERGB);
                                        break;
                                    }
                                    default: {
                                        this.put(PdfName.COLORSPACE, PdfName.DEVICECMYK);
                                    }
                                }
                            }
                            this.put(PdfName.BITSPERCOMPONENT, new PdfNumber(var1_1.bpc()));
                            try {
                                this.flateCompress();
                            }
                            catch (PdfException var8_14) {
                                throw new ExceptionConverter(var8_14);
                            }
                        }
                        if (var1_1.isMask()) {
                            this.put(PdfName.IMAGEMASK, PdfBoolean.PDFTRUE);
                        }
                        var28_19 = null;
                        if (var4_4 == null) return;
                        try {
                            var4_4.close();
                            return;
                        }
                        catch (Exception var29_23) {
                            // empty catch block
                        }
                        return;
                    }
                    if (var1_1.rawData() == null) {
                        var4_4 = var1_1.url().openStream();
                        var5_6 = var1_1.url().toString();
                    } else {
                        var4_4 = new ByteArrayInputStream(var1_1.rawData());
                        var5_6 = "Byte array";
                    }
                    this.streamBytes = new ByteArrayOutputStream();
                    var6_9 = 0;
                    block8 : switch (var1_1.type()) {
                        case 33: {
                            this.put(PdfName.FILTER, PdfName.FLATEDECODE);
                            var7_12 = 0;
                            while (true) {
                                if (var7_12 >= Png.PNGID.length) break;
                                if (Png.PNGID[var7_12] != var4_4.read()) {
                                    throw new BadPdfFormatException(var5_6 + " is not a PNG file.");
                                }
                                ++var7_12;
                            }
                            var8_15 = 0;
                            block40: while (true) {
                                var9_17 = Png.getInt(var4_4);
                                var10_27 = Png.getString(var4_4);
                                if ("IDAT".equals(var10_27)) {
                                    PdfImage.transferBytes(var4_4, this.streamBytes, var9_17);
                                    Png.getInt(var4_4);
                                    continue;
                                }
                                if ("tRNS".equals(var10_27) && !var1_1.isMask() && var3_3 == null) {
                                    block13 : switch (var8_15) {
                                        case 0: {
                                            if (var9_17 < 2) break;
                                            var9_17 -= 2;
                                            var11_29 = Png.getWord(var4_4);
                                            this.put(PdfName.MASK, new PdfLiteral("[" + var11_29 + " " + var11_29 + "]"));
                                            break;
                                        }
                                        case 2: {
                                            if (var9_17 < 6) break;
                                            var9_17 -= 6;
                                            var11_30 = Png.getWord(var4_4);
                                            var12_36 = Png.getWord(var4_4);
                                            var13_40 = Png.getWord(var4_4);
                                            this.put(PdfName.MASK, new PdfLiteral("[" + var11_30 + " " + var11_30 + " " + var12_36 + " " + var12_36 + " " + var13_40 + " " + var13_40 + "]"));
                                            break;
                                        }
                                        case 3: {
                                            if (var9_17 <= 0) break;
                                            var11_31 = 0;
                                            while (var9_17-- != 0) {
                                                if (var4_4.read() == 0) {
                                                    this.put(PdfName.MASK, new PdfLiteral("[" + var11_31 + " " + var11_31 + "]"));
                                                    break block13;
                                                }
                                                ++var11_31;
                                            }
                                            break;
                                        }
                                    }
                                    Image.skip(var4_4, var9_17 + 4);
                                    continue;
                                }
                                if ("IHDR".equals(var10_27)) {
                                    var11_32 = Png.getInt(var4_4);
                                    var12_37 = Png.getInt(var4_4);
                                    var13_40 = var4_4.read();
                                    if (var13_40 == 16) {
                                        throw new BadPdfFormatException(var5_6 + " Bit depth 16 is not suported.");
                                    }
                                    this.put(PdfName.BITSPERCOMPONENT, new PdfNumber(var13_40));
                                    var8_15 = var4_4.read();
                                    if (var8_15 != 0 && var8_15 != 2 && var8_15 != 3) {
                                        throw new BadPdfFormatException(var5_6 + " Colortype " + var8_15 + " is not suported.");
                                    }
                                    if (var8_15 == 0) {
                                        this.put(PdfName.COLORSPACE, PdfName.DEVICEGRAY);
                                    } else if (var8_15 == 2) {
                                        this.put(PdfName.COLORSPACE, PdfName.DEVICERGB);
                                    }
                                    var14_43 = var4_4.read();
                                    var15_46 = var4_4.read();
                                    var16_48 = var4_4.read();
                                    if (var16_48 != 0) {
                                        throw new BadPdfFormatException(var5_6 + " Interlace method " + var16_48 + " is not suported.");
                                    }
                                    var17_50 = new PdfDictionary();
                                    var17_50.put(PdfName.BITSPERCOMPONENT, new PdfNumber(var13_40));
                                    var17_50.put(PdfName.PREDICTOR, new PdfNumber(15));
                                    var17_50.put(PdfName.COLUMNS, new PdfNumber(var11_32));
                                    var17_50.put(PdfName.COLORS, new PdfNumber(var8_15 == 2 ? 3 : 1));
                                    this.put(PdfName.DECODEPARMS, var17_50);
                                    Png.getInt(var4_4);
                                    continue;
                                }
                                if ("PLTE".equals(var10_27)) {
                                    if (var8_15 == 3) {
                                        var11_33 = new PdfArray();
                                        var11_33.add(PdfName.INDEXED);
                                        var11_33.add(PdfName.DEVICERGB);
                                        var11_33.add(new PdfNumber(var9_17 / 3 - 1));
                                        var12_38 = new ByteBuffer();
                                        while (true) {
                                            if (var9_17-- <= 0) {
                                                var11_33.add(new PdfString(var12_38.toByteArray()));
                                                this.put(PdfName.COLORSPACE, var11_33);
                                                Png.getInt(var4_4);
                                                continue block40;
                                            }
                                            var12_38.append_i(var4_4.read());
                                        }
                                    }
                                    Image.skip(var4_4, var9_17 + 4);
                                    continue;
                                }
                                if ("IEND".equals(var10_27)) break block8;
                                var11_34 = -4;
                                while (true) {
                                    if (var11_34 >= var9_17) ** break;
                                    var4_4.read();
                                    ++var11_34;
                                }
                                break;
                            }
                        }
                        case 32: {
                            this.put(PdfName.FILTER, PdfName.DCTDECODE);
                            switch (var1_1.colorspace()) {
                                case 1: {
                                    this.put(PdfName.COLORSPACE, PdfName.DEVICEGRAY);
                                    break;
                                }
                                case 3: {
                                    this.put(PdfName.COLORSPACE, PdfName.DEVICERGB);
                                    break;
                                }
                                default: {
                                    this.put(PdfName.COLORSPACE, PdfName.DEVICECMYK);
                                    if (!var1_1.isInvertedJPEG()) break;
                                    this.put(PdfName.DECODE, new PdfLiteral("[1 0 1 0 1 0 1 0]"));
                                }
                            }
                            this.put(PdfName.BITSPERCOMPONENT, new PdfNumber(8));
                            if (var1_1.rawData() != null) {
                                this.bytes = var1_1.rawData();
                                this.streamBytes = null;
                                this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                                break block102;
                            } else {
                                PdfImage.transferBytes(var4_4, this.streamBytes, -1);
                                break;
                            }
                        }
                        case 31: {
                            if (var4_4.read() != 71) throw new BadPdfFormatException(var5_6 + " is not a GIF-file (GIF header not found).");
                            if (var4_4.read() != 73) throw new BadPdfFormatException(var5_6 + " is not a GIF-file (GIF header not found).");
                            if (var4_4.read() != 70) {
                                throw new BadPdfFormatException(var5_6 + " is not a GIF-file (GIF header not found).");
                            }
                            var9_18 = 0;
                            while (true) {
                                if (var9_18 < 8) ** GOTO lbl286
                                var10_28 = 0;
                                var11_35 = null;
                                if ((var6_9 & 128) == 128) {
                                    var10_28 = 2 << (var6_9 & 7);
                                    var4_4.read();
                                    var4_4.read();
                                    var11_35 = new ByteBuffer();
                                    var12_39 = 0;
                                    break;
                                }
                                ** GOTO lbl298
lbl286:
                                // 1 sources

                                var6_9 = var4_4.read();
                                ++var9_18;
                            }
                            while (var12_39 < var10_28) {
                                var11_35.append_i(var4_4.read());
                                var11_35.append_i(var4_4.read());
                                var11_35.append_i(var4_4.read());
                                ++var12_39;
                            }
lbl298:
                            // 2 sources

                            var12_39 = 0;
                            block46: while (true) {
                                if (var12_39 == 0) ** GOTO lbl304
                                if (var11_35 == null) {
                                    throw new BadPdfFormatException(var5_6 + " is not a supported GIF-file (there is nor a global, nor a local color table present).");
                                }
                                ** GOTO lbl431
lbl304:
                                // 1 sources

                                var13_41 = var4_4.read();
                                switch (var13_41) {
                                    case 44: {
                                        var12_39 = 1;
                                        var14_44 = 0;
                                        while (true) {
                                            if (var14_44 >= 8) {
                                                var15_47 = var4_4.read();
                                                if ((var15_47 & 64) == 0) break;
                                                throw new BadPdfFormatException(var5_6 + " is not a supported GIF-file (interlaced gifs are not supported).");
                                            }
                                            var4_4.read();
                                            ++var14_44;
                                        }
                                        if ((var15_47 & 128) != 0) {
                                            var10_28 = 2 << (var6_9 & 7);
                                            var4_4.read();
                                            var4_4.read();
                                            var11_35 = new ByteBuffer();
                                            var16_49 = 0;
                                            while (var16_49 < var10_28) {
                                                var11_35.append_i(var4_4.read());
                                                var11_35.append_i(var4_4.read());
                                                var11_35.append_i(var4_4.read());
                                                ++var16_49;
                                            }
                                        }
                                        if (var4_4.read() != 8) {
                                            throw new BadPdfFormatException(var5_6 + " is not a supported GIF-file (initial LZW code not supported).");
                                        }
                                        var16_49 = 0;
                                        var17_51 = 9;
                                        var18_52 = 257;
                                        var19_53 = 0;
                                        var20_54 = 0;
                                        var21_55 = 0;
                                        var22_56 = 23;
                                        var23_57 = 0;
                                        var24_58 = 0;
                                        var25_59 = 0;
                                        var26_60 = var4_4.read();
                                        if (var26_60 < 1) {
                                            throw new BadPdfFormatException(var5_6 + " is not a supported GIF-file. (no image data found).");
                                        }
                                        ++var24_58;
                                        var19_53 = var4_4.read();
                                        if (--var26_60 > 0) {
                                            ++var24_58;
                                            var19_53 += var4_4.read() << 8;
                                            if (--var26_60 > 0) {
                                                --var26_60;
                                                ++var24_58;
                                                var19_53 += var4_4.read() << 16;
                                            }
                                        }
                                        block49: while (var24_58 > var25_59) {
                                            ++var18_52;
                                            var16_49 = var19_53 >> var21_55 & (1 << var17_51) - 1;
                                            var23_57 = (var21_55 + var17_51) / 8;
                                            var21_55 = (var21_55 + var17_51) % 8;
                                            while (true) {
                                                if (var23_57 <= 0) {
                                                    var20_54 += var16_49 << var22_56 - var17_51 + 1;
                                                    var22_56 -= var17_51;
                                                    break;
                                                }
                                                --var23_57;
                                                var19_53 >>= 8;
                                                if (var26_60 > 0) {
                                                    --var26_60;
                                                    ++var24_58;
                                                    var19_53 += var4_4.read() << 16;
                                                    continue;
                                                }
                                                var26_60 = var4_4.read();
                                                if (var26_60 <= 0) continue;
                                                --var26_60;
                                                ++var24_58;
                                                var19_53 += var4_4.read() << 16;
                                            }
                                            while (true) {
                                                if (var22_56 >= 16) {
                                                    if (var16_49 == 256) {
                                                        var17_51 = 9;
                                                        var18_52 = 257;
                                                    }
                                                    if (var16_49 != 257) break;
                                                    break block49;
                                                }
                                                this.streamBytes.write(var20_54 >> 16);
                                                ++var25_59;
                                                var20_54 = (var20_54 & 65535) << 8;
                                                var22_56 += 8;
                                            }
                                            if (var18_52 != 1 << var17_51 || var17_51 >= 12) continue;
                                            ++var17_51;
                                        }
                                        if (var24_58 - var25_59 <= 2) continue block46;
                                        throw new BadPdfFormatException(var5_6 + " is not a supported GIF-file (unexpected end of data block).");
                                    }
                                    case 33: {
                                        var14_44 = var4_4.read();
                                        switch (var14_44) {
                                            case 249: {
                                                var4_4.read();
                                                var15_47 = var4_4.read();
                                                var4_4.read();
                                                var4_4.read();
                                                var16_49 = var4_4.read();
                                                if ((var15_47 & 1) != 0) {
                                                    this.put(PdfName.MASK, new PdfLiteral("[" + var16_49 + " " + var16_49 + "]"));
                                                }
                                                var17_51 = 0;
                                                while (true) {
                                                    if ((var17_51 = var4_4.read()) == 0) continue block46;
                                                    var4_4.skip(var17_51);
                                                }
                                            }
                                            case 1: 
                                            case 254: 
                                            case 255: {
                                                var15_47 = 0;
                                                while (true) {
                                                    if ((var15_47 = var4_4.read()) == 0) continue block46;
                                                    var4_4.skip(var15_47);
                                                }
                                            }
                                        }
                                        throw new BadPdfFormatException(var5_6 + " is not a supported GIF-file (bad extension identifier).");
                                    }
                                    case 59: {
                                        continue block46;
                                    }
                                }
                                break;
                            }
                            throw new BadPdfFormatException(var5_6 + " is not a supported GIF-file (bad data block identifier).");
lbl431:
                            // 1 sources

                            this.put(PdfName.FILTER, PdfName.LZWDECODE);
                            var13_42 = new PdfDictionary();
                            var13_42.put(PdfName.EARLYCHANGE, new PdfNumber(0));
                            this.put(PdfName.DECODEPARMS, var13_42);
                            var14_45 = new PdfArray();
                            var14_45.add(PdfName.INDEXED);
                            var14_45.add(PdfName.DEVICERGB);
                            var14_45.add(new PdfNumber(var10_28 - 1));
                            var14_45.add(new PdfString(var11_35.toByteArray()));
                            this.put(PdfName.COLORSPACE, var14_45);
                            this.put(PdfName.BITSPERCOMPONENT, new PdfNumber(8));
                            break;
                        }
                        default: {
                            throw new BadPdfFormatException(var5_6 + " is an unknown Image format.");
                        }
                    }
                    this.put(PdfName.LENGTH, new PdfNumber(this.streamBytes.size()));
                }
                catch (IOException var5_7) {
                    throw new BadPdfFormatException(var5_7.getMessage());
                }
                var28_21 = null;
                if (var4_4 == null) return;
                try {}
                catch (Exception var29_25) {
                    return;
                }
                var4_4.close();
                return;
            }
            catch (Throwable var27_61) {
                var28_22 = null;
                if (var4_4 == null) throw var27_61;
                ** try [egrp 3[TRYBLOCK] [3 : 3293->3301)] { 
lbl471:
                // 1 sources

                var4_4.close();
                throw var27_61;
lbl473:
                // 1 sources

                catch (Exception var29_26) {
                    // empty catch block
                }
                throw var27_61;
            }
        }
        var28_20 = null;
        if (var4_4 == null) return;
        ** try [egrp 3[TRYBLOCK] [3 : 3293->3301)] { 
lbl480:
        // 1 sources

        var4_4.close();
        return;
lbl482:
        // 1 sources

        catch (Exception var29_24) {
            // empty catch block
        }
    }

    public PdfName name() {
        return this.name;
    }

    static void transferBytes(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        byte[] byArray = new byte[4096];
        if (n < 0) {
            n = 0x7FFFFFF;
        }
        while (n != 0) {
            int n2 = inputStream.read(byArray, 0, Math.min(n, 4096));
            if (n2 < 0) {
                return;
            }
            outputStream.write(byArray, 0, n2);
            n -= n2;
        }
    }
}

