/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Anchor;
import com.lowagie.text.Annotation;
import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocListener;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Graphic;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Meta;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Section;
import com.lowagie.text.StringCompare;
import com.lowagie.text.Table;
import com.lowagie.text.Watermark;
import com.lowagie.text.pdf.PageResources;
import com.lowagie.text.pdf.PdfAcroForm;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfCell;
import com.lowagie.text.pdf.PdfChunk;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfContents;
import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfFont;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLine;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPTableEvent;
import com.lowagie.text.pdf.PdfPage;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageLabels;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfResources;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTable;
import com.lowagie.text.pdf.PdfTextArray;
import com.lowagie.text.pdf.PdfTransition;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.TreeMap;

class PdfDocument
extends Document
implements DocListener {
    static final String hangingPunctuation = ".,;:'";
    private PdfWriter writer;
    private PdfInfo info = new PdfInfo();
    private boolean firstPageEvent = true;
    private boolean isParagraph = true;
    private PdfLine line = null;
    private float indentLeft = 0.0f;
    private float indentRight = 0.0f;
    private float listIndentLeft = 0.0f;
    private int alignment = 0;
    private PdfContentByte text;
    private PdfContentByte graphics;
    private ArrayList lines = new ArrayList();
    private float leading = 0.0f;
    private float currentHeight = 0.0f;
    private float indentTop = 0.0f;
    private float indentBottom = 0.0f;
    private boolean pageEmpty = true;
    private int textEmptySize;
    protected Rectangle nextPageSize = null;
    protected Rectangle thisCropSize = null;
    protected Rectangle cropSize = null;
    protected PageResources pageResources;
    private Image imageWait = null;
    private float imageEnd = -1.0f;
    private float imageIndentLeft = 0.0f;
    private float imageIndentRight = 0.0f;
    private ArrayList annotations;
    private ArrayList delayedAnnotations = new ArrayList();
    PdfAcroForm acroForm;
    private PdfOutline rootOutline;
    private PdfOutline currentOutline;
    private PdfAction currentAction = null;
    private TreeMap localDestinations = new TreeMap(new StringCompare());
    private ArrayList documentJavaScript = new ArrayList();
    private int viewerPreferences = 0;
    private String openActionName;
    private PdfAction openActionAction;
    private PdfDictionary additionalActions;
    private PdfPageLabels pageLabels;
    private boolean isNewpage = false;
    private boolean isParagraphE = false;
    private float paraIndent = 0.0f;
    protected float nextMarginLeft;
    protected float nextMarginRight;
    protected float nextMarginTop;
    protected float nextMarginBottom;
    protected int duration = -1;
    protected PdfTransition transition = null;
    protected PdfDictionary pageAA = null;
    private boolean strictImageSequence = false;

    public PdfDocument() throws DocumentException {
        this.addProducer();
        this.addCreationDate();
    }

    public void addWriter(PdfWriter pdfWriter) throws DocumentException {
        if (this.writer == null) {
            this.writer = pdfWriter;
            this.acroForm = new PdfAcroForm(pdfWriter);
            return;
        }
        throw new DocumentException("You can only add a writer to a PdfDocument once.");
    }

    public boolean setPageSize(Rectangle rectangle) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        this.nextPageSize = new Rectangle(rectangle);
        return true;
    }

    public void setHeader(HeaderFooter headerFooter) {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.setHeader(headerFooter);
    }

    public void resetHeader() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.resetHeader();
    }

    public void setFooter(HeaderFooter headerFooter) {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.setFooter(headerFooter);
    }

    public void resetFooter() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.resetFooter();
    }

    public void resetPageCount() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.resetPageCount();
    }

    public void setPageCount(int n) {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.setPageCount(n);
    }

    public boolean add(Watermark watermark) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        this.watermark = watermark;
        return true;
    }

    public void removeWatermark() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        this.watermark = null;
    }

    public boolean setMargins(float f, float f2, float f3, float f4) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        this.nextMarginLeft = f;
        this.nextMarginRight = f2;
        this.nextMarginTop = f3;
        this.nextMarginBottom = f4;
        return true;
    }

    protected PdfArray rotateAnnotations() {
        PdfArray pdfArray = new PdfArray();
        int n = this.pageSize.getRotation() % 360;
        int n2 = this.writer.getCurrentPageNumber();
        int n3 = 0;
        while (n3 < this.annotations.size()) {
            PdfAnnotation pdfAnnotation = (PdfAnnotation)this.annotations.get(n3);
            int n4 = pdfAnnotation.getPlaceInPage();
            if (n4 > n2) {
                this.delayedAnnotations.add(pdfAnnotation);
            } else {
                Object object;
                if (pdfAnnotation.isForm()) {
                    if (!pdfAnnotation.isUsed() && (object = pdfAnnotation.getTemplates()) != null) {
                        this.acroForm.addFieldTemplates((HashMap)object);
                    }
                    if (((PdfFormField)(object = (PdfFormField)pdfAnnotation)).getParent() == null) {
                        this.acroForm.addDocumentField(((PdfAnnotation)object).getIndirectReference());
                    }
                }
                if (pdfAnnotation.isAnnotation()) {
                    pdfArray.add(pdfAnnotation.getIndirectReference());
                    if (!pdfAnnotation.isUsed()) {
                        object = (PdfRectangle)pdfAnnotation.get(PdfName.RECT);
                        switch (n) {
                            case 90: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(this.pageSize.top() - ((PdfRectangle)object).bottom(), ((PdfRectangle)object).left(), this.pageSize.top() - ((PdfRectangle)object).top(), ((PdfRectangle)object).right()));
                                break;
                            }
                            case 180: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(this.pageSize.right() - ((PdfRectangle)object).left(), this.pageSize.top() - ((PdfRectangle)object).bottom(), this.pageSize.right() - ((PdfRectangle)object).right(), this.pageSize.top() - ((PdfRectangle)object).top()));
                                break;
                            }
                            case 270: {
                                pdfAnnotation.put(PdfName.RECT, new PdfRectangle(((PdfRectangle)object).bottom(), this.pageSize.right() - ((PdfRectangle)object).left(), ((PdfRectangle)object).top(), this.pageSize.right() - ((PdfRectangle)object).right()));
                            }
                        }
                    }
                }
                if (!pdfAnnotation.isUsed()) {
                    pdfAnnotation.setUsed();
                    try {
                        this.writer.addToBody((PdfObject)pdfAnnotation, pdfAnnotation.getIndirectReference());
                    }
                    catch (IOException iOException) {
                        throw new ExceptionConverter(iOException);
                    }
                }
            }
            ++n3;
        }
        return pdfArray;
    }

    protected PdfDictionary codeTransition(PdfTransition pdfTransition) {
        PdfDictionary pdfDictionary = new PdfDictionary(PdfName.TRANS);
        switch (pdfTransition.getType()) {
            case 1: {
                pdfDictionary.put(PdfName.S, PdfName.SPLIT);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                pdfDictionary.put(PdfName.DM, PdfName.V);
                pdfDictionary.put(PdfName.M, PdfName.O);
                break;
            }
            case 2: {
                pdfDictionary.put(PdfName.S, PdfName.SPLIT);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                pdfDictionary.put(PdfName.DM, PdfName.H);
                pdfDictionary.put(PdfName.M, PdfName.O);
                break;
            }
            case 3: {
                pdfDictionary.put(PdfName.S, PdfName.SPLIT);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                pdfDictionary.put(PdfName.DM, PdfName.V);
                pdfDictionary.put(PdfName.M, PdfName.I);
                break;
            }
            case 4: {
                pdfDictionary.put(PdfName.S, PdfName.SPLIT);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                pdfDictionary.put(PdfName.DM, PdfName.H);
                pdfDictionary.put(PdfName.M, PdfName.I);
                break;
            }
            case 5: {
                pdfDictionary.put(PdfName.S, PdfName.BLINDS);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                pdfDictionary.put(PdfName.DM, PdfName.V);
                break;
            }
            case 6: {
                pdfDictionary.put(PdfName.S, PdfName.BLINDS);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                pdfDictionary.put(PdfName.DM, PdfName.H);
                break;
            }
            case 7: {
                pdfDictionary.put(PdfName.S, PdfName.BOX);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                pdfDictionary.put(PdfName.M, PdfName.I);
                break;
            }
            case 8: {
                pdfDictionary.put(PdfName.S, PdfName.BOX);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                pdfDictionary.put(PdfName.M, PdfName.O);
                break;
            }
            case 9: {
                pdfDictionary.put(PdfName.S, PdfName.WIPE);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                pdfDictionary.put(PdfName.DI, new PdfNumber(0));
                break;
            }
            case 10: {
                pdfDictionary.put(PdfName.S, PdfName.WIPE);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                pdfDictionary.put(PdfName.DI, new PdfNumber(180));
                break;
            }
            case 11: {
                pdfDictionary.put(PdfName.S, PdfName.WIPE);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                pdfDictionary.put(PdfName.DI, new PdfNumber(90));
                break;
            }
            case 12: {
                pdfDictionary.put(PdfName.S, PdfName.WIPE);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                pdfDictionary.put(PdfName.DI, new PdfNumber(270));
                break;
            }
            case 13: {
                pdfDictionary.put(PdfName.S, PdfName.DISSOLVE);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                break;
            }
            case 14: {
                pdfDictionary.put(PdfName.S, PdfName.GLITTER);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                pdfDictionary.put(PdfName.DI, new PdfNumber(0));
                break;
            }
            case 15: {
                pdfDictionary.put(PdfName.S, PdfName.GLITTER);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                pdfDictionary.put(PdfName.DI, new PdfNumber(270));
                break;
            }
            case 16: {
                pdfDictionary.put(PdfName.S, PdfName.GLITTER);
                pdfDictionary.put(PdfName.D, new PdfNumber(pdfTransition.getDuration()));
                pdfDictionary.put(PdfName.DI, new PdfNumber(315));
            }
        }
        return pdfDictionary;
    }

    public boolean newPage() throws DocumentException {
        PdfObject pdfObject;
        this.isNewpage = true;
        if (this.writer.getDirectContent().size() == 0 && this.writer.getDirectContentUnder().size() == 0 && (this.pageEmpty || this.writer != null && this.writer.isPaused())) {
            return false;
        }
        PdfPageEvent pdfPageEvent = this.writer.getPageEvent();
        if (pdfPageEvent != null) {
            pdfPageEvent.onEndPage(this.writer, this);
        }
        super.newPage();
        this.flushLines();
        PdfResources pdfResources = this.pageResources.getResources();
        int n = this.pageSize.getRotation();
        PdfPage pdfPage = n == 0 ? new PdfPage(new PdfRectangle(this.pageSize, n), this.thisCropSize, pdfResources) : new PdfPage(new PdfRectangle(this.pageSize, n), this.thisCropSize, pdfResources, new PdfNumber(n));
        if (this.transition != null) {
            pdfPage.put(PdfName.TRANS, this.codeTransition(this.transition));
            this.transition = null;
        }
        if (this.duration > 0) {
            pdfPage.put(PdfName.DUR, new PdfNumber(this.duration));
            this.duration = 0;
        }
        if (this.pageAA != null) {
            try {
                pdfPage.put(PdfName.AA, this.writer.addToBody(this.pageAA).getIndirectReference());
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
            this.pageAA = null;
        }
        if (this.annotations.size() > 0 && (pdfObject = this.rotateAnnotations()).size() != 0) {
            pdfPage.put(PdfName.ANNOTS, pdfObject);
        }
        if (!this.open || this.close) {
            throw new PdfException("The document isn't open.");
        }
        if (this.text.size() > this.textEmptySize) {
            this.text.endText();
        } else {
            this.text = null;
        }
        pdfObject = this.writer.add(pdfPage, new PdfContents(this.writer.getDirectContentUnder(), this.graphics, this.text, this.writer.getDirectContent(), this.pageSize));
        this.initPage();
        this.isNewpage = false;
        return true;
    }

    public void open() {
        if (!this.open) {
            super.open();
            this.writer.open();
            this.currentOutline = this.rootOutline = new PdfOutline(this.writer);
        }
        try {
            this.initPage();
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    void outlineTree(PdfOutline pdfOutline) throws IOException {
        pdfOutline.setIndirectReference(this.writer.getPdfIndirectReference());
        if (pdfOutline.parent() != null) {
            pdfOutline.put(PdfName.PARENT, pdfOutline.parent().indirectReference());
        }
        ArrayList arrayList = pdfOutline.getKids();
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            this.outlineTree((PdfOutline)arrayList.get(n2));
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            if (n3 > 0) {
                ((PdfOutline)arrayList.get(n3)).put(PdfName.PREV, ((PdfOutline)arrayList.get(n3 - 1)).indirectReference());
            }
            if (n3 < n - 1) {
                ((PdfOutline)arrayList.get(n3)).put(PdfName.NEXT, ((PdfOutline)arrayList.get(n3 + 1)).indirectReference());
            }
            ++n3;
        }
        if (n > 0) {
            pdfOutline.put(PdfName.FIRST, ((PdfOutline)arrayList.get(0)).indirectReference());
            pdfOutline.put(PdfName.LAST, ((PdfOutline)arrayList.get(n - 1)).indirectReference());
        }
        int n4 = 0;
        while (n4 < n) {
            PdfOutline pdfOutline2 = (PdfOutline)arrayList.get(n4);
            this.writer.addToBody((PdfObject)pdfOutline2, pdfOutline2.indirectReference());
            ++n4;
        }
    }

    void writeOutlines() throws IOException {
        if (this.rootOutline.getKids().size() == 0) {
            return;
        }
        this.outlineTree(this.rootOutline);
        this.writer.addToBody((PdfObject)this.rootOutline, this.rootOutline.indirectReference());
    }

    void traverseOutlineCount(PdfOutline pdfOutline) {
        ArrayList arrayList = pdfOutline.getKids();
        PdfOutline pdfOutline2 = pdfOutline.parent();
        if (arrayList.size() == 0) {
            if (pdfOutline2 != null) {
                pdfOutline2.setCount(pdfOutline2.getCount() + 1);
            }
        } else {
            int n = 0;
            while (n < arrayList.size()) {
                this.traverseOutlineCount((PdfOutline)arrayList.get(n));
                ++n;
            }
            if (pdfOutline2 != null) {
                if (pdfOutline.isOpen()) {
                    pdfOutline2.setCount(pdfOutline.getCount() + pdfOutline2.getCount() + 1);
                } else {
                    pdfOutline2.setCount(pdfOutline2.getCount() + 1);
                    pdfOutline.setCount(-pdfOutline.getCount());
                }
            }
        }
    }

    void calculateOutlineCount() {
        if (this.rootOutline.getKids().size() == 0) {
            return;
        }
        this.traverseOutlineCount(this.rootOutline);
    }

    public void close() {
        if (this.close) {
            return;
        }
        try {
            this.newPage();
            if (this.imageWait != null) {
                this.newPage();
            }
            if (this.annotations.size() > 0) {
                throw new RuntimeException(this.annotations.size() + " annotations had invalid placement pages.");
            }
            PdfPageEvent pdfPageEvent = this.writer.getPageEvent();
            if (pdfPageEvent != null) {
                pdfPageEvent.onCloseDocument(this.writer, this);
            }
            super.close();
            this.writer.addLocalDestinations(this.localDestinations);
            this.calculateOutlineCount();
            this.writeOutlines();
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        this.writer.close();
    }

    PageResources getPageResources() {
        return this.pageResources;
    }

    void addPTable(PdfPTable pdfPTable, float f) throws DocumentException {
        int n;
        float[] fArray;
        int n2;
        float f2;
        if (pdfPTable.getHeaderRows() >= pdfPTable.size()) {
            return;
        }
        boolean bl = pdfPTable.getSkipFirstHeader();
        float f3 = pdfPTable.getHeaderHeight();
        float f4 = this.indentBottom();
        float f5 = f2 = this.indentTop() - this.currentHeight;
        int n3 = n2 = pdfPTable.getHeaderRows();
        PdfContentByte[] pdfContentByteArray = null;
        float f6 = 0.0f;
        int n4 = 0;
        int n5 = 0;
        float[] fArray2 = pdfPTable.getAbsoluteWidths();
        PdfPTableEvent pdfPTableEvent = pdfPTable.getTableEvent();
        pdfPTable.setTableEvent(null);
        float[] fArray3 = new float[pdfPTable.size()];
        int n6 = 0;
        n3 = n2;
        while (n3 < pdfPTable.size()) {
            if (n3 == n2 && f5 - pdfPTable.getRowHeight(n3) - f3 < f4) {
                if (this.currentHeight == 0.0f) {
                    ++n2;
                } else {
                    this.newPage();
                    n2 = n3--;
                    f4 = this.indentBottom();
                    f5 = f2 = this.indentTop() - this.currentHeight;
                    bl = false;
                }
            } else if (f5 - pdfPTable.getRowHeight(n3) < f4) {
                if (pdfContentByteArray != null) {
                    if (pdfPTableEvent != null) {
                        fArray = new float[n6 + 1];
                        fArray[0] = f6;
                        n = 0;
                        while (n < n6) {
                            fArray[n + 1] = fArray[n] - fArray3[n];
                            ++n;
                        }
                        pdfPTableEvent.tableLayout(pdfPTable, pdfPTable.getEventWidths(f, n4, n4 + n6 - n5, true), fArray, n5, n4, pdfContentByteArray);
                    }
                    PdfPTable.endWritingRows(pdfContentByteArray);
                    pdfContentByteArray = null;
                }
                this.newPage();
                n2 = n3--;
                f4 = this.indentBottom();
                f5 = f2 = this.indentTop() - this.currentHeight;
            } else {
                if (pdfContentByteArray == null) {
                    pdfContentByteArray = PdfPTable.beginWritingRows(this.writer.getDirectContent());
                    if (pdfPTableEvent != null && !bl) {
                        n6 = 0;
                        n5 = pdfPTable.getHeaderRows();
                        int n7 = 0;
                        while (n7 < n5) {
                            fArray3[n6++] = pdfPTable.getRowHeight(n7);
                            ++n7;
                        }
                        f6 = f5;
                        n4 = n3;
                    }
                    if (!bl) {
                        f5 = pdfPTable.writeSelectedRows(0, pdfPTable.getHeaderRows(), f, f5, pdfContentByteArray);
                    } else {
                        bl = false;
                    }
                }
                if (pdfPTableEvent != null) {
                    fArray3[n6++] = pdfPTable.getRowHeight(n3);
                }
                f5 = pdfPTable.writeSelectedRows(n3, n3 + 1, f, f5, pdfContentByteArray);
            }
            ++n3;
        }
        if (pdfContentByteArray != null) {
            if (pdfPTableEvent != null) {
                fArray = new float[n6 + 1];
                fArray[0] = f6;
                n = 0;
                while (n < n6) {
                    fArray[n + 1] = fArray[n] - fArray3[n];
                    ++n;
                }
                pdfPTableEvent.tableLayout(pdfPTable, pdfPTable.getEventWidths(f, n4, n4 + n6 - n5, true), fArray, n5, n4, pdfContentByteArray);
            }
            PdfPTable.endWritingRows(pdfContentByteArray);
            this.text.moveText(0.0f, f5 - f2);
            this.currentHeight = this.indentTop() - f5;
        }
        pdfPTable.setTableEvent(pdfPTableEvent);
    }

    public boolean add(Element element) throws DocumentException {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        try {
            switch (element.type()) {
                case 0: {
                    this.info.addkey(((Meta)element).name(), ((Meta)element).content());
                    break;
                }
                case 1: {
                    this.info.addTitle(((Meta)element).content());
                    break;
                }
                case 2: {
                    this.info.addSubject(((Meta)element).content());
                    break;
                }
                case 3: {
                    this.info.addKeywords(((Meta)element).content());
                    break;
                }
                case 4: {
                    this.info.addAuthor(((Meta)element).content());
                    break;
                }
                case 7: {
                    this.info.addCreator(((Meta)element).content());
                    break;
                }
                case 5: {
                    this.info.addProducer();
                    break;
                }
                case 6: {
                    this.info.addCreationDate();
                    break;
                }
                case 10: {
                    PdfChunk pdfChunk;
                    if (this.line == null) {
                        this.carriageReturn();
                    }
                    PdfChunk pdfChunk2 = new PdfChunk((Chunk)element, this.currentAction);
                    while ((pdfChunk = this.line.add(pdfChunk2)) != null) {
                        this.carriageReturn();
                        pdfChunk2 = pdfChunk;
                    }
                    this.pageEmpty = false;
                    if (!pdfChunk2.isAttribute("NEWPAGE")) break;
                    this.newPage();
                    break;
                }
                case 17: {
                    Anchor anchor = (Anchor)element;
                    String string = anchor.reference();
                    this.leading = anchor.leading();
                    if (string != null) {
                        this.currentAction = new PdfAction(string);
                    }
                    element.process(this);
                    this.currentAction = null;
                    break;
                }
                case 29: {
                    if (this.line == null) {
                        this.carriageReturn();
                    }
                    Annotation annotation = (Annotation)element;
                    switch (annotation.annotationType()) {
                        case 1: {
                            this.annotations.add(new PdfAnnotation(this.writer, annotation.llx(), annotation.lly(), annotation.urx(), annotation.ury(), new PdfAction((URL)annotation.attributes().get(Annotation.URL))));
                            break;
                        }
                        case 2: {
                            this.annotations.add(new PdfAnnotation(this.writer, annotation.llx(), annotation.lly(), annotation.urx(), annotation.ury(), new PdfAction((String)annotation.attributes().get(Annotation.FILE))));
                            break;
                        }
                        case 3: {
                            this.annotations.add(new PdfAnnotation(this.writer, annotation.llx(), annotation.lly(), annotation.urx(), annotation.ury(), new PdfAction((String)annotation.attributes().get(Annotation.FILE), (String)annotation.attributes().get(Annotation.DESTINATION))));
                            break;
                        }
                        case 4: {
                            this.annotations.add(new PdfAnnotation(this.writer, annotation.llx(), annotation.lly(), annotation.urx(), annotation.ury(), new PdfAction((String)annotation.attributes().get(Annotation.FILE), (Integer)annotation.attributes().get(Annotation.PAGE))));
                            break;
                        }
                        case 5: {
                            this.annotations.add(new PdfAnnotation(this.writer, annotation.llx(), annotation.lly(), annotation.urx(), annotation.ury(), new PdfAction((Integer)annotation.attributes().get(Annotation.NAMED))));
                            break;
                        }
                        case 6: {
                            this.annotations.add(new PdfAnnotation(this.writer, annotation.llx(), annotation.lly(), annotation.urx(), annotation.ury(), new PdfAction((String)annotation.attributes().get(Annotation.APPLICATION), (String)annotation.attributes().get(Annotation.PARAMETERS), (String)annotation.attributes().get(Annotation.OPERATION), (String)annotation.attributes().get(Annotation.DEFAULTDIR))));
                            break;
                        }
                        default: {
                            this.annotations.add(new PdfAnnotation(this.writer, annotation.llx(this.indentRight() - this.line.widthLeft()), annotation.lly(this.indentTop() - this.currentHeight), annotation.urx(this.indentRight() - this.line.widthLeft() + 20.0f), annotation.ury(this.indentTop() - this.currentHeight - 20.0f), new PdfString(annotation.title()), new PdfString(annotation.content())));
                        }
                    }
                    this.pageEmpty = false;
                    break;
                }
                case 11: {
                    this.leading = ((Phrase)element).leading();
                    element.process(this);
                    break;
                }
                case 12: {
                    Paragraph paragraph = (Paragraph)element;
                    this.alignment = paragraph.alignment();
                    this.leading = paragraph.leading();
                    this.carriageReturn();
                    if (this.currentHeight + this.line.height() + this.leading > this.indentTop() - this.indentBottom()) {
                        this.newPage();
                    }
                    this.indentLeft += paragraph.indentationLeft();
                    this.indentRight += paragraph.indentationRight();
                    this.carriageReturn();
                    this.isParagraphE = true;
                    this.paraIndent += paragraph.indentationLeft();
                    PdfPageEvent pdfPageEvent = this.writer.getPageEvent();
                    if (pdfPageEvent != null && this.isParagraph) {
                        pdfPageEvent.onParagraph(this.writer, this, this.indentTop() - this.currentHeight);
                    }
                    if (paragraph.getKeepTogether()) {
                        Table table = new Table(1, 1);
                        table.setOffset(0.0f);
                        table.setBorder(0);
                        table.setWidth(100.0f);
                        table.setTableFitsPage(true);
                        Cell cell = new Cell(paragraph);
                        cell.setBorder(0);
                        cell.setHorizontalAlignment(paragraph.alignment());
                        table.addCell(cell);
                        this.add(table);
                        break;
                    }
                    element.process(this);
                    this.paraIndent -= paragraph.indentationLeft();
                    this.carriageReturn();
                    if (pdfPageEvent != null && this.isParagraph) {
                        pdfPageEvent.onParagraphEnd(this.writer, this, this.indentTop() - this.currentHeight);
                    }
                    this.alignment = 0;
                    this.indentLeft -= paragraph.indentationLeft();
                    this.indentRight -= paragraph.indentationRight();
                    this.isParagraphE = false;
                    break;
                }
                case 13: 
                case 16: {
                    boolean bl;
                    Section section = (Section)element;
                    boolean bl2 = bl = section.title() != null;
                    if (section.isChapter()) {
                        this.newPage();
                    } else {
                        this.newLine();
                    }
                    if (bl) {
                        PdfOutline pdfOutline;
                        float f = this.indentTop() - this.currentHeight;
                        int n = this.pageSize.getRotation();
                        if (n == 90 || n == 180) {
                            f = this.pageSize.height() - f;
                        }
                        PdfDestination pdfDestination = new PdfDestination(2, f);
                        while (this.currentOutline.level() >= section.depth()) {
                            this.currentOutline = this.currentOutline.parent();
                        }
                        this.currentOutline = pdfOutline = new PdfOutline(this.currentOutline, pdfDestination, section.title(), section.isBookmarkOpen());
                    }
                    this.carriageReturn();
                    this.indentLeft += section.indentationLeft();
                    this.indentRight += section.indentationRight();
                    PdfPageEvent pdfPageEvent = this.writer.getPageEvent();
                    if (pdfPageEvent != null) {
                        if (element.type() == 16) {
                            pdfPageEvent.onChapter(this.writer, this, this.indentTop() - this.currentHeight, section.title());
                        } else {
                            pdfPageEvent.onSection(this.writer, this, this.indentTop() - this.currentHeight, section.depth(), section.title());
                        }
                    }
                    if (bl) {
                        this.isParagraph = false;
                        this.add(section.title());
                        this.isParagraph = true;
                    }
                    this.indentLeft += section.indentation();
                    element.process(this);
                    this.indentLeft -= section.indentationLeft() + section.indentation();
                    this.indentRight -= section.indentationRight();
                    if (pdfPageEvent == null) break;
                    if (element.type() == 16) {
                        pdfPageEvent.onChapterEnd(this.writer, this, this.indentTop() - this.currentHeight);
                        break;
                    }
                    pdfPageEvent.onSectionEnd(this.writer, this, this.indentTop() - this.currentHeight);
                    break;
                }
                case 14: {
                    List list = (List)element;
                    this.listIndentLeft += list.indentationLeft();
                    this.indentRight += list.indentationRight();
                    element.process(this);
                    this.listIndentLeft -= list.indentationLeft();
                    this.indentRight -= list.indentationRight();
                    break;
                }
                case 15: {
                    ListItem listItem = (ListItem)element;
                    this.alignment = listItem.alignment();
                    this.listIndentLeft += listItem.indentationLeft();
                    this.indentRight += listItem.indentationRight();
                    this.leading = listItem.leading();
                    this.carriageReturn();
                    this.line.setListItem(listItem);
                    element.process(this);
                    this.carriageReturn();
                    this.listIndentLeft -= listItem.indentationLeft();
                    this.indentRight -= listItem.indentationRight();
                    break;
                }
                case 30: {
                    Rectangle rectangle = (Rectangle)element;
                    this.graphics.rectangle(rectangle);
                    this.pageEmpty = false;
                    break;
                }
                case 23: {
                    this.newLine();
                    this.flushLines();
                    PdfPTable pdfPTable = (PdfPTable)element;
                    float f = (this.indentRight() - this.indentLeft()) * pdfPTable.getWidthPercentage() / 100.0f;
                    float f2 = 0.0f;
                    switch (pdfPTable.getHorizontalAlignment()) {
                        case 0: {
                            f2 = this.indentLeft();
                            break;
                        }
                        case 2: {
                            f2 = this.indentRight() - f;
                            break;
                        }
                        default: {
                            f2 = (this.indentRight() + this.indentLeft() - f) / 2.0f;
                        }
                    }
                    pdfPTable.setTotalWidth(f);
                    this.addPTable(pdfPTable, f2);
                    break;
                }
                case 22: {
                    boolean bl;
                    ((Table)element).complete();
                    float f = ((Table)element).getOffset();
                    if (Float.isNaN(f)) {
                        f = this.leading;
                    }
                    this.carriageReturn();
                    this.lines.add(new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, f));
                    this.currentHeight += f;
                    this.flushLines();
                    float f3 = this.indentTop();
                    float f4 = this.currentHeight;
                    PdfContentByte pdfContentByte = new PdfContentByte(this.writer);
                    PdfTable pdfTable = new PdfTable((Table)element, this.indentLeft(), this.indentRight(), this.currentHeight > 0.0f ? f3 - this.currentHeight - 6.0f : f3);
                    boolean bl3 = ((Table)element).hasToFitPageTable() ? pdfTable.bottom() < this.indentBottom() : (bl = false);
                    if (this.pageEmpty) {
                        bl = false;
                    }
                    boolean bl4 = ((Table)element).hasToFitPageCells();
                    ArrayList arrayList = pdfTable.getCells();
                    ArrayList arrayList2 = null;
                    while (!arrayList.isEmpty()) {
                        float f5;
                        int n;
                        PdfCell pdfCell;
                        float f6 = 0.0f;
                        boolean bl5 = false;
                        int n2 = 0;
                        boolean bl6 = false;
                        ListIterator listIterator = arrayList.listIterator();
                        while (listIterator.hasNext() && !bl) {
                            pdfCell = (PdfCell)listIterator.next();
                            if (bl4) {
                                if (!pdfCell.isHeader()) {
                                    if (pdfCell.getGroupNumber() != n2) {
                                        boolean bl7 = true;
                                        n2 = pdfCell.getGroupNumber();
                                        int n3 = 0;
                                        while (pdfCell.getGroupNumber() == n2 && bl7 && listIterator.hasNext()) {
                                            if (pdfCell.bottom() < this.indentBottom()) {
                                                bl7 = false;
                                            }
                                            pdfCell = (PdfCell)listIterator.next();
                                            ++n3;
                                        }
                                        if (!bl7) break;
                                        int n4 = n3;
                                        while (n4 >= 0) {
                                            pdfCell = (PdfCell)listIterator.previous();
                                            --n4;
                                        }
                                    }
                                } else if (!bl6) {
                                    bl6 = true;
                                    boolean bl8 = true;
                                    int n5 = 0;
                                    float f7 = pdfCell.top();
                                    while (pdfCell.isHeader() && bl8 && listIterator.hasNext()) {
                                        if (f7 - pdfCell.bottom(0.0f) > this.indentTop() - this.currentHeight - this.indentBottom()) {
                                            bl8 = false;
                                        }
                                        pdfCell = (PdfCell)listIterator.next();
                                        ++n5;
                                    }
                                    n2 = pdfCell.getGroupNumber();
                                    while (pdfCell.getGroupNumber() == n2 && bl8 && listIterator.hasNext()) {
                                        if ((double)(f7 - pdfCell.bottom(0.0f)) > (double)(this.indentTop() - this.currentHeight - this.indentBottom()) - 10.0) {
                                            bl8 = false;
                                        }
                                        pdfCell = (PdfCell)listIterator.next();
                                        ++n5;
                                    }
                                    n = n5;
                                    while (n >= 0) {
                                        pdfCell = (PdfCell)listIterator.previous();
                                        --n;
                                    }
                                    if (!bl8) {
                                        while (pdfCell.isHeader()) {
                                            listIterator.remove();
                                            pdfCell = (PdfCell)listIterator.next();
                                        }
                                        break;
                                    }
                                }
                            }
                            this.lines = pdfCell.getLines(f3, this.indentBottom());
                            if (this.lines != null && this.lines.size() > 0) {
                                bl5 = true;
                                pdfContentByte.rectangle(pdfCell.rectangle(f3, this.indentBottom()));
                                f6 = Math.max(pdfCell.bottom(), this.indentBottom());
                                float f8 = pdfCell.top(f3 - f4);
                                this.text.moveText(0.0f, f8);
                                f5 = this.flushLines() - f8;
                                this.text.moveText(0.0f, f5);
                                if (f4 + f5 > this.currentHeight) {
                                    this.currentHeight = f4 + f5;
                                }
                            }
                            ArrayList arrayList3 = pdfCell.getImages(f3, this.indentBottom());
                            Iterator iterator = arrayList3.iterator();
                            while (iterator.hasNext()) {
                                bl5 = true;
                                Image image = (Image)iterator.next();
                                this.addImage(this.graphics, image, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                            }
                            if (!pdfCell.mayBeRemoved()) continue;
                            listIterator.remove();
                        }
                        bl = false;
                        if (bl5) {
                            Rectangle rectangle = new Rectangle(pdfTable);
                            rectangle.setBorder(pdfTable.border());
                            rectangle.setBorderWidth(pdfTable.borderWidth());
                            rectangle.setBorderColor(pdfTable.borderColor());
                            rectangle.setBackgroundColor(pdfTable.backgroundColor());
                            rectangle.setGrayFill(pdfTable.grayFill());
                            PdfContentByte pdfContentByte2 = this.writer.getDirectContentUnder();
                            pdfContentByte2.rectangle(rectangle.rectangle(this.top(), this.indentBottom()));
                            pdfContentByte2.add(pdfContentByte);
                            rectangle.setGrayFill(0.0f);
                            rectangle.setBackgroundColor(null);
                            pdfContentByte2.rectangle(rectangle.rectangle(this.top(), this.indentBottom()));
                        }
                        pdfContentByte = new PdfContentByte(null);
                        if (arrayList.isEmpty()) continue;
                        this.graphics.setLineWidth(pdfTable.borderWidth());
                        if (bl5 && (pdfTable.border() & 2) == 2) {
                            Color color = pdfTable.borderColor();
                            if (color != null) {
                                this.graphics.setColorStroke(color);
                            }
                            this.graphics.moveTo(pdfTable.left(), Math.max(pdfTable.bottom(), this.indentBottom()));
                            this.graphics.lineTo(pdfTable.right(), Math.max(pdfTable.bottom(), this.indentBottom()));
                            this.graphics.stroke();
                            if (color != null) {
                                this.graphics.resetRGBColorStroke();
                            }
                        }
                        this.pageEmpty = false;
                        float f9 = f6;
                        this.newPage();
                        float f10 = 0.0f;
                        boolean bl9 = false;
                        if (this.currentHeight > 0.0f) {
                            f10 = 6.0f;
                            this.currentHeight += f10;
                            bl9 = true;
                            this.newLine();
                            this.flushLines();
                            this.indentTop = this.currentHeight - this.leading;
                            this.currentHeight = 0.0f;
                        } else {
                            this.flushLines();
                        }
                        arrayList2 = pdfTable.getHeaderCells();
                        n = arrayList2.size();
                        if (n > 0) {
                            pdfCell = (PdfCell)arrayList2.get(0);
                            float f11 = pdfCell.top(0.0f);
                            int n6 = 0;
                            while (n6 < n) {
                                pdfCell = (PdfCell)arrayList2.get(n6);
                                pdfCell.setTop(this.indentTop() - f11 + pdfCell.top(0.0f));
                                pdfCell.setBottom(this.indentTop() - f11 + pdfCell.bottom(0.0f));
                                f3 = pdfCell.bottom();
                                pdfContentByte.rectangle(pdfCell.rectangle(this.indentTop(), this.indentBottom()));
                                ArrayList arrayList4 = pdfCell.getImages(this.indentTop(), this.indentBottom());
                                Iterator iterator = arrayList4.iterator();
                                while (iterator.hasNext()) {
                                    bl5 = true;
                                    Image image = (Image)iterator.next();
                                    this.addImage(this.graphics, image, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                                }
                                this.lines = pdfCell.getLines(this.indentTop(), this.indentBottom());
                                float f12 = pdfCell.top(this.indentTop());
                                this.text.moveText(0.0f, f12 - f10);
                                f5 = this.flushLines() - f12 + f10;
                                this.text.moveText(0.0f, f5);
                                ++n6;
                            }
                            this.currentHeight = this.indentTop() - f3 + pdfTable.cellspacing();
                            this.text.moveText(0.0f, f3 - this.indentTop() - pdfTable.cellspacing() - this.currentHeight);
                        } else if (bl9) {
                            f3 = this.indentTop();
                            this.text.moveText(0.0f, f3 - this.indentTop() - pdfTable.cellspacing());
                        }
                        f4 = this.currentHeight + pdfTable.cellspacing() - f10;
                        n = Math.min(arrayList.size(), pdfTable.columns());
                        int n7 = 0;
                        while (n7 < n) {
                            float f13;
                            float f14;
                            pdfCell = (PdfCell)arrayList.get(n7);
                            if (pdfCell.top(-pdfTable.cellspacing()) > f6 && (f14 = f3 - f9 + pdfCell.bottom()) > f3 - (f13 = pdfCell.remainingHeight())) {
                                f9 += f14 - (f3 - f13);
                            }
                            ++n7;
                        }
                        n = arrayList.size();
                        pdfTable.setTop(this.indentTop());
                        pdfTable.setBottom(f3 - f9 + pdfTable.bottom(pdfTable.cellspacing()));
                        n7 = 0;
                        while (n7 < n) {
                            pdfCell = (PdfCell)arrayList.get(n7);
                            float f15 = f3 - f9 + pdfCell.bottom();
                            float f16 = f3 - f9 + pdfCell.top(-pdfTable.cellspacing());
                            if (f16 > this.indentTop() - this.currentHeight + pdfTable.cellspacing()) {
                                f16 = this.indentTop() - this.currentHeight + pdfTable.cellspacing();
                            }
                            pdfCell.setTop(f16 - pdfTable.cellspacing());
                            pdfCell.setBottom(f15 - pdfTable.cellspacing());
                            ++n7;
                        }
                    }
                    this.text.moveText(0.0f, f4 - this.currentHeight);
                    this.lines.add(this.line);
                    this.currentHeight += this.line.height() - f3 + this.indentTop();
                    this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
                    this.pageEmpty = false;
                    break;
                }
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: {
                    this.carriageReturn();
                    this.add((Image)element);
                    this.pageEmpty = false;
                    break;
                }
                case 39: {
                    Graphic graphic = (Graphic)element;
                    graphic.processAttributes(this.indentLeft(), this.indentBottom(), this.indentRight(), this.indentTop(), this.indentTop() - this.currentHeight);
                    this.graphics.add(graphic);
                    this.pageEmpty = false;
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        catch (Exception exception) {
            System.err.println("Error: " + exception.getMessage());
            throw new DocumentException(exception.getMessage());
        }
    }

    private void addImage(PdfContentByte pdfContentByte, Image image, float f, float f2, float f3, float f4, float f5, float f6) throws DocumentException {
        Annotation annotation = image.annotation();
        if (image.hasAbsolutePosition()) {
            pdfContentByte.addImage(image);
            if (annotation != null) {
                annotation.setDimensions(image.absoluteX(), image.absoluteY(), image.absoluteX() + image.scaledWidth(), image.absoluteY() + image.scaledHeight());
                this.add(annotation);
            }
        } else {
            pdfContentByte.addImage(image, f, f2, f3, f4, f5, f6);
            if (annotation != null) {
                annotation.setDimensions(f5, f6, f5 + image.scaledWidth(), f6 + image.scaledHeight());
                this.add(annotation);
            }
        }
    }

    private void add(Image image) throws PdfException, DocumentException {
        this.pageEmpty = false;
        if (image.hasAbsolutePosition()) {
            this.addImage(this.graphics, image, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            return;
        }
        if (this.currentHeight != 0.0f && this.indentTop() - this.currentHeight - image.scaledHeight() < this.indentBottom()) {
            if (!this.strictImageSequence && this.imageWait == null) {
                this.imageWait = image;
                return;
            }
            this.newPage();
            if (this.currentHeight != 0.0f && this.indentTop() - this.currentHeight - image.scaledHeight() < this.indentBottom()) {
                this.imageWait = image;
                return;
            }
        }
        if (image == this.imageWait) {
            this.imageWait = null;
        }
        boolean bl = (image.alignment() & 4) == 4 && (image.alignment() & 3) != 3;
        boolean bl2 = (image.alignment() & 8) == 8;
        float f = this.leading / 2.0f;
        if (bl) {
            f += this.leading;
        }
        float f2 = this.indentTop() - this.currentHeight - image.scaledHeight() - f;
        float[] fArray = image.matrix();
        float f3 = this.indentLeft() - fArray[4];
        if ((image.alignment() & 3) == 1) {
            f3 = this.indentRight() - image.scaledWidth() - fArray[4];
        }
        if ((image.alignment() & 3) == 3) {
            f3 = this.indentLeft() + (this.indentRight() - this.indentLeft() - image.scaledWidth()) / 2.0f - fArray[4];
        }
        if (image.hasAbsoluteX()) {
            f3 = image.absoluteX();
        }
        this.addImage(this.graphics, image, fArray[0], fArray[1], fArray[2], fArray[3], f3, f2 - fArray[5]);
        if (bl) {
            if (this.imageEnd < 0.0f || this.imageEnd < this.currentHeight + image.scaledHeight() + f) {
                this.imageEnd = this.currentHeight + image.scaledHeight() + f;
            }
            if ((image.alignment() & 1) == 1) {
                this.imageIndentRight += image.scaledWidth();
            } else {
                this.imageIndentLeft += image.scaledWidth();
            }
        }
        if (!bl && !bl2) {
            this.currentHeight += image.scaledHeight() + f;
            this.flushLines();
            this.text.moveText(0.0f, -(image.scaledHeight() + f));
            this.newLine();
        }
    }

    private void initPage() throws DocumentException {
        float f;
        Object object;
        this.annotations = this.delayedAnnotations;
        this.delayedAnnotations = new ArrayList();
        this.pageResources = new PageResources();
        this.writer.resetContent();
        ++this.pageN;
        float f2 = this.leading;
        int n = this.alignment;
        this.marginLeft = this.nextMarginLeft;
        this.marginRight = this.nextMarginRight;
        this.marginTop = this.nextMarginTop;
        this.marginBottom = this.nextMarginBottom;
        this.imageEnd = -1.0f;
        this.imageIndentRight = 0.0f;
        this.imageIndentLeft = 0.0f;
        this.graphics = new PdfContentByte(this.writer);
        this.text = new PdfContentByte(this.writer);
        this.text.beginText();
        this.text.moveText(this.left(), this.top());
        this.textEmptySize = this.text.size();
        this.text.reset();
        this.text.beginText();
        this.leading = 16.0f;
        this.indentBottom = 0.0f;
        this.indentTop = 0.0f;
        this.currentHeight = 0.0f;
        this.pageSize = this.nextPageSize;
        this.thisCropSize = this.cropSize;
        if (this.pageSize.backgroundColor() != null || this.pageSize.hasBorders() || this.pageSize.borderColor() != null || this.pageSize.grayFill() > 0.0f) {
            this.add(this.pageSize);
        }
        if (this.watermark != null) {
            object = this.watermark.matrix();
            this.addImage(this.graphics, this.watermark, object[0], object[1], object[2], object[3], this.watermark.offsetX() - object[4], this.watermark.offsetY() - object[5]);
        }
        if (this.footer != null) {
            float f3 = this.indentLeft;
            f = this.indentRight;
            this.indentRight = 0.0f;
            this.indentLeft = 0.0f;
            this.footer.setPageNumber(this.pageN);
            this.leading = this.footer.paragraph().leading();
            this.add(this.footer.paragraph());
            this.indentBottom = this.currentHeight;
            this.text.moveText(this.left(), this.indentBottom());
            this.flushLines();
            this.text.moveText(-this.left(), -this.bottom());
            this.footer.setTop(this.bottom(this.currentHeight));
            this.footer.setBottom(this.bottom() - 0.75f * this.leading);
            this.footer.setLeft(this.left());
            this.footer.setRight(this.right());
            this.graphics.rectangle(this.footer);
            this.indentBottom = this.currentHeight + this.leading * 2.0f;
            this.currentHeight = 0.0f;
            this.indentLeft = f3;
            this.indentRight = f;
        }
        this.text.moveText(this.left(), this.top());
        if (this.header != null) {
            float f4 = this.indentLeft;
            f = this.indentRight;
            this.indentRight = 0.0f;
            this.indentLeft = 0.0f;
            this.header.setPageNumber(this.pageN);
            this.leading = this.header.paragraph().leading();
            this.text.moveText(0.0f, this.leading);
            this.add(this.header.paragraph());
            this.newLine();
            this.indentTop = this.currentHeight - this.leading;
            this.header.setTop(this.top() + this.leading);
            this.header.setBottom(this.indentTop() + this.leading * 2.0f / 3.0f);
            this.header.setLeft(this.left());
            this.header.setRight(this.right());
            this.graphics.rectangle(this.header);
            this.flushLines();
            this.currentHeight = 0.0f;
            this.indentLeft = f4;
            this.indentRight = f;
        }
        this.pageEmpty = true;
        try {
            if (this.imageWait != null) {
                this.add(this.imageWait);
                this.imageWait = null;
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        this.leading = f2;
        this.alignment = n;
        this.carriageReturn();
        object = this.writer.getPageEvent();
        if (object != null) {
            if (this.firstPageEvent) {
                object.onOpenDocument(this.writer, this);
            }
            object.onStartPage(this.writer, this);
        }
        this.firstPageEvent = false;
    }

    private void carriageReturn() throws DocumentException {
        if (this.lines == null) {
            this.lines = new ArrayList();
        }
        if (this.line != null) {
            if (this.currentHeight + this.line.height() + this.leading < this.indentTop() - this.indentBottom()) {
                if (this.line.size() > 0) {
                    this.currentHeight += this.line.height();
                    this.lines.add(this.line);
                    this.pageEmpty = false;
                }
            } else {
                this.newPage();
            }
        }
        if (this.imageEnd > -1.0f && this.currentHeight > this.imageEnd) {
            this.imageEnd = -1.0f;
            this.imageIndentRight = 0.0f;
            this.imageIndentLeft = 0.0f;
        }
        this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
    }

    private void newLine() throws DocumentException {
        this.carriageReturn();
        if (this.lines != null && this.lines.size() > 0) {
            this.lines.add(this.line);
            this.currentHeight += this.line.height();
        }
        this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
    }

    private float flushLines() throws DocumentException {
        if (this.lines == null) {
            return 0.0f;
        }
        boolean bl = false;
        if (this.line != null && this.line.size() > 0) {
            this.lines.add(this.line);
            this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
            bl = true;
        }
        if (this.lines.size() == 0) {
            return 0.0f;
        }
        Object[] objectArray = new Object[2];
        PdfFont pdfFont = null;
        float f = 0.0f;
        Float f2 = new Float(0.0f);
        objectArray[1] = f2;
        Iterator iterator = this.lines.iterator();
        while (iterator.hasNext()) {
            PdfLine pdfLine = (PdfLine)iterator.next();
            if (this.isParagraphE && this.isNewpage && bl) {
                bl = false;
                this.text.moveText(pdfLine.indentLeft() - this.indentLeft() + this.listIndentLeft + this.paraIndent, -pdfLine.height());
            } else {
                this.text.moveText(pdfLine.indentLeft() - this.indentLeft() + this.listIndentLeft, -pdfLine.height());
            }
            if (pdfLine.listSymbol() != null) {
                Object object;
                PdfChunk pdfChunk = pdfLine.listSymbol();
                this.text.moveText(-pdfLine.listIndent(), 0.0f);
                if (pdfChunk.font().compareTo(pdfFont) != 0) {
                    pdfFont = pdfChunk.font();
                    this.text.setFontAndSize(pdfFont.getFont(), pdfFont.size());
                }
                if (pdfChunk.color() != null) {
                    object = pdfChunk.color();
                    this.text.setColorFill((Color)object);
                    this.text.showText(pdfChunk.toString());
                    this.text.resetRGBColorFill();
                } else if (pdfChunk.isImage()) {
                    object = pdfChunk.getImage();
                    float[] fArray = ((Image)object).matrix();
                    float f3 = this.text.getXTLM();
                    float f4 = this.text.getYTLM();
                    fArray[4] = f3 + pdfChunk.getImageOffsetX() - fArray[4];
                    fArray[5] = f4 + pdfChunk.getImageOffsetY() - fArray[5];
                    this.addImage(this.graphics, (Image)object, fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                } else {
                    this.text.showText(pdfChunk.toString());
                }
                this.text.moveText(pdfLine.listIndent(), 0.0f);
            }
            objectArray[0] = pdfFont;
            this.writeLineToContent(pdfLine, this.text, this.graphics, objectArray, this.writer.getSpaceCharRatio());
            pdfFont = (PdfFont)objectArray[0];
            f += pdfLine.height();
            if (this.indentLeft() - this.listIndentLeft == pdfLine.indentLeft()) continue;
            this.text.moveText(this.indentLeft() - pdfLine.indentLeft() - this.listIndentLeft, 0.0f);
        }
        this.lines = new ArrayList();
        return f;
    }

    PdfInfo getInfo() {
        return this.info;
    }

    PdfCatalog getCatalog(PdfIndirectReference pdfIndirectReference) {
        PdfCatalog pdfCatalog = this.rootOutline.getKids().size() > 0 ? new PdfCatalog(pdfIndirectReference, this.rootOutline.indirectReference()) : new PdfCatalog(pdfIndirectReference);
        if (this.openActionName != null) {
            PdfAction pdfAction = this.getLocalGotoAction(this.openActionName);
            pdfCatalog.setOpenAction(pdfAction);
        } else if (this.openActionAction != null) {
            pdfCatalog.setOpenAction(this.openActionAction);
        }
        if (this.additionalActions != null) {
            pdfCatalog.setAdditionalActions(this.additionalActions);
        }
        if (this.pageLabels != null) {
            pdfCatalog.setPageLabels(this.pageLabels);
        }
        pdfCatalog.addNames(this.localDestinations, this.documentJavaScript, this.writer);
        pdfCatalog.setViewerPreferences(this.viewerPreferences);
        if (this.acroForm.isValid()) {
            try {
                pdfCatalog.setAcroForm(this.writer.addToBody(this.acroForm).getIndirectReference());
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
        }
        return pdfCatalog;
    }

    float bottom(Table table) {
        float f = this.currentHeight > 0.0f ? this.indentTop() - this.currentHeight - 2.0f * this.leading : this.indentTop();
        PdfTable pdfTable = new PdfTable(table, this.indentLeft(), this.indentRight(), f);
        return pdfTable.bottom();
    }

    boolean fitsPage(PdfPTable pdfPTable, float f) {
        float f2 = (this.indentRight() - this.indentLeft()) * pdfPTable.getWidthPercentage() / 100.0f;
        pdfPTable.setTotalWidth(f2);
        return pdfPTable.getTotalHeight() <= this.indentTop() - this.currentHeight - this.indentBottom() - f;
    }

    private float indentLeft() {
        return this.left(this.indentLeft + this.listIndentLeft + this.imageIndentLeft);
    }

    private float indentRight() {
        return this.right(this.indentRight + this.imageIndentRight);
    }

    private float indentTop() {
        return this.top(this.indentTop);
    }

    float indentBottom() {
        return this.bottom(this.indentBottom);
    }

    void addOutline(PdfOutline pdfOutline, String string) {
        this.localDestination(string, pdfOutline.getPdfDestination());
    }

    public PdfAcroForm getAcroForm() {
        return this.acroForm;
    }

    public PdfOutline getRootOutline() {
        return this.rootOutline;
    }

    void writeLineToContent(PdfLine pdfLine, PdfContentByte pdfContentByte, PdfContentByte pdfContentByte2, Object[] objectArray, float f) throws DocumentException {
        float f2;
        float f3;
        boolean bl;
        PdfFont pdfFont = (PdfFont)objectArray[0];
        float f4 = ((Float)objectArray[1]).floatValue();
        float f5 = 0.0f;
        int n = pdfLine.numberOfSpaces();
        int n2 = pdfLine.toString().length();
        boolean bl2 = bl = pdfLine.hasToBeJustified() && (n != 0 || n2 > 1);
        if (bl) {
            if (pdfLine.isNewlineSplit() && pdfLine.widthLeft() >= f4 * (f * (float)n + (float)n2 - 1.0f)) {
                if (pdfLine.isRTL()) {
                    pdfContentByte.moveText(pdfLine.widthLeft() - f4 * (f * (float)n + (float)n2 - 1.0f), 0.0f);
                }
                pdfContentByte.setWordSpacing(f * f4);
                pdfContentByte.setCharacterSpacing(f4);
            } else {
                char c;
                String string;
                float f6 = pdfLine.widthLeft();
                PdfChunk pdfChunk = pdfLine.getChunk(pdfLine.size() - 1);
                if (pdfChunk != null && (string = pdfChunk.toString()).length() > 0 && hangingPunctuation.indexOf(c = string.charAt(string.length() - 1)) >= 0) {
                    f3 = f6;
                    f5 = (f6 += pdfChunk.font().width(c) * 0.4f) - f3;
                }
                f2 = f6 / (f * (float)n + (float)n2 - 1.0f);
                pdfContentByte.setWordSpacing(f * f2);
                pdfContentByte.setCharacterSpacing(f2);
                f4 = f2;
            }
        }
        int n3 = pdfLine.getLastStrokeChunk();
        int n4 = 0;
        float f7 = f2 = pdfContentByte.getXTLM();
        f3 = pdfContentByte.getYTLM();
        boolean bl3 = false;
        Iterator iterator = pdfLine.iterator();
        while (iterator.hasNext()) {
            Object object;
            float f8;
            PdfChunk pdfChunk = (PdfChunk)iterator.next();
            Color color = pdfChunk.color();
            if (n4 <= n3) {
                boolean bl4 = pdfChunk.isAttribute("STRIKETHRU") || pdfChunk.isAttribute("UNDERLINE");
                float f9 = bl ? pdfChunk.getWidthCorrected(f4, f * f4) : pdfChunk.width();
                if (pdfChunk.isStroked()) {
                    float f10;
                    Object object2;
                    float f11;
                    PdfChunk pdfChunk2 = pdfLine.getChunk(n4 + 1);
                    if (bl4) {
                        pdfContentByte2.setLineWidth(pdfChunk.font().size() / 15.0f);
                        if (color != null) {
                            pdfContentByte2.setColorStroke(color);
                        }
                    }
                    f8 = pdfChunk.font().size() / 3.0f;
                    if (pdfChunk.isAttribute("STRIKETHRU")) {
                        f11 = f4;
                        if (pdfChunk2 != null && pdfChunk2.isAttribute("STRIKETHRU")) {
                            f11 = 0.0f;
                        }
                        if (pdfChunk2 == null) {
                            f11 += f5;
                        }
                        pdfContentByte2.moveTo(f2, f3 + f8);
                        pdfContentByte2.lineTo(f2 + f9 - f11, f3 + f8);
                        pdfContentByte2.stroke();
                    }
                    if (pdfChunk.isAttribute("UNDERLINE")) {
                        f11 = f4;
                        if (pdfChunk2 != null && pdfChunk2.isAttribute("UNDERLINE")) {
                            f11 = 0.0f;
                        }
                        if (pdfChunk2 == null) {
                            f11 += f5;
                        }
                        pdfContentByte2.moveTo(f2, f3 - f8);
                        pdfContentByte2.lineTo(f2 + f9 - f11, f3 - f8);
                        pdfContentByte2.stroke();
                    }
                    if (pdfChunk.isAttribute("ACTION")) {
                        f11 = f4;
                        if (pdfChunk2 != null && pdfChunk2.isAttribute("ACTION")) {
                            f11 = 0.0f;
                        }
                        if (pdfChunk2 == null) {
                            f11 += f5;
                        }
                        this.annotations.add(new PdfAnnotation(this.writer, f2, f3, f2 + f9 - f11, f3 + pdfChunk.font().size(), (PdfAction)pdfChunk.getAttribute("ACTION")));
                    }
                    if (pdfChunk.isAttribute("REMOTEGOTO")) {
                        f11 = f4;
                        if (pdfChunk2 != null && pdfChunk2.isAttribute("REMOTEGOTO")) {
                            f11 = 0.0f;
                        }
                        if (pdfChunk2 == null) {
                            f11 += f5;
                        }
                        object = (Object[])pdfChunk.getAttribute("REMOTEGOTO");
                        object2 = (String)object[0];
                        if (object[1] instanceof String) {
                            this.remoteGoto((String)object2, (String)object[1], f2, f3, f2 + f9 - f11, f3 + pdfChunk.font().size());
                        } else {
                            this.remoteGoto((String)object2, (Integer)object[1], f2, f3, f2 + f9 - f11, f3 + pdfChunk.font().size());
                        }
                    }
                    if (pdfChunk.isAttribute("LOCALGOTO")) {
                        f11 = f4;
                        if (pdfChunk2 != null && pdfChunk2.isAttribute("LOCALGOTO")) {
                            f11 = 0.0f;
                        }
                        if (pdfChunk2 == null) {
                            f11 += f5;
                        }
                        this.localGoto((String)pdfChunk.getAttribute("LOCALGOTO"), f2, f3, f2 + f9 - f11, f3 + pdfChunk.font().size());
                    }
                    if (pdfChunk.isAttribute("LOCALDESTINATION")) {
                        f11 = f4;
                        if (pdfChunk2 != null && pdfChunk2.isAttribute("LOCALDESTINATION")) {
                            f11 = 0.0f;
                        }
                        if (pdfChunk2 == null) {
                            f11 += f5;
                        }
                        this.localDestination((String)pdfChunk.getAttribute("LOCALDESTINATION"), new PdfDestination(0, f2, f3 + pdfChunk.font().size(), 0.0f));
                    }
                    if (pdfChunk.isAttribute("GENERICTAG")) {
                        f11 = f4;
                        if (pdfChunk2 != null && pdfChunk2.isAttribute("GENERICTAG")) {
                            f11 = 0.0f;
                        }
                        if (pdfChunk2 == null) {
                            f11 += f5;
                        }
                        object = new Rectangle(f2, f3, f2 + f9 - f11, f3 + pdfChunk.font().size());
                        object2 = this.writer.getPageEvent();
                        if (object2 != null) {
                            object2.onGenericTag(this.writer, this, (Rectangle)object, (String)pdfChunk.getAttribute("GENERICTAG"));
                        }
                    }
                    if (pdfChunk.isAttribute("BACKGROUND")) {
                        f11 = f4;
                        if (pdfChunk2 != null && pdfChunk2.isAttribute("BACKGROUND")) {
                            f11 = 0.0f;
                        }
                        if (pdfChunk2 == null) {
                            f11 += f5;
                        }
                        float f12 = pdfChunk.font().size();
                        float f13 = pdfChunk.font().getFont().getFontDescriptor(1, f12);
                        f10 = pdfChunk.font().getFont().getFontDescriptor(3, f12);
                        pdfContentByte2.setColorFill((Color)pdfChunk.getAttribute("BACKGROUND"));
                        pdfContentByte2.rectangle(f2, f3 + f10, f9 - f11, f13 - f10);
                        pdfContentByte2.fill();
                        pdfContentByte2.setGrayFill(0.0f);
                    }
                    if (pdfChunk.isAttribute("PDFANNOTATION")) {
                        f11 = f4;
                        if (pdfChunk2 != null && pdfChunk2.isAttribute("PDFANNOTATION")) {
                            f11 = 0.0f;
                        }
                        if (pdfChunk2 == null) {
                            f11 += f5;
                        }
                        float f14 = pdfChunk.font().size();
                        float f15 = pdfChunk.font().getFont().getFontDescriptor(1, f14);
                        f10 = pdfChunk.font().getFont().getFontDescriptor(3, f14);
                        PdfAnnotation pdfAnnotation = PdfFormField.shallowDuplicate((PdfAnnotation)pdfChunk.getAttribute("PDFANNOTATION"));
                        pdfAnnotation.put(PdfName.RECT, new PdfRectangle(f2, f3 + f10, f2 + f9 - f11, f3 + f15));
                        this.addAnnotation(pdfAnnotation);
                    }
                    if (pdfChunk.isAttribute("SKEW")) {
                        float[] fArray = (float[])pdfChunk.getAttribute("SKEW");
                        pdfContentByte.setTextMatrix(1.0f, fArray[0], fArray[1], 1.0f, f2, f3);
                    }
                    if (pdfChunk.isImage()) {
                        Image image = pdfChunk.getImage();
                        float[] fArray = image.matrix();
                        fArray[4] = f2 + pdfChunk.getImageOffsetX() - fArray[4];
                        fArray[5] = f3 + pdfChunk.getImageOffsetY() - fArray[5];
                        this.addImage(pdfContentByte2, image, fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                        pdfContentByte.moveText(f2 + f4 + image.scaledWidth() - pdfContentByte.getXTLM(), 0.0f);
                    }
                    if (bl4) {
                        pdfContentByte2.setLineWidth(pdfChunk.font().size() / 15.0f);
                        if (color != null) {
                            pdfContentByte2.resetRGBColorStroke();
                        }
                    }
                }
                f2 += f9;
                ++n4;
            }
            if (pdfChunk.font().compareTo(pdfFont) != 0) {
                pdfFont = pdfChunk.font();
                pdfContentByte.setFontAndSize(pdfFont.getFont(), pdfFont.size());
            }
            float f16 = 0.0f;
            Object[] objectArray2 = (Object[])pdfChunk.getAttribute("TEXTRENDERMODE");
            int n5 = 0;
            f8 = 1.0f;
            Color color2 = null;
            object = (Object[])pdfChunk.getAttribute("SUBSUPSCRIPT");
            if (objectArray2 != null) {
                n5 = (Integer)objectArray2[0] & 3;
                if (n5 != 0) {
                    pdfContentByte.setTextRenderingMode(n5);
                }
                if (n5 == 1 || n5 == 2) {
                    f8 = ((Float)objectArray2[1]).floatValue();
                    if (f8 != 1.0f) {
                        pdfContentByte.setLineWidth(f8);
                    }
                    if ((color2 = (Color)objectArray2[2]) == null) {
                        color2 = color;
                    }
                    if (color2 != null) {
                        pdfContentByte.setColorStroke(color2);
                    }
                }
            }
            if (object != null) {
                f16 = object.floatValue();
            }
            if (color != null) {
                pdfContentByte.setColorFill(color);
            }
            if (f16 != 0.0f) {
                pdfContentByte.setTextRise(f16);
            }
            if (pdfChunk.isImage()) {
                bl3 = true;
            } else if (bl && n > 0 && pdfChunk.isSpecialEncoding()) {
                String string = pdfChunk.toString();
                int n6 = string.indexOf(32);
                if (n6 < 0) {
                    pdfContentByte.showText(pdfChunk.toString());
                } else {
                    float f17 = -f * f4 * 1000.0f / pdfChunk.font.size();
                    PdfTextArray pdfTextArray = new PdfTextArray(string.substring(0, n6));
                    int n7 = n6;
                    while ((n6 = string.indexOf(32, n7 + 1)) >= 0) {
                        pdfTextArray.add(f17);
                        pdfTextArray.add(string.substring(n7, n6));
                        n7 = n6;
                    }
                    pdfTextArray.add(f17);
                    pdfTextArray.add(string.substring(n7));
                    pdfContentByte.showText(pdfTextArray);
                }
            } else {
                pdfContentByte.showText(pdfChunk.toString());
            }
            if (f16 != 0.0f) {
                pdfContentByte.setTextRise(0.0f);
            }
            if (color != null) {
                pdfContentByte.resetRGBColorFill();
            }
            if (n5 != 0) {
                pdfContentByte.setTextRenderingMode(0);
            }
            if (color2 != null) {
                pdfContentByte.resetRGBColorStroke();
            }
            if (f8 != 1.0f) {
                pdfContentByte.setLineWidth(1.0f);
            }
            if (!pdfChunk.isAttribute("SKEW")) continue;
            bl3 = true;
            pdfContentByte.setTextMatrix(f2, f3);
        }
        if (bl) {
            pdfContentByte.setWordSpacing(0.0f);
            pdfContentByte.setCharacterSpacing(0.0f);
            if (pdfLine.isNewlineSplit()) {
                f4 = 0.0f;
            }
        }
        if (bl3) {
            pdfContentByte.moveText(f7 - pdfContentByte.getXTLM(), 0.0f);
        }
        objectArray[0] = pdfFont;
        objectArray[1] = new Float(f4);
    }

    void localGoto(String string, float f, float f2, float f3, float f4) {
        PdfAction pdfAction = this.getLocalGotoAction(string);
        this.annotations.add(new PdfAnnotation(this.writer, f, f2, f3, f4, pdfAction));
    }

    PdfAction getLocalGotoAction(String string) {
        PdfAction pdfAction;
        Object[] objectArray = (Object[])this.localDestinations.get(string);
        if (objectArray == null) {
            objectArray = new Object[3];
        }
        if (objectArray[0] == null) {
            if (objectArray[1] == null) {
                objectArray[1] = this.writer.getPdfIndirectReference();
            }
            pdfAction = new PdfAction((PdfIndirectReference)objectArray[1]);
            objectArray[0] = pdfAction;
            this.localDestinations.put(string, objectArray);
        } else {
            pdfAction = (PdfAction)objectArray[0];
        }
        return pdfAction;
    }

    boolean localDestination(String string, PdfDestination pdfDestination) {
        Object[] objectArray = (Object[])this.localDestinations.get(string);
        if (objectArray == null) {
            objectArray = new Object[3];
        }
        if (objectArray[2] != null) {
            return false;
        }
        objectArray[2] = pdfDestination;
        this.localDestinations.put(string, objectArray);
        pdfDestination.addPage(this.writer.getCurrentPage());
        return true;
    }

    void remoteGoto(String string, String string2, float f, float f2, float f3, float f4) {
        this.annotations.add(new PdfAnnotation(this.writer, f, f2, f3, f4, new PdfAction(string, string2)));
    }

    void remoteGoto(String string, int n, float f, float f2, float f3, float f4) {
        this.annotations.add(new PdfAnnotation(this.writer, f, f2, f3, f4, new PdfAction(string, n)));
    }

    public void setViewerPreferences(int n) {
        this.viewerPreferences |= n;
    }

    void setAction(PdfAction pdfAction, float f, float f2, float f3, float f4) {
        this.annotations.add(new PdfAnnotation(this.writer, f, f2, f3, f4, pdfAction));
    }

    void setOpenAction(String string) {
        this.openActionName = string;
        this.openActionAction = null;
    }

    void setOpenAction(PdfAction pdfAction) {
        this.openActionAction = pdfAction;
        this.openActionName = null;
    }

    void addAdditionalAction(PdfName pdfName, PdfAction pdfAction) {
        if (this.additionalActions == null) {
            this.additionalActions = new PdfDictionary();
        }
        this.additionalActions.put(pdfName, pdfAction);
    }

    void setPageLabels(PdfPageLabels pdfPageLabels) {
        this.pageLabels = pdfPageLabels;
    }

    void addJavaScript(PdfAction pdfAction) {
        if (pdfAction.get(PdfName.JS) == null) {
            throw new RuntimeException("Only JavaScript actions are allowed.");
        }
        try {
            this.documentJavaScript.add(this.writer.addToBody(pdfAction).getIndirectReference());
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    void setCropBoxSize(Rectangle rectangle) {
        this.cropSize = new Rectangle(rectangle);
    }

    void addCalculationOrder(PdfFormField pdfFormField) {
        this.acroForm.addCalculationOrder(pdfFormField);
    }

    void setSigFlags(int n) {
        this.acroForm.setSigFlags(n);
    }

    void addFormFieldRaw(PdfFormField pdfFormField) {
        this.annotations.add(pdfFormField);
        ArrayList arrayList = pdfFormField.getKids();
        if (arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                this.addFormFieldRaw((PdfFormField)arrayList.get(n));
                ++n;
            }
        }
    }

    void addAnnotation(PdfAnnotation pdfAnnotation) {
        this.pageEmpty = false;
        if (pdfAnnotation.isForm()) {
            PdfFormField pdfFormField = (PdfFormField)pdfAnnotation;
            if (pdfFormField.getParent() == null) {
                this.addFormFieldRaw(pdfFormField);
            }
        } else {
            this.annotations.add(pdfAnnotation);
        }
    }

    void setDuration(int n) {
        this.duration = n > 0 ? n : -1;
    }

    void setTransition(PdfTransition pdfTransition) {
        this.transition = pdfTransition;
    }

    void setPageAction(PdfName pdfName, PdfAction pdfAction) {
        if (this.pageAA == null) {
            this.pageAA = new PdfDictionary();
        }
        this.pageAA.put(pdfName, pdfAction);
    }

    boolean isStrictImageSequence() {
        return this.strictImageSequence;
    }

    void setStrictImageSequence(boolean bl) {
        this.strictImageSequence = bl;
    }

    void setPageEmpty(boolean bl) {
        this.pageEmpty = bl;
    }

    class PdfCatalog
    extends PdfDictionary {
        PdfCatalog(PdfIndirectReference pdfIndirectReference) {
            super(PdfDictionary.CATALOG);
            this.put(PdfName.PAGES, pdfIndirectReference);
        }

        PdfCatalog(PdfIndirectReference pdfIndirectReference, PdfIndirectReference pdfIndirectReference2) {
            super(PdfDictionary.CATALOG);
            this.put(PdfName.PAGES, pdfIndirectReference);
            this.put(PdfName.PAGEMODE, PdfName.USEOUTLINES);
            this.put(PdfName.OUTLINES, pdfIndirectReference2);
        }

        void addNames(TreeMap treeMap, ArrayList arrayList, PdfWriter pdfWriter) {
            if (treeMap.size() == 0 && arrayList.size() == 0) {
                return;
            }
            try {
                PdfObject pdfObject;
                Object object;
                String[] stringArray;
                PdfDictionary pdfDictionary = new PdfDictionary();
                if (treeMap.size() > 0) {
                    stringArray = new PdfArray();
                    Iterator iterator = treeMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        object = (String)iterator.next();
                        Object[] objectArray = (Object[])treeMap.get(object);
                        pdfObject = (PdfIndirectReference)objectArray[1];
                        stringArray.add(new PdfString((String)object));
                        stringArray.add(pdfObject);
                    }
                    object = new PdfDictionary();
                    ((PdfDictionary)object).put(PdfName.NAMES, (PdfObject)stringArray);
                    pdfDictionary.put(PdfName.DESTS, pdfWriter.addToBody((PdfObject)object).getIndirectReference());
                }
                if (arrayList.size() > 0) {
                    stringArray = new String[arrayList.size()];
                    int n = 0;
                    while (n < stringArray.length) {
                        stringArray[n] = Integer.toHexString(n);
                        ++n;
                    }
                    Arrays.sort(stringArray, new StringCompare());
                    object = new PdfArray();
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        ((PdfArray)object).add(new PdfString(stringArray[n2]));
                        ((PdfArray)object).add((PdfIndirectReference)arrayList.get(n2));
                        ++n2;
                    }
                    pdfObject = new PdfDictionary();
                    ((PdfDictionary)pdfObject).put(PdfName.NAMES, (PdfObject)object);
                    pdfDictionary.put(PdfName.JAVASCRIPT, pdfWriter.addToBody(pdfObject).getIndirectReference());
                }
                this.put(PdfName.NAMES, pdfWriter.addToBody(pdfDictionary).getIndirectReference());
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
        }

        void setViewerPreferences(int n) {
            if ((n & 1) != 0) {
                this.put(PdfName.PAGELAYOUT, PdfName.SINGLEPAGE);
            } else if ((n & 2) != 0) {
                this.put(PdfName.PAGELAYOUT, PdfName.ONECOLUMN);
            } else if ((n & 4) != 0) {
                this.put(PdfName.PAGELAYOUT, PdfName.TWOCOLUMNLEFT);
            } else if ((n & 8) != 0) {
                this.put(PdfName.PAGELAYOUT, PdfName.TWOCOLUMNRIGHT);
            }
            if ((n & 0x10) != 0) {
                this.put(PdfName.PAGEMODE, PdfName.USENONE);
            } else if ((n & 0x20) != 0) {
                this.put(PdfName.PAGEMODE, PdfName.USEOUTLINES);
            } else if ((n & 0x40) != 0) {
                this.put(PdfName.PAGEMODE, PdfName.USETHUMBS);
            } else if ((n & 0x80) != 0) {
                this.put(PdfName.PAGEMODE, PdfName.FULLSCREEN);
            }
            if ((n & 0x3FF00) == 0) {
                return;
            }
            PdfDictionary pdfDictionary = new PdfDictionary();
            if ((n & 0x100) != 0) {
                pdfDictionary.put(PdfName.HIDETOOLBAR, PdfBoolean.PDFTRUE);
            }
            if ((n & 0x200) != 0) {
                pdfDictionary.put(PdfName.HIDEMENUBAR, PdfBoolean.PDFTRUE);
            }
            if ((n & 0x400) != 0) {
                pdfDictionary.put(PdfName.HIDEWINDOWUI, PdfBoolean.PDFTRUE);
            }
            if ((n & 0x800) != 0) {
                pdfDictionary.put(PdfName.FITWINDOW, PdfBoolean.PDFTRUE);
            }
            if ((n & 0x1000) != 0) {
                pdfDictionary.put(PdfName.CENTERWINDOW, PdfBoolean.PDFTRUE);
            }
            if ((n & 0x2000) != 0) {
                pdfDictionary.put(PdfName.NONFULLSCREENPAGEMODE, PdfName.USENONE);
            } else if ((n & 0x4000) != 0) {
                pdfDictionary.put(PdfName.NONFULLSCREENPAGEMODE, PdfName.USEOUTLINES);
            } else if ((n & 0x8000) != 0) {
                pdfDictionary.put(PdfName.NONFULLSCREENPAGEMODE, PdfName.USETHUMBS);
            }
            if ((n & 0x10000) != 0) {
                pdfDictionary.put(PdfName.DIRECTION, PdfName.L2R);
            } else if ((n & 0x20000) != 0) {
                pdfDictionary.put(PdfName.DIRECTION, PdfName.R2L);
            }
            this.put(PdfName.VIEWERPREFERENCES, pdfDictionary);
        }

        void setOpenAction(PdfAction pdfAction) {
            this.put(PdfName.OPENACTION, pdfAction);
        }

        void setAdditionalActions(PdfDictionary pdfDictionary) {
            try {
                this.put(PdfName.AA, PdfDocument.this.writer.addToBody(pdfDictionary).getIndirectReference());
            }
            catch (Exception exception) {
                new ExceptionConverter(exception);
            }
        }

        void setPageLabels(PdfPageLabels pdfPageLabels) {
            this.put(PdfName.PAGELABELS, pdfPageLabels.getDictionary());
        }

        void setAcroForm(PdfObject pdfObject) {
            this.put(PdfName.ACROFORM, pdfObject);
        }
    }

    public class PdfInfo
    extends PdfDictionary {
        PdfInfo() {
            this.addProducer();
            this.addCreationDate();
        }

        PdfInfo(String string, String string2, String string3) {
            this();
            this.addTitle(string2);
            this.addSubject(string3);
            this.addAuthor(string);
        }

        void addTitle(String string) {
            this.put(PdfName.TITLE, new PdfString(string, "UnicodeBig"));
        }

        void addSubject(String string) {
            this.put(PdfName.SUBJECT, new PdfString(string, "UnicodeBig"));
        }

        void addKeywords(String string) {
            this.put(PdfName.KEYWORDS, new PdfString(string, "UnicodeBig"));
        }

        void addAuthor(String string) {
            this.put(PdfName.AUTHOR, new PdfString(string, "UnicodeBig"));
        }

        void addCreator(String string) {
            this.put(PdfName.CREATOR, new PdfString(string, "UnicodeBig"));
        }

        void addProducer() {
            this.put(PdfName.PRODUCER, new PdfString(Document.getVersion()));
        }

        void addCreationDate() {
            PdfDate pdfDate = new PdfDate();
            this.put(PdfName.CREATIONDATE, pdfDate);
            this.put(PdfName.MODDATE, pdfDate);
        }

        void addkey(String string, String string2) {
            if (string.equals("Producer") || string.equals("CreationDate")) {
                return;
            }
            this.put(new PdfName(string), new PdfString(string2, "UnicodeBig"));
        }
    }
}

