/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.servlets;

import com.lowagie.servlets.OutputFilterBase;
import com.lowagie.text.DocListener;
import com.lowagie.text.Document;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.html.HtmlWriter;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.rtf.RtfWriter;
import com.lowagie.text.xml.SAXiTextHandler;
import com.lowagie.text.xml.SAXmyHandler;
import com.lowagie.text.xml.TagMap;
import com.lowagie.text.xml.XmlWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class ITextOutputFilter
extends OutputFilterBase {
    public static final int PDF_OUTPUT_INT = 0;
    public static final int RTF_OUTPUT_INT = 1;
    public static final int XML_OUTPUT_INT = 2;
    public static final int HTML_OUTPUT_INT = 3;
    public static final int CUSTOM_OUTPUT_INT = 4;
    public static final Integer PDF_OUTPUT = new Integer(0);
    public static final Integer RTF_OUTPUT = new Integer(1);
    public static final Integer XML_OUTPUT = new Integer(2);
    public static final Integer HTML_OUTPUT = new Integer(3);
    public static final Integer CUSTOM_OUTPUT = new Integer(4);
    private static final String[] CONTENT_TYPES = new String[]{"application/pdf", "text/rtf", "text/xml", "text/html"};
    public static final String PAGE_SIZE_KEY = "ITEXT_PAGESIZE";
    public static final String OUTPUT_TYPE_KEY = "ITEXT_OUTPUT_TYPE";
    public static final String FILENAME_KEY = "ITEXT_FILENAME";
    public static final String TAGMAP_KEY = "ITEXT_TAGMAP";
    public static final String DOCWRITER_KEY = "ITEXT_DOCWRITER";
    public static final String CONTENT_TYPE_KEY = "ITEXT_CONTENTTYPE";
    private Rectangle pageSize = PageSize.A4;
    private int outputType = PDF_OUTPUT;
    private String docWriter = null;
    private String contentType = CONTENT_TYPES[0];
    private static final String PAGE_SIZE = "pageSize";
    private static final String OUTPUT_TYPE = "defaultOutput";
    private static final String CUSTOM_WRITER = "writer";
    private static final String CONTENT_TYPE = "contentType";
    private static final Class[] INIT_PARAMS = new Class[]{class$com$lowagie$text$Document == null ? (class$com$lowagie$text$Document = ITextOutputFilter.class$("com.lowagie.text.Document")) : class$com$lowagie$text$Document, class$java$io$OutputStream == null ? (class$java$io$OutputStream = ITextOutputFilter.class$("java.io.OutputStream")) : class$java$io$OutputStream};
    private final HashMap construtores = new HashMap();
    static /* synthetic */ Class class$com$lowagie$text$Document;
    static /* synthetic */ Class class$java$io$OutputStream;
    static /* synthetic */ Class class$com$lowagie$text$PageSize;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        String string = filterConfig.getInitParameter(PAGE_SIZE);
        if (string != null) {
            try {
                this.pageSize = (Rectangle)(class$com$lowagie$text$PageSize == null ? (class$com$lowagie$text$PageSize = ITextOutputFilter.class$("com.lowagie.text.PageSize")) : class$com$lowagie$text$PageSize).getField(string).get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = filterConfig.getInitParameter(OUTPUT_TYPE)) != null) {
            if (string.equalsIgnoreCase("PDF")) {
                this.outputType = PDF_OUTPUT;
            } else if (string.equalsIgnoreCase("RTF")) {
                this.outputType = RTF_OUTPUT;
            } else if (string.equalsIgnoreCase("XML")) {
                this.outputType = XML_OUTPUT;
            } else if (string.equalsIgnoreCase("HTML")) {
                this.outputType = HTML_OUTPUT;
            } else if (string.equalsIgnoreCase("CUSTOM")) {
                string = filterConfig.getInitParameter(CUSTOM_WRITER);
                if (string == null) {
                    this.outputType = PDF_OUTPUT;
                } else {
                    try {
                        this.construtores.put(string, Class.forName(string).getMethod("getInstance", INIT_PARAMS));
                        this.docWriter = string;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    string = filterConfig.getInitParameter(CONTENT_TYPE);
                    if (string != null) {
                        this.contentType = string;
                    }
                }
            }
        }
    }

    public void perform(ServletRequest servletRequest, ServletResponse servletResponse, InputStream inputStream) throws Exception {
        Object object;
        Object object2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document();
        if (servletRequest.getAttribute(PAGE_SIZE_KEY) != null) {
            try {
                object2 = (Rectangle)servletRequest.getAttribute(PAGE_SIZE_KEY);
                document.setPageSize((Rectangle)object2);
            }
            catch (Exception exception) {
                document.setPageSize(this.pageSize);
            }
        } else {
            document.setPageSize(this.pageSize);
        }
        object2 = new Integer(this.outputType);
        try {
            object = (Integer)servletRequest.getAttribute(OUTPUT_TYPE_KEY);
            if (object != null && ((Integer)object).compareTo(PDF_OUTPUT) >= 0 && ((Integer)object).compareTo(CUSTOM_OUTPUT) <= 0) {
                object2 = object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch ((Integer)object2) {
            case 1: {
                RtfWriter.getInstance(document, byteArrayOutputStream);
                break;
            }
            case 2: {
                XmlWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
                break;
            }
            case 3: {
                HtmlWriter.getInstance(document, byteArrayOutputStream);
                break;
            }
            case 4: {
                Object[] objectArray;
                object = (String)servletRequest.getAttribute(DOCWRITER_KEY);
                if (object == null) {
                    object = this.docWriter;
                }
                if (object == null) {
                    throw new IllegalArgumentException("No DocWriter specified.");
                }
                Method method = (Method)this.construtores.get(object);
                if (method == null) {
                    objectArray = this.construtores;
                    synchronized (objectArray) {
                        method = Class.forName((String)object).getMethod("getInstance", INIT_PARAMS);
                        this.construtores.put(object, method);
                    }
                }
                objectArray = new Object[]{document, byteArrayOutputStream};
                method.invoke(null, objectArray);
                break;
            }
            default: {
                PdfWriter.getInstance(document, byteArrayOutputStream);
            }
        }
        SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
        Object object3 = servletRequest.getAttribute(TAGMAP_KEY);
        if (object3 != null) {
            if (object3 instanceof HashMap) {
                sAXParser.parse(inputStream, (DefaultHandler)new SAXmyHandler((DocListener)document, (HashMap)object3));
            } else {
                sAXParser.parse(inputStream, (DefaultHandler)new SAXmyHandler((DocListener)document, (HashMap)new TagMap(object3.toString())));
            }
        } else {
            sAXParser.parse(inputStream, (DefaultHandler)new SAXiTextHandler((DocListener)document));
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Object object4 = servletRequest.getAttribute(FILENAME_KEY);
        if (object4 != null) {
            ((HttpServletResponse)servletResponse).setHeader("Content-Disposition", "attachment;filename=" + object4);
        }
        if (!((Integer)object2).equals(CUSTOM_OUTPUT)) {
            servletResponse.setContentType(CONTENT_TYPES[(Integer)object2]);
        } else {
            String string = (String)servletRequest.getAttribute(CONTENT_TYPE_KEY);
            if (string == null) {
                string = this.contentType;
            }
            servletResponse.setContentType(string);
        }
        servletResponse.setContentLength(byArray.length);
        this.dump(new ByteArrayInputStream(byArray), servletResponse);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

