/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Barrier;
import EDU.oswego.cs.dl.util.concurrent.BrokenBarrierException;
import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import EDU.oswego.cs.dl.util.concurrent.TimeoutException;
import EDU.oswego.cs.dl.util.concurrent.WaiterPreferenceSemaphore;

public class Rendezvous
implements Barrier {
    protected final int parties_;
    protected boolean broken_ = false;
    protected int entries_ = 0;
    protected long departures_ = 0L;
    protected final Semaphore entryGate_;
    protected final Object[] slots_;
    protected RendezvousFunction rendezvousFunction_;

    public Rendezvous(int parties) {
        this(parties, new Rotator());
    }

    public Rendezvous(int parties, RendezvousFunction function) {
        if (parties <= 0) {
            throw new IllegalArgumentException();
        }
        this.parties_ = parties;
        this.rendezvousFunction_ = function;
        this.entryGate_ = new WaiterPreferenceSemaphore(parties);
        this.slots_ = new Object[parties];
    }

    public synchronized RendezvousFunction setRendezvousFunction(RendezvousFunction function) {
        RendezvousFunction old = this.rendezvousFunction_;
        this.rendezvousFunction_ = function;
        return old;
    }

    public int parties() {
        return this.parties_;
    }

    public synchronized boolean broken() {
        return this.broken_;
    }

    public void restart() {
        while (true) {
            Rendezvous rendezvous = this;
            synchronized (rendezvous) {
                if (this.entries_ == 0) {
                    this.broken_ = false;
                    return;
                }
                this.notifyAll();
            }
            Thread.yield();
        }
    }

    public Object rendezvous(Object x) throws InterruptedException, BrokenBarrierException {
        return this.doRendezvous(x, false, 0L);
    }

    public Object attemptRendezvous(Object x, long msecs) throws InterruptedException, TimeoutException, BrokenBarrierException {
        return this.doRendezvous(x, true, msecs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object doRendezvous(Object x, boolean timed, long msecs) throws InterruptedException, TimeoutException, BrokenBarrierException {
        long startTime;
        if (timed) {
            startTime = System.currentTimeMillis();
            if (!this.entryGate_.attempt(msecs)) {
                throw new TimeoutException(msecs);
            }
        } else {
            startTime = 0L;
            this.entryGate_.acquire();
        }
        Rendezvous rendezvous = this;
        synchronized (rendezvous) {
            int index;
            Object y;
            block24: {
                int i2;
                Throwable throwable2;
                block23: {
                    y = null;
                    index = this.entries_++;
                    this.slots_[index] = x;
                    try {
                        if (this.entries_ == this.parties_) {
                            this.departures_ = this.entries_;
                            this.notifyAll();
                            try {
                                if (!this.broken_ && this.rendezvousFunction_ != null) {
                                    this.rendezvousFunction_.rendezvousFunction(this.slots_);
                                }
                            }
                            catch (RuntimeException ex) {
                                this.broken_ = true;
                            }
                        } else {
                            while (!this.broken_) {
                                if (this.departures_ >= 1L) {
                                    break;
                                }
                                long timeLeft = 0L;
                                if (timed && (timeLeft = msecs - (System.currentTimeMillis() - startTime)) <= 0L) {
                                    this.broken_ = true;
                                    this.departures_ = this.entries_;
                                    this.notifyAll();
                                    throw new TimeoutException(msecs);
                                }
                                try {
                                    this.wait(timeLeft);
                                }
                                catch (InterruptedException ex) {
                                    if (!this.broken_ && this.departures_ <= 0L) {
                                        this.broken_ = true;
                                        this.departures_ = this.entries_;
                                        this.notifyAll();
                                        throw ex;
                                    }
                                    Thread.currentThread().interrupt();
                                    break;
                                }
                            }
                        }
                        Object var14_12 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var14_13 = null;
                        y = this.slots_[index];
                        if (--this.departures_ > 0L) throw throwable2;
                        i2 = 0;
                        break block23;
                    }
                    y = this.slots_[index];
                    if (--this.departures_ <= 0L) {
                        int i2 = 0;
                        while (true) {
                            if (i2 >= this.slots_.length) {
                                this.entryGate_.release(this.entries_);
                                this.entries_ = 0;
                                break block24;
                            }
                            this.slots_[i2] = null;
                            ++i2;
                        }
                    }
                    break block24;
                }
                while (true) {
                    if (i2 >= this.slots_.length) break;
                    this.slots_[i2] = null;
                    ++i2;
                }
                this.entryGate_.release(this.entries_);
                this.entries_ = 0;
                throw throwable2;
            }
            if (!this.broken_) return y;
            throw new BrokenBarrierException(index);
        }
    }

    public static class Rotator
    implements RendezvousFunction {
        public void rendezvousFunction(Object[] objects) {
            int lastIdx = objects.length - 1;
            Object first = objects[0];
            int i = 0;
            while (i < lastIdx) {
                objects[i] = objects[i + 1];
                ++i;
            }
            objects[lastIdx] = first;
        }
    }

    public static interface RendezvousFunction {
        public void rendezvousFunction(Object[] var1);
    }
}

