/*
 * Decompiled with CFR 0.152.
 */
package com.tombrus.javaParser.compiler141;

import com.sun.tools.javac.v8.code.Flags;
import com.sun.tools.javac.v8.code.Symbol;
import com.sun.tools.javac.v8.tree.Pretty;
import com.sun.tools.javac.v8.tree.Tree;
import com.sun.tools.javac.v8.tree.TreeInfo;
import com.sun.tools.javac.v8.util.Convert;
import com.sun.tools.javac.v8.util.Hashtable;
import com.sun.tools.javac.v8.util.List;
import com.sun.tools.javac.v8.util.Name;
import com.sun.tools.javac.v8.util.Position;
import java.io.PrintStream;
import java.io.PrintWriter;

public class Dumpy
extends Tree.Visitor
implements Flags {
    private int width = 4;
    private PrintStream out;
    private int lmargin;
    private Hashtable ends;
    private Pretty pretty;

    public Dumpy(String string) {
        this(string, System.err);
    }

    public Dumpy(String string, PrintStream printStream) {
        this.out = printStream;
        this.pretty = new Pretty(new PrintWriter(printStream), false);
        this.print("+++++ " + string + " Tree Dump:");
        this.println();
    }

    public void dump(List list) {
        this.printList(list);
        this.println();
    }

    public void dump(Tree tree) {
        this.printTree(tree);
        this.println();
    }

    void align() {
        int n = 0;
        while (n < this.lmargin) {
            this.out.print(" ");
            ++n;
        }
    }

    void indent() {
        this.lmargin += this.width;
    }

    void undent() {
        this.lmargin -= this.width;
    }

    public void print(String string) {
        this.out.print(Convert.escapeUnicode((String)string));
    }

    public void println() {
        this.out.println();
    }

    public void printTree(Tree tree) {
        this.printTree(null, tree);
    }

    public void printTree(String string, Tree tree) {
        if (tree != null) {
            this.println();
            this.align();
            if (string != null) {
                this.print(string);
                this.print(" ");
            }
            this.printLC(tree);
            this.indent();
            tree.accept((Tree.Visitor)this);
            this.undent();
        }
    }

    public void printList(List list) {
        this.printList(null, list);
    }

    public void printList(String string, List list) {
        int n = 0;
        while (list != null && list.nonEmpty()) {
            this.printTree((string == null ? "" : string) + "[" + n + "]", (Tree)list.head);
            ++n;
            list = list.tail;
        }
    }

    public void printName(Name name) {
        if (name != null) {
            this.print(name.toString());
        }
    }

    public void printSymb(Symbol symbol) {
        this.printSymb(null, symbol);
    }

    public void printSymb(String string, Symbol symbol) {
        if (symbol != null) {
            this.println();
            this.align();
            if (string != null) {
                this.print(string);
                this.print(" ");
            }
            this.indent();
            this.print(this.getSubClassName(symbol) + " " + symbol.toJava() + " ");
            this.undent();
        }
    }

    public static String getFlags(long l) {
        return ((l & 0x10000L) != 0L ? "/*synthetic*/ " : "") + TreeInfo.flagNames((long)l) + " ";
    }

    public void printLC(Tree tree) {
        Integer n;
        String string = null;
        if (this.ends != null && (n = (Integer)this.ends.get((Object)tree)) != null) {
            string = this.makeLC(tree.pos, n);
        }
        if (string == null) {
            string = this.makeLC(tree.pos);
        }
        this.print("[" + this.getSubClassName(tree) + ":" + string + "] ");
    }

    public String makeLC(int n) {
        return Position.line((int)n) + "," + Position.column((int)n);
    }

    public String makeLC(int n, int n2) {
        if (Position.line((int)n) == Position.line((int)n2)) {
            return this.makeLC(n) + "..." + Position.column((int)n2);
        }
        return this.makeLC(n) + "..." + this.makeLC(n2);
    }

    public String getSubClassName(Object object) {
        String string = object.getClass().getName();
        int n = string.indexOf("$");
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return "#" + string + "#";
    }

    public void visitTopLevel(Tree.TopLevel topLevel) {
        this.ends = topLevel.endPositions;
        this.printName(topLevel.sourcefile);
        this.printTree("pid   ", topLevel.pid);
        this.printSymb("packge", (Symbol)topLevel.packge);
        this.printList("defs  ", topLevel.defs);
        this.ends = null;
    }

    public void visitImport(Tree.Import import_) {
        this.printTree("qualid", import_.qualid);
    }

    public void visitClassDef(Tree.ClassDef classDef) {
        this.print(Dumpy.getFlags(classDef.flags) + classDef.name);
        this.printSymb("===>>       ", (Symbol)classDef.sym);
        this.printTree("extending   ", classDef.extending);
        this.printList("implementing", classDef.implementing);
        this.printList("defs        ", classDef.defs);
    }

    public void visitMethodDef(Tree.MethodDef methodDef) {
        this.print(Dumpy.getFlags(methodDef.flags) + methodDef.name);
        this.printSymb("===>>  ", (Symbol)methodDef.sym);
        this.printTree("restype", methodDef.restype);
        this.printList("params ", methodDef.params);
        this.printList("thrown ", methodDef.thrown);
        this.printTree("body   ", (Tree)methodDef.body);
    }

    public void visitVarDef(Tree.VarDef varDef) {
        this.print(Dumpy.getFlags(varDef.flags) + varDef.name);
        this.printSymb("===>>  ", (Symbol)varDef.sym);
        this.printTree("vartype", varDef.vartype);
        this.printTree("init   ", varDef.init);
    }

    public void visitSkip(Tree.Skip skip) {
    }

    public void visitBlock(Tree.Block block) {
        this.print(Dumpy.getFlags(block.flags) + "{}");
        this.printList(block.stats);
    }

    public void visitDoLoop(Tree.DoLoop doLoop) {
        this.printTree("cond", doLoop.cond);
        this.printTree("body", doLoop.body);
    }

    public void visitWhileLoop(Tree.WhileLoop whileLoop) {
        this.printTree("cond", whileLoop.cond);
        this.printTree("body", whileLoop.body);
    }

    public void visitForLoop(Tree.ForLoop forLoop) {
        this.printList("init", forLoop.init);
        this.printTree("cond", forLoop.cond);
        this.printList("step", forLoop.step);
        this.printTree("body", forLoop.body);
    }

    public void visitLabelled(Tree.Labelled labelled) {
        this.printName(labelled.label);
        this.printTree("body", labelled.body);
    }

    public void visitSwitch(Tree.Switch switch_) {
        this.printTree("selector", switch_.selector);
        this.printList("cases   ", switch_.cases);
    }

    public void visitCase(Tree.Case case_) {
        this.printTree("cpat ", case_.pat);
        this.printList("stats", case_.stats);
    }

    public void visitSynchronized(Tree.Synchronized synchronized_) {
        this.printTree("lock", synchronized_.lock);
        this.printTree("body", synchronized_.body);
    }

    public void visitTry(Tree.Try try_) {
        this.printTree("body     ", try_.body);
        this.printList("catchers ", try_.catchers);
        this.printTree("finalizer", try_.finalizer);
    }

    public void visitCatch(Tree.Catch catch_) {
        this.printTree("param", (Tree)catch_.param);
        this.printTree("body ", catch_.body);
    }

    public void visitConditional(Tree.Conditional conditional) {
        this.printTree("cond     ", conditional.cond);
        this.printTree("truepart ", conditional.truepart);
        this.printTree("falsepart", conditional.falsepart);
    }

    public void visitIf(Tree.If if_) {
        this.printTree("cond    ", if_.cond);
        this.printTree("thenpart", if_.thenpart);
        this.printTree("elsepart", if_.elsepart);
    }

    public void visitExec(Tree.Exec exec) {
        this.printTree("expr", exec.expr);
    }

    public void visitBreak(Tree.Break break_) {
        this.printName(break_.label);
    }

    public void visitContinue(Tree.Continue continue_) {
        this.printName(continue_.label);
    }

    public void visitReturn(Tree.Return return_) {
        this.printTree("expr", return_.expr);
    }

    public void visitThrow(Tree.Throw throw_) {
        this.printTree("expr", throw_.expr);
    }

    public void visitAssert(Tree.Assert assert_) {
        this.printTree("cond  ", assert_.cond);
        this.printTree("detail", assert_.detail);
    }

    public void visitApply(Tree.Apply apply) {
        this.printTree("meth", apply.meth);
        this.printList("args", apply.args);
    }

    public void visitNewClass(Tree.NewClass newClass) {
        this.printSymb("constr===>>", newClass.constructor);
        this.printTree("encl       ", newClass.encl);
        this.printTree("clazz      ", newClass.clazz);
        this.printList("args       ", newClass.args);
        this.printTree("def        ", (Tree)newClass.def);
    }

    public void visitNewArray(Tree.NewArray newArray) {
        this.printTree("elemtype", newArray.elemtype);
        this.printList("dims    ", newArray.dims);
        this.printList("elems   ", newArray.elems);
    }

    public void visitParens(Tree.Parens parens) {
        this.printTree("expr", parens.expr);
    }

    public void visitAssign(Tree.Assign assign) {
        this.printTree("lhs", assign.lhs);
        this.printTree("rhs", assign.rhs);
    }

    public void visitAssignop(Tree.Assignop assignop) {
        this.print(this.pretty.operatorName(assignop.tag - 17));
        this.printTree("lhs", assignop.lhs);
        this.printTree("rhs", assignop.rhs);
    }

    public void visitUnary(Tree.Unary unary) {
        this.print(this.pretty.operatorName(unary.tag));
        this.printTree("arg", unary.arg);
    }

    public void visitBinary(Tree.Binary binary) {
        this.print(this.pretty.operatorName(binary.tag));
        this.printTree("lhs", binary.lhs);
        this.printTree("rhs", binary.rhs);
    }

    public void visitTypeCast(Tree.TypeCast typeCast) {
        this.printTree("expr ", typeCast.expr);
        this.printTree("clazz", typeCast.clazz);
    }

    public void visitTypeTest(Tree.TypeTest typeTest) {
        this.printTree("expr ", typeTest.expr);
        this.printTree("clazz", typeTest.clazz);
    }

    public void visitIndexed(Tree.Indexed indexed) {
        this.printTree("indexed", indexed.indexed);
        this.printTree("index  ", indexed.index);
    }

    public void visitSelect(Tree.Select select) {
        this.printName(select.name);
        this.printSymb("===>>   ", select.sym);
        this.printTree("selected", select.selected);
    }

    public void visitIdent(Tree.Ident ident) {
        this.printName(ident.name);
        this.printSymb("===>>", ident.sym);
    }

    public void visitLiteral(Tree.Literal literal) {
        this.pretty.visitLiteral(literal);
    }

    public void visitTypeIdent(Tree.TypeIdent typeIdent) {
        this.pretty.visitTypeIdent(typeIdent);
    }

    public void visitTypeArray(Tree.TypeArray typeArray) {
        this.printTree("elemtype", typeArray.elemtype);
    }

    public void visitErroneous(Tree.Erroneous erroneous) {
        this.print("(ERROR)");
    }

    public void visitTree(Tree tree) {
        this.print("(UNKNOWN: " + tree + ")");
    }
}

