/*
 * Decompiled with CFR 0.152.
 */
package com.tombrus.javaParser.compiler140;

import com.sun.tools.javac.v8.util.Hashtable;
import com.sun.tools.javac.v8.util.List;
import com.tombrus.javaParser.CancelCompile;
import com.tombrus.javaParser.CompilerCallerCreator;
import com.tombrus.javaParser.CompilerCallerInterface;
import com.tombrus.javaParser.Examiner;
import com.tombrus.javaParser.ParserException;
import com.tombrus.javaParser.ProgressKeeper;
import com.tombrus.javaParser.compiler140.AdaptedLog;
import com.tombrus.javaParser.compiler140.Dumpy;
import com.tombrus.javaParser.compiler140.TwistedCompiler;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;

public class CompilerCaller
implements CompilerCallerInterface {
    private static final int NUM_PROGRESS_PHASES = 6;
    public boolean dumpTree;
    public boolean showCompilerOutput;

    public void setDebugFlags(boolean bl, boolean bl2) {
        this.showCompilerOutput = bl2;
        this.dumpTree = bl;
    }

    public void compile(String string, File[] fileArray, Examiner examiner) {
        this.compile(string, fileArray, examiner, null);
    }

    public void compile(String string, File[] fileArray, Examiner examiner, HashMap hashMap) {
        Object object;
        Hashtable hashtable = new Hashtable();
        if (hashMap != null) {
            object = hashMap.keySet().iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                hashtable.put((Object)string2, hashMap.get(string2));
            }
        }
        hashtable.put((Object)"-classpath", (Object)string);
        object = new ArrayList();
        int n = 0;
        while (n < fileArray.length) {
            ((ArrayList)object).add(fileArray[n].getPath());
            ++n;
        }
        Object[] objectArray = ((ArrayList)object).toArray(new String[((ArrayList)object).size()]);
        StringWriter stringWriter = new StringWriter();
        ProgressKeeper progressKeeper = new ProgressKeeper(examiner, 6 * (objectArray.length - 1));
        AdaptedLog adaptedLog = new AdaptedLog(new PrintWriter(stringWriter));
        TwistedCompiler twistedCompiler = new TwistedCompiler(adaptedLog, hashtable, examiner, progressKeeper);
        try {
            CancelCompile.checkCancel(examiner);
            twistedCompiler.compile(List.make((Object[])objectArray));
            CancelCompile.checkCancel(examiner);
            List list = twistedCompiler.getTrees();
            if (this.dumpTree) {
                new Dumpy("Tree after compile:").dump(list);
            }
            this.visitAllVisitors(examiner, progressKeeper, list);
        }
        catch (CancelCompile cancelCompile) {
        }
        catch (OutOfMemoryError outOfMemoryError) {
            examiner.outOfMemoryError(outOfMemoryError);
        }
        catch (Throwable throwable) {
            System.err.println("Throwable during compile: " + throwable);
            throwable.printStackTrace();
            if (throwable instanceof ParserException) {
                throw (ParserException)throwable;
            }
            throw new ParserException("Compiler says: " + throwable.getMessage());
        }
        if (this.showCompilerOutput) {
            System.err.println("COMPILER OUTPUT:");
            System.err.println(stringWriter.toString());
        }
    }

    private void visitAllVisitors(Examiner examiner, ProgressKeeper progressKeeper, List list) {
        Runnable[] runnableArray = examiner.getVisitors(CompilerCallerCreator.getAvailableCompilerMarker(), progressKeeper, list);
        int n = 0;
        while (n < runnableArray.length) {
            runnableArray[n].run();
            ++n;
        }
    }
}

