/*
 * Decompiled with CFR 0.152.
 */
package com.tombrus.cleanImports.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;

public class Import {
    private String packageName;
    private String className;
    private boolean uncollapseable;
    private Set ambiguousWith;

    public Import(String string) {
        this(Import.getPackageBit(string), Import.getClassBit(string));
    }

    public Import(String string, String string2) {
        this.packageName = string;
        this.className = string2;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getFullClassName() {
        return this.packageName + "." + this.className;
    }

    public String toString() {
        return this.getFullClassName();
    }

    public StringBuffer appendImportStatement(StringBuffer stringBuffer, boolean bl, boolean bl2) {
        if (bl) {
            stringBuffer.append("// ");
        }
        stringBuffer.append("import ").append(this).append(";");
        if (bl2 && this.isAmbiguous()) {
            this.appendAmbiguityComment(stringBuffer);
        }
        return stringBuffer;
    }

    public boolean isUncollapseable() {
        return this.uncollapseable || this.isAmbiguous();
    }

    public void setUncollapseable(boolean bl) {
        this.uncollapseable = bl;
    }

    public boolean isAmbiguous() {
        return this.ambiguousWith != null && this.ambiguousWith.size() > 0;
    }

    public void addAmbiguousWith(String string) {
        if (this.ambiguousWith == null) {
            this.ambiguousWith = new HashSet();
        }
        this.ambiguousWith.add(string);
    }

    public void addAmbiguousWith(Collection collection) {
        if (this.ambiguousWith == null) {
            this.ambiguousWith = new HashSet();
        }
        this.ambiguousWith.addAll(collection);
    }

    public StringBuffer appendAmbiguityComment(StringBuffer stringBuffer) {
        stringBuffer.append(" // ambiguous with: ");
        Iterator iterator = this.ambiguousWith.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next()).append(" ");
        }
        return stringBuffer;
    }

    public boolean findMatch(Pattern pattern) {
        return pattern.matcher(this.toString()).find();
    }

    public boolean equals(Object object) {
        boolean bl = object instanceof Import;
        if (bl) {
            Import import_ = (Import)object;
            bl = import_.getPackageName() == this.getPackageName() && import_.getClassName() == this.getClassName();
        }
        return bl;
    }

    public int hashCode() {
        return this.getPackageName().hashCode() + this.getClassName().hashCode();
    }

    static String getClassBit(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string.intern();
    }

    static String getPackageBit(String string) {
        int n = string.lastIndexOf(46);
        string = n >= 0 ? string.substring(0, n) : "";
        return string.intern();
    }
}

