/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.codegen.intfc;

import com.mchange.v1.lang.ClassUtils;
import com.mchange.v2.codegen.CodegenUtils;
import com.mchange.v2.codegen.IndentedWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeSet;

public class DelegatorGenerator {
    int class_modifiers = 1025;
    int method_modifiers = 1;
    int wrapping_ctor_modifiers = 1;
    int default_ctor_modifiers = 1;
    boolean wrapping_constructor = true;
    boolean default_constructor = true;
    boolean inner_getter = true;
    boolean inner_setter = true;
    Class superclass = null;
    Class[] extraInterfaces = null;
    static final Comparator classComp = new Comparator(){

        public int compare(Object a, Object b) {
            return ((Class)a).getName().compareTo(((Class)b).getName());
        }
    };

    public void setGenerateInnerSetter(boolean b) {
        this.inner_setter = b;
    }

    public boolean isGenerateInnerSetter() {
        return this.inner_setter;
    }

    public void setGenerateInnerGetter(boolean b) {
        this.inner_getter = b;
    }

    public boolean isGenerateInnerGetter() {
        return this.inner_getter;
    }

    public void setGenerateNoArgConstructor(boolean b) {
        this.default_constructor = b;
    }

    public boolean isGenerateNoArgConstructor() {
        return this.default_constructor;
    }

    public void setGenerateWrappingConstructor(boolean b) {
        this.wrapping_constructor = b;
    }

    public boolean isGenerateWrappingConstructor() {
        return this.wrapping_constructor;
    }

    public void setWrappingConstructorModifiers(int modifiers) {
        this.wrapping_ctor_modifiers = modifiers;
    }

    public int getWrappingConstructorModifiers() {
        return this.wrapping_ctor_modifiers;
    }

    public void setNoArgConstructorModifiers(int modifiers) {
        this.default_ctor_modifiers = modifiers;
    }

    public int getNoArgConstructorModifiers() {
        return this.default_ctor_modifiers;
    }

    public void setMethodModifiers(int modifiers) {
        this.method_modifiers = modifiers;
    }

    public int getMethodModifiers() {
        return this.method_modifiers;
    }

    public void setClassModifiers(int modifiers) {
        this.class_modifiers = modifiers;
    }

    public int getClassModifiers() {
        return this.class_modifiers;
    }

    public void setSuperclass(Class superclass) {
        this.superclass = superclass;
    }

    public Class getSuperclass() {
        return this.superclass;
    }

    public void setExtraInterfaces(Class[] extraInterfaces) {
        this.extraInterfaces = extraInterfaces;
    }

    public Class[] getExtraInterfaces() {
        return this.extraInterfaces;
    }

    public void writeDelegator(Class intfcl, String genclass, Writer w) throws IOException {
        int i;
        int len;
        IndentedWriter iw = CodegenUtils.toIndentedWriter(w);
        String pkg = genclass.substring(0, genclass.lastIndexOf(46));
        String sgc = CodegenUtils.fqcnLastElement(genclass);
        String scn = this.superclass != null ? ClassUtils.simpleClassName((Class)this.superclass) : null;
        String sin = ClassUtils.simpleClassName((Class)intfcl);
        String[] eins = null;
        if (this.extraInterfaces != null) {
            eins = new String[this.extraInterfaces.length];
            int len2 = this.extraInterfaces.length;
            for (int i2 = 0; i2 < len2; ++i2) {
                eins[i2] = ClassUtils.simpleClassName((Class)this.extraInterfaces[i2]);
            }
        }
        TreeSet<Class> imports = new TreeSet<Class>(classComp);
        Method[] methods = intfcl.getMethods();
        if (!CodegenUtils.inSamePackage(intfcl.getName(), genclass)) {
            imports.add(intfcl);
        }
        if (this.superclass != null && !CodegenUtils.inSamePackage(this.superclass.getName(), genclass)) {
            imports.add(this.superclass);
        }
        if (this.extraInterfaces != null) {
            len = this.extraInterfaces.length;
            for (i = 0; i < len; ++i) {
                Class checkMe = this.extraInterfaces[i];
                if (CodegenUtils.inSamePackage(checkMe.getName(), genclass)) continue;
                imports.add(checkMe);
            }
        }
        len = methods.length;
        for (i = 0; i < len; ++i) {
            Class<?>[] args = methods[i].getParameterTypes();
            int jlen = args.length;
            for (int j = 0; j < jlen; ++j) {
                if (CodegenUtils.inSamePackage(args[j].getName(), genclass)) continue;
                imports.add(CodegenUtils.unarrayClass(args[j]));
            }
            Class<?>[] excClasses = methods[i].getExceptionTypes();
            int jlen2 = excClasses.length;
            for (int j = 0; j < jlen2; ++j) {
                if (CodegenUtils.inSamePackage(excClasses[j].getName(), genclass)) continue;
                imports.add(CodegenUtils.unarrayClass(excClasses[j]));
            }
            if (CodegenUtils.inSamePackage(methods[i].getReturnType().getName(), genclass)) continue;
            imports.add(CodegenUtils.unarrayClass(methods[i].getReturnType()));
        }
        this.generateBannerComment(iw);
        iw.println("package " + pkg + ';');
        iw.println();
        Iterator ii = imports.iterator();
        while (ii.hasNext()) {
            iw.println("import " + ((Class)ii.next()).getName() + ';');
        }
        this.generateExtraImports(iw);
        iw.println();
        iw.print(CodegenUtils.getModifierString(this.class_modifiers) + " class " + sgc);
        if (this.superclass != null) {
            iw.print(" extends " + scn);
        }
        iw.print(" implements " + sin);
        if (eins != null) {
            len = eins.length;
            for (int i3 = 0; i3 < len; ++i3) {
                iw.print(", " + eins[i3]);
            }
        }
        iw.println();
        iw.println("{");
        iw.upIndent();
        iw.println("protected " + sin + " inner;");
        iw.println();
        if (this.wrapping_constructor) {
            iw.println("public " + sgc + '(' + sin + " inner)");
            iw.println("{ this.inner = inner; }");
        }
        if (this.default_constructor) {
            iw.println();
            iw.println("public " + sgc + "()");
            iw.println("{}");
        }
        if (this.inner_setter) {
            iw.println();
            iw.println(CodegenUtils.getModifierString(this.method_modifiers) + " void setInner( " + sin + " inner )");
            iw.println("{ this.inner = inner; }");
        }
        if (this.inner_getter) {
            iw.println();
            iw.println(CodegenUtils.getModifierString(this.method_modifiers) + ' ' + sin + " getInner()");
            iw.println("{ return inner; }");
        }
        iw.println();
        len = methods.length;
        for (int i4 = 0; i4 < len; ++i4) {
            Method method = methods[i4];
            Class<?> retType = method.getReturnType();
            if (i4 != 0) {
                iw.println();
            }
            iw.println(CodegenUtils.methodSignature(this.method_modifiers, method, null));
            iw.println("{");
            iw.upIndent();
            this.generatePreDelegateCode(intfcl, genclass, method, iw);
            this.generateDelegateCode(intfcl, genclass, method, iw);
            this.generatePostDelegateCode(intfcl, genclass, method, iw);
            iw.downIndent();
            iw.println("}");
        }
        iw.println();
        this.generateExtraDeclarations(intfcl, genclass, iw);
        iw.downIndent();
        iw.println("}");
    }

    protected void generateDelegateCode(Class intfcl, String genclass, Method method, IndentedWriter iw) throws IOException {
        Class<?> retType = method.getReturnType();
        iw.println((retType == Void.TYPE ? "" : "return ") + "inner." + CodegenUtils.methodCall(method) + ";");
    }

    protected void generateBannerComment(IndentedWriter iw) throws IOException {
        iw.println("/*");
        iw.println(" * This class generated by " + this.getClass().getName());
        iw.println(" * " + new Date());
        iw.println(" * DO NOT HAND EDIT!!!!");
        iw.println(" */");
    }

    protected void generateExtraImports(IndentedWriter iw) throws IOException {
    }

    protected void generatePreDelegateCode(Class intfcl, String genclass, Method method, IndentedWriter iw) throws IOException {
    }

    protected void generatePostDelegateCode(Class intfcl, String genclass, Method method, IndentedWriter iw) throws IOException {
    }

    protected void generateExtraDeclarations(Class intfcl, String genclass, IndentedWriter iw) throws IOException {
    }
}

