/*
 * Decompiled with CFR 0.152.
 */
package ice.util.alg;

import ice.debug.Debug;
import ice.util.Defs;
import ice.util.alg.Comparator;
import ice.util.alg.SysComparator;

public class HashArray {
    private static final boolean check = true;
    private static final int MINIMAL_ALLOCATION_SIZE = 8;
    private static final int A = -1640531527;
    private static final Entry DELETED = new Entry();
    private Entry[] entries_array;
    private int key_count;
    private int occupied_count;
    private Object monitor_lock;
    private Entry entryPrototype = DELETED;
    private Entry lastNamedAccess = DELETED;
    private Comparator comparator;

    public Object clone() {
        Object object = this.monitor_lock;
        if (object != null) {
            Object object2 = object;
            synchronized (object2) {
                Object object3;
                HashArray hashArray = new HashArray();
                hashArray.comparator = this.comparator;
                hashArray.entries_array = new Entry[this.entries_array.length];
                hashArray.key_count = this.key_count;
                hashArray.occupied_count = this.occupied_count;
                int n = 0;
                while (n < this.entries_array.length) {
                    if (this.entries_array[n] == DELETED) {
                        hashArray.entries_array[n] = DELETED;
                    } else {
                        object3 = this.entries_array[n];
                        if (object3 != null) {
                            Entry entry = new Entry();
                            entry.initKey(((Entry)object3).key(), ((Entry)object3).keyHash());
                            entry.value = ((Entry)object3).value;
                            hashArray.entries_array[n] = entry;
                        }
                    }
                    ++n;
                }
                object3 = hashArray;
                return object3;
            }
        }
        HashArray hashArray = new HashArray();
        hashArray.comparator = this.comparator;
        hashArray.entries_array = new Entry[this.entries_array.length];
        hashArray.key_count = this.key_count;
        hashArray.occupied_count = this.occupied_count;
        int n = 0;
        while (n < this.entries_array.length) {
            if (this.entries_array[n] == DELETED) {
                hashArray.entries_array[n] = DELETED;
            } else {
                Entry entry = this.entries_array[n];
                Entry entry2 = new Entry();
                entry2.initKey(entry.key(), entry.keyHash());
                entry2.value = entry.value;
                hashArray.entries_array[n] = entry2;
            }
            ++n;
        }
        return hashArray;
    }

    public HashArray() {
        this(0);
    }

    public HashArray(Object object) {
        this(object, 0);
    }

    public HashArray(int n) {
        this.monitor_lock = this;
        this.setupInitialCapacity(n);
    }

    public HashArray(Object object, int n) {
        this.monitor_lock = object;
        this.setupInitialCapacity(n);
    }

    final Entry[] access_entries_array() {
        return this.entries_array;
    }

    private void setupInitialCapacity(int n) {
        if (n != 0) {
            this.entries_array = new Entry[1 << HashArray.log_2(n) + 1];
        }
    }

    public void setEntryPrototype(Entry entry) {
        if (this.key_count != 0) {
            Debug.bug();
        }
        this.entryPrototype = entry;
    }

    public void setComparator(Comparator comparator) {
        if (this.key_count != 0) {
            Debug.bug();
        }
        this.comparator = comparator;
    }

    public final Object synchronizationLock() {
        return this.monitor_lock;
    }

    public Object setSynchronizationLock(Object object) {
        if (this.key_count != 0) {
            Debug.bug();
        }
        this.monitor_lock = object;
        return this.monitor_lock;
    }

    public boolean isEmpty() {
        return this.key_count == 0;
    }

    public int size() {
        return this.key_count;
    }

    public final boolean isSealed() {
        return this.occupied_count < 0;
    }

    public void sealObject() {
        Object object = this.monitor_lock;
        if (object != null) {
            Object object2 = object;
            synchronized (object2) {
                this.occupied_count = -1;
            }
        } else {
            this.occupied_count = -1;
        }
    }

    public Entry getEntry(Object object) {
        Entry entry = this.lastNamedAccess;
        if ((entry.key != object || entry.wasDeleted) && (entry = this.getEntry(this.getHashCode(object), object, false)) != null) {
            entry.key = object;
            this.lastNamedAccess = entry;
        }
        return entry;
    }

    public Entry getEntry(int n) {
        return this.getEntry(n, null, false);
    }

    public final boolean has(Object object) {
        return null != this.getEntry(object);
    }

    public final boolean has(int n) {
        return null != this.getEntry(n);
    }

    public final Object get(Object object) {
        Entry entry = this.getEntry(object);
        return entry != null ? entry.value : null;
    }

    public final Object get(int n) {
        Entry entry = this.getEntry(n);
        return entry != null ? entry.value : null;
    }

    public Entry ensureEntry(Object object) {
        Entry entry;
        this.lastNamedAccess = entry = this.ensureEntry(this.getHashCode(object), object);
        return entry;
    }

    public Entry ensureEntry(int n) {
        return this.ensureEntry(n, null);
    }

    public final Object put(Object object, Object object2) {
        Entry entry = this.ensureEntry(object);
        Object object3 = entry.value;
        entry.value = object2;
        return object3;
    }

    public final Object put(int n, Object object) {
        Entry entry = this.ensureEntry(n);
        Object object2 = entry.value;
        entry.value = object;
        return object2;
    }

    public final void setValue(Object object, Object object2) {
        if (this.isSealed()) {
            Debug.bug();
        }
        Entry entry = this.lastNamedAccess;
        if (entry.key != object || entry.wasDeleted) {
            int n = this.getHashCode(object);
            entry = this.getEntry(n, object, false);
            if (entry == null) {
                entry = this.ensureEntry(n, object);
            }
            entry.key = object;
            this.lastNamedAccess = entry;
        }
        entry.value = object2;
    }

    public final void setValue(int n, Object object) {
        Entry entry;
        if (this.isSealed()) {
            Debug.bug();
        }
        if ((entry = this.getEntry(n)) == null) {
            entry = this.ensureEntry(n);
        }
        entry.value = object;
    }

    public Object remove(Object object) {
        return this.deleteEntry(this.getHashCode(object), object);
    }

    public Object remove(int n) {
        return this.deleteEntry(n, null);
    }

    public void clear() {
        Object object;
        if (this.isSealed()) {
            Debug.bug();
        }
        if ((object = this.monitor_lock) != null) {
            Object object2 = object;
            synchronized (object2) {
                this.do_removeAllValues();
            }
        } else {
            this.do_removeAllValues();
        }
    }

    private void do_removeAllValues() {
        this.entries_array = null;
        this.key_count = 0;
        this.occupied_count = 0;
    }

    public Iterator newIterator() {
        return new Iterator(this);
    }

    public Entry[] getEntries() {
        Object object = this.monitor_lock;
        if (object != null) {
            Object object2 = object;
            synchronized (object2) {
                Entry[] entryArray = this.do_getEntries();
                return entryArray;
            }
        }
        return this.do_getEntries();
    }

    private Entry[] do_getEntries() {
        int n = this.key_count;
        Entry[] entryArray = new Entry[n];
        Entry[] entryArray2 = this.entries_array;
        int n2 = 0;
        while (n != 0) {
            Entry entry = entryArray2[n2];
            if (entry != null && entry != DELETED) {
                entryArray[--n] = entry;
            }
            ++n2;
        }
        return entryArray;
    }

    public void getObjectKeys(Object[] objectArray, int n) {
        Object object = this.monitor_lock;
        if (object != null) {
            Object object2 = object;
            synchronized (object2) {
                this.copyKeysOrValues(true, objectArray, n);
            }
        } else {
            this.copyKeysOrValues(true, objectArray, n);
        }
    }

    public Object[] getValues() {
        Object[] objectArray;
        Object object = this.monitor_lock;
        if (object != null) {
            Object object2 = object;
            synchronized (object2) {
                if (this.key_count == 0) {
                    objectArray = Defs.EMPTY_OBJECT_ARRAY;
                } else {
                    objectArray = new Object[this.key_count];
                    this.copyKeysOrValues(false, objectArray, 0);
                }
            }
        } else if (this.key_count == 0) {
            objectArray = Defs.EMPTY_OBJECT_ARRAY;
        } else {
            objectArray = new Object[this.key_count];
            this.copyKeysOrValues(false, objectArray, 0);
        }
        return objectArray;
    }

    public void getValues(Object[] objectArray, int n) {
        Object object = this.monitor_lock;
        if (object != null) {
            Object object2 = object;
            synchronized (object2) {
                this.copyKeysOrValues(false, objectArray, n);
            }
        } else {
            this.copyKeysOrValues(false, objectArray, n);
        }
    }

    private void copyKeysOrValues(boolean bl, Object[] objectArray, int n) {
        int n2 = this.key_count;
        Entry[] entryArray = this.entries_array;
        int n3 = 0;
        while (n2 != 0) {
            Entry entry = entryArray[n3];
            if (entry != null && entry != DELETED) {
                if (bl) {
                    if (entry.key != null) {
                        objectArray[n] = entry.key;
                        ++n;
                    }
                } else {
                    objectArray[n] = entry.value;
                    ++n;
                }
                --n2;
            }
            ++n3;
        }
    }

    private Object deleteEntry(int n, Object object) {
        Object object2;
        if (this.isSealed()) {
            Debug.bug();
        }
        if ((object2 = this.monitor_lock) != null) {
            Object object3 = object2;
            synchronized (object3) {
                Object object4 = this.do_deleteEntry(n, object);
                return object4;
            }
        }
        return this.do_deleteEntry(n, object);
    }

    private Object do_deleteEntry(int n, Object object) {
        Object object2 = null;
        Entry entry = this.getEntry(n, object, true);
        if (null != entry) {
            object2 = entry.value;
            entry.value = null;
        }
        return object2;
    }

    private static int log_2_for_exact_power(int n) {
        switch (n) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 8: {
                return 3;
            }
            case 16: {
                return 4;
            }
            case 32: {
                return 5;
            }
            case 64: {
                return 6;
            }
            case 128: {
                return 7;
            }
            case 256: {
                return 8;
            }
            case 512: {
                return 9;
            }
            case 1024: {
                return 10;
            }
            case 2048: {
                return 11;
            }
            case 4096: {
                return 12;
            }
            case 8192: {
                return 13;
            }
            case 16384: {
                return 14;
            }
            case 32768: {
                return 15;
            }
            case 65536: {
                return 16;
            }
            case 131072: {
                return 17;
            }
            case 262144: {
                return 18;
            }
            case 524288: {
                return 19;
            }
            case 0x100000: {
                return 20;
            }
            case 0x200000: {
                return 21;
            }
            case 0x400000: {
                return 22;
            }
            case 0x800000: {
                return 23;
            }
            case 0x1000000: {
                return 24;
            }
            case 0x2000000: {
                return 25;
            }
            case 0x4000000: {
                return 26;
            }
            case 0x8000000: {
                return 27;
            }
            case 0x10000000: {
                return 28;
            }
            case 0x20000000: {
                return 29;
            }
            case 0x40000000: {
                return 30;
            }
            case -2147483648: {
                return 31;
            }
        }
        Debug.bug();
        return 0;
    }

    private static int log_2(int n) {
        int n2;
        int n3 = 0;
        if (n >> 4 != 0) {
            n2 = n >> 16;
            if (n2 != 0) {
                n3 |= 0x10;
                n = n2;
            }
            if ((n2 = n >> 8) != 0) {
                n3 |= 8;
                n = n2;
            }
            if ((n2 = n >> 4) != 0) {
                n3 |= 4;
                n = n2;
            }
        }
        if ((n2 = n >> 2) != 0) {
            n3 |= 2;
            n = n2;
        }
        if ((n & 2) != 0) {
            n3 |= 1;
        }
        return n3;
    }

    private static int tableLookupStep(int n, int n2, int n3) {
        int n4 = 32 - 2 * n3;
        int n5 = n4 >= 0 ? n >>> n4 & n2 | 1 : n & n2 >>> -n4 | 1;
        return n5;
    }

    private Entry getEntry(int n, Object object, boolean bl) {
        int n2;
        int n3;
        int n4;
        int n5;
        Entry entry;
        Entry[] entryArray = this.entries_array;
        if (entryArray != null && (entry = entryArray[n5 = (n4 = n * -1640531527) >>> 32 - (n3 = HashArray.log_2_for_exact_power(n2 = entryArray.length))]) != null) {
            boolean bl2 = false;
            if (entry != DELETED && entry.hash == n && (object == null || object == entry.key || this.cmp(object, entry.key))) {
                bl2 = true;
            }
            if (!bl2) {
                int n6 = n2 - 1;
                int n7 = HashArray.tableLookupStep(n4, n6, n3);
                while ((entry = entryArray[n5 = n5 + n7 & n6]) != null) {
                    if (entry == DELETED || entry.hash != n || object != null && object != entry.key && !this.cmp(object, entry.key)) continue;
                    bl2 = true;
                    break;
                }
            }
            if (bl2) {
                if (bl) {
                    entryArray[n5] = DELETED;
                    --this.key_count;
                    entry.wasDeleted = true;
                }
                return entry;
            }
        }
        return null;
    }

    private static int getNewEntryIndex(Entry[] entryArray, int n, int n2, Object object) {
        int n3;
        block2: {
            int n4;
            Entry entry;
            int n5 = entryArray.length;
            if (n5 != 1 << n) {
                Debug.bug();
            }
            if ((entry = entryArray[n3 = (n4 = n2 * -1640531527) >>> 32 - n]) == null) break block2;
            int n6 = n5 - 1;
            int n7 = HashArray.tableLookupStep(n4, n6, n);
            do {
                if (entry != DELETED) continue;
                Debug.bug();
            } while ((entry = entryArray[n3 = n3 + n7 & n6]) != null);
        }
        return n3;
    }

    private static Entry[] rehashTable(int n, int n2, Entry[] entryArray, int n3) {
        Entry[] entryArray2 = new Entry[n];
        if (entryArray != null) {
            int n4 = 0;
            int n5 = n3;
            while (n5 != 0) {
                Entry entry = entryArray[n4];
                if (entry != null && entry != DELETED) {
                    int n6 = HashArray.getNewEntryIndex(entryArray2, n2, entry.hash, entry.key);
                    entryArray2[n6] = entry;
                    --n5;
                }
                ++n4;
            }
        }
        return entryArray2;
    }

    private Entry ensureEntry(int n, Object object) {
        Entry entry;
        Object object2;
        if (this.isSealed()) {
            Debug.bug();
        }
        if ((object2 = this.monitor_lock) != null) {
            Object object3 = object2;
            synchronized (object3) {
                entry = this.do_ensureEntry(n, object);
            }
        } else {
            entry = this.do_ensureEntry(n, object);
        }
        return entry;
    }

    private Entry do_ensureEntry(int n, Object object) {
        int n2;
        int n3;
        Entry[] entryArray = this.entries_array;
        int n4 = entryArray != null ? entryArray.length : 0;
        int n5 = -1;
        boolean bl = false;
        if (n4 != 0) {
            n3 = n * -1640531527;
            n2 = HashArray.log_2_for_exact_power(n4);
            int n6 = n3 >>> 32 - n2;
            Entry entry = entryArray[n6];
            if (entry == null) {
                n5 = n6;
            } else {
                if (entry != DELETED) {
                    if (entry.hash == n && (object == null || object == entry.key || this.cmp(object, entry.key))) {
                        return entry;
                    }
                } else {
                    n5 = n6;
                    bl = true;
                }
                int n7 = n4 - 1;
                int n8 = HashArray.tableLookupStep(n3, n7, n2);
                while (true) {
                    if ((entry = entryArray[n6 = n6 + n8 & n7]) == null) {
                        if (n5 >= 0) break;
                        n5 = n6;
                        break;
                    }
                    if (entry != DELETED) {
                        if (entry.hash != n || object != null && object != entry.key && !this.cmp(object, entry.key)) continue;
                        return entry;
                    }
                    if (n5 >= 0) continue;
                    n5 = n6;
                    bl = true;
                }
            }
        }
        if (!bl) {
            if (this.occupied_count * 4 >= n4 * 3) {
                n2 = this.key_count * 2 < this.occupied_count ? n4 : (n4 == 0 ? 8 : n4 * 2);
                n3 = HashArray.log_2_for_exact_power(n2);
                entryArray = HashArray.rehashTable(n2, n3, entryArray, this.key_count);
                this.entries_array = entryArray;
                this.occupied_count = this.key_count;
                n5 = HashArray.getNewEntryIndex(entryArray, n3, n, object);
            }
            ++this.occupied_count;
        }
        Entry entry = this.entryPrototype.newEntry();
        entry.initKey(object, n);
        entryArray[n5] = entry;
        ++this.key_count;
        return entry;
    }

    private boolean cmp(Object object, Object object2) {
        Comparator comparator = this.comparator;
        return comparator == null ? object.equals(object2) : (comparator == SysComparator.instance ? object == object2 : comparator.equals(object, object2));
    }

    private int getHashCode(Object object) {
        Comparator comparator = this.comparator;
        return comparator == null ? object.hashCode() : comparator.hashCode(object);
    }

    public static class Iterator {
        HashArray _master;
        private int _cursor;
        private Entry[] _entries;

        Iterator(HashArray hashArray) {
            this._master = hashArray;
            this._cursor = -1;
        }

        void init(Object[] objectArray) {
        }

        public void start() {
            this._entries = this._master.access_entries_array();
            this._cursor = this._entries == null ? 0 : this._entries.length;
            this.next();
        }

        public boolean done() {
            return this._cursor < 0;
        }

        public void next() {
            if (this._cursor < 0) {
                Debug.bug();
            }
            --this._cursor;
            while (this._cursor >= 0) {
                Entry entry = this._entries[this._cursor];
                if (entry != null && entry != DELETED) break;
                --this._cursor;
            }
        }

        public Entry entry() {
            return this._entries[this._cursor];
        }

        public Object value() {
            return this._entries[this._cursor].value;
        }
    }

    public static class Entry {
        boolean wasDeleted;
        int hash;
        Object key;
        public volatile Object value;

        final void initKey(Object object, int n) {
            this.hash = n;
            this.key = object;
        }

        public final boolean isIndex() {
            return this.key == null;
        }

        public final boolean isKey() {
            return this.key != null;
        }

        public final Object key() {
            return this.key;
        }

        public final int keyHash() {
            return this.hash;
        }

        public final int index() {
            return this.hash;
        }

        protected Entry newEntry() {
            return new Entry();
        }
    }
}

