/*
 * Decompiled with CFR 0.152.
 */
package ice.util;

import ice.util.Defs;
import ice.util.alg.CharKit;
import ice.util.security.SecurityKit;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;

public abstract class JVMCapabilities {
    private static final int CAPABILITY_UNKNOWN = 0;
    private static final int CAPABILITY_PRESENT = 1;
    private static final int CAPABILITY_ABSENT = 2;
    private static int scrollbarsFlag = 0;
    private static int jmfFlag = 0;
    private static int swingFlag = 0;
    private static int jarFlag = 0;
    private static int md5Flag = 0;
    static String jvmVersion = null;
    static int majorVersion = -1;
    static int minorVersion = -1;
    static int microVersion = -1;

    public static String getVersionString() {
        if (jvmVersion == null) {
            JVMCapabilities.readVersionJVM();
        }
        return jvmVersion;
    }

    public static int getMajorVersion() {
        if (majorVersion == -1) {
            JVMCapabilities.readVersionJVM();
        }
        return majorVersion;
    }

    public static int getMinorVersion() {
        if (minorVersion == -1) {
            JVMCapabilities.readVersionJVM();
        }
        return minorVersion;
    }

    public static int getMicroVersion() {
        if (microVersion == -1) {
            JVMCapabilities.readVersionJVM();
        }
        return microVersion;
    }

    public static boolean isScrollbarsPresent() {
        int n = scrollbarsFlag;
        if (n == 0) {
            scrollbarsFlag = n = JVMCapabilities.testClassPresence("java.awt.Scrollbar");
        }
        return n == 1;
    }

    public static boolean isJMFPresent() {
        int n = jmfFlag;
        if (n == 0) {
            jmfFlag = n = JVMCapabilities.testClassPresence("javax.media.Player");
        }
        return n == 1;
    }

    public static boolean isSwingPresent() {
        int n = swingFlag;
        if (n == 0) {
            swingFlag = n = JVMCapabilities.testClassPresence("javax.swing.JComponent");
        }
        return n == 1;
    }

    public static boolean isJarHandlerPresent() {
        int n = jarFlag;
        if (n == 0) {
            n = 2;
            try {
                new URL("jar://test");
                n = 1;
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            jarFlag = n;
        }
        return n == 1;
    }

    public static boolean isMD5Present() {
        int n = md5Flag;
        if (n == 0) {
            n = 2;
            Class clazz = Defs.getClass("java.security.MessageDigest");
            if (clazz != null) {
                try {
                    Class[] classArray = new Class[]{"".getClass()};
                    Method method = Defs.getMethod(clazz, "getInstance", classArray);
                    if (method != null) {
                        Object[] objectArray = new Object[]{"MD5"};
                        method.invoke(null, objectArray);
                        n = 1;
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            md5Flag = n;
        }
        return n == 1;
    }

    private static int testClassPresence(String string) {
        return null != Defs.getClass(string) ? 1 : 2;
    }

    public static void installDefaultSecurityManager() {
        SecurityKit.installDefaultSecurityManager();
    }

    private static void readVersionJVM() {
        long l;
        String string;
        jvmVersion = string = Defs.sysProperty("java.version");
        int n = 1;
        int n2 = 1;
        int n3 = 0;
        int n4 = string.length();
        int n5 = string.indexOf(46);
        if (n5 < 0) {
            n5 = n4;
        }
        if ((l = CharKit.parseInt(string, 0, n5)) >= 0L) {
            n = (int)l;
            if (n5 != n4) {
                int n6 = string.indexOf(46, n5 + 1);
                if (n6 < 0) {
                    n6 = n4;
                }
                if ((l = CharKit.parseInt(string, n5 + 1, n6)) >= 0L) {
                    n2 = (int)l;
                    if (n6 != n4 && (l = CharKit.parseInt(string, n6 + 1, n4)) >= 0L) {
                        n3 = (int)l;
                    }
                }
            }
        }
        majorVersion = n;
        minorVersion = n2;
        microVersion = n3;
    }
}

