/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.debug.Debug;
import ice.storm.ContentLoader;
import ice.storm.DefaultPilotContext;
import ice.storm.DocPane;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import ice.storm.Scripter;
import ice.storm.StormBase;
import ice.storm.StormPrinter;
import ice.storm.UrlMaster;
import ice.storm.Viewport;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;

public abstract class Pilot {
    StormBase base;
    DefaultPilotContext context;

    public StormBase getStorm() {
        return this.base;
    }

    public void init(String string) {
        if (Debug.trace) {
            Debug.trace(this.getClass().getName() + " (" + string + ") in " + this.getViewportId());
        }
    }

    public void dispose() {
    }

    public final String getCurrentLocation() {
        Viewport viewport = this.getPilotViewport();
        if (viewport != null) {
            return viewport.getLocation();
        }
        return null;
    }

    protected void setZoom(int n) {
    }

    protected final int getZoom() {
        return 0;
    }

    public boolean isDetached() {
        return false;
    }

    public void clear(String string) {
    }

    public void parse(ContentLoader contentLoader) throws IOException {
    }

    public void gotoRef(String string) {
    }

    public boolean refExists(String string) {
        return false;
    }

    public void stopLoading() {
    }

    public void modifiedByScript() {
    }

    public void suspend() {
    }

    public void resume() {
    }

    public Component createComponent() {
        return null;
    }

    public StormPrinter createPrinter() {
        return null;
    }

    public Object getDynamicValueOnWindow(DynamicObject dynamicObject, String string, DynEnv dynEnv) {
        return DynamicObject.NOT_FOUND;
    }

    public int setDynamicValueOnWindow(DynamicObject dynamicObject, String string, Object object, DynEnv dynEnv) {
        return 0;
    }

    public Object execDynamicMethodOnWindow(DynamicObject dynamicObject, String string, Object[] objectArray, DynEnv dynEnv) {
        return DynamicObject.NOT_FOUND;
    }

    public DynamicObject getDocumentObject() {
        return null;
    }

    public Object getSnapshot() {
        return null;
    }

    public void applySnapshot(Object object) {
    }

    public Point getScrollPosition(Point point) {
        DocPane docPane = this.getDocPane();
        if (docPane != null) {
            point.x = docPane.getScrollX();
            point.y = docPane.getScrollY();
            return point;
        }
        return null;
    }

    public void setScrollPosition(int n, int n2) {
        DocPane docPane = this.getDocPane();
        if (docPane != null) {
            docPane.setScrollPosition(n, n2);
        }
    }

    public void parsingDone() {
    }

    public final String getViewportId() {
        return this.context.view.getId();
    }

    public final Viewport getPilotViewport() {
        return this.context.view;
    }

    public DocPane getDocPane() {
        return null;
    }

    public final Viewport findViewportByName(String string) {
        return this.base.findViewportByName(string);
    }

    public final void getAllPilotInstances(Vector vector) {
        Class<?> clazz = this.getClass();
        this.base.getAllPilotInstances(clazz, vector);
    }

    public final Object getViewportProperty(String string) {
        return this.context.view.getProperty(string);
    }

    public final void firePropertyChange(String string, Object object, Object object2) {
        this.base.sendViewportMessage(this.context.view, string, object, object2);
    }

    public final boolean configureViewport(Viewport viewport) {
        return this.base.configureViewport(viewport, this.context.view.getId());
    }

    public final void addViewportChild(Viewport viewport) {
        this.context.view.addChild(viewport);
        viewport.setPilotContext(new DefaultPilotContext(this.base, viewport));
    }

    public final void renderContent(String string, String string2, String string3) {
        string3 = this.mapViewportName(string3);
        Scripter scripter = this.base.getScripterForCodeLocation(string);
        if (scripter != null) {
            Viewport viewport = this.base.findViewportByName(string3);
            if (viewport == null) {
                viewport = this.context.view;
            }
            scripter.evalCodeLocation(viewport, string);
        } else {
            this.base.renderContent(string, string2, string3);
        }
    }

    public final void renderContent(ContentLoader contentLoader, String string) {
        string = this.mapViewportName(string);
        this.base.renderContent(contentLoader, string);
    }

    public final void renderContentFully(ContentLoader contentLoader, String string) {
        string = this.mapViewportName(string);
        this.base.renderContentFully(contentLoader, string);
    }

    private String mapViewportName(String string) {
        Viewport viewport = this.context.view.findViewportInTreeByName(string);
        if (viewport != null) {
            string = viewport.getId();
        }
        return string;
    }

    public final void clearContent(String string, String string2) {
        this.base.clearContent(string, string2);
    }

    public final boolean isStopRequested() {
        return this.context.isStopRequested();
    }

    public final void refreshViewport() {
        Container container = this.context.view.getContainer();
        if (container != null) {
            container.repaint();
        }
    }

    public final void viewportBecameActive() {
        this.base.setActiveViewport(this.context.view);
    }

    public final Container getViewportContainer() {
        return this.context.view.getContainer();
    }

    public final UrlMaster getUrlMaster() {
        return this.base.getUrlMaster();
    }

    protected final void setBaseUrl(String string) {
        this.context.view.setBaseUrl(string);
    }

    public final ClassLoader createURLClassLoader(URL[] uRLArray) {
        return this.getStorm().getURLClassLoaderFactory().createURLClassLoader(uRLArray);
    }

    public final void runOnEventThreadLater(Runnable runnable, long l) {
        this.base.runOnEventThreadLater(runnable, l);
    }

    public boolean isEventThread() {
        return this.getStorm().isEventThread();
    }

    public final boolean isMimeTypeEnabled(String string) {
        return this.getStorm().isMimeTypeEnabled(string);
    }

    public final Scripter getScripter(String string) {
        return this.getStorm().getScripter(string);
    }

    public final Scripter getScripterForCodeLocation(String string) {
        return this.getStorm().getScripterForCodeLocation(string);
    }

    public final Object getStormData(Object object) {
        return this.getStorm().getData(object);
    }

    public final Object initStormData(Object object, Object object2) {
        return this.getStorm().initData(object, object2);
    }
}

