/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.storm.ImageCache;
import ice.storm.ImageInputStream;
import ice.util.security.BoxedCode;
import ice.util.security.SecurityKit;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

class ImageConnection
extends URLConnection {
    private ImageInputStream in;
    private boolean reqStop = false;
    private Thread imageThread = null;
    private boolean done = false;

    ImageConnection(URL uRL) {
        super(uRL);
        String string = ImageCache.getInstance().getRealUrl(this.url, this);
        this.in = new ImageInputStream(this, string);
    }

    boolean reqToStop() {
        this.reqStop = true;
        Thread thread = this.imageThread;
        if (thread != null && thread.isAlive()) {
            ImageConnection.interruptImageLoadThread(thread);
        }
        return !this.done;
    }

    private static void interruptImageLoadThread(final Thread thread) {
        SecurityKit.doPrivileged(new BoxedCode(){

            public Object run() {
                thread.interrupt();
                return null;
            }
        });
    }

    boolean isStopRequested() {
        return this.reqStop;
    }

    void inputStreamDone() {
        this.imageThread = null;
        this.done = true;
    }

    public String getContentType() {
        if (this.imageThread == null) {
            this.imageThread = Thread.currentThread();
        }
        return this.in.getContentType();
    }

    public void connect() {
    }

    public InputStream getInputStream() throws IOException {
        if (this.imageThread == null) {
            this.imageThread = Thread.currentThread();
        }
        return this.in;
    }
}

