/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.storm.ContentLoader;
import ice.storm.Pilot;
import ice.storm.StormBase;
import ice.storm.Viewport;
import ice.util.security.BoxedCode;
import ice.util.security.SecurityKit;
import java.util.Hashtable;

class DefaultPilotContext
implements Runnable {
    StormBase base;
    Viewport view;
    private Thread thread;
    private ContentLoader cl;
    private Object load_lock = new Object();
    String state = "empty";
    private boolean disposed = false;
    private Hashtable threadsToStop = new Hashtable();

    DefaultPilotContext(StormBase stormBase, Viewport viewport) {
        this.base = stormBase;
        this.view = viewport;
    }

    void dispose() {
        this.disposed = true;
        this.threadsToStop.clear();
        this.base.unregisterViewport(this.view);
    }

    void queueRenderContent(ContentLoader contentLoader) {
        Object object = this.load_lock;
        synchronized (object) {
            this.cl = contentLoader;
            if (this.thread == null) {
                final String string = "loader-cl-" + this.view.getName();
                this.thread = (Thread)SecurityKit.doPrivileged(new BoxedCode(){

                    public Object run() {
                        return new Thread((Runnable)DefaultPilotContext.this, string);
                    }
                });
                this.thread.setDaemon(true);
                this.thread.start();
            }
        }
    }

    void stopLoading() {
        Pilot pilot;
        Thread thread = this.thread;
        this.thread = null;
        if (thread != null && thread.isAlive()) {
            this.threadsToStop.put(thread, thread);
            thread.interrupt();
        }
        if ((pilot = this.view.getPilot()) != null) {
            pilot.stopLoading();
        }
    }

    boolean isStopRequested() {
        if (this.disposed) {
            return true;
        }
        Thread thread = Thread.currentThread();
        return this.threadsToStop.get(thread) != null;
    }

    public void run() {
        while (!this.isStopRequested()) {
            ContentLoader contentLoader = null;
            Object object = this.load_lock;
            synchronized (object) {
                if (this.cl == null) {
                    this.threadsToStop.remove(Thread.currentThread());
                    this.thread = null;
                    this.state = "ready";
                    return;
                }
                contentLoader = this.cl;
                this.cl = null;
            }
            this.state = "busy";
            this.base.do_render_content(contentLoader, this.view);
        }
        this.threadsToStop.remove(Thread.currentThread());
    }
}

