/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.debug.Debug;
import ice.util.Defs;
import ice.util.net.CookieSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;

public class ContentLoader {
    private static final boolean debug_url_replace = Debug.extra && ContentLoader.debug_init_url_replace();
    private static Object debug_url_replacement_map;
    private URL url;
    private URL serverRoot = null;
    private URLConnection uc;
    private String type;
    private InputStream inputStream;
    private Hashtable params;
    private String referer;
    private String postType;
    private byte[] postData;
    private InputStream postStream;
    private boolean fromHistory = false;
    private boolean iframe = false;
    private IOException exceptionObject;
    private boolean lazyMake = false;
    private boolean redirected = false;
    private boolean connectionRequested;

    ContentLoader(String string, boolean bl) {
        this(null, string, null);
        this.fromHistory = bl;
    }

    private static boolean debug_init_url_replace() {
        block13: {
            if (!Debug.extra) {
                return false;
            }
            String string = Defs.sysProperty("ice.debug.url_replacement");
            if (string != null) {
                string = ContentLoader.debug_preprocess_replace_url(string);
                Vector<String[][]> vector = new Vector<String[][]>();
                try {
                    InputStream inputStream = new URL(string).openStream();
                    try {
                        String[][] stringArrayArray;
                        String string2;
                        BufferedReader bufferedReader;
                        try {
                            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
                        }
                        catch (Exception exception) {
                            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                        }
                        String string3 = null;
                        while (null != (string2 = bufferedReader.readLine())) {
                            if ((string2 = string2.trim()).length() == 0 || string2.charAt(0) == '#') continue;
                            if (string3 == null) {
                                string3 = string2;
                                continue;
                            }
                            string2 = ContentLoader.debug_preprocess_replace_url(string2);
                            stringArrayArray = new String[]{string3, string2};
                            vector.addElement(stringArrayArray);
                            string3 = null;
                        }
                        if (vector.size() != 0) {
                            stringArrayArray = new String[vector.size()][];
                            vector.copyInto((Object[])stringArrayArray);
                            if (Debug.trace) {
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("length=");
                                stringBuffer.append(stringArrayArray.length);
                                int n = 0;
                                while (n != stringArrayArray.length) {
                                    stringBuffer.append('\n');
                                    stringBuffer.append(stringArrayArray[n][0]);
                                    stringBuffer.append("\t -> ");
                                    stringBuffer.append(stringArrayArray[n][1]);
                                    ++n;
                                }
                                Debug.trace(stringBuffer.toString());
                            }
                            debug_url_replacement_map = stringArrayArray;
                        }
                        Object var10_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_12 = null;
                        inputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                    {
                    }
                }
                catch (IOException iOException) {
                    if (!Debug.ex) break block13;
                    Debug.ex(iOException);
                }
            }
        }
        return debug_url_replacement_map != null;
    }

    private static String debug_preprocess_replace_url(String string) {
        if (Debug.extra) {
            if (string.startsWith("./") || string.startsWith(".\\")) {
                String string2 = Defs.sysProperty("user.dir");
                if (string2 == null && (string2 = Defs.sysProperty("user.home")) == null) {
                    string2 = "";
                }
                string = "file:" + string2 + '/' + string.substring(2).replace('\\', '/');
            } else if (string.startsWith("~/") || string.startsWith("~\\")) {
                String string3 = Defs.sysProperty("user.home");
                if (string3 == null && (string3 = Defs.sysProperty("user.dir")) == null) {
                    string3 = "";
                }
                string = "file:" + string3 + '/' + string.substring(2).replace('\\', '/');
            }
        }
        return string;
    }

    private static InputStream debug_get_replace_stream(URLConnection uRLConnection) {
        if (debug_url_replace) {
            String string = uRLConnection.getURL().toString();
            String[][] stringArray = (String[][])debug_url_replacement_map;
            int n = 0;
            while (n != stringArray.length) {
                block6: {
                    String string2 = stringArray[n][0];
                    boolean bl = false;
                    bl = string2.charAt(string2.length() - 1) == '*' ? string2.regionMatches(0, string, 0, string2.length() - 1) : string2.equals(string);
                    if (bl) {
                        String string3 = stringArray[n][1];
                        if (Debug.trace) {
                            Debug.trace("input replacement: " + string + " -> " + string3);
                        }
                        try {
                            return new URL(string3).openStream();
                        }
                        catch (IOException iOException) {
                            if (!Debug.ex) break block6;
                            Debug.ex(iOException);
                        }
                    }
                }
                ++n;
            }
        }
        return null;
    }

    boolean hasReply() {
        return this.connectionRequested || this.exceptionObject != null || this.inputStream != null;
    }

    public void setRedirected(boolean bl) {
        this.redirected = bl;
    }

    public boolean getRedirected() {
        return this.redirected;
    }

    public ContentLoader(URL uRL, String string) {
        this.url = uRL;
        this.type = string;
    }

    public ContentLoader(String string, String string2) {
        try {
            this.url = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            if (Debug.ex) {
                Debug.ex(malformedURLException);
            }
            this.setException(malformedURLException);
        }
        this.type = string2;
    }

    public ContentLoader(URL uRL, String string, String string2) {
        try {
            this.url = uRL != null ? new URL(uRL, string) : new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            if (Debug.ex) {
                Debug.ex(malformedURLException);
            }
            this.setException(malformedURLException);
        }
        this.type = string2;
    }

    public ContentLoader(URLConnection uRLConnection, String string) {
        this.uc = uRLConnection;
        this.type = string;
    }

    public ContentLoader(URL uRL, InputStream inputStream, String string) {
        this.url = uRL;
        this.inputStream = inputStream;
        this.type = string;
    }

    public ContentLoader(URL uRL, URL uRL2, InputStream inputStream, String string) {
        this.serverRoot = uRL;
        this.url = uRL2;
        this.inputStream = inputStream;
        this.type = string;
    }

    void make() {
        if (this.url == null && this.uc == null) {
            return;
        }
        if (this.getException() != null) {
            return;
        }
        try {
            Object object;
            byte[] byArray;
            if (this.uc == null || this.lazyMake) {
                if (this.uc == null) {
                    this.uc = ContentLoader.openConnection(this.url);
                }
                try {
                    if (this.referer != null) {
                        int n = this.referer.indexOf("#");
                        if (n != -1) {
                            this.referer = this.referer.substring(0, n);
                        }
                        this.uc.setRequestProperty("Referer", this.referer);
                    }
                    if (this.postType != null && this.postData != null) {
                        this.uc.setDoOutput(true);
                        this.uc.setRequestProperty("Content-type", this.postType);
                        OutputStream outputStream = this.uc.getOutputStream();
                        this.connectionRequested = true;
                        try {
                            outputStream.write(this.postData);
                            outputStream.flush();
                            byArray = null;
                        }
                        catch (Throwable throwable) {
                            Object var3_8 = null;
                            outputStream.close();
                            throw throwable;
                        }
                        outputStream.close();
                        {
                        }
                    }
                    if (this.postType != null && this.postStream != null) {
                        this.uc.setDoOutput(true);
                        this.uc.setRequestProperty("Content-type", this.postType);
                        OutputStream outputStream = this.uc.getOutputStream();
                        object = new byte[8192];
                        boolean bl = false;
                        int n = 0;
                        while (!bl) {
                            n = this.postStream.read((byte[])object);
                            if (n != -1) {
                                outputStream.write((byte[])object, 0, n);
                                continue;
                            }
                            bl = true;
                        }
                        outputStream.flush();
                        outputStream.close();
                    }
                }
                catch (IOException iOException) {
                    if (Debug.ex) {
                        Debug.ex(iOException);
                    }
                    this.setException(iOException);
                }
                this.lazyMake = false;
            }
            if (this.inputStream == null) {
                InputStream inputStream;
                this.inputStream = this.uc.getInputStream();
                if (debug_url_replace && (inputStream = ContentLoader.debug_get_replace_stream(this.uc)) != null) {
                    object = this.inputStream;
                    this.inputStream = inputStream;
                    if (object != null) {
                        try {
                            byArray = new byte[4096];
                            ((InputStream)object).read(byArray);
                            Object var6_13 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_14 = null;
                            ((InputStream)object).close();
                            throw throwable;
                        }
                        ((InputStream)object).close();
                        {
                        }
                    }
                }
                this.connectionRequested = true;
            }
            if (this.type == null) {
                this.type = this.uc.getContentType();
            }
            this.url = this.uc.getURL();
        }
        catch (IOException iOException) {
            if (Debug.ex) {
                Debug.ex(iOException);
            }
            this.setException(iOException);
        }
    }

    public void setIframe(boolean bl) {
        this.iframe = bl;
    }

    boolean isIframe() {
        return this.iframe;
    }

    public boolean isFromHistory() {
        return this.fromHistory;
    }

    void setContentType(String string) {
        this.type = string;
    }

    public String getReferer() {
        return this.referer;
    }

    public void setReferer(String string) {
        this.referer = string;
    }

    public void setPostData(String string, byte[] byArray) {
        if (string == null) {
            string = "application/x-www-form-urlencoded";
        }
        this.postType = string;
        this.postData = byArray;
    }

    public void setPostStream(String string, InputStream inputStream) {
        if (string == null) {
            string = "multipart/form-data";
        }
        this.postType = string;
        this.postStream = inputStream;
    }

    public byte[] getPostData() {
        return this.postData;
    }

    public String getContentType() {
        if (this.type == null) {
            this.make();
        }
        if (this.type == null) {
            this.type = "content/unknown";
        }
        return this.type;
    }

    void setURL(URL uRL) {
        this.url = uRL;
    }

    public URL getURL() {
        if (this.url == null) {
            this.make();
        }
        return this.url;
    }

    public URL getServerRoot() {
        return this.serverRoot;
    }

    public URLConnection getURLConnection() {
        if (this.uc == null) {
            try {
                this.uc = ContentLoader.openConnection(this.url);
                this.lazyMake = true;
            }
            catch (IOException iOException) {
                if (Debug.ex) {
                    Debug.ex(iOException);
                }
                this.setException(iOException);
            }
        }
        return this.uc;
    }

    private static URLConnection openConnection(URL uRL) throws IOException {
        return uRL.openConnection();
    }

    public String getRequestProperty(String string) {
        if (this.inputStream == null) {
            this.make();
        }
        if (this.uc != null) {
            return this.uc.getRequestProperty(string);
        }
        return null;
    }

    public String getHeaderFieldKey(int n) {
        if (this.inputStream == null) {
            this.make();
        }
        if (this.uc != null) {
            return this.uc.getHeaderFieldKey(n);
        }
        return null;
    }

    public String getHeaderField(int n) {
        if (this.inputStream == null) {
            this.make();
        }
        if (this.uc != null) {
            return this.uc.getHeaderField(n);
        }
        return null;
    }

    public CookieSet getCookieSet() {
        if (this.inputStream == null) {
            this.make();
        }
        if (this.uc instanceof CookieSet) {
            return (CookieSet)((Object)this.uc);
        }
        return null;
    }

    public InputStream getInputStream() {
        if (this.inputStream == null) {
            this.make();
        }
        return this.inputStream;
    }

    public String getContentCharset() {
        if (this.inputStream == null) {
            this.make();
        }
        if (this.uc != null) {
            return this.uc.getContentEncoding();
        }
        return null;
    }

    public String getLocation() {
        if (this.url != null) {
            return this.url.toExternalForm();
        }
        return null;
    }

    public void setParams(Hashtable hashtable) {
        this.params = hashtable;
    }

    public Hashtable getParams() {
        return this.params;
    }

    void setException(IOException iOException) {
        this.exceptionObject = iOException;
    }

    public IOException getException() {
        return this.exceptionObject;
    }

    public String toString() {
        IOException iOException;
        String string;
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append('{');
        boolean bl = true;
        URL uRL = this.url;
        if (uRL != null) {
            stringBuffer.append(uRL.toExternalForm());
            bl = false;
        }
        if (this.postType != null) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(' ');
            }
            stringBuffer.append("postType=");
            stringBuffer.append(this.postType);
            if (this.postData != null) {
                stringBuffer.append(" postData: ");
                stringBuffer.append(new String(this.postData));
            }
        }
        if ((string = this.type) != null) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(' ');
            }
            stringBuffer.append("type=");
            stringBuffer.append(string);
        }
        if ((iOException = this.getException()) != null) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(' ');
            }
            stringBuffer.append("excepton=");
            stringBuffer.append(iOException);
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

