/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.text;

import ice.pilots.text.ThePilot;
import ice.storm.StormPrinter;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.util.Vector;

public class ThePrinter
implements StormPrinter {
    private int pageWidth;
    private int pageHeight;
    private int zoom = 256;
    private ThePilot pilot = null;
    private int firstLayoutLine = -1;
    private int firstPaintLine;
    private int lineHeight;
    private int fontAscent;
    private int linesPerPage;
    private int numLines;

    ThePrinter(ThePilot thePilot) {
        this.pilot = thePilot;
    }

    public void setPageSize(int n, int n2) {
        this.pageWidth = n - 20;
        this.pageHeight = n2 - 10;
        Font font = ThePilot.getDefaultFont();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        this.lineHeight = fontMetrics.getHeight();
        this.fontAscent = fontMetrics.getAscent();
        this.linesPerPage = this.pageHeight / this.lineHeight;
        this.firstLayoutLine = -1;
        this.firstPaintLine = 0;
        this.numLines = this.pilot.getLines().size();
    }

    public void setZoom(int n) {
        this.zoom = n;
    }

    public int getZoom() {
        return this.zoom;
    }

    public boolean layoutNextPage() {
        if (this.firstLayoutLine == -1) {
            this.firstPaintLine = 0;
            this.firstLayoutLine = this.linesPerPage;
        } else {
            if (this.firstLayoutLine >= this.numLines) {
                return false;
            }
            this.firstPaintLine = this.firstLayoutLine;
            this.firstLayoutLine += this.linesPerPage;
        }
        return true;
    }

    public void printPage(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.setFont(ThePilot.getDefaultFont());
        Vector vector = this.pilot.getLines();
        int n = this.linesPerPage;
        if (this.firstPaintLine + n > this.numLines) {
            n = this.numLines - this.firstPaintLine;
        }
        int n2 = this.fontAscent;
        int n3 = 0;
        while (n3 < n) {
            String string = (String)vector.elementAt(this.firstPaintLine + n3);
            graphics.drawString(string, 10, n2);
            ++n3;
            n2 += this.lineHeight;
        }
    }

    public void dispose() {
    }
}

