/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.pdf;

import com.adobe.acrobat.Viewer;
import ice.debug.Debug;
import ice.storm.ContentLoader;
import ice.storm.Pilot;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;

public class ThePilot
extends Pilot {
    Viewer acrobat;

    public void init(String string) {
        block3: {
            super.init(string);
            if (this.acrobat == null) {
                try {
                    this.acrobat = new Viewer(true);
                    this.acrobat.activate();
                }
                catch (Exception exception) {
                    if (!Debug.ex) break block3;
                    Debug.ex(exception);
                }
            }
        }
    }

    public Component createComponent() {
        return this.acrobat;
    }

    public void clear(String string) {
    }

    public void parse(ContentLoader contentLoader) throws IOException {
        try {
            if (contentLoader.getLocation() == null && contentLoader.getInputStream() != null) {
                InputStream inputStream = contentLoader.getInputStream();
                this.acrobat.setDocumentInputStream(inputStream);
            } else {
                this.acrobat.setDocumentURL(contentLoader.getLocation());
            }
        }
        catch (Exception exception) {
            if (Debug.ex) {
                Debug.ex(exception);
            }
            throw new IOException("Acrobat: Could not load " + contentLoader.getLocation());
        }
        this.firePropertyChange("location", null, contentLoader.getLocation());
        this.firePropertyChange("title", null, "Displaying " + contentLoader.getLocation());
    }

    public void setZoom(int n) {
        block3: {
            super.setZoom(n);
            double d = n;
            try {
                this.acrobat.zoomTo(d / 256.0);
            }
            catch (Exception exception) {
                if (Debug.trace) {
                    Debug.trace("Acrobat: cannot zoom");
                }
                if (!Debug.ex) break block3;
                Debug.ex(exception);
            }
        }
    }

    public void dispose() {
        block2: {
            try {
                this.acrobat.deactivate();
            }
            catch (Exception exception) {
                if (!Debug.ex) break block2;
                Debug.ex(exception);
            }
        }
        super.dispose();
        this.acrobat.deactivate();
        this.acrobat = null;
    }
}

