/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DOptionElement;
import ice.pilots.html4.DSelectElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.swing.DocView;
import ice.pilots.html4.swing.Movable;
import ice.pilots.html4.swing.OptionListModel;
import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.Graphics;
import javax.swing.JComboBox;

class FormSelectChoice
extends JComboBox
implements DSelectElement.SelectPainter,
Movable {
    private DocView docView;
    private DSelectElement sel;
    private ObjectBox box;
    private OptionListModel listModel;

    FormSelectChoice(DocView docView, DElement dElement) {
        this.docView = docView;
        this.sel = (DSelectElement)dElement;
        this.copyOptionsToView();
    }

    private void copyOptionsToView() {
        this.listModel = new OptionListModel(this.sel);
        this.setModel(this.listModel);
        this.checkAttributes();
        this.listModel.ignoreItemChange = false;
        this.updateSelection();
    }

    private void updateSelection() {
        this.listModel.ignoreItemChange = true;
        int n = this.sel.getSelectedIndex();
        if (n >= 0 && n < this.getItemCount()) {
            this.setSelectedIndex(n);
        }
        this.listModel.ignoreItemChange = false;
    }

    private void checkAttributes() {
        this.setEnabled(!this.sel.getDisabled());
    }

    public void onElementAttrChange(DElement dElement, DAttr dAttr) {
        this.checkAttributes();
    }

    public void onOptionSelectionChange() {
        this.updateSelection();
    }

    public void onOptionAttrChange(DOptionElement dOptionElement, DAttr dAttr) {
    }

    public void onOptionStructChange() {
        this.copyOptionsToView();
    }

    public void dispose() {
        Container container = this.getParent();
        if (container != null) {
            container.remove(this);
        }
    }

    public void setBox(ObjectBox objectBox) {
        this.box = objectBox;
        this.docView.checkAwtTree(objectBox, this);
        if (objectBox != null) {
            this.copyOptionsToView();
        }
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int n, int n2) {
        this.setSize(n, n2);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isManagingFocus() {
        return true;
    }

    public void addNotify() {
        super.addNotify();
        this.setNextFocusableComponent(this.getParent());
    }

    public void draw(Graphics graphics) {
    }

    public void syncDom(int n, int n2, boolean bl) {
        this.setLocation(n, n2);
        this.setVisible(bl);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (this.docView.onComponentEvent(this, aWTEvent)) {
            super.processEvent(aWTEvent);
        }
    }
}

