/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.awt;

import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.DOMUIEvent;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.awt.DocView;
import ice.pilots.html4.awt.Movable;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

class FormInputText
extends TextField
implements EventListener,
ObjectPainter,
TextListener,
Movable {
    private DocView docView;
    private DInputElement element;
    private ObjectBox box;
    private int maxLength = 10000;
    private String startValue;

    FormInputText(DocView docView, DElement dElement) {
        this.docView = docView;
        this.element = (DInputElement)dElement;
        this.checkAttributes();
        int n = this.element.getAttributeAsInt("size");
        if (n <= 0) {
            n = 20;
        }
        this.setColumns(n);
        this.setBackground(Color.white);
        this.setFont(new Font("Monospaced", 0, 12));
        this.enableEvents(28L);
        this.addTextListener(this);
    }

    private void checkAttributes() {
        String string;
        this.setEditable(!this.element.getReadOnly());
        this.setEnabled(!this.element.getDisabled());
        int n = this.element.getMaxLength();
        if (n > 0) {
            this.maxLength = n;
        }
        if ((string = this.element.getValue()) != null && !string.equals(this.getText())) {
            this.setText(string);
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        String string = this.getText();
        if (string.length() > this.maxLength) {
            int n = this.getCaretPosition();
            if (n > this.maxLength) {
                n = this.maxLength;
            }
            string = string.substring(0, this.maxLength);
            this.setText(string);
            this.setCaretPosition(n);
        }
        this.element.setValue(string);
    }

    public void onElementAttrChange(DElement dElement, DAttr dAttr) {
        this.checkAttributes();
    }

    public void dispose() {
        Container container = this.getParent();
        if (container != null) {
            container.remove(this);
        }
    }

    public void setBox(ObjectBox objectBox) {
        this.box = objectBox;
        this.docView.checkAwtTree(objectBox, this);
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int n, int n2) {
        this.setSize(n, n2);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void draw(Graphics graphics) {
        if (this.isVisible()) {
            return;
        }
        graphics.setColor(Color.lightGray);
        graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
    }

    public void syncDom(int n, int n2, boolean bl) {
        this.setLocation(n, n2);
        this.setVisible(bl);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        Object object;
        int n;
        FormInputText formInputText = null;
        int n2 = aWTEvent.getID();
        if (!(n2 != 401 && n2 != 402 || (n = ((KeyEvent)(object = (KeyEvent)aWTEvent)).getKeyCode()) != 39 && n != 37)) {
            formInputText = this;
        }
        if (this.docView.onComponentEvent(this, aWTEvent, formInputText)) {
            super.processEvent(aWTEvent);
            if (1004 == n2) {
                if (this.startValue == null) {
                    this.startValue = this.getText();
                }
            } else if (1005 == n2 && !((FocusEvent)aWTEvent).isTemporary()) {
                object = this.getText();
                if (!((String)object).equals(this.startValue)) {
                    this.element.dispatchChange();
                }
                this.startValue = null;
            }
        }
    }

    public void handleEvent(Event event) {
        DOMUIEvent dOMUIEvent = (DOMUIEvent)event;
        int n = this.getCaretPosition();
        int n2 = this.getText().length();
        if (n == 0 && dOMUIEvent.getKeyCode() == 37L) {
            return;
        }
        if (n == n2 && dOMUIEvent.getKeyCode() == 39L) {
            return;
        }
        super.processEvent((AWTEvent)dOMUIEvent.getSystemEvent());
        dOMUIEvent.setDefaultDone();
    }
}

