/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.dombase.Nbrs;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.CSSManager;
import ice.pilots.html4.CSSMatcher;
import ice.pilots.html4.CSSUtil;
import ice.pilots.html4.ComponentFactory;
import ice.pilots.html4.CoordsList;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DFormElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DNodeListeners;
import ice.pilots.html4.DOM;
import ice.pilots.html4.DOMBuilder;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DOptionElement;
import ice.pilots.html4.DSelectElement;
import ice.pilots.html4.DStyleSheet;
import ice.pilots.html4.DTextAreaElement;
import ice.pilots.html4.DefaultActionHandler;
import ice.pilots.html4.DocAction;
import ice.pilots.html4.DocPaneXml;
import ice.pilots.html4.FormTypeElement;
import ice.pilots.html4.Lex2;
import ice.pilots.html4.ObjectPool;
import ice.pilots.html4.RefreshItem;
import ice.pilots.html4.Search;
import ice.pilots.html4.StormData;
import ice.pilots.html4.ThePrinter;
import ice.pilots.html4.TheView;
import ice.storm.ContentLoader;
import ice.storm.DocPane;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import ice.storm.FramesDivider;
import ice.storm.Pilot;
import ice.storm.Scripter;
import ice.storm.StormBase;
import ice.storm.StormPrinter;
import ice.storm.Viewport;
import ice.util.Defs;
import ice.util.ICEException;
import ice.util.alg.HashArray;
import ice.util.alg.ThreadVar;
import ice.util.security.BoxedCode;
import ice.util.security.SecurityKit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.EventListener;

public class ThePilot
extends Pilot
implements Nbrs {
    private static final ThreadVar GLOBAL_EVENT_KEY = ThreadVar.create();
    StormData sdata;
    boolean isFromHistory = false;
    private DDocument doc;
    private CSSLayout cssLayout;
    ObjectPool objectPool;
    private ComponentFactory componentFactory;
    private boolean loadSingleOnly = false;
    public static boolean viewNoframes = Defs.sysPropertyBoolean("ice.pilots.html4.view_noframes", false);
    private String defaultEncoding = null;
    private String encoding = null;
    Object[] persistentDomListeners;
    EventListener defaultEventHandler;
    private boolean bodyOnloadSent = false;
    private Lex2 currentLexer;
    private boolean lexerShouldFinishOnScriptEnd;
    private boolean allowedToLoadImages = true;
    volatile int noLayoutUpdate;
    HashArray tmpBodyEventHandlers;
    private static final int TMP_BUG_FIX_frameset_onload_delay = Defs.sysPropertyInt("ice.pilots.html4.frameset_onload_delay", 0);
    private static final int Field_DOMImplementation = 1;
    private static final int Field_event = 2;
    private static final int Field_pageXOffset = 3;
    private static final int Field_pageYOffset = 4;
    private static final int Method_ActiveXObject = -1;
    private static final int Method_Option = -2;

    public void init(String string) {
        Object object;
        block2: {
            super.init(string);
            this.sdata = StormData.get(this.getStorm());
            this.loadSingleOnly = this.sdata.getLoadSingleOnly();
            String string2 = "ice.pilots.html4." + string + ".TheFactory";
            try {
                object = Class.forName(string2).newInstance();
                this.componentFactory = (ComponentFactory)object;
            }
            catch (Exception exception) {
                if (!Debug.ex) break block2;
                Debug.ex(exception);
            }
        }
        this.defaultEncoding = Defs.sysProperty("ice.pilots.html4.defaultEncoding");
        this.doc = DOM.getInstance(this.sdata).createDDocument(this, true);
        this.objectPool = new ObjectPool(this);
        object = this.componentFactory == null ? "none" : this.componentFactory.getMedia();
        this.cssLayout = this.createCSSLayout((String)object, this.doc);
        this.defaultEventHandler = new DefaultActionHandler(this);
    }

    public void dispose() {
        this.persistentDomListeners = null;
        this.defaultEventHandler = null;
        if (this.componentFactory != null) {
            this.componentFactory.dispose();
        }
        this.cssLayout.clear();
        this.objectPool.dispose();
        this.doc.clear();
        this.componentFactory = null;
        this.cssLayout = null;
        this.objectPool = null;
        this.doc = null;
        this.tmpBodyEventHandlers = null;
        super.dispose();
    }

    protected CSSLayout createCSSLayout(String string, DDocument dDocument) {
        CSSMatcher cSSMatcher = new CSSMatcher(string, this.sdata, dDocument);
        CSSLayout cSSLayout = null;
        if (string.equals("screen") || string.equals("none")) {
            cSSLayout = new CSSLayout(this.sdata, dDocument, cSSMatcher);
        } else if (string.equals("print")) {
            if (!dDocument.isFrameset) {
                cSSLayout = new ThePrinter(this.sdata, dDocument, cSSMatcher);
            }
        } else {
            throw new IllegalArgumentException();
        }
        return cSSLayout;
    }

    public Dimension getDocumentDimension(Dimension dimension) {
        dimension.width = this.cssLayout.getWidth();
        dimension.height = this.cssLayout.getHeight();
        return dimension;
    }

    public Dimension getViewDimension(Dimension dimension) {
        if (this.cssLayout.docPane != null) {
            dimension.width = this.cssLayout.docPane.getPaneWidth();
            dimension.height = this.cssLayout.docPane.getPaneHeight();
        }
        return dimension;
    }

    public void setEncoding(String string) {
        this.defaultEncoding = string;
    }

    public String getEncoding() {
        return this.defaultEncoding;
    }

    public String getPageInfo(String string) {
        return this.doc.getHttpProperty("_http_" + string);
    }

    public Component createComponent() {
        DocPaneXml docPaneXml;
        String string = (String)this.getViewportProperty("encoding");
        if (string != null) {
            this.defaultEncoding = string;
        }
        if (this.componentFactory != null && (docPaneXml = this.componentFactory.createDocPane()) != null) {
            int n = 0;
            String string2 = (String)this.getViewportProperty("scrolling");
            if (string2 != null) {
                if (string2.equalsIgnoreCase("yes")) {
                    n = 1;
                } else if (string2.equalsIgnoreCase("no")) {
                    n = 2;
                }
            }
            docPaneXml.init(n);
            docPaneXml.bind(this, this.cssLayout);
            return docPaneXml.getPaneComponent();
        }
        return null;
    }

    public StormPrinter createPrinter() {
        return (StormPrinter)((Object)this.createCSSLayout("print", this.doc));
    }

    void putBaseUrl(String string) {
        this.setBaseUrl(string);
    }

    public boolean refExists(String string) {
        return this.cssLayout.refExists(string);
    }

    public void gotoRef(String string) {
        DocPaneXml docPaneXml = this.cssLayout.docPane;
        if (docPaneXml == null) {
            return;
        }
        DNode dNode = null;
        if (string == null) {
            docPaneXml.setScrollPosition(0, 0);
            dNode = this.doc.getDBody();
        } else {
            int n = this.cssLayout.getRefPos(string);
            if (n >= 0) {
                docPaneXml.setScrollPosition(0, n);
                dNode = string != null ? this.cssLayout.getRefNode(string) : this.doc.getDBody();
            } else if ("top".equalsIgnoreCase(string)) {
                docPaneXml.setScrollPosition(0, 0);
                dNode = this.doc.getDBody();
            }
        }
        if (dNode != null) {
            this.doc.processEvent(30, dNode);
        }
    }

    public final Document getDocument() {
        return this.getDDocument();
    }

    public DDocument getDDocument() {
        return this.doc;
    }

    final CSSLayout getCSSLayout() {
        return this.cssLayout;
    }

    public TheView getView() {
        return this.cssLayout.theView;
    }

    public DocPane getDocPane() {
        return this.cssLayout.docPane;
    }

    public String getSelectedText() {
        return this.cssLayout.selection.toString();
    }

    public Search getSearch() {
        return new Search(this.doc, this.cssLayout);
    }

    Object doScriptEval(String string, String string2, String string3, int n) {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        Scripter scripter = this.getStorm().getScripter(string);
        if (scripter == null) {
            return null;
        }
        return scripter.eval(this.getPilotViewport(), string2, string3, n);
    }

    private boolean doScriptHandlerEval(String string, Object object, DynamicObject dynamicObject, DynamicObject dynamicObject2) {
        Scripter scripter = this.getStorm().getScripter(string);
        if (scripter == null) {
            return true;
        }
        return scripter.evalEventHandler(this.getPilotViewport(), dynamicObject2, object, dynamicObject);
    }

    void do_document_write(String string) {
        block6: {
            boolean bl = false;
            if (this.currentLexer == null) {
                this.clearContent("text/html", this.getViewportId());
                ThePilot thePilot = this;
                synchronized (thePilot) {
                    this.bodyOnloadSent = false;
                }
                DOMBuilder dOMBuilder = new DOMBuilder(this.doc, this);
                this.currentLexer = new Lex2(dOMBuilder);
                this.lexerShouldFinishOnScriptEnd = true;
                bl = true;
            }
            this.currentLexer.appendGeneratedContent(string);
            try {
                this.currentLexer.parse(bl, false);
            }
            catch (IOException iOException) {
                if (!Debug.ex) break block6;
                Debug.ex(iOException);
            }
        }
    }

    void do_document_close() {
        if (this.currentLexer != null && this.lexerShouldFinishOnScriptEnd) {
            block3: {
                this.lexerShouldFinishOnScriptEnd = false;
                try {
                    this.currentLexer.parse(false, true);
                }
                catch (IOException iOException) {
                    if (!Debug.ex) break block3;
                    Debug.ex(iOException);
                }
            }
            this.currentLexer = null;
            this.finalize_parsing(null);
        }
    }

    private void checkLayoutProperties() {
        this.cssLayout.doImageAnimation = Defs.sysPropertyBoolean("ice.pilots.html4.imageAnimation", true);
        try {
            int n;
            String string = Defs.sysProperty("ice.pilots.html4.minFontSize");
            if (string != null && (n = CSSUtil.parseInt(string)) >= 4) {
                this.sdata.fontCache.setMinFontSize(n);
            }
            if ((string = Defs.sysProperty("ice.pilots.html4.baseFontSize")) != null && (n = CSSUtil.parseInt(string)) >= 4) {
                this.sdata.fontCache.setBaseFontSize(n);
            }
            if ((string = Defs.sysProperty("ice.pilots.html4.baseFontFamily")) != null) {
                this.sdata.fontCache.setBaseFontFamily(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void refresh() {
        this.checkLayoutProperties();
        this.doc.mutate();
        this.cssLayout.validateLayout();
    }

    protected void setZoom(int n) {
        this.cssLayout.setLayoutZoom(n);
    }

    public void suspend() {
        if (this.cssLayout != null) {
            this.cssLayout.clear();
        }
    }

    public void resume() {
        this.refresh();
    }

    public void clear(String string) {
        ThePilot thePilot;
        ThePilot thePilot2 = this;
        synchronized (thePilot2) {
            ++this.noLayoutUpdate;
        }
        try {
            this.do_clear(string);
            Object var5_4 = null;
            thePilot = this;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ThePilot thePilot3 = this;
            synchronized (thePilot3) {
                --this.noLayoutUpdate;
            }
            throw throwable;
        }
        synchronized (thePilot) {
            --this.noLayoutUpdate;
        }
    }

    private void do_clear(String string) {
        this.allowedToLoadImages = true;
        this.doc.processEvent(14, this.doc.getDBody());
        this.cssLayout.clear();
        this.objectPool.dispose();
        this.objectPool = new ObjectPool(this);
        this.doc.clear();
        if (CSSLayout.forceGC) {
            System.gc();
        }
        String string2 = string.toLowerCase();
        if (Debug.trace) {
            Debug.trace("contentType ==" + string + " tmp == " + string2);
        }
        if (string2.indexOf("html") > 0 || string2.indexOf("unknown") >= 0) {
            this.doc.setHtmlMode(true);
        } else {
            this.doc.setHtmlMode(false);
        }
        this.encoding = this.defaultEncoding;
        int n = string2.indexOf("charset");
        if (n > 0 && (n = string.indexOf(61, n)) > 0) {
            this.encoding = string.substring(n + 1).trim();
        }
        this.checkLayoutProperties();
        this.firePropertyChange("title", null, "");
    }

    public void stopImageAnimation() {
        this.cssLayout.doImageAnimation = false;
    }

    public void stopLoading() {
        this.allowedToLoadImages = false;
        this.objectPool.stopImageLoading();
    }

    public void addPersistentDOMEventListener(String string, EventListener eventListener, boolean bl) {
        ThePilot thePilot = this;
        synchronized (thePilot) {
            this.persistentDomListeners = DNodeListeners.addEventListener(this.persistentDomListeners, string, bl, eventListener);
        }
    }

    public void removePersistentDOMEventListener(String string, EventListener eventListener, boolean bl) {
        ThePilot thePilot = this;
        synchronized (thePilot) {
            this.persistentDomListeners = DNodeListeners.removeEventListener(this.persistentDomListeners, string, bl, eventListener);
        }
    }

    public EventListener getDefaultEventHandler() {
        return this.defaultEventHandler;
    }

    public void setDefaultEventHandler(EventListener eventListener) {
        if (eventListener == null) {
            throw new IllegalArgumentException();
        }
        this.defaultEventHandler = eventListener;
    }

    public void parse(ContentLoader contentLoader) throws IOException {
        ThePilot thePilot;
        this.isFromHistory = contentLoader.isFromHistory();
        ThePilot thePilot2 = this;
        synchronized (thePilot2) {
            this.bodyOnloadSent = false;
            ++this.noLayoutUpdate;
        }
        try {
            this.do_parse(contentLoader);
            Object var5_4 = null;
            thePilot = this;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ThePilot thePilot3 = this;
            synchronized (thePilot3) {
                --this.noLayoutUpdate;
            }
            throw throwable;
        }
        synchronized (thePilot) {
            --this.noLayoutUpdate;
        }
        this.finalize_parsing(contentLoader.getLocation());
    }

    private void do_parse(ContentLoader contentLoader) throws IOException {
        Lex2 lex2;
        DOMBuilder dOMBuilder = new DOMBuilder(this.doc, this);
        this.currentLexer = lex2 = new Lex2(dOMBuilder);
        this.doc.setServerRoot(contentLoader.getServerRoot());
        this.doc.cookieSet = contentLoader.getCookieSet();
        try {
            String string;
            Object object;
            int n = 1;
            while (true) {
                object = contentLoader.getHeaderFieldKey(n);
                string = contentLoader.getHeaderField(n);
                if (object == null || string == null) break;
                if (((String)object).equalsIgnoreCase("set-cookie")) {
                    this.doc.setCookie(string);
                } else {
                    this.doc.setHttpProperty("_http_" + ((String)object).toLowerCase(), string);
                }
                ++n;
            }
            try {
                object = contentLoader.getRequestProperty("Cookie");
                if (object != null) {
                    this.doc.setCookie((String)object);
                }
                if ((object = contentLoader.getRequestProperty("referer")) != null) {
                    this.doc.setHttpProperty("_http_referer", (String)object);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            object = contentLoader.getInputStream();
            if (object == null) {
                throw new IOException("Could not connect to: " + contentLoader.getLocation());
            }
            string = contentLoader.getLocation();
            if (string != null) {
                this.firePropertyChange("location", null, string);
            }
            this.doc.setDefaultCharset(this.encoding);
            lex2.setInputStream((InputStream)object, this.encoding);
            try {
                block20: {
                    try {
                        lex2.parse();
                        if (Debug.trace && this.doc == null) {
                            Debug.trace("do_parse: Document is null");
                        }
                        if (this.doc == null) break block20;
                        this.doc.setDefaultCharset(lex2.getEncoding());
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        throw new ICEException(1, 3, 2);
                    }
                    catch (RuntimeException runtimeException) {
                        if (Debug.ex) {
                            Debug.ex(runtimeException);
                        }
                        if (Debug.trace) {
                            Debug.trace("Do not be scared - this exception is caught!");
                        }
                        throw new IOException("Parsing problem");
                    }
                    catch (IOException iOException) {
                        throw iOException;
                    }
                }
                Object var11_8 = null;
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                ((InputStream)object).close();
                throw throwable;
            }
            ((InputStream)object).close();
            Object var13_14 = null;
            this.currentLexer = null;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            this.currentLexer = null;
            throw throwable;
        }
    }

    public void parsingDone() {
        if (this.doc != null && this.doc.isFrameset) {
            this.firePropertyChange("contentRendering", null, "end");
            this.firePropertyChange("outstandingImages", null, "0");
        } else if (this.doc != null) {
            if (this.cssLayout.isLayoutValid()) {
                this.sendBodyLoadEvent();
            } else {
                this.cssLayout.validateLayout();
            }
        }
    }

    private void finalize_parsing(String string) {
        DElement dElement;
        Object object;
        Object object2;
        if (Debug.trace && this.doc == null) {
            Debug.trace("finalize_parsing: Document is null");
        }
        if (this.doc == null) {
            return;
        }
        if (this.doc.isFrameset && !viewNoframes && !this.loadSingleOnly) {
            this.processFrameset();
        } else {
            int n;
            if (string != null && (n = string.indexOf(35)) >= 0) {
                object2 = string.substring(0, n);
                this.cssLayout.setWaitForRef((String)object2);
            }
            object = (String)this.getViewportProperty("marginwidth");
            object2 = (String)this.getViewportProperty("marginheight");
            if ((object != null || object2 != null) && (dElement = this.doc.getDBody()) != null) {
                if (object != null) {
                    dElement.setAttribute(58, (String)object);
                }
                if (object2 != null) {
                    dElement.setAttribute(57, (String)object2);
                }
                this.doc.mutate();
            }
        }
        object = this.doc.getHead();
        if (object != null) {
            object2 = ((DNode)object).getFirstDChild();
            while (object2 != null) {
                String string2;
                if (((DNode)object2).getNameId() == 57 && (string2 = (dElement = (DElement)object2).getAttribute(49)) != null && string2.equalsIgnoreCase("refresh") && (string2 = dElement.getAttribute(31)) != null) {
                    this.setupRefresh(string2);
                }
                object2 = ((DNode)object2).next;
            }
        }
    }

    void sendBodyLoadEvent() {
        DElement dElement;
        if (this.currentLexer == null && (dElement = this.doc.getDBody()) != null) {
            boolean bl;
            if (this.cssLayout.docPane != null) {
                this.cssLayout.docPane.updateScrollbars(this.doc.isRTL());
            }
            ThePilot thePilot = this;
            synchronized (thePilot) {
                bl = this.bodyOnloadSent;
                this.bodyOnloadSent = true;
            }
            if (!bl) {
                DOMEvent dOMEvent = this.doc.createDOMEvent(13, dElement);
                this.doc.processEventLater(dOMEvent, 0L);
                this.firePropertyChange("contentRendering", null, "finished");
                this.objectPool.fireOutstandingImagesEvent();
            }
        }
    }

    boolean canLoadImages() {
        return this.allowedToLoadImages;
    }

    protected void processFrameset() {
        Object object;
        String string;
        Object object2;
        Cloneable cloneable;
        DNode dNode;
        NodeList nodeList = this.doc.getElementsByTagName("frameset");
        if (nodeList.getLength() == 0) {
            return;
        }
        Viewport viewport = new Viewport();
        Vector<Object> vector = new Vector<Object>();
        Vector<String> vector2 = new Vector<String>();
        Vector<DElement> vector3 = new Vector<DElement>();
        DNode dNode2 = dNode = (DNode)nodeList.item(0);
        boolean bl = true;
        do {
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            cloneable = (DElement)dNode2;
            if (((DNode)cloneable).tagId == 34) {
                vector3.addElement((DElement)cloneable);
                object2 = ((DElement)cloneable).getAttribute(28);
                string = ((DElement)cloneable).getAttribute(92);
                if (object2 != null) {
                    object6 = new CoordsList((String)object2);
                    object = ((CoordsList)object6).getListOfValues();
                    object5 = ((CoordsList)object6).getListOfTypes();
                } else {
                    object = new int[1];
                    object5 = new int[1];
                    object[0] = 100;
                    object5[0] = 1;
                }
                if (string != null) {
                    object4 = new CoordsList(string);
                    object6 = ((CoordsList)object4).getListOfValues();
                    object3 = ((CoordsList)object4).getListOfTypes();
                } else {
                    object6 = new int[1];
                    object3 = new int[1];
                    object6[0] = 100;
                    object3[0] = 1;
                }
                object4 = null;
                if (bl) {
                    bl = false;
                } else {
                    DElement dElement;
                    Component component = this.cssLayout.docPane.createFramesDividerComponent();
                    object4 = new FramesDivider(component);
                    String string2 = ((DElement)cloneable).getAttribute(65);
                    if (component != null && (string2 == null || string2.equalsIgnoreCase("false"))) {
                        component.addMouseListener((MouseListener)object4);
                        component.addMouseMotionListener((MouseMotionListener)object4);
                    }
                    if ((string2 = (dElement = (DElement)((DNode)cloneable).getDParent()).getAttribute(43)) != null) {
                        ((FramesDivider)object4).setProperty("frameborder", string2);
                    }
                    if ((string2 = dElement.getAttribute(13)) != null) {
                        ((FramesDivider)object4).setProperty("border", string2);
                    }
                }
                if (((Object)object6).length > 1) {
                    viewport.beginFrameset((int[])object, (int[])object5, (int[])object6, (int[])object3, 1, (FramesDivider)object4);
                } else {
                    viewport.beginFrameset((int[])object, (int[])object5, (int[])object6, (int[])object3, 2, (FramesDivider)object4);
                }
            } else if (((DNode)cloneable).tagId == 33) {
                object2 = ((DElement)cloneable).getAttribute(102);
                string = ((DElement)cloneable).getAttribute(63);
                if (object2 == null) {
                    object2 = "";
                }
                if (((String)object2).length() > 0) {
                    object2 = this.doc.resolveUrl((String)object2);
                }
                if (string != null && string.length() == 0) {
                    string = null;
                }
                if (viewport.addFramesetChild((Viewport)(object = (Object)new Viewport(string)), (FramesDivider)(object6 = new FramesDivider((Component)(object5 = (Object)this.cssLayout.docPane.createFramesDividerComponent()))))) {
                    vector2.addElement(((Viewport)object).getId());
                    vector.addElement(object2);
                    object3 = ((DElement)cloneable).getAttribute(97);
                    if (object3 != null) {
                        ((Viewport)object).setProperty("scrolling", object3);
                    }
                    if ((object3 = (Object)((DElement)cloneable).getAttribute(58)) != null) {
                        ((Viewport)object).setProperty("marginwidth", object3);
                    }
                    if ((object3 = (Object)((DElement)cloneable).getAttribute(57)) != null) {
                        ((Viewport)object).setProperty("marginheight", object3);
                    }
                    if ((object3 = (Object)((DElement)(object4 = (DElement)((DNode)cloneable).getDParent())).getAttribute(43)) != null) {
                        ((FramesDivider)object6).setProperty("frameborder", (String)object3);
                    }
                    if ((object3 = (Object)((DElement)object4).getAttribute(13)) != null) {
                        ((FramesDivider)object6).setProperty("border", (String)object3);
                    }
                    object3 = ((DElement)cloneable).getAttribute(65);
                    if (object5 != null && (object3 == null || ((String)object3).equalsIgnoreCase("false"))) {
                        ((Component)object5).addMouseListener((MouseListener)object6);
                        ((Component)object5).addMouseMotionListener((MouseMotionListener)object6);
                    }
                }
            }
            if (((DNode)cloneable).tagId != 34 || dNode2.getFirstDChild() == null) {
                while (dNode2 != dNode && dNode2.next == null) {
                    dNode2 = dNode2.parent;
                    if (dNode2.getNameId() != 34) continue;
                    viewport.endFrameset();
                }
                if (dNode2 == dNode) continue;
                dNode2 = dNode2.next;
                continue;
            }
            dNode2 = dNode2.getFirstDChild();
        } while (dNode2 != dNode);
        if (this.configureViewport(viewport)) {
            int n = 0;
            while (n < vector2.size()) {
                object2 = (String)vector.elementAt(n);
                string = (String)vector2.elementAt(n);
                this.clearContent("text/html", string);
                if (((String)object2).length() != 0 && !this.isFromHistory) {
                    object = this.getUrlMaster().createLoader((String)object2);
                    ((ContentLoader)object).setReferer(this.doc.getBaseUrl());
                    this.renderContent((ContentLoader)object, string);
                }
                ++n;
            }
            if (this.isFromHistory) {
                this.firePropertyChange("viewport", null, "childrenReady");
            }
        }
        if (TMP_BUG_FIX_frameset_onload_delay <= 0) {
            this.sendFramesetOnload(vector3);
        } else {
            cloneable = vector3;
            object2 = new DocAction((Vector)cloneable, this.doc){
                private final /* synthetic */ Vector val$v;
                {
                    this.val$v = vector;
                }

                protected void doit(DDocument dDocument) {
                    ThePilot.this.sendFramesetOnload(this.val$v);
                }
            };
            ((DocAction)object2).postToEventThread(TMP_BUG_FIX_frameset_onload_delay);
        }
    }

    void sendFramesetOnload(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            DElement dElement = (DElement)vector.elementAt(n);
            this.doc.processEvent(13, dElement);
            ++n;
        }
    }

    protected boolean allowedToRunHandler(DOMEvent dOMEvent, DNode dNode) {
        switch (dOMEvent.getTypeId()) {
            case 19: {
                if (!(dNode instanceof DFormElement) || dOMEvent.getTarget() == dNode) break;
                return false;
            }
        }
        return true;
    }

    protected DynamicObject getScriptHandlerThis(DNode dNode, DOMEvent dOMEvent) {
        DNode dNode2 = dNode;
        if (!(dNode.tagId != 13 && dNode.tagId != 34 || dOMEvent.typeId != 13 && dOMEvent.typeId != 14)) {
            dNode2 = null;
        }
        return dNode2;
    }

    protected void evalScriptHandlerListeners(DNode dNode, DOMEvent dOMEvent, Object object) {
        if (object != null && this.allowedToRunHandler(dOMEvent, dNode)) {
            boolean bl;
            DynamicObject dynamicObject = this.getScriptHandlerThis(dNode, dOMEvent);
            DOMEvent dOMEvent2 = (DOMEvent)GLOBAL_EVENT_KEY.push(dOMEvent);
            try {
                bl = this.doScriptHandlerEval("ECMAScript", object, dOMEvent, dynamicObject);
                Object var8_7 = null;
                GLOBAL_EVENT_KEY.restore(dOMEvent2);
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                GLOBAL_EVENT_KEY.restore(dOMEvent2);
                throw throwable;
            }
            if (dOMEvent.typeId == 5 || dOMEvent.typeId == 7) {
                boolean bl2 = bl = !bl;
            }
            if (!bl) {
                dOMEvent.preventDefault();
            }
        }
    }

    public static void addColorDefinition(String string, Color color) {
        CSSUtil.addColorDefinition(string, color);
    }

    public static DStyleSheet getUserStyleSheet(StormBase stormBase) {
        return CSSManager.getUserStyle(StormData.get(stormBase));
    }

    protected Object script_createOption(Object[] objectArray) {
        DOptionElement dOptionElement = (DOptionElement)this.doc.createElement(63);
        if (objectArray.length >= 1) {
            Object object = objectArray[0];
            String string = object == null ? "" : object.toString();
            dOptionElement.setText(string);
            if (objectArray.length >= 2) {
                object = objectArray[1];
                String string2 = object == null ? "" : object.toString();
                dOptionElement.setValue(string2);
            }
        }
        return dOptionElement;
    }

    protected Object script_createActiveXObject(String string) {
        if ("Msxml2.DOMDocument".equals(string)) {
            if (Debug.trace) {
                Debug.trace("WindowObj.script_ActiveXObject 2");
            }
            return this.doc.getDom().createDDocument(this, false);
        }
        return null;
    }

    protected Object script_getDOMImplementation() {
        return this.doc.getDom();
    }

    public final DynamicObject getDocumentObject() {
        return this.getDDocument();
    }

    private int IE_nameToWinBodySharedAttr(String string) {
        int n = 0;
        String string2 = null;
        int n2 = string.length();
        if (n2 == 6) {
            char c = string.charAt(2);
            if (c == 'b') {
                string2 = "onblur";
                n = 70;
            } else if (c == 'l') {
                string2 = "onload";
                n = 78;
            }
        } else if (n2 == 7) {
            string2 = "onfocus";
            n = 74;
        } else if (n2 == 8) {
            string2 = "onunload";
            n = 87;
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n - 1;
    }

    private void tmpStoreBodyEventHandlers(int n, Object object) {
        if (this.tmpBodyEventHandlers == null) {
            this.tmpBodyEventHandlers = new HashArray();
        }
        this.tmpBodyEventHandlers.put(n, object);
    }

    private Object getTmpStoredBodyEventHandlers(int n) {
        HashArray hashArray = this.tmpBodyEventHandlers;
        return hashArray != null ? hashArray.get(n) : null;
    }

    void moveToBodyTmpBodyEventHandlers() {
        DElement dElement;
        HashArray hashArray = this.tmpBodyEventHandlers;
        this.tmpBodyEventHandlers = null;
        if (hashArray != null && (dElement = this.doc.getDBody()) != null) {
            HashArray.Iterator iterator = hashArray.newIterator();
            iterator.start();
            while (!iterator.done()) {
                HashArray.Entry entry = iterator.entry();
                int n = entry.index();
                Object object = entry.value;
                dElement.setDAttr(n, object, false);
                iterator.next();
            }
        }
    }

    public Object getDynamicValueOnWindow(DynamicObject dynamicObject, String string, DynEnv dynEnv) {
        int n = ThePilot.toDynamicId(string);
        if (n < 0) {
            return dynEnv.wrapMethod(dynamicObject, string);
        }
        if (n > 0) {
            return this.getDynamicValueOnWindow(n, dynEnv);
        }
        int n2 = this.IE_nameToWinBodySharedAttr(string);
        if (n2 >= 0) {
            DElement dElement = this.doc.getDBody();
            Object object = dElement != null ? dElement.getDAttrValueOrNull(n2) : this.getTmpStoredBodyEventHandlers(n2);
            return object;
        }
        return super.getDynamicValueOnWindow(dynamicObject, string, dynEnv);
    }

    public int setDynamicValueOnWindow(DynamicObject dynamicObject, String string, Object object, DynEnv dynEnv) {
        int n = ThePilot.toDynamicId(string);
        if (n < 0) {
            return 2;
        }
        if (n > 0) {
            return this.setDynamicValueOnWindow(n, object, dynEnv);
        }
        int n2 = this.IE_nameToWinBodySharedAttr(string);
        if (n2 >= 0) {
            DElement dElement = this.doc.getDBody();
            if (dElement != null) {
                dElement.setDAttr(n2, object, false);
            } else {
                this.tmpStoreBodyEventHandlers(n2, object);
            }
            return 1;
        }
        return super.setDynamicValueOnWindow(dynamicObject, string, object, dynEnv);
    }

    public Object execDynamicMethodOnWindow(DynamicObject dynamicObject, String string, Object[] objectArray, DynEnv dynEnv) {
        int n = ThePilot.toDynamicId(string);
        if (n < 0) {
            return this.execDynamicMethodOnWindow(n, objectArray, dynEnv);
        }
        return super.execDynamicMethodOnWindow(dynamicObject, string, objectArray, dynEnv);
    }

    private Object getDynamicValueOnWindow(int n, DynEnv dynEnv) {
        switch (n) {
            case 2: {
                DOMEvent dOMEvent = (DOMEvent)GLOBAL_EVENT_KEY.get();
                return dOMEvent;
            }
            case 1: {
                return this.script_getDOMImplementation();
            }
        }
        return null;
    }

    private int setDynamicValueOnWindow(int n, Object object, DynEnv dynEnv) {
        return 1;
    }

    private Object execDynamicMethodOnWindow(int n, Object[] objectArray, DynEnv dynEnv) {
        if (n == -2) {
            return this.script_createOption(objectArray);
        }
        if (n == -1) {
            return this.script_createActiveXObject(dynEnv.toStr(objectArray, 0));
        }
        return dynEnv.wrapVoid();
    }

    private static int toDynamicId(String string) {
        int n = 0;
        String string2 = null;
        switch (string.length()) {
            case 5: {
                string2 = "event";
                n = 2;
                break;
            }
            case 6: {
                string2 = "Option";
                n = -2;
                break;
            }
            case 11: {
                char c = string.charAt(4);
                if (c == 'X') {
                    string2 = "pageXOffset";
                    n = 3;
                    break;
                }
                if (c != 'Y') break;
                string2 = "pageYOffset";
                n = 4;
                break;
            }
            case 13: {
                string2 = "ActiveXObject";
                n = -1;
                break;
            }
            case 17: {
                string2 = "DOMImplementation";
                n = 1;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }

    public Object getSnapshot() {
        FormTypeElement formTypeElement;
        int n;
        DDocument dDocument = (DDocument)this.getDocument();
        if (dDocument == null) {
            return null;
        }
        HashArray hashArray = new HashArray(Defs.NO_SYNCHRONIZATION);
        String string = null;
        String string2 = null;
        NodeList nodeList = dDocument.getElementsByTagName("input");
        if (nodeList != null) {
            n = 0;
            while (n < nodeList.getLength()) {
                formTypeElement = (DInputElement)nodeList.item(n);
                string = formTypeElement.getName();
                string2 = ((DInputElement)formTypeElement).getType();
                if (string != null && string2 != null) {
                    if (string2.equals("text") || string2.equals("hidden")) {
                        hashArray.put(string, (Object)((DInputElement)formTypeElement).getValue());
                    } else if (string2.equals("checkbox")) {
                        hashArray.put(string, (Object)new Boolean(((DInputElement)formTypeElement).getChecked()));
                    } else if (string2.equals("radio") && formTypeElement.getAttribute("value") != null) {
                        hashArray.put(string + "_" + formTypeElement.getAttribute("value"), (Object)new Boolean(((DInputElement)formTypeElement).getChecked()));
                    }
                }
                ++n;
            }
        }
        if ((nodeList = dDocument.getElementsByTagName("textarea")) != null) {
            n = 0;
            while (n < nodeList.getLength()) {
                String string3;
                formTypeElement = (DTextAreaElement)nodeList.item(n);
                string = formTypeElement.getName();
                if (string != null && (string3 = ((DTextAreaElement)formTypeElement).getValue()) != null) {
                    hashArray.put(string, (Object)string3);
                }
                ++n;
            }
        }
        if ((nodeList = dDocument.getElementsByTagName("select")) != null) {
            n = 0;
            while (n < nodeList.getLength()) {
                formTypeElement = (DSelectElement)nodeList.item(n);
                string = formTypeElement.getName();
                if (string != null) {
                    int n2 = 0;
                    while (n2 < ((DSelectElement)formTypeElement).getLength()) {
                        DOptionElement dOptionElement = (DOptionElement)((DSelectElement)formTypeElement).item(n2);
                        hashArray.put(string + "_" + n2, (Object)new Boolean(dOptionElement.getSelected()));
                        ++n2;
                    }
                }
                ++n;
            }
        }
        hashArray.sealObject();
        if (hashArray.isEmpty()) {
            return null;
        }
        Snapshot snapshot = new Snapshot();
        snapshot.inputNames = hashArray;
        snapshot.scrollPosition = this.getDocPane().getScrollY();
        return snapshot;
    }

    public void applySnapshot(Object object) {
        Object object2;
        Object object3;
        DDocument dDocument = (DDocument)this.getDocument();
        Snapshot snapshot = (Snapshot)object;
        HashArray hashArray = snapshot.inputNames;
        if (dDocument == null || hashArray == null) {
            return;
        }
        String string = null;
        String string2 = null;
        NodeList nodeList = dDocument.getElementsByTagName("input");
        int n = 0;
        while (n < nodeList.getLength()) {
            DInputElement dInputElement = (DInputElement)nodeList.item(n);
            string = dInputElement.getName();
            string2 = dInputElement.getType();
            if (string != null && string2 != null) {
                if (string2.equals("text") || string2.equals("hidden")) {
                    object3 = (String)hashArray.get(string);
                    if (object3 != null) {
                        dInputElement.setValue((String)object3);
                    }
                } else if (string2.equals("checkbox")) {
                    object3 = (Boolean)hashArray.get(string);
                    if (object3 != null) {
                        dInputElement.setChecked((Boolean)object3);
                    }
                } else if (string2.equals("radio") && dInputElement.getAttribute("value") != null && (object3 = (Boolean)hashArray.get(string + "_" + dInputElement.getAttribute("value"))) != null) {
                    dInputElement.setChecked((Boolean)object3);
                }
            }
            ++n;
        }
        nodeList = dDocument.getElementsByTagName("textarea");
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            object3 = (DTextAreaElement)nodeList.item(n2);
            string = ((DElement)object3).getName();
            if (string != null && (object2 = (String)hashArray.get(string)) != null) {
                ((DTextAreaElement)object3).setValue((String)object2);
            }
            ++n2;
        }
        nodeList = dDocument.getElementsByTagName("select");
        int n3 = 0;
        while (n3 < nodeList.getLength()) {
            object2 = (DSelectElement)nodeList.item(n3);
            string = ((DElement)object2).getName();
            if (string != null) {
                int n4 = 0;
                while (n4 < ((DSelectElement)object2).getLength()) {
                    DOptionElement dOptionElement = (DOptionElement)((DSelectElement)object2).item(n4);
                    Boolean bl = (Boolean)hashArray.get(string + "_" + n4);
                    if (bl != null) {
                        dOptionElement.setSelected(bl);
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        this.cssLayout.setPresetScrollPos(snapshot.scrollPosition);
    }

    static boolean prepareImage(final Image image, final ImageObserver imageObserver) {
        final Toolkit toolkit = Toolkit.getDefaultToolkit();
        return Boolean.TRUE == SecurityKit.doPrivileged(new BoxedCode(){

            public Object run() {
                boolean bl = toolkit.prepareImage(image, -1, -1, imageObserver);
                return bl ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    void setupRefresh(String string) {
        String string2;
        char c;
        int n = 0;
        int n2 = string.indexOf(59);
        if (n2 < 0) {
            n2 = string.indexOf(44);
        }
        if (n2 > 0) {
            try {
                n = CSSUtil.parseInt(string.substring(0, n2));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            string = string.substring(n2 + 1);
        }
        if ((n2 = string.indexOf(61)) > 0 && string.substring(0, n2).trim().equalsIgnoreCase("url")) {
            string = string.substring(n2 + 1);
        }
        if ((string = string.trim()).length() > 0 && ((c = string.charAt(0)) == '\'' || c == '\"')) {
            int n3 = string.indexOf(c, 1);
            string = n3 < 0 ? string.substring(1) : string.substring(1, n3);
        }
        try {
            n = CSSUtil.parseInt(string);
            string = "";
            string2 = this.doc.getBaseUrl();
        }
        catch (RuntimeException runtimeException) {
            string2 = this.doc.resolveUrl(string);
        }
        if (string2 == null) {
            if (null != this.getStorm().getScripterForCodeLocation(string)) {
                string2 = string;
            } else {
                return;
            }
        }
        RefreshItem refreshItem = new RefreshItem(this.doc, string2, n *= 1000);
        refreshItem.postToEventThread(n);
    }

    private static class Snapshot {
        HashArray inputNames;
        int scrollPosition;

        private Snapshot() {
        }
    }
}

