/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.BlockBox;
import ice.pilots.html4.BoxList;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.CSSRect;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.FloatBox;
import ice.pilots.html4.FloatManager;
import ice.pilots.html4.FloatPainter;
import ice.pilots.html4.InlineBox;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

class PositionedBox
extends BlockBox {
    Vector children = new Vector();
    BoxList list;
    boolean dummy = false;
    private CSSBox firstBlock;
    CSSBox previousSibling;
    private FloatPainter floatPainter = new FloatPainter();

    PositionedBox(DElement dElement, CSSAttribs cSSAttribs, CSSLayout cSSLayout, byte by, CSSBox cSSBox) {
        super(dElement, cSSAttribs, cSSLayout, by);
        if (cSSAttribs.margin_left != -123456) {
            cSSAttribs.left += cSSAttribs.margin_left;
            cSSAttribs.margin_left = -123456;
        }
        if (cSSAttribs.margin_right != -123456) {
            cSSAttribs.right += cSSAttribs.margin_right;
            cSSAttribs.margin_right = -123456;
        }
        this.floatPainter = new FloatPainter();
        this.previousSibling = cSSBox;
    }

    PositionedBox(boolean bl, CSSBox cSSBox, BoxList boxList) {
        super(null, null, null, (byte)0);
        this.dummy = bl;
        if (cSSBox != null) {
            CSSAttribs cSSAttribs = cSSBox.css;
            this.css = new CSSAttribs(cSSBox.cssLayout.sdata, null);
            this.css.position = cSSAttribs.position;
            this.css.left = cSSAttribs.left;
            if (cSSAttribs.margin_left != -123456) {
                this.css.left += cSSAttribs.margin_left;
            }
            this.css.top = cSSAttribs.top;
            this.css.right = cSSAttribs.right;
            if (cSSAttribs.margin_right != -123456) {
                this.css.right += cSSAttribs.margin_right;
            }
            this.css.bottom = cSSAttribs.bottom;
            this.css.display = cSSAttribs.display;
            this.css.width = cSSAttribs.width;
            this.css.percentage_flag = cSSAttribs.percentage_flag;
        }
        this.firstBlock = cSSBox;
        this.list = boxList;
    }

    void propagateVisibility(byte by, boolean bl) {
        if (this.firstBlock != null) {
            this.firstBlock.propagateVisibility(by, bl);
        } else {
            super.propagateVisibility(by, bl);
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                CSSBox cSSBox = (CSSBox)enumeration.nextElement();
                cSSBox.propagateVisibility(by, true);
            }
        }
    }

    void changeTopAndLeft(int n, int n2) {
        this.oy += n2;
        this.ox += n;
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            CSSBox cSSBox = (CSSBox)enumeration.nextElement();
            if (cSSBox instanceof PositionedBox) {
                ((PositionedBox)cSSBox).changeTopAndLeft(n, n2);
                continue;
            }
            cSSBox.oy += n2;
            cSSBox.ox += n;
        }
    }

    void setParentBox(CSSBox cSSBox) {
        super.setParentBox(cSSBox);
        if (this.parentBox.getType() == 0 && this.css.position == 126) {
            InlineBox inlineBox = (InlineBox)this.parentBox;
            this.parentBox = inlineBox.inline2Block();
        }
    }

    boolean substitute(CSSBox cSSBox, CSSBox cSSBox2) {
        if (this.firstBlock == cSSBox) {
            this.firstBlock = cSSBox2;
            return true;
        }
        int n = 0;
        while (n < this.children.size()) {
            PositionedBox positionedBox = (PositionedBox)this.children.elementAt(n);
            if (positionedBox == cSSBox) {
                ((PositionedBox)cSSBox2).list = this.list;
                this.children.setElementAt(cSSBox2, n);
                return true;
            }
            if (positionedBox.substitute(cSSBox, cSSBox2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void clear() {
        this.firstBlock = null;
        int n = 0;
        while (n < this.children.size()) {
            PositionedBox positionedBox = (PositionedBox)this.children.elementAt(n);
            positionedBox.clear();
            ++n;
        }
        this.children.removeAllElements();
    }

    private CSSBox do_getBoxAt(int n, int n2, Point point, CSSBox cSSBox) {
        Object object;
        CSSBox cSSBox2;
        int n3 = cSSBox.ox;
        int n4 = cSSBox.oy;
        int n5 = cSSBox.width;
        int n6 = cSSBox.height;
        if (cSSBox.getType() == 0) {
            cSSBox2 = (InlineBox)cSSBox;
            object = new Rectangle();
            cSSBox2.findBoundingBox((Rectangle)object);
            n3 = ((Rectangle)object).x;
            n4 = ((Rectangle)object).y;
            n5 = ((Rectangle)object).width;
            n6 = ((Rectangle)object).height;
        }
        cSSBox2 = null;
        object = cSSBox.css.clip;
        if (object != null) {
            if (n >= n3 + ((CSSRect)object).left && n2 >= n4 + ((CSSRect)object).top && n < n3 + ((CSSRect)object).right && n2 < n4 + ((CSSRect)object).bottom) {
                cSSBox2 = cSSBox.getBoxAt(n - n3, n2 - n4, point);
            }
        } else if (n >= n3 && n2 >= n4 && n < n3 + n5 && n2 < n4 + n6) {
            cSSBox2 = cSSBox.getBoxAt(n - n3, n2 - n4, point);
        }
        return cSSBox2;
    }

    CSSBox _getBoxAt(int n, int n2, Point point) {
        CSSBox cSSBox = null;
        CSSBox cSSBox2 = this.firstBlock;
        if (cSSBox2 == null) {
            int n3 = this.children.size() - 1;
            while (n3 >= 0 && cSSBox == null) {
                PositionedBox positionedBox = (PositionedBox)this.children.elementAt(n3);
                cSSBox = positionedBox._getBoxAt(n, n2, point);
                --n3;
            }
        }
        if (!this.dummy) {
            cSSBox2 = this;
        }
        if (cSSBox == null && cSSBox2 != null && this._isVisible(cSSBox2) && !this.isClippedByParents(n, n2, cSSBox2)) {
            cSSBox = this.do_getBoxAt(n, n2, point, cSSBox2);
        }
        return cSSBox;
    }

    private void do_paint(Graphics graphics, CSSBox cSSBox) {
        if (cSSBox != null && this._isVisible(cSSBox) && cSSBox.getType() != 0) {
            Graphics graphics2 = graphics.create();
            PositionedBox.applyClippingFromParents(graphics2, cSSBox);
            graphics2.clipRect(cSSBox.ox, cSSBox.oy, cSSBox.width, cSSBox.height);
            cSSBox.cssLayout.outlinePainter.drawBox(graphics2, cSSBox, cSSBox.ox, cSSBox.oy);
            graphics2.dispose();
        }
    }

    void _paint(Graphics graphics) {
        PositionedBox positionedBox;
        if (this.firstBlock != null) {
            this.do_paint(graphics, this.firstBlock);
            return;
        }
        int n = 0;
        int n2 = this.children.size();
        while (n < n2) {
            positionedBox = (PositionedBox)this.children.elementAt(n);
            if (positionedBox.css.z_index >= 0) break;
            positionedBox._paint(graphics);
            ++n;
        }
        if (!this.dummy) {
            this.do_paint(graphics, this);
        }
        while (n < n2) {
            positionedBox = (PositionedBox)this.children.elementAt(n);
            positionedBox._paint(graphics);
            ++n;
        }
    }

    private boolean _isVisible(CSSBox cSSBox) {
        while (cSSBox != null) {
            if (cSSBox.css.position != 124 && (cSSBox.css.misc & 1) == 0) {
                return false;
            }
            cSSBox = cSSBox.getParentBox();
        }
        return true;
    }

    private static void applyClippingFromParents(Graphics graphics, CSSBox cSSBox) {
        cSSBox = cSSBox.getParentBox();
        while (cSSBox != null) {
            CSSRect cSSRect;
            if (cSSBox.css.position != 124 && (cSSRect = cSSBox.css.clip) != null) {
                graphics.clipRect(cSSBox.ox + cSSRect.left, cSSBox.oy + cSSRect.top, cSSRect.right - cSSRect.left, cSSRect.bottom - cSSRect.top);
            }
            cSSBox = cSSBox.getParentBox();
        }
    }

    private boolean isClippedByParents(int n, int n2, CSSBox cSSBox) {
        cSSBox = cSSBox.getParentBox();
        while (cSSBox != null) {
            CSSRect cSSRect;
            if (cSSBox.css.position != 124 && (cSSRect = cSSBox.css.clip) != null && (n < cSSBox.ox + cSSRect.left || n2 < cSSBox.oy + cSSRect.top || n >= cSSBox.ox + cSSRect.right || n2 >= cSSBox.oy + cSSRect.bottom)) {
                return true;
            }
            cSSBox = cSSBox.getParentBox();
        }
        return false;
    }

    void layout(CSSBox cSSBox) {
        if (cSSBox == null) {
            return;
        }
        if (!this.dummy || this.firstBlock != null) {
            if (this.css.position == 125) {
                this.layoutRelativeBox();
            } else if (this.css.position == 126) {
                this.layoutAbsoluteBox(cSSBox.width, cSSBox.height);
            }
        }
        if (this.firstBlock == null) {
            int n = 0;
            while (n < this.children.size()) {
                PositionedBox positionedBox = (PositionedBox)this.children.elementAt(n);
                positionedBox.layout(cSSBox);
                ++n;
            }
        }
    }

    CSSBox findCSSBox(DNode dNode) {
        if (this.firstBlock != null) {
            if (this.firstBlock.getDomNode() == dNode) {
                return this.firstBlock;
            }
            return null;
        }
        if (this.getDomNode() == dNode) {
            return this;
        }
        int n = 0;
        while (n < this.children.size()) {
            PositionedBox positionedBox = (PositionedBox)this.children.elementAt(n);
            CSSBox cSSBox = positionedBox.findCSSBox(dNode);
            if (cSSBox != null) {
                return cSSBox;
            }
            ++n;
        }
        return null;
    }

    PositionedBox findBox(CSSBox cSSBox) {
        if (this.firstBlock != null) {
            return null;
        }
        if (cSSBox == this) {
            return this;
        }
        PositionedBox positionedBox = null;
        int n = 0;
        while (n < this.children.size()) {
            PositionedBox positionedBox2 = (PositionedBox)this.children.elementAt(n);
            positionedBox = positionedBox2.findBox(cSSBox);
            if (positionedBox != null) break;
            ++n;
        }
        return positionedBox;
    }

    void add(CSSBox cSSBox, CSSBox cSSBox2) {
        PositionedBox positionedBox = null;
        if (!(cSSBox instanceof PositionedBox)) {
            positionedBox = new PositionedBox(true, cSSBox, this.list);
        } else {
            positionedBox = (PositionedBox)cSSBox;
            positionedBox.list = this.list;
        }
        positionedBox.setParentBox(cSSBox2);
        int n = 0;
        while (n < this.children.size()) {
            PositionedBox positionedBox2 = (PositionedBox)this.children.elementAt(n);
            if (cSSBox.css.z_index < positionedBox2.css.z_index) {
                this.children.insertElementAt(positionedBox, n);
                return;
            }
            ++n;
        }
        this.children.addElement(positionedBox);
    }

    private void layoutRelativeBox() {
        CSSBox cSSBox = this.firstBlock != null ? this.firstBlock : this;
        int n = 0;
        int n2 = 0;
        if (cSSBox.css.left != -123456) {
            n = cSSBox.css.left;
        }
        if (cSSBox.css.right != -123456 && Math.abs(cSSBox.css.right) > Math.abs(n)) {
            n = -cSSBox.css.right;
        }
        if (cSSBox.css.top != -123456) {
            n2 = cSSBox.css.top;
        }
        if (cSSBox.css.bottom != -123456 && Math.abs(cSSBox.css.bottom) > Math.abs(n2)) {
            n2 = -cSSBox.css.bottom;
        }
        if (cSSBox.getType() == 0) {
            InlineBox inlineBox = (InlineBox)cSSBox;
            inlineBox.relX = n;
            inlineBox.relY = n2;
        } else {
            Point point = new Point();
            point.x = cSSBox.ox;
            point.y = cSSBox.oy;
            if (cSSBox.parentBox != null) {
                cSSBox.parentBox.findAbsolutePosition(point);
            }
            cSSBox.ox = point.x + n;
            cSSBox.oy = point.y + n2;
            if (cSSBox.parentBox != null && cSSBox.parentBox.minWidth == cSSBox.parentBox.maxWidth) {
                cSSBox.width = cSSBox.maxWidth;
            }
        }
    }

    void layoutAbsoluteBox(int n, int n2) {
        int n3;
        CSSBox cSSBox = this.firstBlock != null ? this.firstBlock : this;
        Rectangle rectangle = new Rectangle();
        int n4 = n;
        int n5 = n2;
        int n6 = 0;
        int n7 = 0;
        rectangle.x = 0;
        rectangle.y = 0;
        rectangle.width = 0;
        rectangle.height = 0;
        CSSBox cSSBox2 = cSSBox.parentBox;
        if (cSSBox2 != null) {
            cSSBox2.findBoundingBox(rectangle);
        }
        while (cSSBox2 != null) {
            if (cSSBox2.css.position != 124) {
                if (cSSBox2.css.position == 125) {
                    n6 = rectangle.x;
                    n7 = rectangle.y;
                    rectangle.x -= cSSBox2.ox;
                    rectangle.y -= cSSBox2.oy;
                } else {
                    n6 = cSSBox2.ox;
                    n7 = cSSBox2.oy;
                }
                if (!(cSSBox2 instanceof BlockBox)) break;
                n4 = cSSBox2.width;
                n5 = cSSBox2.height;
                break;
            }
            cSSBox2 = cSSBox2.parentBox;
        }
        if (cSSBox instanceof PositionedBox) {
            CSSBox cSSBox3 = cSSBox;
            Rectangle rectangle2 = new Rectangle();
            CSSBox cSSBox4 = ((PositionedBox)cSSBox3).previousSibling;
            if (cSSBox4 != null) {
                n3 = 0;
                if (cSSBox4.next != null) {
                    cSSBox4 = cSSBox4.next;
                    n3 = 1;
                }
                if (cSSBox4.getType() == 2) {
                    cSSBox4 = ((FloatBox)cSSBox4).getBlock();
                }
                cSSBox4.findBoundingBox(rectangle2);
                rectangle.x = rectangle2.x;
                if (n3 == 0) {
                    rectangle.x += rectangle2.width;
                }
                rectangle.y = rectangle2.y;
            }
        }
        cSSBox.calcMinMaxWidths();
        int n8 = cSSBox.css.left;
        int n9 = cSSBox.css.right;
        int n10 = cSSBox.css.margin_left;
        n3 = cSSBox.css.margin_right;
        int n11 = cSSBox.css.width;
        if ((cSSBox.css.percentage_flag & 0x100000) != 0) {
            n11 = n4 * n11 / 100;
        }
        int n12 = -123456;
        int n13 = cSSBox.css.border_left_width + cSSBox.css.border_right_width + cSSBox.css.padding_left + cSSBox.css.padding_right;
        n4 -= n13;
        if (n8 == n12 && n9 == n12) {
            n8 = rectangle.x;
        } else if ((cSSBox.css.percentage_flag & 0x10) != 0) {
            n8 = n8 * n / 100;
        }
        if (n11 == n12) {
            if (n8 == n12) {
                n8 = 0;
            }
            if (n9 == n12) {
                n9 = 0;
            }
        }
        if (n8 == n12 || n9 == n12 || n11 == n12) {
            if (n10 == n12) {
                n10 = 0;
            }
            if (n3 == n12) {
                n3 = 0;
            }
        }
        if (n10 == n12 && n3 == n12) {
            n10 = n3 = (n4 - n8 - n9 - n11) / 2;
        }
        if (n10 == n12) {
            n10 = n4 - n8 - n9 - n11 - n3;
        } else if (n3 == n12) {
            n3 = n4 - n8 - n9 - n11 - n10;
        } else if (n11 == n12) {
            n11 = n4 - n8 - n9 - n10 - n3;
            if (n11 > cSSBox.maxWidth) {
                if (cSSBox.css.right != n12) {
                    n8 += n11 - cSSBox.maxWidth;
                } else {
                    n9 += n11 - cSSBox.maxWidth;
                }
                n11 = cSSBox.maxWidth;
            } else if (n11 < cSSBox.minWidth) {
                n11 = cSSBox.minWidth;
            }
        } else if (n8 == n12) {
            n8 = n4 - n9 - n10 - n3;
        } else {
            n9 = n9 == n12 ? n4 - n8 - n11 - n10 - n3 : n4 - n8 - n11 - n10 - n3;
        }
        int n14 = cSSBox.css.top;
        int n15 = cSSBox.css.bottom;
        int n16 = cSSBox.css.margin_top;
        int n17 = cSSBox.css.margin_bottom;
        int n18 = cSSBox.css.height;
        if ((cSSBox.css.percentage_flag & 8) != 0) {
            n18 = n5 * n18 / 100;
        }
        n13 = cSSBox.css.border_top_width + cSSBox.css.border_bottom_width + cSSBox.css.padding_top + cSSBox.css.padding_bottom;
        n5 -= n13;
        if (n14 == n12) {
            n14 = rectangle.y;
        } else if ((cSSBox.css.percentage_flag & 0x80000) != 0) {
            n14 = n14 * n2 / 100;
        }
        if (n18 == n12 && n15 == n12) {
            n15 = 0;
        }
        if (n18 == n12 || n15 == n12) {
            if (n16 == n12) {
                n16 = 0;
            }
            if (n17 == n12) {
                n17 = 0;
            }
        }
        if (n16 == n12 && n17 == n12) {
            n16 = n17 = (n5 - n14 - n15 - n18) / 2;
        }
        if (n16 == n12) {
            n16 = n5 - n14 - n15 - n18 - n17;
        } else if (n17 == n12) {
            n17 = n5 - n14 - n15 - n18 - n16;
        } else if (n18 == n12) {
            n18 = -1;
        } else if (n14 == n12) {
            n14 = n5 - n18 - n15 - n16 - n17;
        } else if (n15 == n12) {
            n15 = n5 - n14 - n18 - n16 - n17;
        } else {
            n14 = n5 - n15 - n18 - n16 - n17;
        }
        cSSBox.ox = n8 + n10 + n6;
        cSSBox.oy = n14 + n16 + n7;
        if (cSSBox instanceof PositionedBox) {
            ((PositionedBox)cSSBox).layout(n11, n18);
        } else {
            FloatManager floatManager = new FloatManager(0, n11);
            cSSBox.layout(n11, n18, floatManager);
            cSSBox.height += floatManager.skipTill(n11);
        }
        if (n18 >= 0) {
            if (cSSBox.height > n18) {
                if (n14 == n12) {
                    cSSBox.oy -= cSSBox.height - n18;
                }
            } else {
                cSSBox.height = n18;
            }
        }
        if (cSSBox.ox + cSSBox.width > this.list.maxWidth) {
            this.list.maxWidth = cSSBox.ox + cSSBox.width;
        }
        if (cSSBox.oy + cSSBox.height > this.list.maxHeight) {
            this.list.maxHeight = cSSBox.oy + cSSBox.height;
        }
    }

    void dispose() {
        super.dispose();
    }

    CSSBox getBoxAt(int n, int n2, Point point) {
        CSSBox cSSBox = this.floatPainter.getBoxAt(n, n2, point);
        if (cSSBox == null) {
            cSSBox = super.getBoxAt(n, n2, point);
        }
        return cSSBox;
    }

    void layout(int n, int n2) {
        this.floatPainter.clear();
        FloatManager floatManager = new FloatManager(0, n);
        super.layout(n, n2, floatManager);
        this.height += floatManager.skipTill(n);
        CSSBox cSSBox = floatManager.getFirstFloater();
        if (cSSBox != null) {
            this.floatPainter.add(cSSBox);
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.floatPainter.paintNegativeZ_Indices(graphics);
        this.floatPainter.paintPositiveZ_Indices(graphics);
    }
}

