/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.dombase.Nbrs;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DFormElement;
import ice.pilots.html4.DHrefElement;
import ice.pilots.html4.DImageElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DOMUIEvent;
import ice.pilots.html4.DirectionFocusManager;
import ice.pilots.html4.FocusManager;
import ice.pilots.html4.ScrollHandler;
import ice.pilots.html4.SmoothScrollHandler;
import ice.pilots.html4.ThePilot;
import ice.storm.DocPane;
import ice.util.Defs;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

class DefaultActionHandler
implements EventListener,
Nbrs {
    static final int KEY_TAB = 9;
    static final int KEY_HELP = 112;
    static final int KEY_ACTION = 32;
    static final int KEY_SUBMIT = 10;
    static final int KEY_SUBMIT2 = 13;
    static final int KEY_UP = 38;
    static final int KEY_DOWN = 40;
    static final int KEY_LEFT = 37;
    static final int KEY_RIGHT = 39;
    static final int KEY_PGDOWN = 34;
    static final int KEY_PGUP = 33;
    static final int KEY_END = 35;
    static final int KEY_HOME = 36;
    ThePilot pilot;
    FocusManager focusManager;
    ScrollHandler scrollHandler;
    private boolean shouldScrollOnly = false;
    private boolean shouldFocusOnly = false;
    private long previousTabAction = -1L;

    DefaultActionHandler(ThePilot thePilot) {
        this.pilot = thePilot;
        CSSLayout cSSLayout = thePilot.getCSSLayout();
        String string = Defs.sysProperty("ice.browser.directionFocus");
        this.focusManager = string != null && string.equalsIgnoreCase("true") ? new DirectionFocusManager(thePilot.getDDocument(), cSSLayout, thePilot) : new FocusManager(thePilot.getDDocument(), cSSLayout, thePilot);
        cSSLayout.setFocusManager(this.focusManager);
        String string2 = Defs.sysProperty("ice.browser.scroll");
        this.scrollHandler = string2 != null && string2.equalsIgnoreCase("smooth") ? new SmoothScrollHandler(thePilot) : new ScrollHandler(thePilot);
    }

    private void copySelectedToClipboard() {
        String string = this.pilot.getSelectedText();
        if (string != null && string.length() > 0) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(string);
            clipboard.setContents(stringSelection, stringSelection);
        }
    }

    protected boolean isTabKey(long l) {
        return l == 9L;
    }

    protected boolean isActionKey(long l) {
        return l == 32L;
    }

    protected boolean isFormSubmitKey(long l) {
        return l == 10L || l == 13L;
    }

    protected boolean isDirectionKey(long l) {
        return l == 38L || l == 40L || l == 37L || l == 39L;
    }

    protected boolean scrollOnly() {
        return this.shouldScrollOnly;
    }

    protected boolean focusOnly() {
        return this.shouldFocusOnly;
    }

    private void changeZoom(int n) {
        CSSLayout cSSLayout = this.pilot.getCSSLayout();
        cSSLayout.setLayoutZoom(cSSLayout.getLayoutZoom() + n);
    }

    public void handleEvent(Event event) {
        DOMEvent dOMEvent = (DOMEvent)event;
        if (dOMEvent.isDefaultDone()) {
            return;
        }
        EventListener eventListener = dOMEvent.getAction();
        if (eventListener != null) {
            eventListener.handleEvent(dOMEvent);
            if (dOMEvent.isDefaultDone()) {
                return;
            }
        }
        if (dOMEvent instanceof DOMUIEvent) {
            this.shouldScrollOnly = ((DOMUIEvent)dOMEvent).getCtrlKey();
        }
        switch (dOMEvent.typeId) {
            case 6: {
                this.onMouseMove((DOMUIEvent)dOMEvent);
                break;
            }
            case 5: {
                this.onMouseOver((DOMUIEvent)dOMEvent);
                break;
            }
            case 7: {
                this.onMouseOut((DOMUIEvent)dOMEvent);
                break;
            }
            case 3: {
                this.onMouseDown((DOMUIEvent)dOMEvent);
                break;
            }
            case 4: {
                this.onMouseUp((DOMUIEvent)dOMEvent);
                break;
            }
            case 1: {
                this.onClick((DOMUIEvent)dOMEvent);
                break;
            }
            case 9: {
                this.onKeyDown((DOMUIEvent)dOMEvent);
                break;
            }
            case 10: {
                this.onKeyUp((DOMUIEvent)dOMEvent);
                break;
            }
            case 8: {
                this.onKeyPress((DOMUIEvent)dOMEvent);
                break;
            }
            case 21: {
                this.onFocus((DOMUIEvent)dOMEvent);
                break;
            }
            case 22: {
                this.onBlur((DOMUIEvent)dOMEvent);
            }
        }
    }

    private void onMouseMove(DOMUIEvent dOMUIEvent) {
        this.mouseAction(dOMUIEvent);
    }

    private void onMouseOver(DOMUIEvent dOMUIEvent) {
        this.mouseAction(dOMUIEvent);
    }

    private void onMouseOut(DOMUIEvent dOMUIEvent) {
        this.mouseAction(dOMUIEvent);
    }

    private void onMouseDown(DOMUIEvent dOMUIEvent) {
        DNode dNode = (DNode)dOMUIEvent.getTarget();
        DNode dNode2 = this.getButtonBox(dNode);
        if (dNode2 == null) {
            dNode2 = dNode;
        }
        while (dNode2 != null) {
            if (dNode2 instanceof DElement && ((DElement)dNode2).isFocusable()) break;
            dNode2 = DDocument.getEventChainParent(dNode2, dOMUIEvent);
        }
        this.focusManager.setFocusedBox(dNode2);
    }

    private DNode getButtonBox(DNode dNode) {
        while (dNode != null && dNode.getNameId() != 13) {
            if (dNode.getNameId() == 15) {
                return dNode;
            }
            dNode = (DNode)dNode.getParentNode();
        }
        return null;
    }

    private void onMouseUp(DOMUIEvent dOMUIEvent) {
    }

    private void onClick(DOMUIEvent dOMUIEvent) {
        this.mouseAction(dOMUIEvent);
    }

    private void onKeyDown(DOMUIEvent dOMUIEvent) {
        if (dOMUIEvent.isDefaultCancelled()) {
            return;
        }
        long l = dOMUIEvent.getKeyCode();
        if (this.isTabKey(l)) {
            if (this.previousTabAction == l + (dOMUIEvent.getShiftKey() ? 1L : 0L) && this.focusManager.getFocusedElement() == null) {
                this.previousTabAction = -1L;
                return;
            }
            this.previousTabAction = l + (dOMUIEvent.getShiftKey() ? 1L : 0L);
            int n = dOMUIEvent.getShiftKey() ? this.focusManager.previousFocus() : this.focusManager.nextFocus();
            this.focusManager.setFocusedBox(n);
            dOMUIEvent.preventDefault();
            return;
        }
        if (this.isActionKey(l)) {
            String string;
            DNode dNode = this.focusManager.getFocusedElement();
            if (dNode == null) {
                return;
            }
            int n = dNode.getNameId();
            if (n == 71) {
                return;
            }
            if (n == 82) {
                return;
            }
            if (n == 47 && ((string = ((DInputElement)dNode).getType()) == null || string.equalsIgnoreCase("text") || string.equalsIgnoreCase("password"))) {
                return;
            }
            this.doAction(dNode);
            dOMUIEvent.preventDefault();
            return;
        }
        if (this.isFormSubmitKey(l)) {
            DNode dNode = this.focusManager.getFocusedElement();
            if (dNode == null) {
                return;
            }
            if (dNode instanceof DInputElement) {
                DInputElement dInputElement = (DInputElement)dNode;
                String string = dInputElement.getType();
                if (string.equalsIgnoreCase("text") || string.equalsIgnoreCase("password")) {
                    DFormElement dFormElement = dInputElement.getDForm();
                    if (dFormElement != null && dFormElement.submitUsingSubmitkey()) {
                        dOMUIEvent.preventDefault();
                    }
                } else if (string.equalsIgnoreCase("button") || string.equalsIgnoreCase("submit") || string.equalsIgnoreCase("image") || string.equalsIgnoreCase("reset")) {
                    this.doAction(dNode);
                    dOMUIEvent.preventDefault();
                }
            } else if (dNode instanceof DHrefElement) {
                this.doAction(dNode);
                dOMUIEvent.preventDefault();
            }
            return;
        }
        if (this.isDirectionKey(l)) {
            if (this.doDirectionKey((int)l)) {
                dOMUIEvent.preventDefault();
            }
            return;
        }
        if (dOMUIEvent.getObjectPainter() != null) {
            return;
        }
        if (!this.scrollAction((int)l)) {
            switch ((int)l) {
                case 107: {
                    this.changeZoom(16);
                    dOMUIEvent.preventDefault();
                    break;
                }
                case 109: {
                    this.changeZoom(-16);
                    dOMUIEvent.preventDefault();
                    break;
                }
                case 45: 
                case 67: 
                case 88: 
                case 155: {
                    if (!dOMUIEvent.getCtrlKey()) break;
                    this.copySelectedToClipboard();
                    dOMUIEvent.preventDefault();
                }
            }
        } else {
            dOMUIEvent.preventDefault();
        }
    }

    protected boolean doDirectionKey(int n) {
        if (!this.scrollOnly() && this.focusManager.localDFM(n)) {
            return true;
        }
        if (!this.focusOnly() && this.scrollHandler.scrollRequest(n)) {
            return true;
        }
        return !this.scrollOnly() && this.focusManager.globalDFM(n);
    }

    private void onKeyUp(DOMUIEvent dOMUIEvent) {
    }

    private void onKeyPress(DOMUIEvent dOMUIEvent) {
        if (dOMUIEvent.isDefaultCancelled()) {
            return;
        }
        if (dOMUIEvent.getAltKey()) {
            long l = dOMUIEvent.getCharCode();
            if (!dOMUIEvent.getShiftKey() && l >= 65L && l <= 93L) {
                l -= 32L;
            }
            if (this.focusManager.processAccessKey(l)) {
                dOMUIEvent.preventDefault();
            }
        }
    }

    private void onFocus(DOMUIEvent dOMUIEvent) {
        DocPane docPane = this.pilot.getDocPane();
        Rectangle rectangle = new Rectangle();
        this.pilot.getView().findBoundingBox((DNode)dOMUIEvent.getTarget(), rectangle);
        Point point = new Point();
        this.pilot.getView().findPosition((DNode)dOMUIEvent.getTarget(), point);
        int n = docPane.getScrollX();
        int n2 = docPane.getScrollY();
        int n3 = docPane.getPaneWidth();
        int n4 = docPane.getPaneHeight();
        int n5 = n;
        int n6 = n2;
        if (point.x < n || point.x > n + n3) {
            n5 = point.x < n ? point.x : 5 + point.x - n3;
        }
        if (point.y < n2 || point.y > n2 + n4) {
            n6 = point.y < n2 ? point.y : rectangle.height + point.y - n4;
        }
        if (n5 != n || n6 != n2) {
            this.scrollHandler.scrollRequest(n5, n6);
        }
    }

    private void onBlur(DOMUIEvent dOMUIEvent) {
    }

    protected void doAction(DNode dNode) {
        DDocument dDocument = (DDocument)this.pilot.getDocument();
        if (dDocument == null) {
            return;
        }
        DOMEvent dOMEvent = dDocument.createDOMEvent(1);
        dOMEvent.target = dNode;
        dDocument.processEvent(dOMEvent);
    }

    private boolean scrollAction(int n) {
        if (n == 34 || n == 33 || n == 35 || n == 36) {
            return this.scrollHandler.scrollRequest(n);
        }
        return false;
    }

    private void mouseAction(DOMUIEvent dOMUIEvent) {
        DNode dNode = dOMUIEvent.target;
        block5: while (dNode != null) {
            switch (dNode.tagId) {
                case 1: {
                    this.handleDefaultActionOnLinks(dOMUIEvent, (DElement)dNode);
                    break block5;
                }
                case 6: {
                    this.handleDefaultActionOnLinks(dOMUIEvent, (DElement)dNode);
                    break block5;
                }
                case 15: 
                case 47: {
                    this.inputMouseAction(dOMUIEvent, (DInputElement)dNode);
                    break block5;
                }
                default: {
                    dNode = DDocument.getEventChainParent(dNode, dOMUIEvent);
                }
            }
        }
    }

    private void inputMouseAction(DOMUIEvent dOMUIEvent, DInputElement dInputElement) {
        if (dOMUIEvent.typeId == 1) {
            dInputElement.mouseClick(dOMUIEvent.posX, dOMUIEvent.posY);
        }
    }

    private void handleDefaultActionOnLinks(DOMUIEvent dOMUIEvent, DElement dElement) {
        String string = dElement.getAttribute(46);
        if (string != null) {
            boolean bl = string.equals("#");
            boolean bl2 = false;
            if (dElement.tagId == 1 && dOMUIEvent.target instanceof DImageElement && !bl && ((DImageElement)dOMUIEvent.target).getIsMap()) {
                string = string + "?" + dOMUIEvent.posX + "," + dOMUIEvent.posY;
                bl2 = true;
            }
            DDocument dDocument = this.pilot.getDDocument();
            string = dDocument.resolveUrl(string);
            switch (dOMUIEvent.typeId) {
                case 6: {
                    if (!bl2) break;
                    this.pilot.firePropertyChange("statusLine", null, string);
                    break;
                }
                case 5: {
                    this.pilot.firePropertyChange("statusLine", null, string);
                    break;
                }
                case 7: {
                    this.pilot.firePropertyChange("statusLine", null, "");
                    break;
                }
                case 1: {
                    String string2;
                    short s;
                    if (bl || (s = dOMUIEvent.getButton()) != 0 && s != 1) break;
                    if (s == 1) {
                        string2 = "_blank";
                    } else {
                        string2 = dElement.getAttribute(108);
                        if (string2 == null || string2.length() == 0) {
                            string2 = dDocument.getBaseTarget();
                        }
                    }
                    this.pilot.renderContent(string, null, string2);
                }
            }
        }
    }
}

