/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSDecl;
import ice.pilots.html4.CSSRect;
import ice.util.alg.CharKit;
import ice.util.alg.HashArray;
import java.awt.Color;
import java.awt.Graphics;
import java.util.StringTokenizer;

class CSSUtil {
    private static final Color[] defaultColors = new Color[]{new Color(0xF0F8FF), new Color(16444375), new Color(65535), new Color(8388564), new Color(0xF0FFFF), new Color(16119260), new Color(16770244), Color.black, new Color(16772045), new Color(255), new Color(9055202), new Color(0xA52A2A), new Color(14596231), new Color(6266528), new Color(0x7FFF00), new Color(13789470), new Color(16744272), new Color(6591981), new Color(16775388), new Color(14423100), new Color(65535), new Color(139), new Color(35723), new Color(12092939), new Color(0xA9A9A9), new Color(25600), new Color(0xA9A9A9), new Color(12433259), new Color(0x8B008B), new Color(5597999), new Color(16747520), new Color(10040012), new Color(0x8B0000), new Color(15308410), new Color(9419919), new Color(4734347), new Color(0x2F4F4F), new Color(0x2F4F4F), new Color(52945), new Color(9699539), new Color(16716947), new Color(49151), new Color(0x696969), new Color(0x696969), new Color(2003199), new Color(0xB22222), new Color(0xFFFAF0), new Color(0x228B22), new Color(0xFF00FF), new Color(0xDCDCDC), new Color(0xF8F8FF), new Color(16766720), new Color(14329120), new Color(0x808080), new Color(0x808080), new Color(32768), new Color(11403055), new Color(0xF0FFF0), new Color(16738740), new Color(0xCD5C5C), new Color(4915330), new Color(0xFFFFF0), new Color(15787660), new Color(15132410), new Color(0xFFF0F5), new Color(8190976), new Color(16775885), new Color(11393254), new Color(0xF08080), new Color(0xE0FFFF), new Color(16448210), new Color(0xD3D3D3), new Color(0x90EE90), new Color(0xD3D3D3), new Color(16758465), new Color(16752762), new Color(2142890), new Color(8900346), new Color(0x778899), new Color(0x778899), new Color(11584734), new Color(0xFFFFE0), new Color(65280), new Color(3329330), new Color(16445670), new Color(0xFF00FF), new Color(0x800000), new Color(6737322), new Color(205), new Color(12211667), new Color(9662683), new Color(3978097), new Color(8087790), new Color(64154), new Color(4772300), new Color(13047173), new Color(1644912), new Color(0xF5FFFA), new Color(16770273), new Color(16770229), new Color(16768685), new Color(128), new Color(16643558), new Color(0x808000), new Color(7048739), new Color(16753920), new Color(16729344), new Color(14315734), new Color(0xEEE8AA), new Color(10025880), new Color(0xAFEEEE), new Color(14381203), new Color(16773077), new Color(16767673), new Color(13468991), new Color(16761035), new Color(0xDDA0DD), new Color(11591910), new Color(0x800080), new Color(0xFF0000), new Color(12357519), new Color(4286945), new Color(9127187), new Color(16416882), new Color(16032864), new Color(3050327), new Color(0xFFF5EE), new Color(10506797), new Color(0xC0C0C0), new Color(8900331), new Color(6970061), new Color(7372944), new Color(7372944), new Color(0xFFFAFA), new Color(65407), new Color(4620980), new Color(13808780), new Color(32896), new Color(14204888), new Color(16737095), new Color(4251856), new Color(0xEE82EE), new Color(16113331), Color.white, new Color(0xF5F5F5), new Color(0xFFFF00), new Color(10145074)};
    private static final HashArray colors = new HashArray();

    CSSUtil() {
    }

    static int parseInt(String string, int n) {
        long l;
        char c;
        int n2 = 0;
        int n3 = string.length();
        while (n2 != n3) {
            if (' ' < string.charAt(n2)) break;
            ++n2;
        }
        while (n2 != n3) {
            if (' ' < string.charAt(n3 - 1)) break;
            --n3;
        }
        if (n2 != n3 && ((c = string.charAt(n3 - 1)) == '\"' || c == '.')) {
            --n3;
        }
        if ((l = CharKit.parseInt(string, n2, n3)) >= 0L) {
            return (int)l;
        }
        return n;
    }

    static int parseInt(String string) throws NumberFormatException {
        if (string.endsWith(" ")) {
            string = string.trim();
        }
        if (string.endsWith("\"") || string.endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        return Integer.parseInt(string);
    }

    static int parseIntAsFloat(String string) throws NumberFormatException {
        if ((string = string.trim()).endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        return Double.valueOf(string).intValue();
    }

    static int findNonSpace(char[] cArray, int n, int n2) {
        char c = '\u0000';
        while (n < n2) {
            c = cArray[n];
            if (c != ' ' && c != '\t' && c != '\r' && c != '\n' && c != '\f') {
                return n;
            }
            ++n;
        }
        return -1;
    }

    static int findWhitespace(char[] cArray, int n, int n2) {
        char c = '\u0000';
        while (n < n2) {
            c = cArray[n];
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\f') {
                return n;
            }
            ++n;
        }
        return -1;
    }

    static long findNextValue1(char[] cArray, int n, int n2) {
        char c = '\u0000';
        block0: while (n < n2) {
            c = cArray[n];
            if (c == '/' && n + 1 < n2 && cArray[n + 1] == '*') {
                n += 2;
                while (n < n2) {
                    c = cArray[n];
                    if (c == '*' && n + 1 < n2 && cArray[n + 1] == '/') {
                        n += 2;
                        continue block0;
                    }
                    ++n;
                }
                continue;
            }
            if (c != ' ' && c != '\t' && c != '\r' && c != '\n' && c != '\f') break;
            ++n;
        }
        if (n >= n2) {
            return 0L;
        }
        int n3 = n;
        boolean bl = false;
        int n4 = 0;
        while (n3 < n2) {
            c = cArray[n3];
            if (c == ')') {
                --n4;
            } else if (c == '(') {
                ++n4;
            } else if (c == ',') {
                bl = true;
            } else {
                if (n4 == 0 && !bl && (c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\f')) break;
                bl = false;
            }
            ++n3;
        }
        return (long)n3 << 32 | (long)n;
    }

    static void parseRect(CSSDecl cSSDecl, String string) {
        if ((string = CharKit.toLowerCase(string.trim())).startsWith("rect(")) {
            string = string.substring(5, string.length() - 1);
        }
        if ((string = string.replace(',', ' ')).equals("auto")) {
            cSSDecl.type = 15;
            return;
        }
        CSSRect cSSRect = new CSSRect();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r\t ");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            CSSDecl cSSDecl2 = new CSSDecl(0, 0, null);
            if (string2.equals("auto")) {
                cSSDecl2.type = 15;
            } else {
                char[] cArray = string2.toCharArray();
                CSSUtil.parseLength(cSSDecl2, cArray, 0, cArray.length);
            }
            if (cSSDecl2.type == 0) continue;
            if (n == 0) {
                cSSRect.declTop = cSSDecl2;
            } else if (n == 1) {
                cSSRect.declRight = cSSDecl2;
            } else if (n == 2) {
                cSSRect.declBottom = cSSDecl2;
            } else if (n == 3) {
                cSSRect.declLeft = cSSDecl2;
            }
            ++n;
        }
        if (cSSRect.declTop != null && cSSRect.declRight != null && cSSRect.declBottom != null && cSSRect.declLeft != null) {
            cSSDecl.type = -16;
            cSSDecl.value = cSSRect;
        }
    }

    static void cssClipRectToPixels(CSSRect cSSRect, CSSAttribs cSSAttribs, int n) {
        cSSAttribs.clip = new CSSRect();
        cSSAttribs.clip.top = cSSRect.declTop != null && cSSRect.declTop.type != 15 ? CSSUtil.cssLengthToPixels(cSSRect.declTop, cSSAttribs, n) : 0;
        cSSAttribs.clip.right = cSSRect.declRight != null && cSSRect.declRight.type != 15 ? CSSUtil.cssLengthToPixels(cSSRect.declRight, cSSAttribs, n) : 100000;
        cSSAttribs.clip.bottom = cSSRect.declBottom != null && cSSRect.declBottom.type != 15 ? CSSUtil.cssLengthToPixels(cSSRect.declBottom, cSSAttribs, n) : 100000;
        cSSAttribs.clip.left = cSSRect.declLeft != null && cSSRect.declLeft.type != 15 ? CSSUtil.cssLengthToPixels(cSSRect.declLeft, cSSAttribs, n) : 0;
    }

    static String parseUrl(char[] cArray, int n, int n2) {
        String string = null;
        char c = cArray[n];
        if (c == 'u' || c == 'U') {
            --n2;
            c = cArray[n += 4];
        }
        while (cArray[n] == ' ') {
            ++n;
        }
        while (n2 - 1 > n && cArray[n2 - 1] == ' ') {
            --n2;
        }
        string = c == '\'' || c == '\"' ? new String(cArray, n + 1, n2 - n - 2) : new String(cArray, n, n2 - n);
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int getDefaultColorIndex(String string) {
        int n = 0;
        String string2 = null;
        block0 : switch (string.length()) {
            case 3: {
                char c = string.charAt(0);
                if (c == 'r') {
                    if (string.charAt(2) != 'd' || string.charAt(1) != 'e') break;
                    return 119;
                }
                if (c != 't' || string.charAt(2) != 'n' || string.charAt(1) != 'a') break;
                return 136;
            }
            case 4: {
                switch (string.charAt(3)) {
                    case 'a': {
                        string2 = "aqua";
                        n = 3;
                        break;
                    }
                    case 'd': {
                        string2 = "gold";
                        n = 52;
                        break;
                    }
                    case 'e': {
                        char c = string.charAt(0);
                        if (c == 'b') {
                            if (string.charAt(2) != 'u' || string.charAt(1) != 'l') break;
                            return 9;
                        }
                        if (c != 'l' || string.charAt(2) != 'm' || string.charAt(1) != 'i') break;
                        return 82;
                    }
                    case 'k': {
                        string2 = "pink";
                        n = 116;
                        break;
                    }
                    case 'l': {
                        string2 = "teal";
                        n = 138;
                        break;
                    }
                    case 'm': {
                        string2 = "plum";
                        n = 117;
                        break;
                    }
                    case 'n': {
                        string2 = "cyan";
                        n = 21;
                        break;
                    }
                    case 'u': {
                        string2 = "peru";
                        n = 115;
                        break;
                    }
                    case 'w': {
                        string2 = "snow";
                        n = 134;
                        break;
                    }
                    case 'y': {
                        char c = string.charAt(2);
                        if (c == 'a') {
                            if (string.charAt(0) != 'g' || string.charAt(1) != 'r') break;
                            return 53;
                        }
                        if (c == 'e') {
                            if (string.charAt(0) != 'g' || string.charAt(1) != 'r') break;
                            return 54;
                        }
                        if (c != 'v' || string.charAt(0) != 'n' || string.charAt(1) != 'a') break;
                        return 101;
                    }
                }
                break;
            }
            case 5: {
                switch (string.charAt(0)) {
                    case 'a': {
                        string2 = "azure";
                        n = 5;
                        break;
                    }
                    case 'b': {
                        char c = string.charAt(4);
                        if (c == 'e') {
                            string2 = "beige";
                            n = 6;
                            break;
                        }
                        if (c == 'k') {
                            string2 = "black";
                            n = 8;
                            break;
                        }
                        if (c != 'n') break;
                        string2 = "brown";
                        n = 12;
                        break;
                    }
                    case 'c': {
                        string2 = "coral";
                        n = 17;
                        break;
                    }
                    case 'g': {
                        string2 = "green";
                        n = 56;
                        break;
                    }
                    case 'i': {
                        string2 = "ivory";
                        n = 62;
                        break;
                    }
                    case 'k': {
                        string2 = "khaki";
                        n = 63;
                        break;
                    }
                    case 'l': {
                        string2 = "linen";
                        n = 85;
                        break;
                    }
                    case 'o': {
                        string2 = "olive";
                        n = 104;
                        break;
                    }
                    case 'w': {
                        char c = string.charAt(4);
                        if (c == 'e') {
                            string2 = "white";
                            n = 144;
                            break;
                        }
                        if (c != 't') break;
                        string2 = "wheat";
                        n = 143;
                        break;
                    }
                }
                break;
            }
            case 6: {
                switch (string.charAt(3)) {
                    case 'a': {
                        string2 = "tomato";
                        n = 140;
                        break;
                    }
                    case 'h': {
                        string2 = "orchid";
                        n = 108;
                        break;
                    }
                    case 'i': {
                        string2 = "indigo";
                        n = 61;
                        break;
                    }
                    case 'l': {
                        char c = string.charAt(0);
                        if (c == 'v') {
                            string2 = "violet";
                            n = 142;
                            break;
                        }
                        if (c != 'y') break;
                        string2 = "yellow";
                        n = 146;
                        break;
                    }
                    case 'm': {
                        string2 = "salmon";
                        n = 124;
                        break;
                    }
                    case 'n': {
                        char c = string.charAt(0);
                        if (c == 'o') {
                            string2 = "orange";
                            n = 106;
                            break;
                        }
                        if (c != 's') break;
                        string2 = "sienna";
                        n = 128;
                        break;
                    }
                    case 'o': {
                        string2 = "maroon";
                        n = 87;
                        break;
                    }
                    case 'p': {
                        string2 = "purple";
                        n = 119;
                        break;
                    }
                    case 'q': {
                        string2 = "bisque";
                        n = 7;
                        break;
                    }
                    case 'v': {
                        string2 = "silver";
                        n = 129;
                        break;
                    }
                }
                break;
            }
            case 7: {
                switch (string.charAt(3)) {
                    case 'b': {
                        string2 = "skyblue";
                        n = 130;
                        break;
                    }
                    case 'e': {
                        string2 = "magenta";
                        n = 86;
                        break;
                    }
                    case 'g': {
                        char c = string.charAt(5);
                        if (c == 'a') {
                            string2 = "dimgray";
                            n = 43;
                            break;
                        }
                        if (c != 'e') break;
                        string2 = "dimgrey";
                        n = 44;
                        break;
                    }
                    case 'h': {
                        string2 = "fuchsia";
                        n = 49;
                        break;
                    }
                    case 'k': {
                        string2 = "darkred";
                        n = 33;
                        break;
                    }
                    case 'l': {
                        string2 = "oldlace";
                        n = 103;
                        break;
                    }
                    case 'm': {
                        string2 = "crimson";
                        n = 20;
                        break;
                    }
                    case 'p': {
                        string2 = "hotpink";
                        n = 59;
                        break;
                    }
                    case 's': {
                        string2 = "thistle";
                        n = 139;
                        break;
                    }
                }
                break;
            }
            case 8: {
                switch (string.charAt(4)) {
                    case 'a': {
                        string2 = "moccasin";
                        n = 100;
                        break;
                    }
                    case 'b': {
                        string2 = "darkblue";
                        n = 22;
                        break;
                    }
                    case 'c': {
                        string2 = "darkcyan";
                        n = 23;
                        break;
                    }
                    case 'g': {
                        char c = string.charAt(6);
                        if (c == 'a') {
                            string2 = "darkgray";
                            n = 25;
                            break;
                        }
                        if (c != 'e') break;
                        string2 = "darkgrey";
                        n = 27;
                        break;
                    }
                    case 'h': {
                        string2 = "seashell";
                        n = 127;
                        break;
                    }
                    case 'n': {
                        string2 = "lavender";
                        n = 64;
                        break;
                    }
                    case 'p': {
                        string2 = "deeppink";
                        n = 41;
                        break;
                    }
                    case 'r': {
                        string2 = "seagreen";
                        n = 126;
                        break;
                    }
                    case 's': {
                        string2 = "cornsilk";
                        n = 19;
                        break;
                    }
                    case 'y': {
                        string2 = "honeydew";
                        n = 58;
                        break;
                    }
                }
                break;
            }
            case 9: {
                switch (string.charAt(0)) {
                    case 'a': {
                        string2 = "aliceblue";
                        n = 1;
                        break;
                    }
                    case 'b': {
                        string2 = "burlywood";
                        n = 13;
                        break;
                    }
                    case 'c': {
                        char c = string.charAt(1);
                        if (c == 'a') {
                            string2 = "cadetblue";
                            n = 14;
                            break;
                        }
                        if (c != 'h') break;
                        string2 = "chocolate";
                        n = 16;
                        break;
                    }
                    case 'd': {
                        char c = string.charAt(8);
                        if (c == 'i') {
                            string2 = "darkkhaki";
                            n = 28;
                            break;
                        }
                        if (c != 'n') break;
                        string2 = "darkgreen";
                        n = 26;
                        break;
                    }
                    case 'f': {
                        string2 = "firebrick";
                        n = 46;
                        break;
                    }
                    case 'g': {
                        char c = string.charAt(8);
                        if (c == 'd') {
                            string2 = "goldenrod";
                            n = 53;
                            break;
                        }
                        if (c != 'o') break;
                        string2 = "gainsboro";
                        n = 50;
                        break;
                    }
                    case 'i': {
                        string2 = "indianred";
                        n = 60;
                        break;
                    }
                    case 'l': {
                        switch (string.charAt(5)) {
                            case 'b': {
                                string2 = "lightblue";
                                n = 68;
                                break;
                            }
                            case 'c': {
                                string2 = "lightcyan";
                                n = 70;
                                break;
                            }
                            case 'g': {
                                char c = string.charAt(7);
                                if (c == 'a') {
                                    string2 = "lightgray";
                                    n = 72;
                                    break;
                                }
                                if (c != 'e') break;
                                string2 = "lightgrey";
                                n = 74;
                                break;
                            }
                            case 'p': {
                                string2 = "lightpink";
                                n = 75;
                                break;
                            }
                            case 'r': {
                                char c = string.charAt(1);
                                if (c == 'a') {
                                    string2 = "lawngreen";
                                    n = 66;
                                    break;
                                }
                                if (c != 'i') break;
                                string2 = "limegreen";
                                n = 84;
                                break;
                            }
                        }
                        break;
                    }
                    case 'm': {
                        char c = string.charAt(8);
                        if (c == 'e') {
                            string2 = "mistyrose";
                            n = 99;
                            break;
                        }
                        if (c != 'm') break;
                        string2 = "mintcream";
                        n = 98;
                        break;
                    }
                    case 'o': {
                        char c = string.charAt(8);
                        if (c == 'b') {
                            string2 = "olivedrab";
                            n = 105;
                            break;
                        }
                        if (c != 'd') break;
                        string2 = "orangered";
                        n = 107;
                        break;
                    }
                    case 'p': {
                        char c = string.charAt(8);
                        if (c == 'f') {
                            string2 = "peachpuff";
                            n = 114;
                            break;
                        }
                        if (c != 'n') break;
                        string2 = "palegreen";
                        n = 110;
                        break;
                    }
                    case 'r': {
                        char c = string.charAt(8);
                        if (c == 'e') {
                            string2 = "royalblue";
                            n = 122;
                            break;
                        }
                        if (c != 'n') break;
                        string2 = "rosybrown";
                        n = 121;
                        break;
                    }
                    case 's': {
                        char c = string.charAt(7);
                        if (c == 'a') {
                            string2 = "slategray";
                            n = 132;
                            break;
                        }
                        if (c == 'e') {
                            string2 = "slategrey";
                            n = 133;
                            break;
                        }
                        if (c != 'u') break;
                        c = string.charAt(1);
                        if (c == 'l') {
                            string2 = "slateblue";
                            n = 131;
                            break;
                        }
                        if (c != 't') break;
                        string2 = "steelblue";
                        n = 136;
                        break;
                    }
                    case 't': {
                        string2 = "turquoise";
                        n = 141;
                        break;
                    }
                }
                break;
            }
            case 10: {
                switch (string.charAt(8)) {
                    case 'a': {
                        string2 = "lightcoral";
                        n = 69;
                        break;
                    }
                    case 'e': {
                        char c = string.charAt(0);
                        if (c == 'b') {
                            string2 = "blueviolet";
                            n = 11;
                            break;
                        }
                        if (c == 'd') {
                            string2 = "darkviolet";
                            n = 40;
                            break;
                        }
                        if (c != 'l') break;
                        string2 = "lightgreen";
                        n = 73;
                        break;
                    }
                    case 'g': {
                        string2 = "darkorange";
                        n = 31;
                        break;
                    }
                    case 'i': {
                        char c = string.charAt(0);
                        if (c == 'd') {
                            string2 = "darkorchid";
                            n = 32;
                            break;
                        }
                        if (c != 'p') break;
                        string2 = "papayawhip";
                        n = 113;
                        break;
                    }
                    case 'k': {
                        string2 = "whitesmoke";
                        n = 145;
                        break;
                    }
                    case 'n': {
                        string2 = "aquamarine";
                        n = 4;
                        break;
                    }
                    case 'o': {
                        string2 = "darksalmon";
                        n = 34;
                        break;
                    }
                    case 's': {
                        string2 = "chartreuse";
                        n = 15;
                        break;
                    }
                    case 't': {
                        string2 = "ghostwhite";
                        n = 51;
                        break;
                    }
                    case 'u': {
                        char c = string.charAt(0);
                        if (c == 'd') {
                            string2 = "dodgerblue";
                            n = 45;
                            break;
                        }
                        if (c == 'm') {
                            string2 = "mediumblue";
                            n = 89;
                            break;
                        }
                        if (c != 'p') break;
                        string2 = "powderblue";
                        n = 118;
                        break;
                    }
                    case 'w': {
                        string2 = "sandybrown";
                        n = 125;
                        break;
                    }
                }
                break;
            }
            case 11: {
                switch (string.charAt(5)) {
                    case 'a': {
                        string2 = "darkmagenta";
                        n = 29;
                        break;
                    }
                    case 'e': {
                        string2 = "saddlebrown";
                        n = 123;
                        break;
                    }
                    case 'g': {
                        string2 = "springgreen";
                        n = 135;
                        break;
                    }
                    case 'k': {
                        string2 = "deepskyblue";
                        n = 42;
                        break;
                    }
                    case 'l': {
                        string2 = "floralwhite";
                        n = 47;
                        break;
                    }
                    case 'o': {
                        string2 = "navajowhite";
                        n = 101;
                        break;
                    }
                    case 's': {
                        string2 = "lightsalmon";
                        n = 76;
                        break;
                    }
                    case 't': {
                        string2 = "forestgreen";
                        n = 48;
                        break;
                    }
                    case 'w': {
                        string2 = "yellowgreen";
                        n = 147;
                        break;
                    }
                    case 'y': {
                        char c = string.charAt(0);
                        if (c == 'g') {
                            string2 = "greenyellow";
                            n = 57;
                            break;
                        }
                        if (c != 'l') break;
                        string2 = "lightyellow";
                        n = 82;
                        break;
                    }
                }
                break;
            }
            case 12: {
                switch (string.charAt(7)) {
                    case 'g': {
                        string2 = "darkseagreen";
                        n = 35;
                        break block0;
                    }
                    case 'i': {
                        string2 = "lemonchiffon";
                        n = 67;
                        break block0;
                    }
                    case 'r': {
                        string2 = "mediumorchid";
                        n = 90;
                        break block0;
                    }
                    case 't': {
                        string2 = "midnightblue";
                        n = 97;
                        break block0;
                    }
                    case 'u': {
                        string2 = "mediumpurple";
                        n = 91;
                        break block0;
                    }
                    case 'w': {
                        string2 = "antiquewhite";
                        n = 2;
                        break block0;
                    }
                    case 'y': {
                        string2 = "lightskyblue";
                        n = 78;
                        break block0;
                    }
                }
                break;
            }
            case 13: {
                switch (string.charAt(9)) {
                    case 'b': {
                        string2 = "darkslateblue";
                        n = 36;
                        break;
                    }
                    case 'g': {
                        char c = string.charAt(11);
                        if (c == 'a') {
                            string2 = "darkslategray";
                            n = 37;
                            break;
                        }
                        if (c != 'e') break;
                        string2 = "darkslategrey";
                        n = 38;
                        break;
                    }
                    case 'l': {
                        string2 = "lavenderblush";
                        n = 65;
                        break;
                    }
                    case 'n': {
                        char c = string.charAt(0);
                        if (c == 'd') {
                            string2 = "darkgoldenrod";
                            n = 24;
                            break;
                        }
                        if (c != 'p') break;
                        string2 = "palegoldenrod";
                        n = 109;
                        break;
                    }
                    case 'o': {
                        char c = string.charAt(0);
                        if (c == 'd') {
                            string2 = "darkturquoise";
                            n = 39;
                            break;
                        }
                        if (c != 'p') break;
                        string2 = "paleturquoise";
                        n = 111;
                        break;
                    }
                    case 'r': {
                        string2 = "lightseagreen";
                        n = 77;
                        break;
                    }
                    case 't': {
                        string2 = "palevioletred";
                        n = 112;
                        break;
                    }
                }
                break;
            }
            case 14: {
                switch (string.charAt(6)) {
                    case 'e': {
                        string2 = "blanchedalmond";
                        n = 9;
                        break;
                    }
                    case 'i': {
                        string2 = "darkolivegreen";
                        n = 30;
                        break;
                    }
                    case 'l': {
                        char c = string.charAt(12);
                        if (c == 'a') {
                            string2 = "lightslategray";
                            n = 79;
                            break;
                        }
                        if (c != 'e') break;
                        string2 = "lightslategrey";
                        n = 80;
                        break;
                    }
                    case 'o': {
                        string2 = "cornflowerblue";
                        n = 18;
                        break;
                    }
                    case 's': {
                        string2 = "mediumseagreen";
                        n = 92;
                        break;
                    }
                    case 't': {
                        string2 = "lightsteelblue";
                        n = 81;
                        break;
                    }
                }
                break;
            }
            case 15: {
                char c = string.charAt(6);
                if (c == 's') {
                    string2 = "mediumslateblue";
                    n = 93;
                    break;
                }
                if (c == 't') {
                    string2 = "mediumturquoise";
                    n = 95;
                    break;
                }
                if (c != 'v') break;
                string2 = "mediumvioletred";
                n = 96;
                break;
            }
            case 16: {
                string2 = "mediumaquamarine";
                n = 88;
                break;
            }
            case 17: {
                string2 = "mediumspringgreen";
                n = 94;
                break;
            }
            case 20: {
                string2 = "lightgoldenrodyellow";
                n = 71;
            }
        }
        if (string2 == null) return n - 1;
        if (string2 == string) return n - 1;
        if (string2.equals(string)) return n - 1;
        return -1;
    }

    static void addColorDefinition(String string, Color color) {
        int n = CSSUtil.getDefaultColorIndex(string = CharKit.toLowerCase(string));
        if (n >= 0) {
            CSSUtil.defaultColors[n] = color;
        } else {
            colors.put(string, (Object)color);
        }
    }

    private static Color convertNamedColor(String string) {
        int n = CSSUtil.getDefaultColorIndex(string);
        return n >= 0 ? defaultColors[n] : (Color)colors.get(string);
    }

    static String convertColorNameToRGB(String string) {
        Color color = CSSUtil.convertNamedColor(CharKit.toLowerCase(string));
        if (color != null) {
            int n = color.getRGB();
            char[] cArray = new char[7];
            cArray[0] = 35;
            int n2 = 1;
            int n3 = 20;
            while (n3 >= 0) {
                int n4 = 0xF & n >> n3;
                cArray[n2] = n4 < 10 ? (char)(n4 + 48) : (char)(n4 + 65 - 10);
                ++n2;
                n3 -= 4;
            }
            string = new String(cArray, 0, 7);
        }
        return string;
    }

    static Color parseColor(char[] cArray, int n, int n2) {
        if (n2 < 2) {
            return null;
        }
        int n3 = n + n2;
        try {
            char c = cArray[n];
            char c2 = cArray[n + 1];
            if (c == '#') {
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                if (n3 - n < 4) {
                    return null;
                }
                if (n3 - n >= 7) {
                    n4 = (CSSUtil.hexToInt(cArray[n + 1]) << 4) + CSSUtil.hexToInt(cArray[n + 2]);
                    n5 = (CSSUtil.hexToInt(cArray[n + 3]) << 4) + CSSUtil.hexToInt(cArray[n + 4]);
                    n6 = (CSSUtil.hexToInt(cArray[n + 5]) << 4) + CSSUtil.hexToInt(cArray[n + 6]);
                } else if (n3 - n == 6) {
                    n4 = (CSSUtil.hexToInt(cArray[n + 1]) << 4) + CSSUtil.hexToInt(cArray[n + 2]);
                    n5 = (CSSUtil.hexToInt(cArray[n + 3]) << 4) + CSSUtil.hexToInt(cArray[n + 4]);
                    n6 = (CSSUtil.hexToInt(cArray[n + 5]) << 4) + 0;
                } else if (n3 - n < 6) {
                    n4 = CSSUtil.hexToInt(cArray[n + 1]);
                    n5 = CSSUtil.hexToInt(cArray[n + 2]);
                    n6 = CSSUtil.hexToInt(cArray[n + 3]);
                    n4 = (n4 << 4) + n4;
                    n5 = (n5 << 4) + n5;
                    n6 = (n6 << 4) + n6;
                }
                return new Color(n4, n5, n6);
            }
            if (!(c != 'r' && c != 'R' || c2 != 'g' && c2 != 'G')) {
                --n3;
                int n7 = 0;
                boolean bl = false;
                boolean bl2 = false;
                int n8 = n += 4;
                while (n8 < n3) {
                    c = cArray[n8];
                    if (c == ',') {
                        ++n8;
                        break;
                    }
                    if (c == '.') {
                        bl2 = true;
                    } else if (c == '%') {
                        bl = true;
                    } else if (c >= '0' && c <= '9' && !bl2) {
                        n7 = n7 * 10 + (c - 48);
                    }
                    ++n8;
                }
                if (bl) {
                    n7 = 255 * n7 / 100;
                }
                if (n7 < 0) {
                    n7 = 0;
                } else if (n7 > 255) {
                    n7 = 255;
                }
                int n9 = 0;
                bl = false;
                bl2 = false;
                while (n8 < n3) {
                    c = cArray[n8];
                    if (c == ',') {
                        ++n8;
                        break;
                    }
                    if (c == '.') {
                        bl2 = true;
                    } else if (c == '%') {
                        bl = true;
                    } else if (c >= '0' && c <= '9' && !bl2) {
                        n9 = n9 * 10 + (c - 48);
                    }
                    ++n8;
                }
                if (bl) {
                    n9 = 255 * n9 / 100;
                }
                if (n9 < 0) {
                    n9 = 0;
                } else if (n9 > 255) {
                    n9 = 255;
                }
                int n10 = 0;
                bl = false;
                bl2 = false;
                while (n8 < n3) {
                    c = cArray[n8];
                    if (c == ',') {
                        ++n8;
                        break;
                    }
                    if (c == '.') {
                        bl2 = true;
                    } else if (c == '%') {
                        bl = true;
                    } else if (c >= '0' && c <= '9' && !bl2) {
                        n10 = n10 * 10 + (c - 48);
                    }
                    ++n8;
                }
                if (bl) {
                    n10 = 255 * n10 / 100;
                }
                if (n10 < 0) {
                    n10 = 0;
                } else if (n10 > 255) {
                    n10 = 255;
                }
                return new Color(n7, n9, n10);
            }
            CharKit.asciiToLowerCase(cArray, n, n + n2);
            String string = new String(cArray, n, n2);
            Color color = CSSUtil.convertNamedColor(string);
            if (color != null) {
                return color;
            }
            if (n2 == 6 && (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F')) {
                int n11 = 0;
                int n12 = 0;
                int n13 = 0;
                n11 = (CSSUtil.hexToInt(cArray[n + 0]) << 4) + CSSUtil.hexToInt(cArray[n + 1]);
                n12 = (CSSUtil.hexToInt(cArray[n + 2]) << 4) + CSSUtil.hexToInt(cArray[n + 3]);
                n13 = (CSSUtil.hexToInt(cArray[n + 4]) << 4) + CSSUtil.hexToInt(cArray[n + 5]);
                return new Color(n11, n12, n13);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static void parseLength(CSSDecl cSSDecl, char[] cArray, int n, int n2) {
        if (n2 == 1) {
            int n3 = cArray[n];
            n3 = n3 >= 48 || n3 <= 57 ? (n3 -= 48) : 0;
            cSSDecl.type = -7;
            cSSDecl.value = new Float(n3);
            return;
        }
        char c = cArray[n + n2 - 1];
        if (c == '%') {
            try {
                cSSDecl.value = new Float(new String(cArray, n, n2 - 1));
                cSSDecl.type = -4;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        char c2 = cArray[n + n2 - 2];
        cSSDecl.type = !(c2 != 'e' && c2 != 'E' || c != 'm' && c != 'M') ? -5 : (!(c2 != 'e' && c2 != 'E' || c != 'x' && c != 'X') ? -6 : (!(c2 != 'p' && c2 != 'P' || c != 'x' && c != 'X') ? -7 : (!(c2 != 'i' && c2 != 'I' || c != 'n' && c != 'N') ? -8 : (!(c2 != 'c' && c2 != 'C' || c != 'm' && c != 'M') ? -9 : (!(c2 != 'm' && c2 != 'M' || c != 'm' && c != 'M') ? -10 : (!(c2 != 'p' && c2 != 'P' || c != 't' && c != 'T') ? -11 : (!(c2 != 'p' && c2 != 'P' || c != 'c' && c != 'C') ? -12 : -7)))))));
        try {
            cSSDecl.value = Character.isDigit(c) ? new Float(new String(cArray, n, n2)) : new Float(new String(cArray, n, n2 - 2));
        }
        catch (Exception exception) {
            cSSDecl.type = 0;
        }
    }

    static int cssLengthToPixels(CSSDecl cSSDecl, CSSAttribs cSSAttribs, int n) {
        float f = 0.0f;
        try {
            f = ((Float)cSSDecl.value).floatValue();
        }
        catch (Exception exception) {
            return 0;
        }
        switch (cSSDecl.type) {
            case -4: {
                return (int)f;
            }
            case -5: {
                return (int)(f * (float)cSSAttribs.font_size);
            }
            case -6: {
                return (int)(0.5f * f * (float)cSSAttribs.font_size);
            }
            case -7: {
                break;
            }
            case -8: {
                f *= cSSAttribs.sdata.fontCache.getScreenResolution();
                break;
            }
            case -9: {
                f = f * cSSAttribs.sdata.fontCache.getScreenResolution() / 2.54f;
                break;
            }
            case -10: {
                f = f * cSSAttribs.sdata.fontCache.getScreenResolution() / 25.4f;
                break;
            }
            case -11: {
                f = f * cSSAttribs.sdata.fontCache.getScreenResolution() / 72.0f;
                break;
            }
            case -12: {
                f = f * 12.0f * cSSAttribs.sdata.fontCache.getScreenResolution() / 72.0f;
            }
        }
        return (int)(f * (float)n) >> 8;
    }

    private static int hexToInt(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + (c - 97);
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + (c - 65);
        }
        return 0;
    }

    static String colorToString(Object object) {
        Color color = (Color)object;
        if (color == null) {
            return "";
        }
        return "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
    }

    static int cssCursorToAWT(int n) {
        switch (n) {
            case 23: {
                return 1;
            }
            case 24: {
                return 0;
            }
            case 25: {
                return 12;
            }
            case 26: {
                return 13;
            }
            case 27: {
                return 11;
            }
            case 28: {
                return 7;
            }
            case 29: {
                return 6;
            }
            case 30: {
                return 8;
            }
            case 31: {
                return 5;
            }
            case 32: {
                return 4;
            }
            case 33: {
                return 9;
            }
            case 34: {
                return 10;
            }
            case 35: {
                return 2;
            }
            case 36: {
                return 3;
            }
            case 37: {
                return -1;
            }
            case 159: {
                return 12;
            }
        }
        return -1;
    }

    static void drawStyledLine(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (n > n3 || n2 > n4) {
            n7 = n;
            n = n3;
            n3 = n7;
            n7 = n2;
            n2 = n4;
            n4 = n7;
        }
        if (n6 == 1) {
            CSSUtil.drawStyledLine(graphics, n, n2, n3, n4, n5);
        } else {
            switch (n5) {
                case 148: {
                    n7 = 3 * n6;
                    if (n2 == n4) {
                        if (n3 - n <= 2 * n7) {
                            n7 /= 2;
                        }
                        int n8 = n;
                        while (n8 <= n3) {
                            graphics.fillRect(n8, n2, n6, n6);
                            n8 += n6 + n7;
                        }
                    } else {
                        if (n != n3) break;
                        if (n4 - n2 <= 2 * n7) {
                            n7 /= 2;
                        }
                        int n9 = n2;
                        while (n9 < n4) {
                            graphics.fillRect(n, n9, n6, n6);
                            n9 += n6 + n7;
                        }
                    }
                    break;
                }
                case 149: {
                    n7 = 2 * n6;
                    int n10 = 3 * n6;
                    if (n2 == n4) {
                        int n11 = n;
                        while (n11 <= n3 - n10 / 2) {
                            if (n11 + n10 >= n3) {
                                n10 = n3 - n11;
                            }
                            graphics.drawRect(n11, n2, n10, n6);
                            graphics.fillRect(n11, n2, n10, n6);
                            n11 += n10 + n7;
                        }
                    } else {
                        if (n != n3) break;
                        int n12 = n2;
                        while (n12 <= n4 - n10) {
                            graphics.drawRect(n, n12, n6, n10);
                            graphics.fillRect(n, n12, n6, n10);
                            n12 += n10 + n7;
                        }
                    }
                    break;
                }
                default: {
                    CSSUtil.drawStyledLine(graphics, n, n2, n3, n4, n5);
                }
            }
        }
    }

    static void drawStyledLine(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        switch (n5) {
            case 148: {
                int n6 = 4;
                if (n2 == n4) {
                    if (Math.abs(n3 - n) <= 8) {
                        n6 = 2;
                    }
                    int n7 = n;
                    while (n7 <= n3) {
                        graphics.drawLine(n7, n2, n7, n2);
                        n7 += n6;
                    }
                } else {
                    if (n != n3) break;
                    if (Math.abs(n4 - n2) <= 8) {
                        n6 = 2;
                    }
                    int n8 = n2;
                    while (n8 <= n4) {
                        graphics.drawLine(n, n8, n, n8);
                        n8 += n6;
                    }
                }
                break;
            }
            case 149: {
                if (n2 == n4) {
                    int n9 = n;
                    while (n9 < n3) {
                        graphics.drawLine(n9, n2, n9 + 3, n2);
                        n9 += 5;
                    }
                } else {
                    if (n != n3) break;
                    int n10 = n2;
                    while (n10 < n4) {
                        graphics.drawLine(n, n10, n, n10 + 3);
                        n10 += 5;
                    }
                }
                break;
            }
            default: {
                graphics.drawLine(n, n2, n3, n4);
            }
        }
    }
}

