/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.dombase.Nbrs;
import ice.pilots.html4.AttributeSelector;
import ice.pilots.html4.CSSDecl;
import ice.pilots.html4.CSSLex;
import ice.pilots.html4.CSSLexCallback;
import ice.pilots.html4.CSSLookup;
import ice.pilots.html4.CSSUtil;
import ice.pilots.html4.DCSSRule;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DRuleList;
import ice.pilots.html4.DStyleDeclaration;
import ice.pilots.html4.DStyleSheet;
import ice.pilots.html4.Names;
import ice.pilots.html4.Selector;
import ice.pilots.html4.SimpleSelector;
import ice.pilots.html4.StormData;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;

public class CSSBuilder
implements CSSLexCallback,
Nbrs {
    private String baseUrl;
    private DStyleSheet styleSheet;
    private Selector[] selectors = new Selector[32];
    private int numSelectors = 0;
    private Selector sel = null;
    private SimpleSelector simple = null;
    private CSSDecl firstDecl = null;
    private CSSDecl lastDecl = null;
    private DCSSRule mediaRule = null;
    private boolean importAllowed = true;
    private int defaultNamespace;
    private Hashtable nsPrefixes = new Hashtable();
    private StormData sdata;
    private Names names;
    private DDocument _doc;

    public CSSBuilder(DDocument dDocument) {
        this.sdata = dDocument.getDom().getStormData();
        this._doc = dDocument;
        this.names = dDocument.getNames();
    }

    public void build(DStyleSheet dStyleSheet, String string) throws IOException {
        Reader reader = this._doc.openUrlReader(string);
        try {
            this.build(dStyleSheet, reader, string);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            reader.close();
            throw throwable;
        }
        reader.close();
    }

    public void build(DStyleSheet dStyleSheet, Reader reader, String string) throws IOException {
        this.baseUrl = string;
        this.styleSheet = dStyleSheet;
        this.defaultNamespace = dStyleSheet.defaultNamespace;
        CSSLex cSSLex = new CSSLex();
        cSSLex.setLexCallback(this);
        cSSLex.setReader(reader);
        cSSLex.parse();
    }

    public void startStylesheet() {
    }

    public void endStylesheet() {
        this.baseUrl = null;
        this.styleSheet = null;
        this.numSelectors = 0;
        this.sel = null;
        this.simple = null;
        this.lastDecl = null;
        this.firstDecl = null;
        this.mediaRule = null;
        this.importAllowed = true;
    }

    public void atRule(char[] cArray, int n, int n2) {
        int n3 = n + n2;
        char c = cArray[n];
        if ((c == 'i' || c == 'I') && this.importAllowed) {
            int n4 = CSSUtil.findNonSpace(cArray, n += 6, n3);
            int n5 = CSSUtil.findWhitespace(cArray, n4, n3);
            if (n5 < 0) {
                n5 = n3;
            }
            String string = CSSUtil.parseUrl(cArray, n4, n5);
            String string2 = this._doc.resolveUrl(this.baseUrl, string);
            DCSSRule dCSSRule = new DCSSRule(3, this.styleSheet, null);
            String string3 = new String(cArray, n5, n3 - n5);
            dCSSRule.mediaList.setCssText(string3);
            DStyleSheet dStyleSheet = this._doc.getDom().createDStyleSheet(this.defaultNamespace, null, this.styleSheet, dCSSRule);
            dStyleSheet.getMedia().setMediaText(string3);
            dCSSRule.importedStyleSheet = dStyleSheet;
            dCSSRule.href = string2;
            dStyleSheet.setHref(dCSSRule.href);
            ((DRuleList)this.styleSheet.getCssRules()).addRule(dCSSRule);
            CSSBuilder cSSBuilder = new CSSBuilder(this._doc);
            try {
                cSSBuilder.build(dStyleSheet, string2);
            }
            catch (IOException iOException) {
                if (Debug.ex) {
                    Debug.ex(iOException);
                }
            }
        } else if (c == 'm' || c == 'M') {
            this.mediaRule = new DCSSRule(4, this.styleSheet, null);
            this.mediaRule.mediaList.setCssText(new String(cArray, n += 5, n3 - n));
            ((DRuleList)this.styleSheet.getCssRules()).addRule(this.mediaRule);
        } else if (c == 'n' || c == 'N') {
            int n6;
            String string = null;
            String string4 = null;
            int n7 = CSSUtil.findNonSpace(cArray, n += 9, n3);
            int n8 = CSSUtil.findWhitespace(cArray, n7, n3);
            if (n8 > n7) {
                n6 = CSSUtil.findNonSpace(cArray, n8, n3);
                if (n6 < 0) {
                    string4 = CSSUtil.parseUrl(cArray, n7, n8);
                } else {
                    int n9 = CSSUtil.findWhitespace(cArray, n6, n3);
                    if (n9 < 0) {
                        n9 = n3;
                    }
                    string = new String(cArray, n7, n8 - n7);
                    string4 = CSSUtil.parseUrl(cArray, n6, n9);
                }
            } else {
                string4 = CSSUtil.parseUrl(cArray, n7, n3);
            }
            if (string4 != null && (n6 = this.names.getNamespace(string4)) >= 0) {
                if (string != null) {
                    this.nsPrefixes.put(string, new Integer(n6));
                } else {
                    this.defaultNamespace = n6;
                }
            }
        }
    }

    public void startBlock() {
        this.importAllowed = false;
    }

    public void endBlock() {
        if (this.mediaRule != null) {
            this.mediaRule = null;
        }
    }

    public void startSelector() {
        this.importAllowed = false;
        this.sel = new Selector();
    }

    public void endSelector() {
        if (this.simple != null) {
            this.sel.addSimpleSelector(this.simple);
        }
        this.sel.computeWeight();
        if (!this.sel.isEmpty()) {
            if (this.numSelectors >= this.selectors.length) {
                Selector[] selectorArray = new Selector[this.selectors.length * 2];
                System.arraycopy(this.selectors, 0, selectorArray, 0, this.selectors.length);
                this.selectors = selectorArray;
            }
            this.selectors[this.numSelectors++] = this.sel;
        }
        this.sel = null;
        this.simple = null;
    }

    public void selectorCombinator(char c) {
        if (this.simple != null) {
            this.simple.combinator = c;
            this.sel.addSimpleSelector(this.simple);
            this.simple = null;
        }
    }

    public void typeSelector(char[] cArray, int n, int n2, int n3) {
        int n4 = 0;
        if (cArray[n] != '*') {
            Integer n5;
            int n6 = this.defaultNamespace;
            if (n3 > 0 && (n5 = (Integer)this.nsPrefixes.get(new String(cArray, n, n3 - 1))) != null) {
                n6 = n5;
            }
            n4 = this.names.getTagId(n6, cArray, n + n3, n2 - n3);
        }
        if (this.simple != null) {
            this.sel.addSimpleSelector(this.simple);
        }
        this.simple = new SimpleSelector(this.sdata.names, n4);
    }

    public void attributeSelector(char[] cArray, int n, int n2) {
        int n3;
        String string = new String(cArray, n, n2);
        String string2 = null;
        String string3 = null;
        int n4 = 0;
        int n5 = string.indexOf(61);
        if (n5 > 0) {
            string3 = string.substring(n5 + 1).trim();
            if (string3.length() > 1 && ((n3 = string3.charAt(0)) == 39 || n3 == 34)) {
                string3 = string3.substring(1, string3.length() - 1);
            }
            if ((n3 = string.charAt(n5 - 1)) == 126) {
                n4 = 1;
                --n5;
            } else if (n3 == 124) {
                n4 = 2;
                --n5;
            }
            string2 = string.substring(0, n5).trim();
        } else {
            string2 = string.trim();
        }
        if (string2 != null && string2.length() > 0) {
            if (this.simple == null) {
                this.simple = new SimpleSelector(this.sdata.names, 0);
            }
            n3 = this.names.getAttrId(3, string2);
            AttributeSelector attributeSelector = new AttributeSelector(this.sdata.names, n3, string3, n4);
            this.simple.addAttributeSelector(attributeSelector);
        }
    }

    public void classSelector(char[] cArray, int n, int n2) {
        if (this.simple == null) {
            this.simple = new SimpleSelector(this.sdata.names, 0);
        }
        String string = new String(cArray, n, n2);
        AttributeSelector attributeSelector = new AttributeSelector(this.sdata.names, 21, string, 1);
        this.simple.addAttributeSelector(attributeSelector);
    }

    public void pseudoSelector(char[] cArray, int n, int n2) {
        if (this.simple == null) {
            this.simple = new SimpleSelector(this.sdata.names, 0);
        }
        String string = new String(cArray, n, n2);
        this.simple.addPseudoSelector(string);
    }

    public void idSelector(char[] cArray, int n, int n2) {
        if (this.simple == null) {
            this.simple = new SimpleSelector(this.sdata.names, 0);
        }
        String string = new String(cArray, n, n2);
        this.simple.setIDSelector(string);
    }

    public void startDeclBlock() {
    }

    public void endDeclBlock() {
        DRuleList dRuleList = null;
        DCSSRule dCSSRule = null;
        if (this.mediaRule != null) {
            dRuleList = this.mediaRule.ruleList;
            dCSSRule = this.mediaRule;
        } else {
            dRuleList = (DRuleList)this.styleSheet.getCssRules();
        }
        int n = 0;
        while (n < this.numSelectors) {
            DCSSRule dCSSRule2 = new DCSSRule(1, this.styleSheet, dCSSRule);
            DStyleDeclaration dStyleDeclaration = this._doc.getDom().createDStyleDeclaration(dCSSRule2, null);
            dStyleDeclaration.setFirstDecl(this.firstDecl);
            dCSSRule2.setStyleRule(this.selectors[n], dStyleDeclaration);
            dRuleList.addRule(dCSSRule2);
            this.selectors[n] = null;
            ++n;
        }
        this.numSelectors = 0;
        this.lastDecl = null;
        this.firstDecl = null;
    }

    public void declaration(char[] cArray, int n, int n2, int n3, int n4) {
        CSSDecl cSSDecl = CSSLookup.parseDeclaration(this.sdata, cArray, n, n2, n3, n4);
        if (cSSDecl != null) {
            CSSDecl cSSDecl2 = cSSDecl;
            while (cSSDecl2.next != null) {
                cSSDecl2 = cSSDecl2.next;
            }
            if (this.firstDecl == null) {
                this.firstDecl = cSSDecl;
                this.lastDecl = cSSDecl2;
            } else {
                this.lastDecl.next = cSSDecl;
                this.lastDecl = cSSDecl2;
            }
        }
    }
}

