/*
 * Decompiled with CFR 0.152.
 */
package ice.browser;

import ice.browser.MultiLabel;
import ice.storm.StormBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.MouseEvent;

public class Tooltip
extends Window
implements EventListener {
    private StormBase storm;
    private MultiLabel myLabel;
    private Node currentTooltipNode;

    public Tooltip(Frame frame, StormBase stormBase) {
        super(frame);
        this.storm = stormBase;
        ((Component)this).setSize(200, 30);
        ((Component)this).setBackground(new Color(255, 255, 225));
        this.enableEvents(0L);
        this.myLabel = new MultiLabel();
        this.myLabel.setFont(new Font("SansSerif", 0, 12));
        this.add(this.myLabel);
    }

    public void dispose() {
        this.currentTooltipNode = null;
        super.dispose();
    }

    public void handleEvent(Event event) {
        MouseEvent mouseEvent = (MouseEvent)event;
        String string = mouseEvent.getType();
        Node node = (Node)((Object)mouseEvent.getTarget());
        if (string.equals("mouseover") || string.equals("mouseout")) {
            String string2 = null;
            while (node != null) {
                if (node instanceof Element) {
                    Element element = (Element)node;
                    string2 = element.getAttribute("title");
                    if (string2 == null) {
                        string2 = element.getAttribute("alt");
                    }
                    if (string2 != null && (string2 = string2.trim()).length() != 0) break;
                }
                node = node.getParentNode();
            }
            if (this.currentTooltipNode != node) {
                this.currentTooltipNode = node;
                if (node != null) {
                    this.storm.runOnEventThreadLater(new Shower(this, node, string2, mouseEvent.getScreenX(), mouseEvent.getScreenY()), 500L);
                } else {
                    ((Component)this).setVisible(false);
                }
            }
        }
    }

    static class Shower
    implements Runnable {
        Tooltip master;
        Node tooltipNode;
        String title;
        int eventX;
        int eventY;

        Shower(Tooltip tooltip, Node node, String string, int n, int n2) {
            this.master = tooltip;
            this.tooltipNode = node;
            this.title = string;
            this.eventX = n;
            this.eventY = n2;
        }

        public void run() {
            if (this.master.currentTooltipNode == this.tooltipNode) {
                this.master.myLabel.setText(this.title, true);
                this.master.myLabel.invalidate();
                this.master.invalidate();
                this.master.pack();
                ((Component)this.master).setLocation(this.eventX + 5, this.eventY + 5);
                ((Component)this.master).setVisible(true);
            }
        }
    }
}

