/*
 * Decompiled with CFR 0.152.
 */
package ice.browser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;
import java.util.Vector;

public class MultiLabel
extends Component {
    private Dimension prefSize = new Dimension();
    private String[] lines = new String[0];
    private boolean drawBorder = false;
    private int maxChars = 0;

    public MultiLabel() {
    }

    public MultiLabel(String string, int n) {
        this.maxChars = n;
        this.setText(string, false);
    }

    public void setMaxChars(int n) {
        this.maxChars = n;
    }

    public void setText(String string, boolean bl) {
        this.drawBorder = bl;
        string = string.replace('\t', ' ');
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r", false);
        if (this.maxChars <= 0 || string.length() <= this.maxChars) {
            this.lines = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.lines[n++] = stringTokenizer.nextToken();
            }
        } else {
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                while (string2.length() > this.maxChars) {
                    vector.addElement(string2.substring(0, this.maxChars));
                    string2 = string2.substring(this.maxChars);
                }
                vector.addElement(string2);
            }
            this.lines = new String[vector.size()];
            vector.copyInto(this.lines);
        }
    }

    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        String[] stringArray = this.lines;
        if (stringArray == null) {
            return null;
        }
        int n3 = 0;
        while (n3 < stringArray.length) {
            int n4 = fontMetrics.stringWidth(stringArray[n3]);
            if (n4 > n) {
                n = n4;
            }
            n2 += fontMetrics.getHeight();
            ++n3;
        }
        this.prefSize.width = n + 6;
        this.prefSize.height = n2 + 2;
        return this.prefSize;
    }

    public void paint(Graphics graphics) {
        String[] stringArray = this.lines;
        if (stringArray == null) {
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.getAscent();
        int n2 = fontMetrics.getHeight();
        int n3 = 0;
        while (n3 < stringArray.length) {
            graphics.drawString(stringArray[n3], 3, n);
            ++n3;
            n += n2;
        }
        if (this.drawBorder) {
            graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        }
    }
}

