/*
 * Decompiled with CFR 0.152.
 */
package ice.browser;

import ice.storm.PilotInfo;
import ice.storm.ScripterInfo;
import ice.storm.StormBase;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.List;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Hashtable;

public class ListDialog
extends Dialog
implements WindowListener,
ItemListener,
ActionListener {
    private List names;
    private TextArea info;
    private Button done;
    private Hashtable pilotInfos = new Hashtable();
    private Hashtable scripterInfos = new Hashtable();

    public ListDialog(Frame frame, StormBase stormBase) {
        super(frame, "Storm Pilots and Scripters", true);
        Object object;
        this.addWindowListener(this);
        this.names = new List(10);
        this.names.addItemListener(this);
        this.names.setForeground(Color.white);
        this.names.setBackground(Color.black);
        this.info = new TextArea(12, 50);
        this.info.setEditable(false);
        this.info.setFont(new Font("Monospaced", 0, 12));
        Enumeration enumeration = stormBase.getPilotFactory().getAllPilotInfos();
        Enumeration enumeration2 = stormBase.getScripterFactory().getAllScripterInfos();
        while (enumeration.hasMoreElements()) {
            object = (PilotInfo)enumeration.nextElement();
            if (!((PilotInfo)object).isLoaded()) continue;
            this.names.add(((PilotInfo)object).getName());
            this.pilotInfos.put(((PilotInfo)object).getName(), object);
        }
        while (enumeration2.hasMoreElements()) {
            object = (ScripterInfo)enumeration2.nextElement();
            if (!((ScripterInfo)object).isLoaded()) continue;
            this.names.add(((ScripterInfo)object).getName());
            this.scripterInfos.put(((ScripterInfo)object).getName(), object);
        }
        this.done = new Button("Done");
        this.done.addActionListener(this);
        object = new Panel();
        ((Container)object).setLayout(new BorderLayout());
        ((Container)object).add((Component)this.names, "Center");
        ((Container)object).add((Component)this.done, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)object, "West");
        this.add((Component)this.info, "Center");
        this.pack();
        Point point = frame.getLocation();
        ((Component)this).setLocation(point.x + 10, point.y + 10);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        block4: {
            ScripterInfo scripterInfo;
            block3: {
                String string = this.names.getSelectedItem();
                this.info.setText("");
                if (string == null) {
                    return;
                }
                PilotInfo pilotInfo = (PilotInfo)this.pilotInfos.get(string);
                scripterInfo = (ScripterInfo)this.scripterInfos.get(string);
                if (pilotInfo == null) break block3;
                this.info.append("Pilot:     " + pilotInfo.getName() + "\n");
                this.info.append("Version:   " + pilotInfo.getVersion() + "\n");
                this.info.append("Author:    " + pilotInfo.getAuthor() + "\n");
                this.info.append("Description: " + pilotInfo.getDescription() + "\n");
                this.info.append("Supported content types: \n");
                String[] stringArray = pilotInfo.getSupportedContentTypes();
                int n = 0;
                while (n < stringArray.length) {
                    this.info.append("      " + stringArray[n] + "\n");
                    ++n;
                }
                break block4;
            }
            if (scripterInfo == null) break block4;
            this.info.append("Scripter:  " + scripterInfo.getName() + "\n");
            this.info.append("Version:   " + scripterInfo.getVersion() + "\n");
            this.info.append("Author:    " + scripterInfo.getAuthor() + "\n");
            this.info.append("Description: " + scripterInfo.getDescription() + "\n");
            this.info.append("Supported aliases: \n");
            String[] stringArray = scripterInfo.getAliases();
            int n = 0;
            while (n < stringArray.length) {
                this.info.append("      " + stringArray[n] + "\n");
                ++n;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

