/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.worker;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Dictionary;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import oracle.bali.ewt.event.DeferringPropertyChangeListener;
import oracle.bali.ewt.worker.AbstractWorker;
import oracle.bali.ewt.worker.InvocationContext;
import oracle.bali.ewt.worker.MultiWorkerStatusListener;
import oracle.bali.ewt.worker.Worker;
import oracle.bali.ewt.worker.WorkerStatusAdapter;
import oracle.bali.ewt.worker.WorkerStatusListener;
import oracle.bali.ewt.worker.WorkerUtils;
import oracle.bali.share.util.IntegerUtils;

public final class WorkerUIUtils {
    public static final Object WORKER_CLIENT_PROPERTY = "JEWTWorker";
    public static final Object WORKER_SHORT_DESCRIPTION = "ShortDescription";
    public static final Object WORKER_LONG_DESCRIPTION = "LongDescription";
    public static final Object WORKER_SMALL_ICON = "SmallIcon";
    public static final Object WORKER_ROLLOVER_ICON = "ROIcon";
    public static final Object WORKER_MNEMONIC = "Mnemon";
    public static final Object WORKER_ACCELERATOR = "Accel";
    public static final Object WORKER_INVOKING_COMPONENT = "InvComp";
    private static final String _ACTION_LISTENER = "WorkerUIUtils.actionListener";
    private static final String _WORKER_CHANGE_LISTENER = "WorkerUIUtils.workerChangeListener";
    private static final String _PROPERTY_CHANGE_LISTENER = "WorkerUIUtils.propertyChangeListener";

    public static void setShortDescription(Worker worker, String string) {
        worker.putValue(WORKER_SHORT_DESCRIPTION, string);
    }

    public static String getShortDescription(Worker worker) {
        return (String)worker.getValue(WORKER_SHORT_DESCRIPTION);
    }

    public static void setLongDescription(Worker worker, String string) {
        worker.putValue(WORKER_LONG_DESCRIPTION, string);
    }

    public static String getLongDescription(Worker worker) {
        return (String)worker.getValue(WORKER_LONG_DESCRIPTION);
    }

    public static void setSmallIcon(Worker worker, Icon icon) {
        worker.putValue(WORKER_SMALL_ICON, icon);
    }

    public static Icon getSmallIcon(Worker worker) {
        return (Icon)worker.getValue(WORKER_SMALL_ICON);
    }

    public static void setRolloverIcon(Worker worker, Icon icon) {
        worker.putValue(WORKER_ROLLOVER_ICON, icon);
    }

    public static Icon getRolloverIcon(Worker worker) {
        return (Icon)worker.getValue(WORKER_ROLLOVER_ICON);
    }

    public static void setMnemonic(Worker worker, int n) {
        Integer n2 = n != 0 ? IntegerUtils.getInteger(n) : null;
        worker.putValue(WORKER_MNEMONIC, n2);
    }

    public static int getMnemonic(Worker worker) {
        Integer n = (Integer)worker.getValue(WORKER_MNEMONIC);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static void setAccelerator(Worker worker, KeyStroke keyStroke) {
        worker.putValue(WORKER_ACCELERATOR, keyStroke);
    }

    public static KeyStroke getAccelerator(Worker worker) {
        return (KeyStroke)worker.getValue(WORKER_ACCELERATOR);
    }

    public JComponent getInvokingComponent(InvocationContext invocationContext) {
        return (JComponent)invocationContext.getValue(WORKER_INVOKING_COMPONENT, null);
    }

    public static Worker getComponentWorker(JComponent jComponent) {
        return (Worker)jComponent.getClientProperty(WORKER_CLIENT_PROPERTY);
    }

    public static JButton createToolBarButton(Worker worker) {
        return WorkerUIUtils.createToolBarButton(worker, InvocationContext.UNDEFINED);
    }

    public static JButton createToolBarButton(Worker worker, Object object) {
        return WorkerUIUtils.createToolBarButton(worker, object, null);
    }

    public static JButton createToolBarButton(Worker worker, Object object, WorkerStatusListener workerStatusListener) {
        return WorkerUIUtils.createToolBarButton(worker, InvocationContext.PARAMETER_VALUE, object, workerStatusListener);
    }

    public static JButton createToolBarButton(Worker worker, Object object, Object object2, WorkerStatusListener workerStatusListener) {
        return WorkerUIUtils.createToolBarButton(worker, WorkerUtils.createParameters(object, object2), workerStatusListener);
    }

    public static JButton createToolBarButton(Worker worker, Dictionary dictionary, WorkerStatusListener workerStatusListener) {
        JButton jButton = new JButton();
        jButton.setRequestFocusEnabled(false);
        WorkerUIUtils._configureWorkerButton(jButton, worker, dictionary, workerStatusListener, false, true);
        return jButton;
    }

    public static JMenuItem createMenuItem(Worker worker) {
        return WorkerUIUtils.createMenuItem(worker, InvocationContext.UNDEFINED);
    }

    public static JMenuItem createMenuItem(Worker worker, Object object) {
        return WorkerUIUtils.createMenuItem(worker, object, null);
    }

    public static JMenuItem createMenuItem(Worker worker, Object object, WorkerStatusListener workerStatusListener) {
        return WorkerUIUtils.createMenuItem(worker, InvocationContext.PARAMETER_VALUE, object, workerStatusListener);
    }

    public static JMenuItem createMenuItem(Worker worker, Object object, Object object2, WorkerStatusListener workerStatusListener) {
        return WorkerUIUtils.createMenuItem(worker, WorkerUtils.createParameters(object, object2), workerStatusListener);
    }

    public static JMenuItem createMenuItem(Worker worker, Dictionary dictionary, WorkerStatusListener workerStatusListener) {
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setAccelerator(WorkerUIUtils.getAccelerator(worker));
        WorkerUIUtils._configureWorkerButton(jMenuItem, worker, dictionary, workerStatusListener, true, false);
        return jMenuItem;
    }

    public static JButton createPushButton(Worker worker) {
        return WorkerUIUtils.createPushButton(worker, InvocationContext.UNDEFINED);
    }

    public static JButton createPushButton(Worker worker, Object object) {
        return WorkerUIUtils.createPushButton(worker, object, null);
    }

    public static JButton createPushButton(Worker worker, Object object, WorkerStatusListener workerStatusListener) {
        return WorkerUIUtils.createPushButton(worker, InvocationContext.PARAMETER_VALUE, object, workerStatusListener);
    }

    public static JButton createPushButton(Worker worker, Object object, Object object2, WorkerStatusListener workerStatusListener) {
        return WorkerUIUtils.createPushButton(worker, WorkerUtils.createParameters(object, object2), workerStatusListener);
    }

    public static JButton createPushButton(Worker worker, Dictionary dictionary, WorkerStatusListener workerStatusListener) {
        JButton jButton = new JButton();
        WorkerUIUtils._configureWorkerButton(jButton, worker, dictionary, workerStatusListener, true, false);
        return jButton;
    }

    public static void dispose(AbstractButton abstractButton) {
        Object object;
        Object object2 = abstractButton.getClientProperty(_ACTION_LISTENER);
        if (object2 instanceof WorkerActionProxy) {
            object = (WorkerActionProxy)object2;
            ((WorkerActionProxy)object).dispose();
            abstractButton.removeActionListener((ActionListener)object);
        }
        abstractButton.putClientProperty(_ACTION_LISTENER, null);
        object2 = abstractButton.getClientProperty(_WORKER_CHANGE_LISTENER);
        if (object2 instanceof WorkerChangedListener) {
            object = (WorkerChangedListener)object2;
            ((WorkerChangedListener)object).dispose();
        }
        abstractButton.putClientProperty(_WORKER_CHANGE_LISTENER, null);
        object2 = abstractButton.getClientProperty(WORKER_CLIENT_PROPERTY);
        object = object2 instanceof Worker ? (Worker)object2 : null;
        abstractButton.putClientProperty(WORKER_CLIENT_PROPERTY, null);
        object2 = abstractButton.getClientProperty(_PROPERTY_CHANGE_LISTENER);
        if (object2 instanceof PropertyChangeListener) {
            object.removePropertyChangeListener((PropertyChangeListener)object2);
        }
        abstractButton.putClientProperty(_PROPERTY_CHANGE_LISTENER, null);
    }

    private static void _configureWorkerButton(AbstractButton abstractButton, Worker worker, Dictionary dictionary, WorkerStatusListener workerStatusListener, boolean bl, boolean bl2) {
        int n;
        String string = bl ? AbstractWorker.getName(worker) : null;
        String string2 = AbstractWorker.getCommand(worker);
        abstractButton.setName(string2);
        Icon icon = null;
        Icon icon2 = null;
        if (bl2) {
            icon = WorkerUIUtils.getSmallIcon(worker);
            icon2 = WorkerUIUtils.getRolloverIcon(worker);
        }
        if ((n = WorkerUIUtils.getMnemonic(worker)) != 0) {
            abstractButton.setMnemonic(n);
        }
        String string3 = bl ? WorkerUIUtils.getLongDescription(worker) : WorkerUIUtils.getShortDescription(worker);
        abstractButton.setText(string);
        abstractButton.setActionCommand(string2);
        abstractButton.setToolTipText(string3);
        WorkerActionProxy workerActionProxy = new WorkerActionProxy(abstractButton, worker, dictionary, workerStatusListener);
        abstractButton.addActionListener(workerActionProxy);
        abstractButton.putClientProperty(_ACTION_LISTENER, workerActionProxy);
        abstractButton.setEnabled(worker.isEnabled());
        if (icon != null) {
            abstractButton.setIcon(icon);
        }
        if (icon2 != null) {
            abstractButton.setRolloverIcon(icon2);
        }
        WorkerChangedListener workerChangedListener = new WorkerChangedListener(abstractButton, bl, bl2);
        DeferringPropertyChangeListener deferringPropertyChangeListener = new DeferringPropertyChangeListener(workerChangedListener);
        abstractButton.putClientProperty(_WORKER_CHANGE_LISTENER, workerChangedListener);
        abstractButton.putClientProperty(_PROPERTY_CHANGE_LISTENER, deferringPropertyChangeListener);
        worker.addPropertyChangeListener(deferringPropertyChangeListener);
        abstractButton.putClientProperty(WORKER_CLIENT_PROPERTY, worker);
    }

    private WorkerUIUtils() {
    }

    private static class WorkerChangedListener
    implements PropertyChangeListener {
        private AbstractButton _button;
        private boolean _trackLabel;
        private boolean _trackIcon;

        public WorkerChangedListener(AbstractButton abstractButton, boolean bl, boolean bl2) {
            this._button = abstractButton;
            this._trackLabel = bl;
            this._trackIcon = bl2;
        }

        public void dispose() {
            this._button = null;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getNewValue();
            if (string.equals(Worker.WORKER_NAME)) {
                if (this._trackLabel) {
                    this._button.setText((String)object);
                }
            } else if (string.equals("enabled")) {
                this._button.setEnabled((Boolean)object);
            } else if (string.equals(WORKER_SMALL_ICON)) {
                if (this._trackIcon) {
                    this._button.setIcon((Icon)object);
                }
            } else if (string.equals(WORKER_ROLLOVER_ICON)) {
                if (this._trackIcon) {
                    this._button.setRolloverIcon((Icon)object);
                }
            } else if (string.equals(WORKER_SHORT_DESCRIPTION)) {
                if (!this._trackLabel) {
                    this._button.setToolTipText((String)object);
                }
            } else if (string.equals(WORKER_LONG_DESCRIPTION)) {
                if (this._trackLabel) {
                    this._button.setToolTipText((String)object);
                }
            } else if (string.equals(Worker.WORKER_COMMAND)) {
                this._button.setActionCommand((String)object);
            }
        }
    }

    private static class WorkerActionProxy
    extends WorkerStatusAdapter
    implements ActionListener {
        private AbstractButton _button;
        private Worker _target;
        private Dictionary _parameters;
        private MultiWorkerStatusListener _multiListener;

        public WorkerActionProxy(AbstractButton abstractButton, Worker worker, Dictionary dictionary, WorkerStatusListener workerStatusListener) {
            if (worker == null) {
                throw new IllegalArgumentException();
            }
            if (dictionary == null) {
                dictionary = WorkerUtils.createMinimalParameterDictionary();
            }
            dictionary.put(WORKER_INVOKING_COMPONENT, abstractButton);
            this._button = abstractButton;
            this._target = worker;
            this._parameters = dictionary;
            this._multiListener = new MultiWorkerStatusListener(workerStatusListener, this);
        }

        public void dispose() {
            this._button = null;
            this._target = null;
            this._parameters = null;
            this._multiListener = null;
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            ((AbstractButton)actionEvent.getSource()).setEnabled(false);
            WorkerUtils.queueWorker(this._target, this._parameters, (WorkerStatusListener)this._multiListener);
        }

        public void workerSucceeded(InvocationContext invocationContext) {
            this._reenable(invocationContext);
        }

        public void workerFailed(InvocationContext invocationContext) {
            this._reenable(invocationContext);
        }

        private void _reenable(InvocationContext invocationContext) {
            this._button.setEnabled(this._target.isEnabled());
        }
    }
}

