/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.worker;

import oracle.bali.ewt.worker.AbstractWorkerQueue;
import oracle.bali.share.thread.Task;
import oracle.bali.share.thread.TaskEvent;
import oracle.bali.share.thread.TaskScheduler;

public class ThreadWorkerQueue
extends AbstractWorkerQueue {
    private static final String _BASE_NAME = "WorkerQueue #";
    private static int _sQueueCount = 0;
    private String _threadName = null;
    private transient TaskScheduler _scheduler = null;

    public ThreadWorkerQueue() {
        this(null);
    }

    public ThreadWorkerQueue(String string) {
        if (string == null) {
            string = _BASE_NAME + _sQueueCount++;
        }
        this._threadName = string;
    }

    public boolean isInWorkerQueueThread() {
        return Thread.currentThread().getName().equals(this._threadName);
    }

    public void destroy() {
    }

    protected void invokeLater(Runnable runnable) {
        this._getScheduler().schedule(new TaskAdapter(runnable), 0);
    }

    protected void invokeAndWait(Runnable runnable) throws InterruptedException, Throwable {
        Runnable runnable2 = runnable;
        synchronized (runnable2) {
            this._getScheduler().schedule(new TaskAdapter(runnable), 0);
            runnable.wait();
        }
    }

    private TaskScheduler _getScheduler() {
        if (this._scheduler == null) {
            TaskScheduler taskScheduler = new TaskScheduler();
            taskScheduler.setName(this._threadName);
            taskScheduler.setDaemon(true);
            this._scheduler = taskScheduler;
        }
        return this._scheduler;
    }

    private static class TaskAdapter
    implements Task {
        private Runnable _runnable = null;

        public TaskAdapter(Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException();
            }
            this._runnable = runnable;
        }

        public void runTask(TaskEvent taskEvent) {
            this._runnable.run();
        }
    }
}

