/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.worker;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.model.BooleanModel;
import oracle.bali.ewt.worker.DelegatingWorker;
import oracle.bali.ewt.worker.Worker;

public class SwitchingWorker
extends DelegatingWorker {
    private Worker _trueWorker;
    private Worker _falseWorker;

    public SwitchingWorker(Worker worker, Worker worker2, BooleanModel booleanModel) {
        if (booleanModel == null) {
            throw new IllegalArgumentException();
        }
        this._trueWorker = worker;
        this._falseWorker = worker2;
        booleanModel.addChangeListener(new WorkerChanger());
        this._setNewWorker(booleanModel);
    }

    public Worker getTrueWorker() {
        return this._trueWorker;
    }

    public Worker getFalseWorker() {
        return this._falseWorker;
    }

    private void _setNewWorker(BooleanModel booleanModel) {
        Worker worker = booleanModel.getState() ? this.getTrueWorker() : this.getFalseWorker();
        this.setDelegatedWorker(worker);
    }

    private class WorkerChanger
    implements ChangeListener {
        private WorkerChanger() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            SwitchingWorker.this._setNewWorker((BooleanModel)changeEvent.getSource());
        }
    }
}

