/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.worker;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.bali.ewt.model.ObjectModel;
import oracle.bali.ewt.worker.InvocationContext;
import oracle.bali.ewt.worker.Worker;
import oracle.bali.ewt.worker.WorkerQueue;
import oracle.bali.ewt.worker.WorkerUtils;
import oracle.bali.share.util.BooleanUtils;

public abstract class AbstractWorker
implements Worker {
    private PropertyChangeSupport _changeSupport = null;
    private boolean _enabled = true;
    private Hashtable _keyTable = null;
    private Hashtable _defaultsTable = null;

    protected AbstractWorker() {
    }

    public Object putValue(Object object, Object object2) {
        if (object == null) {
            return null;
        }
        Object object3 = this.getValue(object);
        Dictionary dictionary = this._getValueDictionary();
        if (object2 != null) {
            dictionary.put(object, object2);
        } else {
            dictionary.remove(object);
        }
        this.firePropertyChange(object, object3, object2);
        return object3;
    }

    public Object getValue(Object object) {
        if (this._keyTable == null) {
            return null;
        }
        return this._getValueDictionary().get(object);
    }

    public Enumeration getValueKeys() {
        return this._getValueDictionary().keys();
    }

    public synchronized void setEnabled(boolean bl) {
        boolean bl2 = this.isEnabled();
        this._enabled = bl;
        this.fireEnabledPropertyChange(bl2);
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void putDefaultParameterValue(Object object, Object object2) {
        if (object2 == null) {
            object2 = WorkerUtils.PARAMETER_NULL;
        } else if (object2 == InvocationContext.UNDEFINED) {
            object2 = null;
        }
        this._getDefaultsDictionary().put(object, object2);
    }

    public Object getDefaultParameterValue(Object object) {
        Object object2 = InvocationContext.UNDEFINED;
        if (this._defaultsTable != null) {
            object2 = this._getDefaultsDictionary().get(object);
            if (object2 == null) {
                object2 = InvocationContext.UNDEFINED;
            } else if (object2 == WorkerUtils.PARAMETER_NULL) {
                object2 = null;
            } else if (object2 instanceof ObjectModel) {
                object2 = ((ObjectModel)object2).getObject();
            }
        }
        return object2;
    }

    public final Object run(InvocationContext invocationContext) throws Throwable {
        if (this.isEnabled()) {
            return this.runWorker(invocationContext);
        }
        throw this.getDisabledWorkerException(invocationContext);
    }

    protected abstract Object runWorker(InvocationContext var1) throws Throwable;

    public Object clone() {
        AbstractWorker abstractWorker = null;
        try {
            abstractWorker = (AbstractWorker)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException();
        }
        return abstractWorker;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._changeSupport == null) {
            this._changeSupport = new PropertyChangeSupport(this);
        }
        this._changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._changeSupport != null) {
            this._changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public static void setWorkerQueue(Worker worker, WorkerQueue workerQueue) {
        worker.putValue(Worker.WORKER_QUEUE, workerQueue);
    }

    public static WorkerQueue getWorkerQueue(Worker worker) {
        return (WorkerQueue)worker.getValue(Worker.WORKER_QUEUE);
    }

    public static void setName(Worker worker, String string) {
        worker.putValue(Worker.WORKER_NAME, string);
    }

    public static String getName(Worker worker) {
        return (String)worker.getValue(Worker.WORKER_NAME);
    }

    public static void setCommand(Worker worker, String string) {
        worker.putValue(Worker.WORKER_COMMAND, string);
    }

    public static String getCommand(Worker worker) {
        return (String)worker.getValue(Worker.WORKER_COMMAND);
    }

    public final void setName(String string) {
        AbstractWorker.setName(this, string);
    }

    public final String getName() {
        return AbstractWorker.getName(this);
    }

    public final void setCommand(String string) {
        AbstractWorker.setCommand(this, string);
    }

    public final String getCommand() {
        return AbstractWorker.getCommand(this);
    }

    public final void setWorkerQueue(WorkerQueue workerQueue) {
        AbstractWorker.setWorkerQueue(this, workerQueue);
    }

    public final WorkerQueue getWorkerQueue() {
        return AbstractWorker.getWorkerQueue(this);
    }

    protected Throwable getDisabledWorkerException(InvocationContext invocationContext) {
        return new IllegalStateException("Attempt to run disabled Worker:" + this);
    }

    protected void firePropertyChange(Object object, Object object2, Object object3) {
        if (this._changeSupport != null && (object2 != null || object3 != null)) {
            this._changeSupport.firePropertyChange(object.toString(), object2, object3);
        }
    }

    protected final void fireEnabledPropertyChange(boolean bl) {
        boolean bl2 = this.isEnabled();
        if (bl != bl2) {
            this.firePropertyChange("enabled", BooleanUtils.getBoolean(bl), BooleanUtils.getBoolean(bl2));
        }
    }

    private Dictionary _getValueDictionary() {
        if (this._keyTable == null) {
            this._keyTable = new Hashtable(11);
        }
        return this._keyTable;
    }

    private Dictionary _getDefaultsDictionary() {
        if (this._defaultsTable == null) {
            this._defaultsTable = new Hashtable(7);
        }
        return this._defaultsTable;
    }
}

