/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.wizard.AccessibleLWComponent;
import oracle.bali.ewt.wizard.WizardPage;

public class ImageWizardPage
extends WizardPage {
    private static final ImageVersionDetails[] _sImageVersionDetails = new ImageVersionDetails[]{new ImageVersionDetails(new Color(51, 102, 153), new Color(102, 153, 204), 96, 120, 200), new ImageVersionDetails(new Color(51, 102, 153), new Color(153, 204, 255), 120, 120, 200), new ImageVersionDetails(new Color(64, 96, 128), new Color(96, 160, 192), 120, 120, 200){

        public boolean isImageOfThisVersion(Image image) {
            if (Toolkit.getDefaultToolkit().getColorModel().getPixelSize() != 8) {
                return false;
            }
            return super.isImageOfThisVersion(image);
        }
    }};
    private static final Border _sInteractiveBorder = new EmptyBorder(0, 16, 0, 0);
    private static final Border _sContentBorder = new EmptyBorder(10, 10, 10, 10);
    private static final LWComponent _sImageObserver = new LWComponent();
    private static final int _sNullImgWidth = 120;
    private static final int _sNullImgHeight = 200;
    private ColorStrip _imageCanvas;
    private JComponent _interactiveComponent;
    private Component _interactiveArea;

    public ImageWizardPage() {
        this(null, null, "");
    }

    public ImageWizardPage(Component component, Image image, String string) {
        super(new AccessibleLWComponent(), string);
        this._imageCanvas = new ColorStrip(image);
        this._interactiveComponent = new AccessibleLWComponent();
        this._interactiveComponent.setLayout(new BorderLayout());
        this._interactiveComponent.setBorder(_sInteractiveBorder);
        this.setInteractiveArea(component);
        AccessibleLWComponent accessibleLWComponent = (AccessibleLWComponent)this.getContent();
        accessibleLWComponent.setBorder(_sContentBorder);
        accessibleLWComponent.setLayout(new BorderLayout());
        accessibleLWComponent.add((Component)this._imageCanvas, "West");
        accessibleLWComponent.add((Component)this._interactiveComponent, "Center");
    }

    public Image getImage() {
        return this._imageCanvas.getImage();
    }

    public void setImage(Image image) {
        this._imageCanvas.setImage(image);
    }

    public Component getInteractiveArea() {
        return this._interactiveArea;
    }

    public void setInteractiveArea(Component component) {
        Component component2 = this._interactiveArea;
        if (component2 == component) {
            return;
        }
        if (component2 != null) {
            this._interactiveComponent.remove(component2);
        }
        this._interactiveArea = component;
        if (component != null) {
            this._interactiveComponent.add(component, "Center");
        }
    }

    private static class ImageVersionDetails {
        private Color _topColor;
        private Color _bottomColor;
        private int _stripWidth;
        private int _imageWidth;
        private int _imageHeight;

        ImageVersionDetails(Color color, Color color2, int n, int n2, int n3) {
            this._topColor = color;
            this._bottomColor = color2;
            this._stripWidth = n;
            this._imageWidth = n2;
            this._imageHeight = n3;
        }

        public Color getTopColor() {
            return this._topColor;
        }

        public Color getBottomColor() {
            return this._bottomColor;
        }

        public int getStripWidth() {
            return this._stripWidth;
        }

        public int getUISpecImageHeight() {
            return this._imageHeight;
        }

        public int getUISpecImageWidth() {
            return this._imageWidth;
        }

        public boolean isImageOfThisVersion(Image image) {
            boolean bl;
            if (image == null) {
                return false;
            }
            int n = image.getWidth(_sImageObserver);
            int n2 = image.getHeight(_sImageObserver);
            boolean bl2 = bl = n == this.getUISpecImageWidth() && n2 == this.getUISpecImageHeight();
            if (!bl) {
                return false;
            }
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, nArray, 0, n);
            PixelGrabber pixelGrabber2 = new PixelGrabber(image, 0, n2 - 1, 1, 1, nArray2, 0, n);
            try {
                pixelGrabber.grabPixels();
                pixelGrabber2.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return nArray[0] == this.getTopColor().getRGB() && nArray2[0] == this.getBottomColor().getRGB();
        }
    }

    private class ColorStrip
    extends AccessibleLWComponent {
        private ImageVersionDetails _imageVersionDetails;
        private Image _image;

        public ColorStrip(Image image) {
            this._image = image;
            this._imageVersionDetails = this._getImageVersionDetails();
        }

        public Dimension getPreferredSize() {
            if (this._image == null) {
                return new Dimension(120, 200);
            }
            return this._imageVersionDetails == null ? new Dimension(this._image.getWidth(this), this._image.getHeight(this)) : new Dimension(this._imageVersionDetails.getUISpecImageWidth(), this._imageVersionDetails.getUISpecImageHeight());
        }

        public void setImage(Image image) {
            this._image = image;
            this._imageVersionDetails = this._getImageVersionDetails();
        }

        public Image getImage() {
            return this._image;
        }

        protected void paintComponent(Graphics graphics) {
            int n;
            if (this._image == null) {
                return;
            }
            Dimension dimension = this.getSize();
            if (this._imageVersionDetails != null) {
                graphics.setColor(this._imageVersionDetails.getTopColor());
                graphics.fillRect(0, 0, this._imageVersionDetails.getStripWidth(), dimension.height / 2);
                graphics.setColor(this._imageVersionDetails.getBottomColor());
                graphics.fillRect(0, dimension.height / 2, this._imageVersionDetails.getStripWidth(), dimension.height / 2);
                n = this._imageVersionDetails.getUISpecImageHeight();
            } else {
                n = this._image.getHeight(this);
            }
            int n2 = dimension.height / 2 - n / 2;
            graphics.drawImage(this._image, 0, n2, this);
        }

        private ImageVersionDetails _getImageVersionDetails() {
            if (this._image != null) {
                int n = 0;
                while (n < _sImageVersionDetails.length) {
                    if (_sImageVersionDetails[n].isImageOfThisVersion(this._image)) {
                        return _sImageVersionDetails[n];
                    }
                    ++n;
                }
            }
            return null;
        }
    }
}

