/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.util;

import java.awt.event.InputEvent;

public final class InputEventUtils {
    public static final int ALT_GRAPH_MASK = 32;
    public static final int SHIFT_DOWN_MASK = 64;
    public static final int CTRL_DOWN_MASK = 128;
    public static final int META_DOWN_MASK = 256;
    public static final int ALT_DOWN_MASK = 512;
    public static final int BUTTON1_DOWN_MASK = 1024;
    public static final int BUTTON2_DOWN_MASK = 2048;
    public static final int BUTTON3_DOWN_MASK = 4096;
    public static final int BUTTON1_CHANGED_MASK = 8192;
    public static final int BUTTON2_CHANGED_MASK = 16384;
    public static final int BUTTON3_CHANGED_MASK = 32768;

    public static final int getMods(InputEvent inputEvent) {
        return InputEventUtils._filterModifiers(inputEvent.getModifiers());
    }

    private static final int _filterModifiers(int n) {
        if ((n & 0x40) != 0) {
            n &= 0xFFFFFFBF;
            n |= 1;
        }
        if ((n & 0x100) != 0) {
            n &= 0xFFFFFEFF;
            n |= 4;
        }
        if ((n & 0x200) != 0) {
            n &= 0xFFFFFDFF;
            n |= 8;
        }
        if ((n & 0x80) != 0) {
            n &= 0xFFFFFF7F;
            n |= 2;
        }
        if ((n & 0x400) != 0) {
            n &= 0xFFFFFBFF;
            n |= 0x10;
        }
        if ((n & 0x800) != 0) {
            n &= 0xFFFFF7FF;
            n |= 8;
        }
        if ((n & 0x1000) != 0) {
            n &= 0xFFFFEFFF;
            n |= 4;
        }
        n &= 0xFFFFDFFF;
        n &= 0xFFFFBFFF;
        return n &= 0xFFFF7FFF;
    }

    private InputEventUtils() {
    }
}

