/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.HashSet;
import javax.swing.DefaultFocusManager;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;

public final class FocusUtils {
    private static boolean _sJDK14orHigher = false;
    private static Method _sSetFocusTraversalKeysEnabled;
    private static Method _sIsFocusable;
    private static Method _sSetFocusable;
    private static Method _sRequestFocusInWindow;
    private static Method _sFocusEventOppComp;
    private static Method _sPeerIsFocusable;
    static /* synthetic */ Class class$java$awt$Window;
    static /* synthetic */ Class class$java$awt$Container;
    static /* synthetic */ Class class$java$awt$Component;
    static /* synthetic */ Class class$java$awt$event$FocusEvent;
    static /* synthetic */ Class class$java$awt$peer$ComponentPeer;

    public static final boolean areNewFocusAPIsAvailable() {
        return _sJDK14orHigher;
    }

    public static final Component getMostRecentFocusOwner(Window window) {
        Component component = null;
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            try {
                Method method = (class$java$awt$Window == null ? (class$java$awt$Window = FocusUtils.class$("java.awt.Window")) : class$java$awt$Window).getMethod("getMostRecentFocusOwner", null);
                component = (Component)method.invoke((Object)window, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return component;
    }

    public static final void transferFocus(Component component, boolean bl) {
        boolean bl2 = bl;
        if (!bl) {
            if (FocusUtils.areNewFocusAPIsAvailable()) {
                try {
                    Class<?> clazz = component.getClass();
                    Method method = clazz.getMethod("transferFocusBackward", null);
                    method.invoke((Object)component, null);
                }
                catch (Exception exception) {
                    bl2 = true;
                }
            } else {
                bl2 = true;
            }
        }
        if (bl2) {
            component.transferFocus();
        }
    }

    public static final boolean isFocusable(Component component) {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            try {
                Method method = FocusUtils._getIsFocusableMethod();
                Object object = method.invoke((Object)component, null);
                return Boolean.TRUE.equals(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return component.isFocusTraversable();
    }

    public static final void setFocusable(Component component, boolean bl) {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            try {
                Method method = FocusUtils._getSetFocusableMethod();
                Object[] objectArray = new Object[]{new Boolean(bl)};
                Object object = method.invoke((Object)component, objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void setFocusTraversalKeysEnabled(Component component, boolean bl) {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            try {
                Method method = FocusUtils._getFocusTraversalMethod();
                Object[] objectArray = new Object[]{new Boolean(bl)};
                method.invoke((Object)component, objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setFocusTraversalKeysEnabled(Component component, boolean bl, boolean bl2) {
        FocusUtils.setFocusTraversalKeysEnabled(component, bl);
        if (bl2 && FocusUtils.areNewFocusAPIsAvailable() && component instanceof Container) {
            Container container = (Container)component;
            int n = 0;
            while (n < container.getComponentCount()) {
                FocusUtils.setFocusTraversalKeysEnabled(container.getComponent(n), bl, bl2);
                ++n;
            }
        }
    }

    public static void requestFocus(Component component) {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            try {
                Method method = FocusUtils._getRequestFocusInWindowMethod();
                method.invoke((Object)component, null);
            }
            catch (Exception exception) {
                component.requestFocus();
            }
        } else {
            component.requestFocus();
        }
    }

    public static final Component getFirstFocusableComponent(Container container) {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            try {
                GenericDeclaration genericDeclaration;
                Class[] classArray;
                Method method = (class$java$awt$Container == null ? (class$java$awt$Container = FocusUtils.class$("java.awt.Container")) : class$java$awt$Container).getMethod("getFocusTraversalPolicy", null);
                Object object = method.invoke((Object)container, null);
                if (object == null && (classArray = ((Method)(genericDeclaration = (class$java$awt$Component == null ? (class$java$awt$Component = FocusUtils.class$("java.awt.Component")) : class$java$awt$Component).getMethod("getFocusCycleRootAncestor", null))).invoke(container, null)) != null) {
                    object = method.invoke((Object)classArray, null);
                }
                if (object != null) {
                    genericDeclaration = Class.forName("java.awt.FocusTraversalPolicy");
                    classArray = new Class[]{class$java$awt$Container == null ? (class$java$awt$Container = FocusUtils.class$("java.awt.Container")) : class$java$awt$Container};
                    Method method2 = ((Class)genericDeclaration).getMethod("getFirstComponent", classArray);
                    Object[] objectArray = new Object[]{container};
                    Object object2 = method2.invoke(object, objectArray);
                    return (Component)object2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return FocusUtils._getFirstFocusableComponentOLD(container);
    }

    public static Component getOppositeComponent(FocusEvent focusEvent) {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            try {
                Method method = FocusUtils._getFocusEventOppCompMethod();
                if (method != null) {
                    return (Component)method.invoke((Object)focusEvent, null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean getAcceptsFocus(Component component) {
        Object object;
        Object object2;
        boolean bl;
        boolean bl2 = bl = component.isVisible() && component.isEnabled() && FocusUtils.isFocusable(component) && component.isDisplayable();
        if (!bl || !FocusUtils.areNewFocusAPIsAvailable()) {
            return bl;
        }
        if (!(component instanceof Window)) {
            object2 = component.getParent();
            while (object2 != null) {
                if (!((Component)object2).isEnabled() && !((Component)object2).isLightweight()) {
                    return false;
                }
                if (object2 instanceof Window) break;
                object2 = ((Component)object2).getParent();
            }
        }
        if (component instanceof JTable) {
            return true;
        }
        if (component instanceof JComboBox) {
            object2 = (JComboBox)component;
            return ((JComboBox)object2).getUI().isFocusTraversable((JComboBox<?>)object2);
        }
        if (component instanceof JComponent) {
            object2 = (JComponent)component;
            object = ((JComponent)object2).getInputMap(0);
            while (object != null && ((InputMap)object).size() == 0) {
                object = ((InputMap)object).getParent();
            }
            if (object != null) {
                return true;
            }
        }
        object2 = component.getPeer();
        object = FocusUtils._getPeerIsFocusableMethod();
        if (object2 != null && object != null) {
            try {
                Boolean bl3 = (Boolean)((Method)object).invoke(object2, null);
                return bl && Boolean.TRUE.equals(bl3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static Method _getFocusTraversalMethod() {
        if (_sSetFocusTraversalKeysEnabled == null) {
            try {
                Class clazz = class$java$awt$Component == null ? (class$java$awt$Component = FocusUtils.class$("java.awt.Component")) : class$java$awt$Component;
                Class[] classArray = new Class[]{Boolean.TYPE};
                _sSetFocusTraversalKeysEnabled = clazz.getMethod("setFocusTraversalKeysEnabled", classArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _sSetFocusTraversalKeysEnabled;
    }

    private static Method _getSetFocusableMethod() {
        if (_sSetFocusable == null) {
            try {
                Class clazz = class$java$awt$Component == null ? (class$java$awt$Component = FocusUtils.class$("java.awt.Component")) : class$java$awt$Component;
                Class[] classArray = new Class[]{Boolean.TYPE};
                _sSetFocusable = clazz.getMethod("setFocusable", classArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _sSetFocusable;
    }

    private static Method _getIsFocusableMethod() {
        if (_sIsFocusable == null) {
            try {
                Class clazz = class$java$awt$Component == null ? (class$java$awt$Component = FocusUtils.class$("java.awt.Component")) : class$java$awt$Component;
                _sIsFocusable = clazz.getMethod("isFocusable", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _sIsFocusable;
    }

    private static Method _getRequestFocusInWindowMethod() {
        if (_sRequestFocusInWindow == null) {
            try {
                Class clazz = class$java$awt$Component == null ? (class$java$awt$Component = FocusUtils.class$("java.awt.Component")) : class$java$awt$Component;
                _sRequestFocusInWindow = clazz.getMethod("requestFocusInWindow", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _sRequestFocusInWindow;
    }

    private static final Component _getFirstFocusableComponentOLD(Container container) {
        Component component;
        Container container2 = null;
        if (container != null && container.isEnabled() && container.isVisible() && FocusUtils.isFocusable(container)) {
            return container;
        }
        container2 = container;
        Component component2 = component = container2.getComponentCount() == 0 ? null : container2.getComponent(0);
        if (component == null) {
            return null;
        }
        DefaultFocusManager defaultFocusManager = new DefaultFocusManager();
        HashSet<Component> hashSet = new HashSet<Component>();
        while ((component = FocusUtils.getNextComponent(component, container2, true, defaultFocusManager)) != null) {
            if (!hashSet.add(component)) {
                component = null;
                break;
            }
            if (!component.isVisible() || !FocusUtils.isFocusable(component) || !component.isEnabled()) continue;
        }
        return component;
    }

    private static Component getNextComponent(Component component, Container container, boolean bl, DefaultFocusManager defaultFocusManager) {
        Component component2 = null;
        if (bl && component.isVisible() && (!(component instanceof JComponent) || !((JComponent)component).isManagingFocus()) && component instanceof Container && ((Container)component).getComponentCount() > 0) {
            return defaultFocusManager.getFirstComponent((Container)component);
        }
        Container container2 = component.getParent();
        component2 = defaultFocusManager.getComponentAfter(container2, component);
        if (component2 != null) {
            return component2;
        }
        if (container2 == container) {
            return container;
        }
        return FocusUtils.getNextComponent(container2, container, false, defaultFocusManager);
    }

    private static Method _getFocusEventOppCompMethod() {
        if (_sFocusEventOppComp == null) {
            try {
                _sFocusEventOppComp = (class$java$awt$event$FocusEvent == null ? (class$java$awt$event$FocusEvent = FocusUtils.class$("java.awt.event.FocusEvent")) : class$java$awt$event$FocusEvent).getMethod("getOppositeComponent", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _sFocusEventOppComp;
    }

    private static Method _getPeerIsFocusableMethod() {
        if (_sPeerIsFocusable == null) {
            try {
                _sPeerIsFocusable = (class$java$awt$peer$ComponentPeer == null ? (class$java$awt$peer$ComponentPeer = FocusUtils.class$("java.awt.peer.ComponentPeer")) : class$java$awt$peer$ComponentPeer).getMethod("isFocusable", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _sPeerIsFocusable;
    }

    private FocusUtils() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("java.awt.KeyboardFocusManager");
            _sJDK14orHigher = true;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        _sSetFocusTraversalKeysEnabled = null;
        _sIsFocusable = null;
        _sSetFocusable = null;
        _sRequestFocusInWindow = null;
        _sFocusEventOppComp = null;
        _sPeerIsFocusable = null;
    }
}

