/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderEvent;
import oracle.bali.ewt.header.HeaderMoveListener;
import oracle.bali.ewt.header.HeaderResizeListener;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;

final class TableHeaderAdapter
implements HeaderMoveListener,
HeaderResizeListener,
PropertyChangeListener {
    private int _oldIndex;
    private SpreadTable _table;
    private Header _header;
    boolean _originatingSelectionChange;

    public TableHeaderAdapter(SpreadTable spreadTable, Header header) {
        this._table = spreadTable;
        this._header = header;
    }

    public void dispose() {
        this._table = null;
        this._header = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("focusItem".equals(string)) {
            int n = this._header.getFocusItem();
            Cell cell = this._table.getGrid().getFocusCell();
            if (n != -1 && cell != null) {
                if (this._header.getOrientation() == 0) {
                    this._table.getGrid().requestFocus(n, cell.row, null);
                } else {
                    this._table.getGrid().requestFocus(cell.column, n, null);
                }
            }
        } else if ("selection".equals(string) && !this._table.getGridAdapter().originatingSelectionChange()) {
            Grid grid = this._table.getGrid();
            GridSelectionManager gridSelectionManager = grid.getGridSelectionManager();
            OneDSelection oneDSelection = (OneDSelection)propertyChangeEvent.getNewValue();
            try {
                grid.freezeRepaints();
                grid.commitCellEdit();
                TwoDSelection twoDSelection = this._header.getOrientation() == 0 ? new TwoDSelection(oneDSelection, null) : new TwoDSelection(null, oneDSelection);
                try {
                    this._originatingSelectionChange = true;
                    gridSelectionManager.setSelection(twoDSelection, null);
                    this._originatingSelectionChange = false;
                }
                catch (PropertyVetoException propertyVetoException) {
                }
                Object var9_10 = null;
                grid.unfreezeRepaints();
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                grid.unfreezeRepaints();
                throw throwable;
            }
        }
    }

    public void itemMoving(HeaderEvent headerEvent) {
        int n = headerEvent.getHeaderItem();
        boolean bl = TableHeaderAdapter._isHorizontal(this._header) ? this._table.fireCancelableColumnEvent(2007, n) : this._table.fireCancelableRowEvent(2009, n);
        if (bl) {
            ((Cancelable)((Object)headerEvent)).cancel();
        }
    }

    public void itemMoved(HeaderEvent headerEvent) {
        this._table.getGrid().commitCellEdit();
        int n = headerEvent.getHeaderItem();
        int n2 = this._header.getItemVisibleIndex(n);
        if (TableHeaderAdapter._isHorizontal(this._header)) {
            this._table.getGrid().setColumnVisibleIndex(n, n2);
            this._table.fireColumnEvent(2008, n);
        } else {
            this._table.getGrid().setRowVisibleIndex(n, n2);
            this._table.fireRowEvent(2010, n);
        }
    }

    public void itemResizing(HeaderEvent headerEvent) {
        int n = headerEvent.getHeaderItem();
        boolean bl = TableHeaderAdapter._isHorizontal(this._header) ? this._table.fireCancelableColumnEvent(2001, n) : this._table.fireCancelableRowEvent(2003, n);
        if (bl) {
            ((Cancelable)((Object)headerEvent)).cancel();
        }
    }

    public void itemResized(HeaderEvent headerEvent) {
        int n = headerEvent.getHeaderItem();
        if (TableHeaderAdapter._isHorizontal(this._header)) {
            this._table.fireColumnEvent(2002, n);
        } else {
            this._table.fireRowEvent(2004, n);
        }
    }

    boolean originatingSelectionChange() {
        return this._originatingSelectionChange;
    }

    private static boolean _isHorizontal(Header header) {
        return header.getOrientation() == 0;
    }
}

