/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.grid.GridEditListener;
import oracle.bali.ewt.grid.GridEvent;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderSelectionManager;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.table.TableHeaderAdapter;

final class TableGridAdapter
implements GridEditListener,
PropertyChangeListener,
VetoableChangeListener {
    private SpreadTable _table;
    private boolean _originatingSelectionChange;

    public TableGridAdapter(SpreadTable spreadTable) {
        this._table = spreadTable;
    }

    public void dispose() {
        this._table = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("focusCell".equals(string)) {
            Cell cell = this._table.getGrid().getFocusCell();
            if (cell != null) {
                if (this._table.getColumnHeader() != null) {
                    this._table.getColumnHeader().setFocusItem(cell.column);
                }
                if (this._table.getRowHeader() != null) {
                    this._table.getRowHeader().setFocusItem(cell.row);
                }
            }
        } else if ("selection".equals(string)) {
            Header header = this._table.getRowHeader();
            Header header2 = this._table.getColumnHeader();
            TwoDSelection twoDSelection = (TwoDSelection)propertyChangeEvent.getNewValue();
            OneDSelection oneDSelection = twoDSelection.getRowSelection();
            OneDSelection oneDSelection2 = twoDSelection.getColumnSelection();
            try {
                HeaderSelectionManager headerSelectionManager;
                this._originatingSelectionChange = true;
                TableHeaderAdapter tableHeaderAdapter = this._table.getRowHeaderAdapter();
                TableHeaderAdapter tableHeaderAdapter2 = this._table.getColumnHeaderAdapter();
                if (header != null && !tableHeaderAdapter.originatingSelectionChange()) {
                    headerSelectionManager = header.getHeaderSelectionManager();
                    headerSelectionManager.setSelection(oneDSelection, -1);
                }
                if (header2 != null && !tableHeaderAdapter2.originatingSelectionChange()) {
                    headerSelectionManager = header2.getHeaderSelectionManager();
                    headerSelectionManager.setSelection(oneDSelection2, -1);
                }
                this._originatingSelectionChange = false;
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        this._table.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        this._table.fireVetoableChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
    }

    public void cellEditing(GridEvent gridEvent) {
        if (this._table.fireCancelableCellEvent(2005, gridEvent.getColumn(), gridEvent.getRow())) {
            ((Cancelable)((Object)gridEvent)).cancel();
        }
    }

    public void cellEdited(GridEvent gridEvent) {
        this._table.fireCellEvent(2006, gridEvent.getColumn(), gridEvent.getRow());
    }

    boolean originatingSelectionChange() {
        return this._originatingSelectionChange;
    }
}

