/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.table;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.elaf.EWTTableUI;
import oracle.bali.ewt.geometry.GeometryManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.print.PrinterUtils;
import oracle.bali.ewt.scrolling.EWTScrollPane;
import oracle.bali.ewt.scrolling.ScrollableComponent;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.DummyPanel;
import oracle.bali.ewt.table.TableEditListener;
import oracle.bali.ewt.table.TableEvent;
import oracle.bali.ewt.table.TableGeometryManager;
import oracle.bali.ewt.table.TableGridAdapter;
import oracle.bali.ewt.table.TableHeaderAdapter;
import oracle.bali.ewt.table.TableLayoutManager;
import oracle.bali.ewt.table.TableMoveListener;
import oracle.bali.ewt.table.TableResizeListener;
import oracle.bali.ewt.table.TableValidateEvent;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.nls.LocaleUtils;

public class SpreadTable
extends ScrollableComponent
implements Accessible {
    public static final Object DUPLICATE_COLUMN_HEADERS = "table.dupColHeaders";
    public static final Object DUPLICATE_ROW_HEADERS = "table.dupRowHeaders";
    public static final Object DISPLAY_COLUMN_HEADERS = "table.dispColHeaders";
    public static final Object DISPLAY_ROW_HEADERS = "table.dispRowHeaders";
    public static final Object PRINT_RAISED = "spreadTable.printRaised";
    public static final String PROPERTY_FOCUSCELL = "focusCell";
    public static final String PROPERTY_SELECTION = "selection";
    static final String _RESOURCE_BUNDLE = "oracle.bali.ewt.resource.AccessibilityBundle";
    static final String _SELECT_ALL_KEY = "SELECT_ALL";
    private Header _columnHeader;
    private Header _rowHeader;
    private Component[] _corners = new Component[4];
    private Grid _grid;
    private boolean _displayRowHeader;
    private boolean _displayColumnHeader;
    private int _columnHeaderHeight = -1;
    private int _rowHeaderWidth = -1;
    private ListenerManager _cellSelectListeners;
    private ListenerManager _colSelectListeners;
    private ListenerManager _rowSelectListeners;
    private ListenerManager _focusListeners;
    private ListenerManager _editListeners;
    private ListenerManager _resizeListeners;
    private ListenerManager _moveListeners;
    private ContainerListener _containerListener;
    private ChangeListener _hHeaderListener;
    private ChangeListener _vHeaderListener;
    private ChangeListener _editListener;
    private JScrollPane _scrollPane;
    private boolean _drawRaised = true;
    private TableHeaderAdapter _columnHeaderAdapter;
    private TableHeaderAdapter _rowHeaderAdapter;
    private TableGridAdapter _gridAdapter;
    private static String[] _scrollPaneKeys = new String[]{"LOWER_LEFT_CORNER", "LOWER_RIGHT_CORNER", "UPPER_LEFT_CORNER", "UPPER_RIGHT_CORNER"};

    public SpreadTable() {
        this(null, null, null);
    }

    public SpreadTable(TwoDModel twoDModel, OneDModel oneDModel, OneDModel oneDModel2) {
        TableGeometryManager tableGeometryManager;
        GeometryManager geometryManager;
        super.setLayout(this.createLayoutManager());
        this._grid = this.createGrid(twoDModel);
        if (oneDModel == null) {
            this._displayColumnHeader = false;
        } else {
            this._columnHeader = this.createColumnHeader(oneDModel);
            geometryManager = this._grid.getColumnGeometryManager();
            tableGeometryManager = new TableGeometryManager(geometryManager);
            this._columnHeader.setGeometryManager(tableGeometryManager);
            this._columnHeaderAdapter = new TableHeaderAdapter(this, this._columnHeader);
            this._columnHeader.addResizeListener(this._columnHeaderAdapter);
            this._columnHeader.addMoveListener(this._columnHeaderAdapter);
            this._columnHeader.addPropertyChangeListener(this._columnHeaderAdapter);
            this._displayColumnHeader = true;
            this.add("columnHeader", this._columnHeader);
        }
        if (oneDModel2 == null) {
            this._displayRowHeader = false;
        } else {
            this._rowHeader = this.createRowHeader(oneDModel2);
            geometryManager = this._grid.getRowGeometryManager();
            tableGeometryManager = new TableGeometryManager(geometryManager);
            this._rowHeader.setGeometryManager(tableGeometryManager);
            this._rowHeaderAdapter = new TableHeaderAdapter(this, this._rowHeader);
            this._rowHeader.addResizeListener(this._rowHeaderAdapter);
            this._rowHeader.addMoveListener(this._rowHeaderAdapter);
            this._rowHeader.addPropertyChangeListener(this._rowHeaderAdapter);
            this._displayRowHeader = true;
            this.add("rowHeader", this._rowHeader);
        }
        this._gridAdapter = new TableGridAdapter(this);
        this._grid.addPropertyChangeListener(this._gridAdapter);
        this._grid.addVetoableChangeListener(this._gridAdapter);
        this._grid.addEditListener(this._gridAdapter);
        this._grid.setDrawFocusCellHighlite(true);
        this.add("grid", this._grid);
        this._editListener = new EditListener();
        long l = 20L;
        this.enableEvents(l);
        this.updateUI();
    }

    public void dispose() {
        if (this._grid == null) {
            return;
        }
        if (this._columnHeaderAdapter != null) {
            this._columnHeader.removeResizeListener(this._columnHeaderAdapter);
            this._columnHeader.removeMoveListener(this._columnHeaderAdapter);
            this._columnHeader.removePropertyChangeListener(this._columnHeaderAdapter);
            this._columnHeaderAdapter.dispose();
        }
        if (this._rowHeaderAdapter != null) {
            this._rowHeader.removeResizeListener(this._rowHeaderAdapter);
            this._rowHeader.removeMoveListener(this._rowHeaderAdapter);
            this._rowHeader.removePropertyChangeListener(this._rowHeaderAdapter);
            this._rowHeaderAdapter.dispose();
        }
        this._grid.removePropertyChangeListener(this._gridAdapter);
        this._grid.removeVetoableChangeListener(this._gridAdapter);
        this._grid.removeEditListener(this._gridAdapter);
        this._gridAdapter.dispose();
        this._columnHeaderAdapter = null;
        this._rowHeaderAdapter = null;
        this._gridAdapter = null;
        this._cellSelectListeners = null;
        this._colSelectListeners = null;
        this._rowSelectListeners = null;
        this._focusListeners = null;
        this._editListeners = null;
        this._resizeListeners = null;
        this._moveListeners = null;
        this._grid.dispose();
        this._grid = null;
        if (this._columnHeader != null) {
            this._columnHeader.dispose();
        }
        this._columnHeader = null;
        if (this._rowHeader != null) {
            this._rowHeader.dispose();
        }
        this._rowHeader = null;
        int n = 0;
        while (n < this._corners.length) {
            this._corners[n] = null;
            ++n;
        }
        this._clearScrollPane();
        this.removeAll();
        this.setLayout(null);
        this.setUI(null);
    }

    public void setFocusCell(Cell cell) {
        this.getGrid().setFocusCell(cell);
    }

    public Cell getFocusCell() {
        return this.getGrid().getFocusCell();
    }

    public void setSelection(TwoDSelection twoDSelection) throws PropertyVetoException {
        this.getGrid().setSelection(twoDSelection);
    }

    public TwoDSelection getSelection() {
        return this.getGrid().getSelection();
    }

    public void selectAll() throws PropertyVetoException {
        this.getGrid().selectAll();
    }

    public void deselectAll() throws PropertyVetoException {
        this.getGrid().deselectAll();
    }

    public void setDrawRaised(boolean bl) {
        if (this._drawRaised != bl) {
            this._drawRaised = bl;
            this.repaint();
        }
    }

    public boolean getDrawRaised() {
        return this._drawRaised;
    }

    public void setColumnGeometryManager(GeometryManager geometryManager) {
        Grid grid = this.getGrid();
        grid.setColumnGeometryManager(geometryManager);
        Header header = this.getColumnHeader();
        if (header != null) {
            header.setGeometryManager(new TableGeometryManager(grid.getColumnGeometryManager()));
        }
    }

    public GeometryManager getColumnGeometryManager() {
        return this.getGrid().getColumnGeometryManager();
    }

    public void setRowGeometryManager(GeometryManager geometryManager) {
        Grid grid = this.getGrid();
        grid.setRowGeometryManager(geometryManager);
        Header header = this.getRowHeader();
        if (header != null) {
            header.setGeometryManager(new TableGeometryManager(grid.getRowGeometryManager()));
        }
    }

    public GeometryManager getRowGeometryManager() {
        return this.getGrid().getRowGeometryManager();
    }

    public void updateUI() {
        Header header;
        this.setUI((EWTTableUI)UIManager.getUI(this));
        Header header2 = this.getColumnHeader();
        if (header2 != null && this._scrollPane != null && !this.isColumnHeaderVisible()) {
            ((JComponent)header2).updateUI();
        }
        if ((header = this.getRowHeader()) != null && this._scrollPane != null && !this.isRowHeaderVisible()) {
            ((JComponent)header).updateUI();
        }
    }

    public String getUIClassID() {
        return "EWTTableUI";
    }

    public synchronized void addEditListener(TableEditListener tableEditListener) {
        if (this._editListeners == null) {
            this._editListeners = new ListenerManager();
        }
        this._editListeners.addListener(tableEditListener);
    }

    public synchronized void removeEditListener(TableEditListener tableEditListener) {
        if (this._editListeners != null) {
            this._editListeners.removeListener(tableEditListener);
        }
    }

    public synchronized void addResizeListener(TableResizeListener tableResizeListener) {
        if (this._resizeListeners == null) {
            this._resizeListeners = new ListenerManager();
        }
        this._resizeListeners.addListener(tableResizeListener);
    }

    public synchronized void removeResizeListener(TableResizeListener tableResizeListener) {
        if (this._resizeListeners != null) {
            this._resizeListeners.removeListener(tableResizeListener);
        }
    }

    public synchronized void addMoveListener(TableMoveListener tableMoveListener) {
        if (this._moveListeners == null) {
            this._moveListeners = new ListenerManager();
        }
        this._moveListeners.addListener(tableMoveListener);
    }

    public synchronized void removeMoveListener(TableMoveListener tableMoveListener) {
        if (this._moveListeners != null) {
            this._moveListeners.removeListener(tableMoveListener);
        }
    }

    public int getOnScreenRowCount() {
        return this._grid.getOnScreenRowCount();
    }

    public int getOnScreenColumnCount() {
        return this._grid.getOnScreenColumnCount();
    }

    public int getFirstRowOnScreen() {
        return this._grid.getFirstRowOnScreen();
    }

    public void setFirstRowOnScreen(int n) {
        this._grid.setFirstRowOnScreen(n);
        if (this.isRowHeaderVisible()) {
            this._rowHeader.setFirstItemOnScreen(n);
        }
        if (this._scrollPane != null) {
            int n2;
            int n3 = this.getGrid().getRowPosition(n);
            int n4 = this.getRowGeometryManager().getTotalSize();
            if (n4 - n3 < (n2 = this.getGrid().getInnerHeight())) {
                n3 = n4 - n2;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            JViewport jViewport = this._scrollPane.getViewport();
            Point point = jViewport.getViewPosition();
            point.y = n3;
            jViewport.setViewPosition(point);
            jViewport = this._scrollPane.getRowHeader();
            if (jViewport != null) {
                point = jViewport.getViewPosition();
                point.y = n3;
                jViewport.setViewPosition(point);
            }
        }
    }

    public int getFirstColumnOnScreen() {
        return this._grid.getFirstColumnOnScreen();
    }

    public void setFirstColumnOnScreen(int n) {
        this._grid.setFirstColumnOnScreen(n);
        if (this.isColumnHeaderVisible()) {
            this._columnHeader.setFirstItemOnScreen(n);
        }
        if (this._scrollPane != null) {
            int n2;
            int n3 = this.getGrid().getColumnPosition(n);
            int n4 = this.getColumnGeometryManager().getTotalSize();
            if (n4 - n3 < (n2 = this.getGrid().getInnerWidth())) {
                n3 = n4 - n2;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            JViewport jViewport = this._scrollPane.getViewport();
            Point point = jViewport.getViewPosition();
            point.x = n3;
            jViewport.setViewPosition(point);
            jViewport = this._scrollPane.getColumnHeader();
            if (jViewport != null) {
                point = jViewport.getViewPosition();
                point.x = n3;
                jViewport.setViewPosition(point);
            }
        }
    }

    public Grid getGrid() {
        return this._grid;
    }

    public void setRowHeaderVisible(boolean bl) {
        if (bl && this._rowHeader == null) {
            throw new IllegalStateException("rowHeader does not have a OneDModel.");
        }
        if (this.isRowHeaderVisible() != bl) {
            this._displayRowHeader = bl;
            this._updateLayout();
            this.revalidate();
        }
    }

    public boolean isRowHeaderVisible() {
        return this._displayRowHeader;
    }

    public void setColumnHeaderVisible(boolean bl) {
        if (bl && this._columnHeader == null) {
            throw new IllegalStateException("columnHeader does not have a OneDModel.");
        }
        if (this.isColumnHeaderVisible() != bl) {
            this._displayColumnHeader = bl;
            this._updateLayout();
            this.revalidate();
        }
    }

    public boolean isColumnHeaderVisible() {
        return this._displayColumnHeader;
    }

    public void setColumnHeaderHeight(int n) {
        if (n != this._columnHeaderHeight) {
            this._columnHeaderHeight = n;
            if (this._columnHeader != null) {
                this._columnHeader.setPreferredHeaderSize(this._columnHeaderHeight);
                this.revalidate();
            }
        }
    }

    public int getColumnHeaderHeight() {
        return this._columnHeaderHeight;
    }

    public Header getColumnHeader() {
        return this._columnHeader;
    }

    public void setRowHeaderWidth(int n) {
        if (n != this._rowHeaderWidth) {
            this._rowHeaderWidth = n;
            if (this._rowHeader != null) {
                this._rowHeader.setPreferredHeaderSize(this._rowHeaderWidth);
                this.revalidate();
            }
        }
    }

    public int getRowHeaderWidth() {
        return this._rowHeaderWidth;
    }

    public Header getRowHeader() {
        return this._rowHeader;
    }

    public void setHorizontalSeparatorsVisible(boolean bl) {
        if (this._grid.getHorizontalSeparatorsVisible() != bl) {
            this._grid.setHorizontalSeparatorsVisible(bl);
        }
    }

    public boolean getHorizontalSeparatorsVisible() {
        return this._grid.getHorizontalSeparatorsVisible();
    }

    public void setHorizontalSeparatorPainter(Painter painter) {
        if (this._grid.getHorizontalSeparatorPainter() != painter) {
            this._grid.setHorizontalSeparatorPainter(painter);
        }
    }

    public Painter getHorizontalSeparatorPainter() {
        return this._grid.getHorizontalSeparatorPainter();
    }

    public void setVerticalSeparatorsVisible(boolean bl) {
        if (this._grid.getVerticalSeparatorsVisible() != bl) {
            this._grid.setVerticalSeparatorsVisible(bl);
        }
    }

    public boolean getVerticalSeparatorsVisible() {
        return this._grid.getVerticalSeparatorsVisible();
    }

    public void setVerticalSeparatorPainter(Painter painter) {
        if (this._grid.getVerticalSeparatorPainter() != painter) {
            this._grid.setVerticalSeparatorPainter(painter);
        }
    }

    public Painter getVerticalSeparatorPainter() {
        return this._grid.getVerticalSeparatorPainter();
    }

    public void setDefaultColumnWidth(int n) {
        this._grid.setDefaultColumnWidth(n);
    }

    public int getDefaultColumnWidth() {
        return this._grid.getDefaultColumnWidth();
    }

    public void setDefaultRowHeight(int n) {
        this._grid.setDefaultRowHeight(n);
    }

    public int getDefaultRowHeight() {
        return this._grid.getDefaultRowHeight();
    }

    public synchronized void setColumnVisibleIndex(int n, int n2) {
        if (this._columnHeader != null) {
            this._columnHeader.getGeometryManager().setItemVisibleIndex(n, n2);
        } else {
            this._grid.setColumnVisibleIndex(n, n2);
        }
    }

    public synchronized void setRowVisibleIndex(int n, int n2) {
        if (this._rowHeader != null) {
            this._rowHeader.getGeometryManager().setItemVisibleIndex(n, n2);
        } else {
            this._grid.setRowVisibleIndex(n, n2);
        }
    }

    public void setColumnVisible(int n, boolean bl) {
        if (this._columnHeader != null) {
            this._columnHeader.getGeometryManager().setItemVisible(n, bl);
        } else {
            this._grid.setColumnVisible(n, bl);
        }
    }

    public boolean isColumnVisible(int n) {
        return this._grid.isColumnVisible(n);
    }

    public void setRowVisible(int n, boolean bl) {
        if (this._rowHeader != null) {
            this._rowHeader.getGeometryManager().setItemVisible(n, bl);
        } else {
            this._grid.setRowVisible(n, bl);
        }
    }

    public boolean isRowVisible(int n) {
        return this._grid.isRowVisible(n);
    }

    public void setColumnWidth(int n, int n2) {
        this._grid.setColumnWidth(n, n2);
    }

    public int getColumnWidth(int n) {
        return this._grid.getColumnWidth(n);
    }

    public void setRowHeight(int n, int n2) {
        this._grid.setRowHeight(n, n2);
    }

    public int getRowHeight(int n) {
        return this._grid.getRowHeight(n);
    }

    public void setModels(TwoDModel twoDModel, OneDModel oneDModel, OneDModel oneDModel2) {
        Grid grid = this.getGrid();
        try {
            boolean bl;
            this.freezeRepaints();
            grid.freezeRepaints();
            if (this._columnHeader != null) {
                this._columnHeader.freezeRepaints();
                bl = this.isColumnHeaderVisible() && oneDModel != null;
                this.setColumnHeaderVisible(bl);
                this._columnHeader.setModel(oneDModel);
            } else if (oneDModel != null) {
                this._columnHeader = this.createColumnHeader(oneDModel);
                this._columnHeader.freezeRepaints();
                this._columnHeader.setGeometryManager(new TableGeometryManager(grid.getColumnGeometryManager()));
                this._columnHeaderAdapter = new TableHeaderAdapter(this, this._columnHeader);
                this._columnHeader.addResizeListener(this._columnHeaderAdapter);
                this._columnHeader.addMoveListener(this._columnHeaderAdapter);
                this._columnHeader.addPropertyChangeListener(this._columnHeaderAdapter);
                if (this._scrollPane == null) {
                    this.add("columnHeader", this._columnHeader);
                }
                this._displayColumnHeader = true;
            }
            if (this._rowHeader != null) {
                this._rowHeader.freezeRepaints();
                bl = this.isRowHeaderVisible() && oneDModel2 != null;
                this.setRowHeaderVisible(bl);
                this._rowHeader.setModel(oneDModel2);
            } else if (oneDModel2 != null) {
                this._rowHeader = this.createRowHeader(oneDModel2);
                this._rowHeader.freezeRepaints();
                this._rowHeader.setGeometryManager(new TableGeometryManager(grid.getRowGeometryManager()));
                this._rowHeaderAdapter = new TableHeaderAdapter(this, this._rowHeader);
                this._rowHeader.addResizeListener(this._rowHeaderAdapter);
                this._rowHeader.addMoveListener(this._rowHeaderAdapter);
                this._rowHeader.addPropertyChangeListener(this._rowHeaderAdapter);
                this._displayRowHeader = true;
                if (this._scrollPane == null) {
                    this.add("rowHeader", this._rowHeader);
                }
            }
            grid.setModel(twoDModel);
            Object var7_7 = null;
            if (this._columnHeader != null) {
                this._columnHeader.unfreezeRepaints();
            }
            if (this._rowHeader != null) {
                this._rowHeader.unfreezeRepaints();
            }
            grid.unfreezeRepaints();
            this.unfreezeRepaints();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (this._columnHeader != null) {
                this._columnHeader.unfreezeRepaints();
            }
            if (this._rowHeader != null) {
                this._rowHeader.unfreezeRepaints();
            }
            grid.unfreezeRepaints();
            this.unfreezeRepaints();
            throw throwable;
        }
        AccessibleContext accessibleContext = this.accessibleContext;
        if (accessibleContext != null) {
            ((AccessibleSpreadTable)accessibleContext).updateAccessibleParents();
        }
        this._updateLayout();
        this.revalidate();
    }

    public Dimension getDocumentSize(PaintContext paintContext, Dictionary dictionary) {
        return this.getGrid().getDocumentSize(paintContext, dictionary);
    }

    public void printPage(PaintContext paintContext, Dictionary dictionary, Graphics graphics) {
        Object object;
        Serializable serializable;
        Serializable serializable2;
        Object object2;
        boolean bl;
        int n;
        int n2;
        Shape shape = graphics.getClip();
        Rectangle rectangle = graphics.getClipRect();
        boolean bl2 = PrinterUtils.getPrinterProperty(dictionary, DISPLAY_COLUMN_HEADERS, true) && (rectangle.y == 0 || PrinterUtils.getPrinterProperty(dictionary, DUPLICATE_COLUMN_HEADERS, true));
        boolean bl3 = PrinterUtils.getPrinterProperty(dictionary, DISPLAY_ROW_HEADERS, true) && (rectangle.x == 0 || PrinterUtils.getPrinterProperty(dictionary, DUPLICATE_ROW_HEADERS, true));
        Header header = bl2 && this.isColumnHeaderVisible() ? this.getColumnHeader() : null;
        Header header2 = bl3 && this.isRowHeaderVisible() ? this.getRowHeader() : null;
        int n3 = header2 != null ? this.getRowHeaderWidth() : 0;
        int n4 = n2 = header != null ? this.getColumnHeaderHeight() : 0;
        if (n2 >= rectangle.height) {
            n = rectangle.height / 8;
            n2 = rectangle.height - n;
        }
        if (n3 >= rectangle.width) {
            n = rectangle.width / 8;
            n3 = rectangle.width - n;
        }
        n = this.getDrawRaised() ? 1 : 0;
        boolean bl4 = PrinterUtils.getPrinterProperty(dictionary, PRINT_RAISED, false);
        this.freezeRepaints();
        this.setDrawRaised(bl4);
        rectangle.width -= n3;
        rectangle.height -= n2;
        if (header != null) {
            header.freezeRepaints();
            bl = header.getDrawRaised();
            header.setDrawRaised(bl4);
            object2 = graphics;
            serializable2 = ((Graphics)object2).getColor();
            serializable = ((Graphics)object2).getFont();
            ((Graphics)object2).translate(n3, rectangle.y);
            ((Graphics)object2).setClip(rectangle.x, 0, rectangle.width, n2);
            ((Graphics)object2).setFont(header.getFont());
            ((Graphics)object2).setColor(header.getForeground());
            header.printPage(paintContext, dictionary, (Graphics)object2);
            ((Graphics)object2).translate(-n3, -rectangle.y);
            ((Graphics)object2).setClip(shape);
            ((Graphics)object2).setColor((Color)serializable2);
            ((Graphics)object2).setFont((Font)serializable);
            header.setDrawRaised(bl);
            header.unfreezeRepaints();
        }
        if (header2 != null) {
            header2.freezeRepaints();
            bl = header2.getDrawRaised();
            header2.setDrawRaised(bl4);
            object2 = graphics;
            serializable2 = ((Graphics)object2).getColor();
            serializable = ((Graphics)object2).getFont();
            ((Graphics)object2).translate(rectangle.x, n2);
            ((Graphics)object2).setClip(0, rectangle.y, n3, rectangle.height);
            ((Graphics)object2).setFont(header2.getFont());
            ((Graphics)object2).setColor(header2.getForeground());
            header2.printPage(paintContext, dictionary, (Graphics)object2);
            ((Graphics)object2).translate(-rectangle.x, -n2);
            ((Graphics)object2).setClip(shape);
            ((Graphics)object2).setColor((Color)serializable2);
            ((Graphics)object2).setFont((Font)serializable);
            header2.setDrawRaised(bl);
            header2.unfreezeRepaints();
        }
        if ((object = PrinterUtils.getPrinterProperty(dictionary, Grid.DISPLAY_HORIZONTAL_SEPARATOR, null)) == null) {
            object2 = header == null ? Boolean.TRUE : Boolean.FALSE;
            dictionary.put(Grid.DISPLAY_HORIZONTAL_SEPARATOR, object2);
        }
        if ((object2 = PrinterUtils.getPrinterProperty(dictionary, Grid.DISPLAY_VERTICAL_SEPARATOR, null)) == null) {
            serializable2 = header2 == null ? Boolean.TRUE : Boolean.FALSE;
            dictionary.put(Grid.DISPLAY_VERTICAL_SEPARATOR, serializable2);
        }
        serializable2 = this.getGrid();
        graphics.translate(n3, n2);
        graphics.setClip(rectangle);
        graphics.setFont(((Component)serializable2).getFont());
        graphics.setColor(((Component)serializable2).getForeground());
        ((Grid)serializable2).printPage(paintContext, dictionary, graphics);
        graphics.translate(-n3, -n2);
        serializable = this.getCornerComponent("UPPER_LEFT_CORNER");
        if (serializable != null && n3 != 0 && n2 != 0) {
            graphics.translate(rectangle.x, rectangle.y);
            graphics.setClip(0, 0, n3, n2);
            ((Component)serializable).paint(graphics);
            graphics.translate(-rectangle.x, -rectangle.y);
        }
        graphics.setClip(shape);
        this.setDrawRaised(n != 0);
        this.unfreezeRepaints();
        if (object == null) {
            dictionary.remove(Grid.DISPLAY_HORIZONTAL_SEPARATOR);
        }
        if (object2 == null) {
            dictionary.remove(Grid.DISPLAY_VERTICAL_SEPARATOR);
        }
    }

    public Rectangle getPageBounds(PaintContext paintContext, Dictionary dictionary, int n, int n2, int n3, int n4) {
        int n5;
        boolean bl;
        int n6 = 0;
        int n7 = 0;
        boolean bl2 = bl = PrinterUtils.getPrinterProperty(dictionary, DISPLAY_COLUMN_HEADERS, true) && (n2 == 0 || PrinterUtils.getPrinterProperty(dictionary, DUPLICATE_COLUMN_HEADERS, true));
        if (bl) {
            if (this.isColumnHeaderVisible()) {
                n6 = this.getColumnHeaderHeight();
            }
            if (n6 >= n4) {
                n5 = n4 / 8;
                n6 = n4 - n5;
                n4 = n5;
            } else {
                n4 -= n6;
            }
        }
        int n8 = n5 = PrinterUtils.getPrinterProperty(dictionary, DISPLAY_ROW_HEADERS, true) && (n == 0 || PrinterUtils.getPrinterProperty(dictionary, DUPLICATE_ROW_HEADERS, true)) ? 1 : 0;
        if (n5 != 0) {
            if (this.isRowHeaderVisible()) {
                n7 = this.getRowHeaderWidth();
            }
            if (n7 >= n3) {
                int n9 = n3 / 8;
                n7 = n3 - n9;
                n3 = n9;
            } else {
                n3 -= n7;
            }
        }
        Rectangle rectangle = this.getGrid().getPageBounds(paintContext, dictionary, n, n2, n3, n4);
        rectangle.width += n7;
        rectangle.height += n6;
        return rectangle;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._grid.setEnabled(bl);
        if (this._columnHeader != null) {
            this._columnHeader.setEnabled(bl);
        }
        if (this._rowHeader != null) {
            this._rowHeader.setEnabled(bl);
        }
    }

    protected LayoutManager createLayoutManager() {
        return new TableLayoutManager();
    }

    public void addNotify() {
        super.addNotify();
        if (!this._configureScrollPane()) {
            this.remove(this._grid);
            super.setLayout(this.createLayoutManager());
            this.add("grid", this._grid);
            if (this._rowHeader != null) {
                this.add("rowHeader", this._rowHeader);
            }
            if (this._columnHeader != null) {
                this.add("columnHeader", this._columnHeader);
            }
            int n = 0;
            while (n < _scrollPaneKeys.length) {
                String string = this._toScrollPaneKey(n);
                Component component = this.getCornerComponent(string);
                if (component != null) {
                    this.add(string, component);
                }
                ++n;
            }
        }
        if (this.getRowHeaderWidth() == -1) {
            this.setRowHeaderWidth(this._grid.getDefaultColumnWidth());
        }
        if (this.getColumnHeaderHeight() == -1) {
            this.setColumnHeaderHeight(this._grid.getDefaultRowHeight());
        }
        this._updateLayout();
        AccessibleContext accessibleContext = this.accessibleContext;
        if (accessibleContext != null) {
            ((AccessibleSpreadTable)accessibleContext).updateAccessibleParents();
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this._clearScrollPane();
    }

    public boolean isHScrollable() {
        return true;
    }

    public boolean isVScrollable() {
        return true;
    }

    public void setScrollByColumn(boolean bl) {
        if (bl == this.getScrollByColumn()) {
            return;
        }
        this._grid.setScrollByColumn(bl);
        if (this._columnHeader != null) {
            this._columnHeader.setScrollByItem(bl);
        }
    }

    public boolean getScrollByColumn() {
        return this._grid.getScrollByColumn();
    }

    public void setScrollByRow(boolean bl) {
        if (bl == this.getScrollByRow()) {
            return;
        }
        this._grid.setScrollByRow(bl);
        if (this._rowHeader != null) {
            this._rowHeader.setScrollByItem(bl);
        }
    }

    public boolean getScrollByRow() {
        return this._grid.getScrollByRow();
    }

    public final boolean fireCancelableRowEvent(int n, int n2) {
        TableValidateEvent tableValidateEvent = new TableValidateEvent(this, n, -1, n2);
        this.processEvent(tableValidateEvent);
        return tableValidateEvent.isCancelled();
    }

    public final boolean fireCancelableColumnEvent(int n, int n2) {
        TableValidateEvent tableValidateEvent = new TableValidateEvent(this, n, n2, -1);
        this.processEvent(tableValidateEvent);
        return tableValidateEvent.isCancelled();
    }

    public final boolean fireCancelableCellEvent(int n, int n2, int n3) {
        TableValidateEvent tableValidateEvent = new TableValidateEvent(this, n, n2, n3);
        this.processEvent(tableValidateEvent);
        return tableValidateEvent.isCancelled();
    }

    public final void fireRowEvent(int n, int n2) {
        TableEvent tableEvent = new TableEvent(this, n, -1, n2);
        this.processEvent(tableEvent);
    }

    public final void fireColumnEvent(int n, int n2) {
        TableEvent tableEvent = new TableEvent(this, n, n2, -1);
        this.processEvent(tableEvent);
    }

    public final void fireCellEvent(int n, int n2, int n3) {
        TableEvent tableEvent = new TableEvent(this, n, n2, n3);
        this.processEvent(tableEvent);
    }

    public void requestFocus() {
        this._grid.requestFocus();
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getGrid().getPreferredScrollableViewportSize();
    }

    public void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        super.fireVetoableChange(string, object, object2);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
    }

    protected Object getPaintData(Object object) {
        if (EWTTableUI.KEY_DRAW_RAISED.equals(object)) {
            return this.getDrawRaised() ? Boolean.TRUE : Boolean.FALSE;
        }
        return super.getPaintData(object);
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof TableEvent) {
            switch (aWTEvent.getID()) {
                case 2005: 
                case 2006: {
                    this.processEditEvent((TableEvent)aWTEvent);
                    break;
                }
                case 2001: 
                case 2002: 
                case 2003: 
                case 2004: {
                    this.processResizeEvent((TableEvent)aWTEvent);
                    break;
                }
                case 2007: 
                case 2008: 
                case 2009: 
                case 2010: {
                    this.processMoveEvent((TableEvent)aWTEvent);
                }
            }
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void processEditEvent(TableEvent tableEvent) {
        if (this._editListeners == null) {
            return;
        }
        Enumeration enumeration = this._editListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (tableEvent.getID()) {
            case 2005: {
                while (enumeration.hasMoreElements()) {
                    ((TableEditListener)enumeration.nextElement()).cellEditing(tableEvent);
                }
                break;
            }
            case 2006: {
                while (enumeration.hasMoreElements()) {
                    ((TableEditListener)enumeration.nextElement()).cellEdited(tableEvent);
                }
                break;
            }
        }
    }

    protected void processResizeEvent(TableEvent tableEvent) {
        Object object;
        int n = tableEvent.getID();
        if (n == 2002 || n == 2004) {
            object = this._grid.getCanvasOrigin();
            if (((Point)object).x > 0) {
                ((Point)object).x = 0;
                this._grid.setCanvasOrigin(((Point)object).x, ((Point)object).y);
            }
            if (n == 2002 && this._columnHeader != null) {
                Point point = this._columnHeader.getCanvasOrigin();
                if (point.x != ((Point)object).x) {
                    this._columnHeader.setCanvasOrigin(((Point)object).x, 0);
                }
            }
        }
        if (this._resizeListeners == null) {
            return;
        }
        object = this._resizeListeners.getListeners();
        if (object == null) {
            return;
        }
        switch (n) {
            case 2001: {
                while (object.hasMoreElements()) {
                    ((TableResizeListener)object.nextElement()).columnResizing(tableEvent);
                }
                break;
            }
            case 2002: {
                while (object.hasMoreElements()) {
                    ((TableResizeListener)object.nextElement()).columnResized(tableEvent);
                }
                break;
            }
            case 2003: {
                while (object.hasMoreElements()) {
                    ((TableResizeListener)object.nextElement()).rowResizing(tableEvent);
                }
                break;
            }
            case 2004: {
                while (object.hasMoreElements()) {
                    ((TableResizeListener)object.nextElement()).rowResized(tableEvent);
                }
                break;
            }
        }
    }

    protected void processMoveEvent(TableEvent tableEvent) {
        if (this._moveListeners == null) {
            return;
        }
        Enumeration enumeration = this._moveListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (tableEvent.getID()) {
            case 2007: {
                while (enumeration.hasMoreElements()) {
                    ((TableMoveListener)enumeration.nextElement()).columnMoving(tableEvent);
                }
                break;
            }
            case 2008: {
                while (enumeration.hasMoreElements()) {
                    ((TableMoveListener)enumeration.nextElement()).columnMoved(tableEvent);
                }
                break;
            }
            case 2009: {
                while (enumeration.hasMoreElements()) {
                    ((TableMoveListener)enumeration.nextElement()).rowMoving(tableEvent);
                }
                break;
            }
            case 2010: {
                while (enumeration.hasMoreElements()) {
                    ((TableMoveListener)enumeration.nextElement()).rowMoved(tableEvent);
                }
                break;
            }
        }
    }

    protected Header createColumnHeader(OneDModel oneDModel) {
        return new Header(oneDModel, 0);
    }

    protected Header createRowHeader(OneDModel oneDModel) {
        return new Header(oneDModel, 1);
    }

    protected Grid createGrid(TwoDModel twoDModel) {
        return new Grid(twoDModel);
    }

    protected int getHMaximum() {
        return this.getGrid().getHMaximum();
    }

    protected int getHValueOfOffset(int n) {
        return this.getGrid().getHValueOfOffset(n);
    }

    protected int getHOffsetOfValue(int n) {
        return this.getGrid().getHOffsetOfValue(n);
    }

    protected int getVMaximum() {
        return this.getGrid().getVMaximum();
    }

    protected int getVValueOfOffset(int n) {
        return this.getGrid().getVValueOfOffset(n);
    }

    protected int getVOffsetOfValue(int n) {
        return this.getGrid().getVOffsetOfValue(n);
    }

    protected Dimension layoutCanvas() {
        Dimension dimension = this.getGrid().layoutCanvas();
        if (this._scrollPane == null) {
            if (this.isColumnHeaderVisible()) {
                dimension.height += this.getColumnHeaderHeight();
            }
            if (this.isRowHeaderVisible()) {
                dimension.width += this.getRowHeaderWidth();
            }
        }
        return dimension;
    }

    protected boolean isSelectAllEnabled() {
        return this.isColumnHeaderVisible() && this.isRowHeaderVisible();
    }

    protected void paintCanvasInterior(Graphics graphics) {
        if (this._scrollPane != null) {
            this.getGrid().paintCanvasInterior(graphics);
        }
    }

    public void setCanvasOrigin(int n, int n2) {
        super.setCanvasOrigin(n, n2);
        this.getGrid().setCanvasOrigin(n, n2);
    }

    public void setCornerComponent(String string, Component component) {
        int n = this._toLocalIndicator(string);
        if (n == -1) {
            return;
        }
        this._corners[n] = component;
        this._updateLayout();
    }

    public Component getCornerComponent(String string) {
        int n = this._toLocalIndicator(string);
        if (n == -1) {
            return null;
        }
        if (this._corners[n] == null) {
            if (string.equals("UPPER_LEFT_CORNER")) {
                this._corners[n] = new UpperLeftCorner(3);
            }
            if (string.equals("UPPER_RIGHT_CORNER")) {
                this._corners[n] = new Corner(1);
            }
            if (string.equals("LOWER_LEFT_CORNER")) {
                this._corners[n] = new Corner(0);
            }
        }
        return this._corners[n];
    }

    int getHorizontalSeparatorSize() {
        boolean bl = this._grid.getHorizontalSeparatorsVisible();
        Painter painter = this._grid.getHorizontalSeparatorPainter();
        PaintContext paintContext = this._grid.getPaintContext();
        int n = bl ? painter.getPreferredSize((PaintContext)paintContext).height : 0;
        return n;
    }

    int getVerticalSeparatorSize() {
        boolean bl = this._grid.getVerticalSeparatorsVisible();
        Painter painter = this._grid.getVerticalSeparatorPainter();
        PaintContext paintContext = this._grid.getPaintContext();
        int n = bl ? painter.getPreferredSize((PaintContext)paintContext).width : 0;
        return n;
    }

    void matchGridWithHeader(boolean bl) {
        Grid grid = this.getGrid();
        if (bl) {
            Header header = this.getColumnHeader();
            if (header != null) {
                int n = header.getCanvasOriginX();
                grid.setCanvasOrigin(n, grid.getCanvasOriginY());
            }
        } else {
            Header header = this.getRowHeader();
            if (header != null) {
                int n = header.getCanvasOriginY();
                grid.setCanvasOrigin(grid.getCanvasOriginX(), n);
            }
        }
    }

    void matchHeadersWithGrid() {
        Header header = this.getColumnHeader();
        if (header != null) {
            header.setFirstItemOnScreen(this.getGrid().getFirstColumnOnScreen());
        }
        if ((header = this.getRowHeader()) != null) {
            header.setFirstItemOnScreen(this.getGrid().getFirstRowOnScreen());
        }
    }

    TableHeaderAdapter getRowHeaderAdapter() {
        return this._rowHeaderAdapter;
    }

    TableHeaderAdapter getColumnHeaderAdapter() {
        return this._columnHeaderAdapter;
    }

    TableGridAdapter getGridAdapter() {
        return this._gridAdapter;
    }

    private String _toScrollPaneKey(int n) {
        if (n < 0 || n >= _scrollPaneKeys.length) {
            return null;
        }
        return _scrollPaneKeys[n];
    }

    private int _toLocalIndicator(String string) {
        int n = 0;
        while (n < _scrollPaneKeys.length) {
            if (_scrollPaneKeys[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private boolean _configureScrollPane() {
        JScrollPane jScrollPane;
        JViewport jViewport;
        Container container;
        JScrollPane jScrollPane2 = null;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane && (jViewport = (jScrollPane = (JScrollPane)container).getViewport()) != null && jViewport.getView() == this) {
            if (this._editListener == null) {
                this._editListener = new EditListener();
                jViewport.addChangeListener(this._editListener);
            }
            this.setBorder(null);
            jScrollPane2 = jScrollPane;
            this.remove(this._grid);
            if (this._rowHeader != null) {
                this.remove(this._rowHeader);
            }
            if (this._columnHeader != null) {
                this.remove(this._columnHeader);
            }
            super.setLayout(new BorderLayout());
            this.add("Center", this._grid);
            LookAndFeel.installBorder(jScrollPane2, "EWTTable.scrollPaneBorder");
        }
        this._scrollPane = jScrollPane2;
        return jScrollPane2 != null;
    }

    private EWTTableUI _getUI() {
        return (EWTTableUI)this.ui;
    }

    private void _updateLayout() {
        this._getUI().updateGeometry(this);
        this._updateScrollpaneLayout();
    }

    private void _updateScrollpaneLayout() {
        if (this._scrollPane != null) {
            this._removeChangeListeners();
            this._scrollPane.setViewportBorder(null);
            boolean bl = false;
            String string = "UPPER_LEFT_CORNER";
            if (this._scrollPane.getCorner(string) == null || this._scrollPane.getCorner(string) instanceof DummyPanel) {
                this._scrollPane.setCorner(string, this.getCornerComponent(string));
                bl = true;
            }
            if (this._scrollPane.getCorner(string = "UPPER_RIGHT_CORNER") == null || this._scrollPane.getCorner(string) instanceof DummyPanel) {
                this._scrollPane.setCorner(string, this.getCornerComponent(string));
                bl = true;
            }
            if (this._scrollPane.getCorner(string = "LOWER_LEFT_CORNER") == null || this._scrollPane.getCorner(string) instanceof DummyPanel) {
                this._scrollPane.setCorner(string, this.getCornerComponent(string));
                bl = true;
            }
            if (bl && this._containerListener == null) {
                this._containerListener = new STContainerListener();
                this._scrollPane.getViewport().addContainerListener(this._containerListener);
            }
            Header header = this.isColumnHeaderVisible() ? this.getColumnHeader() : null;
            this._scrollPane.setColumnHeaderView(header);
            header = this.isRowHeaderVisible() ? this.getRowHeader() : null;
            this._scrollPane.setRowHeaderView(header);
            this._addChangeListeners();
            this.setBorder(null);
            this.getGrid().setBorder(null);
        }
    }

    private void _addChangeListeners() {
        JViewport jViewport;
        if (this._hHeaderListener == null) {
            this._hHeaderListener = new HeaderListener(true);
            this._vHeaderListener = new HeaderListener(false);
        }
        if ((jViewport = this._scrollPane.getColumnHeader()) != null) {
            jViewport.addChangeListener(this._hHeaderListener);
        }
        if ((jViewport = this._scrollPane.getRowHeader()) != null) {
            jViewport.addChangeListener(this._vHeaderListener);
        }
    }

    private void _removeChangeListeners() {
        JViewport jViewport = this._scrollPane.getColumnHeader();
        if (jViewport != null) {
            jViewport.removeChangeListener(this._hHeaderListener);
        }
        if ((jViewport = this._scrollPane.getRowHeader()) != null) {
            jViewport.removeChangeListener(this._vHeaderListener);
        }
    }

    private void _clearScrollPane() {
        if (this._scrollPane != null) {
            this._scrollPane.getViewport().removeChangeListener(this._editListener);
            if (this._containerListener != null) {
                this._scrollPane.getViewport().removeContainerListener(this._containerListener);
            }
            this._removeChangeListeners();
            this._scrollPane.setViewportBorder(null);
            this._scrollPane.setCorner("UPPER_LEFT_CORNER", new DummyPanel());
            this._scrollPane.setCorner("UPPER_RIGHT_CORNER", new DummyPanel());
            this._scrollPane.setCorner("LOWER_LEFT_CORNER", new DummyPanel());
            this._scrollPane.setColumnHeaderView(null);
            this._scrollPane.setRowHeaderView(null);
            LookAndFeel.uninstallBorder(this._scrollPane);
        }
        this._editListener = null;
        this._containerListener = null;
        this._hHeaderListener = null;
        this._vHeaderListener = null;
        this._scrollPane = null;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSpreadTable();
        }
        return this.accessibleContext;
    }

    private class Corner
    extends LWComponent {
        private int _corner;

        public Corner(int n) {
            this._corner = n;
        }

        public void paint(Graphics graphics) {
            PaintContext paintContext = this.getPaintContext();
            EWTTableUI eWTTableUI = SpreadTable.this._getUI();
            Painter painter = eWTTableUI.getCornerPainter(SpreadTable.this, this._corner);
            Dimension dimension = this.getSize();
            painter.paint(paintContext, graphics, 0, 0, dimension.width, dimension.height);
        }
    }

    private class UpperLeftCorner
    extends Corner
    implements Accessible {
        public UpperLeftCorner(int n) {
            super(n);
            long l = 16L;
            this.enableEvents(l);
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            if (mouseEvent.isConsumed()) {
                return;
            }
            boolean bl = SwingUtilities.isLeftMouseButton(mouseEvent);
            int n = mouseEvent.getID();
            if (bl && n == 501 && this.isEnabled()) {
                SpreadTable.this._grid.requestFocus();
                if (SpreadTable.this.isSelectAllEnabled()) {
                    try {
                        SpreadTable.this._grid.selectAll();
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleCorner();
            }
            return this.accessibleContext;
        }

        private class AccessibleCorner
        extends JComponent.AccessibleJComponent
        implements AccessibleAction {
            private AccessibleCorner() {
                super(UpperLeftCorner.this);
            }

            public AccessibleAction getAccessibleAction() {
                return this;
            }

            public int getAccessibleActionCount() {
                return 1;
            }

            public String getAccessibleActionDescription(int n) {
                Locale locale = LocaleUtils.getDefaultableLocale(SpreadTable.this);
                ResourceBundle resourceBundle = ResourceBundle.getBundle(SpreadTable._RESOURCE_BUNDLE, locale);
                switch (n) {
                    case 0: {
                        return resourceBundle.getString(SpreadTable._SELECT_ALL_KEY);
                    }
                }
                return null;
            }

            public boolean doAccessibleAction(int n) {
                boolean bl;
                boolean bl2 = bl = n == 0 && SpreadTable.this.isSelectAllEnabled();
                if (bl) {
                    try {
                        SpreadTable.this.selectAll();
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        bl = false;
                    }
                }
                return bl;
            }
        }
    }

    private class STContainerListener
    implements ContainerListener {
        private STContainerListener() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            Container container = containerEvent.getContainer();
            if (SpreadTable.this._scrollPane != null && container == SpreadTable.this._scrollPane.getViewport() && containerEvent.getChild() == SpreadTable.this && SpreadTable.this._scrollPane instanceof EWTScrollPane) {
                container.removeContainerListener(this);
                SpreadTable.this._scrollPane.setCorner("UPPER_LEFT_CORNER", null);
                SpreadTable.this._scrollPane.setCorner("UPPER_RIGHT_CORNER", null);
                SpreadTable.this._scrollPane.setCorner("LOWER_LEFT_CORNER", null);
            }
        }
    }

    private class EditListener
    implements ChangeListener {
        private EditListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            SpreadTable.this.getGrid().commitCellEdit();
        }
    }

    private class HeaderListener
    implements ChangeListener {
        private boolean _horizontal;

        public HeaderListener(boolean bl) {
            this._horizontal = bl;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            SpreadTable.this.matchGridWithHeader(this._horizontal);
        }
    }

    protected class AccessibleSpreadTable
    extends JComponent.AccessibleJComponent {
        public AccessibleSpreadTable() {
            super(SpreadTable.this);
            this.updateAccessibleParents();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TABLE;
        }

        public int getAccessibleChildrenCount() {
            int n = 1;
            if (SpreadTable.this.getColumnHeader() != null) {
                ++n;
            }
            if (SpreadTable.this.getRowHeader() != null) {
                ++n;
            }
            return n;
        }

        public Accessible getAccessibleChild(int n) {
            if (n < 0 || n >= this.getAccessibleChildrenCount()) {
                return null;
            }
            if (n == 0) {
                return SpreadTable.this.getGrid();
            }
            if (n == 2) {
                return SpreadTable.this.getRowHeader();
            }
            if (SpreadTable.this.getColumnHeader() != null) {
                return SpreadTable.this.getColumnHeader();
            }
            return SpreadTable.this.getRowHeader();
        }

        void updateAccessibleParents() {
            SpreadTable.this.getGrid().getAccessibleContext().setAccessibleParent(SpreadTable.this);
            if (SpreadTable.this.getColumnHeader() != null) {
                SpreadTable.this.getColumnHeader().getAccessibleContext().setAccessibleParent(SpreadTable.this);
            }
            if (SpreadTable.this.getRowHeader() != null) {
                SpreadTable.this.getRowHeader().getAccessibleContext().setAccessibleParent(SpreadTable.this);
            }
        }
    }
}

