/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.spinBox;

import oracle.bali.ewt.spinBox.NumericSpinBoxModel;
import oracle.bali.share.Assert;
import oracle.bali.share.collection.Range;
import oracle.bali.share.util.IntegerUtils;

public class WrappingNumericSpinBoxModel
extends NumericSpinBoxModel {
    private int _count;
    private Range _range;
    private boolean _iteratedOnce = false;

    public WrappingNumericSpinBoxModel(Range range) {
        super(range);
        this._count = range.getLowerLimit();
    }

    public int getValue() {
        return this._count;
    }

    public void setValue(int n) {
        if (!this.getRange().inRange(n)) {
            throw new IllegalArgumentException();
        }
        this._count = n;
        this._iteratedOnce = false;
    }

    public Object skip(int n) {
        Range range = this.getRange();
        boolean bl = this.isIteratingForward();
        if (!this._iteratedOnce) {
            this._iteratedOnce = true;
            --n;
        }
        this._count = bl ? (this._count += n) : (this._count -= n);
        if (!range.inRange(this._count)) {
            int n2 = range.getLowerLimit();
            int n3 = range.getUpperLimit() - n2 + 1;
            this._count = (this._count - n2) % n3 + n2;
            if (this._count < n2) {
                this._count += n3;
            }
            Assert.assertion(range.inRange(this._count));
        }
        return IntegerUtils.getInteger(this._count);
    }

    public int remainingElements(int n) {
        return n;
    }
}

