/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.spinBox;

import java.awt.AWTEvent;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.UIManager;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.elaf.EWTSpinButtonUI;
import oracle.bali.ewt.spinBox.SpinAccelerator;
import oracle.bali.ewt.spinBox.SpinButtonEvent;
import oracle.bali.ewt.spinBox.SpinButtonListener;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.nls.LocaleUtils;

public class SpinButton
extends LWComponent
implements Accessible {
    private static final String _RESOURCE_BUNDLE = "oracle.bali.ewt.resource.AccessibilityBundle";
    private static final String _INCREMENT_KEY = "INCREMENT";
    private static final String _DECREMENT_KEY = "DECREMENT";
    private boolean _incrementEnabled = true;
    private boolean _decrementEnabled = true;
    private boolean _standAlone;
    private SpinAccelerator _accelerator;
    private ListenerManager _listeners;

    public SpinButton() {
        this(true);
    }

    public SpinButton(boolean bl) {
        this._standAlone = bl;
        this.updateUI();
    }

    public void updateUI() {
        this.setUI((EWTSpinButtonUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "EWTSpinButtonUI";
    }

    public void setIncrementEnabled(boolean bl) {
        if (bl != this.isIncrementEnabled()) {
            this._incrementEnabled = bl;
            this.firePropertyChange("incrementEnabled", !bl, bl);
        }
    }

    public boolean isIncrementEnabled() {
        return this._incrementEnabled;
    }

    public void setDecrementEnabled(boolean bl) {
        if (bl != this.isDecrementEnabled()) {
            this._decrementEnabled = bl;
            this.firePropertyChange("decrementEnabled", !bl, bl);
        }
    }

    public boolean isDecrementEnabled() {
        return this._decrementEnabled;
    }

    public SpinAccelerator getAccelerator() {
        return this._accelerator;
    }

    public void setAccelerator(SpinAccelerator spinAccelerator) {
        this._accelerator = spinAccelerator;
    }

    public void addSpinButtonListener(SpinButtonListener spinButtonListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener(spinButtonListener);
    }

    public void removeSpinButtonListener(SpinButtonListener spinButtonListener) {
        this._listeners.removeListener(spinButtonListener);
    }

    public void fireSpinButtonEvent(int n) {
        if (this._listeners != null) {
            this.processEvent(new SpinButtonEvent(this, 2000, n));
        }
    }

    public boolean isStandalone() {
        return this._standAlone;
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof SpinButtonEvent) {
            this.processSpinButtonEvent((SpinButtonEvent)aWTEvent);
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void processSpinButtonEvent(SpinButtonEvent spinButtonEvent) {
        Enumeration enumeration;
        ListenerManager listenerManager = this._listeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                SpinButtonListener spinButtonListener = (SpinButtonListener)enumeration.nextElement();
                switch (spinButtonEvent.getID()) {
                    case 2000: {
                        spinButtonListener.spinButtonSpinning(spinButtonEvent);
                        break;
                    }
                }
            }
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSpinButton();
        }
        return this.accessibleContext;
    }

    protected class AccessibleSpinButton
    extends JComponent.AccessibleJComponent
    implements AccessibleAction {
        protected AccessibleSpinButton() {
            super(SpinButton.this);
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public int getAccessibleActionCount() {
            return 2;
        }

        public String getAccessibleActionDescription(int n) {
            Locale locale = LocaleUtils.getDefaultableLocale(SpinButton.this);
            ResourceBundle resourceBundle = ResourceBundle.getBundle(SpinButton._RESOURCE_BUNDLE, locale);
            switch (n) {
                case 0: {
                    return resourceBundle.getString(SpinButton._INCREMENT_KEY);
                }
                case 1: {
                    return resourceBundle.getString(SpinButton._DECREMENT_KEY);
                }
            }
            return null;
        }

        public boolean doAccessibleAction(int n) {
            int n2;
            switch (n) {
                case 0: {
                    if (!SpinButton.this.isIncrementEnabled()) {
                        return false;
                    }
                    n2 = 1;
                    break;
                }
                case 1: {
                    if (!SpinButton.this.isDecrementEnabled()) {
                        return false;
                    }
                    n2 = 2;
                    break;
                }
                default: {
                    return false;
                }
            }
            SpinButton.this.fireSpinButtonEvent(n2);
            return true;
        }
    }
}

