/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.spinBox;

import java.util.NoSuchElementException;
import oracle.bali.ewt.spinBox.SpinBoxModel;
import oracle.bali.share.collection.Range;
import oracle.bali.share.util.IntegerUtils;

public class NumericSpinBoxModel
implements SpinBoxModel {
    private int _count;
    private Range _range;
    private boolean _forward;
    private boolean _iteratedOnce;

    public NumericSpinBoxModel(Range range) {
        if (range == null) {
            throw new NullPointerException();
        }
        this._range = range;
        this._forward = true;
        this._count = range.getLowerLimit();
        this._iteratedOnce = false;
    }

    public Range getRange() {
        return this._range;
    }

    public void setValue(int n) {
        if (!this.getRange().inRange(n)) {
            throw new IllegalArgumentException();
        }
        this._count = n;
        this._iteratedOnce = false;
    }

    public int getValue() {
        return this._count;
    }

    public final Object nextElement() {
        return this.skip(1);
    }

    public void setIteratingForward(boolean bl) {
        this._forward = bl;
    }

    public boolean isIteratingForward() {
        return this._forward;
    }

    public final boolean hasMoreElements() {
        return this.remainingElements(1) == 1;
    }

    public Object skip(int n) {
        if (n == 0) {
            return IntegerUtils.getInteger(this._count);
        }
        boolean bl = this.isIteratingForward();
        if (this.remainingElements(n) == n) {
            if (!this._iteratedOnce) {
                this._iteratedOnce = true;
                --n;
            }
            this._count = this.isIteratingForward() ? (this._count += n) : (this._count -= n);
            return IntegerUtils.getInteger(this._count);
        }
        throw new NoSuchElementException();
    }

    public int remainingElements(int n) {
        if (n == 0) {
            return 0;
        }
        if (n < 0) {
            boolean bl = this.isIteratingForward();
            this.setIteratingForward(!bl);
            int n2 = -this.remainingElements(-n);
            this.setIteratingForward(bl);
            return n2;
        }
        long l = this._count;
        Range range = this._range;
        long l2 = this.isIteratingForward() ? (long)range.getUpperLimit() - l : l - (long)range.getLowerLimit();
        if (!this._iteratedOnce) {
            ++l2;
        }
        if ((long)n < l2) {
            return n;
        }
        return (int)l2;
    }
}

