/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.shuttle;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.util.FocusUtils;

class ShuttleLayout
implements LayoutManager {
    public static final String FROM_LIST = "FromList";
    public static final String TO_LIST = "ToList";
    public static final String FROM_HEADER = "FromHeader";
    public static final String TO_HEADER = "ToHeader";
    public static final String FROM_FOOTER = "FromFooter";
    public static final String TO_FOOTER = "ToFooter";
    public static final String SHUTTLE_CONTROL = "ShuttleControl";
    public static final String FROM_REORDER_CONTROL = "FromReorderControl";
    public static final String TO_REORDER_CONTROL = "ToReorderControl";
    private static final String DUMMY_LABEL = "DummyLabel";
    private static final int _FOCUS_ROOT = 0;
    private static final int _FROM_HEADER = 1;
    private static final int _TO_HEADER = 2;
    private static final int _FROM_REORDER = 3;
    private static final int _FROM_PICKER = 4;
    private static final int _SHUTTLE = 5;
    private static final int _TO_PICKER = 6;
    private static final int _TO_REORDER = 7;
    private static final int _FROM_FOOTER = 8;
    private static final int _TO_FOOTER = 9;
    private static final int _HEADER_GAP = 0;
    private static final int _FOOTER_GAP = 0;
    private static final int _SHUTTLE_GAP = 5;
    private static final int _INSET = 5;
    private static final int _REORDER_GAP = 5;
    private static final Dimension _ZERO_SIZE = new Dimension(0, 0);
    private Component _fromListComponent;
    private Component _toListComponent;
    private Component _fromListHeader;
    private Component _toListHeader;
    private Component _fromListFooter;
    private Component _toListFooter;
    private Component _shuttleControl;
    private Component _fromReorderControl;
    private Component _toReorderControl;
    private JButton _dummyButton;
    private Shuttle _shuttle;
    private boolean _reversed = false;
    private boolean _horizontal = true;
    private int _lastDirection = 1;

    public ShuttleLayout(Shuttle shuttle) {
        this._shuttle = shuttle;
    }

    public void addLayoutComponent(String string, Component component) {
        if (string == FROM_LIST) {
            this._fromListComponent = component;
        } else if (string == TO_LIST) {
            this._toListComponent = component;
        } else if (string == FROM_HEADER) {
            this._fromListHeader = component;
        } else if (string == TO_HEADER) {
            this._toListHeader = component;
        } else if (string == SHUTTLE_CONTROL) {
            this._shuttleControl = component;
        } else if (string == FROM_REORDER_CONTROL) {
            this._fromReorderControl = component;
        } else if (string == TO_REORDER_CONTROL) {
            this._toReorderControl = component;
        } else if (string == FROM_FOOTER) {
            this._fromListFooter = component;
        } else if (string == TO_FOOTER) {
            this._toListFooter = component;
        } else if (string == DUMMY_LABEL) {
            this._dummyButton = (JButton)component;
        } else {
            throw new IllegalArgumentException();
        }
        this.updateFocusCycle();
    }

    public void removeLayoutComponent(Component component) {
        boolean bl = false;
        if (component == this._fromListComponent) {
            this._fromListComponent = null;
        } else if (component == this._toListComponent) {
            this._toListComponent = null;
        } else if (component == this._fromListHeader) {
            this._fromListHeader = null;
        } else if (component == this._toListHeader) {
            this._toListHeader = null;
        } else if (component == this._shuttleControl) {
            this._shuttleControl = null;
        } else if (component == this._fromReorderControl) {
            this._fromReorderControl = null;
        } else if (component == this._toReorderControl) {
            this._toReorderControl = null;
        } else if (component == this._fromListFooter) {
            this._fromListFooter = null;
        } else if (component == this._toListFooter) {
            this._toListFooter = null;
        }
        this.updateFocusCycle();
    }

    public Dimension preferredLayoutSize(Container container) {
        if (this._horizontal) {
            return this._calculateHorizontalSize(this._getPreferredSize(this._fromListComponent), this._getPreferredSize(this._toListComponent), this._getPreferredSize(this._fromListHeader), this._getPreferredSize(this._toListHeader), this._getPreferredSize(this._shuttleControl), this._getPreferredSize(this._fromReorderControl), this._getPreferredSize(this._toReorderControl), this._getPreferredSize(this._fromListFooter), this._getPreferredSize(this._toListFooter));
        }
        return this._calculateVerticalSize(this._getPreferredSize(this._fromListComponent), this._getPreferredSize(this._toListComponent), this._getPreferredSize(this._fromListHeader), this._getPreferredSize(this._toListHeader), this._getPreferredSize(this._shuttleControl), this._getPreferredSize(this._fromReorderControl), this._getPreferredSize(this._toReorderControl), this._getPreferredSize(this._fromListFooter), this._getPreferredSize(this._toListFooter));
    }

    public Dimension minimumLayoutSize(Container container) {
        if (this._horizontal) {
            return this._calculateHorizontalSize(this._getMinimumSize(this._fromListComponent), this._getMinimumSize(this._toListComponent), this._getMinimumSize(this._fromListHeader), this._getMinimumSize(this._toListHeader), this._getMinimumSize(this._shuttleControl), this._getMinimumSize(this._fromReorderControl), this._getMinimumSize(this._toReorderControl), this._getMinimumSize(this._fromListFooter), this._getMinimumSize(this._toListFooter));
        }
        return this._calculateVerticalSize(this._getMinimumSize(this._fromListComponent), this._getMinimumSize(this._toListComponent), this._getMinimumSize(this._fromListHeader), this._getMinimumSize(this._toListHeader), this._getMinimumSize(this._shuttleControl), this._getMinimumSize(this._fromReorderControl), this._getMinimumSize(this._toReorderControl), this._getMinimumSize(this._fromListFooter), this._getMinimumSize(this._toListFooter));
    }

    public void layoutContainer(Container container) {
        Shuttle shuttle = (Shuttle)container;
        int n = shuttle.getActualReadingDirection();
        if (n != this._lastDirection) {
            if (n == 2) {
                shuttle._setActualLayoutReversed(!shuttle.isLayoutReversed());
            } else if (n == 1) {
                shuttle._setActualLayoutReversed(shuttle.isLayoutReversed());
            }
            this._lastDirection = n;
        }
        if (this._dummyButton == null) {
            JButton jButton = ShuttleLayout._createDummyButton();
            this._shuttle.add((Component)jButton, DUMMY_LABEL);
        }
        if (this._horizontal) {
            this._layoutHorizontal(container);
        } else {
            this._layoutVertical(container);
        }
    }

    public Component getComponent(Object object) {
        if (object == FROM_HEADER) {
            return this._fromListHeader;
        }
        if (object == FROM_FOOTER) {
            return this._fromListFooter;
        }
        if (object == TO_HEADER) {
            return this._toListHeader;
        }
        if (object == TO_FOOTER) {
            return this._toListFooter;
        }
        return null;
    }

    public Component getShuttleControl() {
        return this._shuttleControl;
    }

    public void setHorizontalLayout(boolean bl) {
        this._horizontal = bl;
    }

    public void setReverseLayout(boolean bl) {
        this._reversed = bl;
    }

    private void _layoutHorizontal(Container container) {
        int n;
        int n2 = this._getShuttleGap();
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        Dimension dimension2 = this._getPreferredSize(this._fromListHeader);
        Dimension dimension3 = this._getPreferredSize(this._toListHeader);
        int n3 = Math.max(dimension2.height, dimension3.height);
        Dimension dimension4 = this._getPreferredSize(this._fromListFooter);
        Dimension dimension5 = this._getPreferredSize(this._toListFooter);
        Dimension dimension6 = this._getPreferredSize(this._shuttleControl);
        Dimension dimension7 = this._getPreferredSize(this._fromReorderControl);
        Dimension dimension8 = this._getPreferredSize(this._toReorderControl);
        int n4 = dimension7.width;
        int n5 = dimension8.width;
        if (n4 != 0) {
            n4 += 5;
        }
        if (n5 != 0) {
            n5 += 5;
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (this._fromListComponent != null) {
            ++n8;
        }
        if (this._toListComponent != null) {
            ++n8;
        }
        if (n8 == 1) {
            n7 = dimension.width - insets.left - insets.right - dimension6.width - n2 * 2 - n4 - n5;
            if (this._toListComponent == null) {
                n6 = n7;
                n7 = 0;
            }
        } else if (n8 == 2) {
            n7 = n6 = (dimension.width - insets.left - insets.right - dimension6.width - n2 * 2 - n4 - n5) / 2;
        }
        int n9 = insets.left;
        if (!this._reversed) {
            if (dimension7 != _ZERO_SIZE) {
                n9 += n4;
            }
        } else if (dimension8 != _ZERO_SIZE) {
            n9 += n5;
        }
        int n10 = n9 + n2;
        int n11 = (n10 += !this._reversed ? n6 : n7) + dimension6.width + n2;
        int n12 = !this._reversed ? n11 + n7 + 5 : insets.left;
        int n13 = !this._reversed ? insets.left : n11 + n6 + 5;
        int n14 = !this._reversed ? n9 : n11;
        int n15 = !this._reversed ? n11 : n9;
        int n16 = n = insets.top + 5;
        if (n3 > 0) {
            n16 += n3 + 0;
            if (dimension2 != _ZERO_SIZE) {
                this._fromListHeader.setBounds(n14, n, n6, n3);
            }
            if (dimension3 != _ZERO_SIZE) {
                this._toListHeader.setBounds(n15, n, n7, n3);
            }
        }
        int n17 = dimension.height - n16 - dimension4.height - 0 - 5 - insets.bottom;
        int n18 = dimension.height - n16 - dimension5.height - 0 - 5 - insets.bottom;
        if (this._fromListComponent != null && this._fromListComponent.isVisible()) {
            this._fromListComponent.setBounds(n14, n16, n6, n17);
        }
        if (this._toListComponent != null && this._toListComponent.isVisible()) {
            this._toListComponent.setBounds(n15, n16, n7, n18);
        }
        if (dimension4 != _ZERO_SIZE) {
            this._fromListFooter.setBounds(n14, n16 + n17 + 0, n6, dimension4.height);
        }
        if (dimension5 != _ZERO_SIZE) {
            this._toListFooter.setBounds(n15, n16 + n18 + 0, n7, dimension5.height);
        }
        this._dummyButton.setBounds(n15 + n7, n16 + n18 + 0, 0, 0);
        int n19 = Math.min(n17, n18);
        if (dimension6 != _ZERO_SIZE) {
            this._shuttleControl.setBounds(n10, n16 + (n19 - dimension6.height) / 2, dimension6.width, dimension6.height);
        }
        if (dimension8 != _ZERO_SIZE) {
            this._toReorderControl.setBounds(n12, n16 + (n18 - dimension8.height) / 2, dimension8.width, dimension8.height);
        }
        if (dimension7 != _ZERO_SIZE) {
            this._fromReorderControl.setBounds(n13, n16 + (n17 - dimension7.height) / 2, dimension7.width, dimension7.height);
        }
    }

    private void _layoutVertical(Container container) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = this._getShuttleGap();
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        Dimension dimension2 = this._getPreferredSize(this._fromListHeader);
        Dimension dimension3 = this._getPreferredSize(this._toListHeader);
        int n10 = dimension2.height > 0 ? dimension2.height + 0 : 0;
        int n11 = dimension3.height > 0 ? dimension3.height + 0 : 0;
        Dimension dimension4 = this._getPreferredSize(this._fromListFooter);
        Dimension dimension5 = this._getPreferredSize(this._toListFooter);
        int n12 = dimension4.height > 0 ? dimension4.height + 0 : 0;
        int n13 = dimension5.height > 0 ? dimension5.height + 0 : 0;
        Dimension dimension6 = this._getPreferredSize(this._shuttleControl);
        Dimension dimension7 = this._getPreferredSize(this._toReorderControl);
        Dimension dimension8 = this._getPreferredSize(this._fromReorderControl);
        int n14 = dimension7.width;
        int n15 = dimension8.width;
        if (n14 != 0) {
            n14 += 5;
        }
        if (n15 != 0) {
            n15 += 5;
        }
        int n16 = dimension.width - insets.left - insets.right - Math.max(n14, n15);
        int n17 = insets.left;
        int n18 = (dimension.width - insets.left - insets.right - dimension6.width) / 2 + insets.left;
        int n19 = n17 + n16 + 5;
        int n20 = dimension.height - insets.top - n10 - n11 - n12 - n13 - 2 * n9 - dimension6.height - insets.bottom;
        if (this._fromListComponent != null && this._toListComponent != null) {
            n20 /= 2;
        }
        int n21 = this._fromListComponent != null ? n20 : 0;
        int n22 = this._toListComponent != null ? n20 : 0;
        int n23 = insets.top;
        int n24 = n23 + (this._reversed ? n11 : n10);
        int n25 = n24 + (this._reversed ? n22 : n21);
        int n26 = n25 + n9 + (this._reversed ? n13 : n12);
        int n27 = n26 + dimension6.height + n9;
        int n28 = n27 + (this._reversed ? n10 : n11);
        int n29 = n28 + (this._reversed ? n21 : n22);
        if (!this._reversed) {
            n8 = n24;
            n7 = n23;
            n6 = n25;
            n5 = n28;
            n4 = n27;
            n3 = n29;
            n2 = n28;
            n = n24;
        } else {
            n8 = n28;
            n7 = n27;
            n6 = n29;
            n5 = n24;
            n4 = n23;
            n3 = n25;
            n2 = n24;
            n = n28;
        }
        n2 += (n22 - dimension7.height) / 2;
        n += (n21 - dimension8.height) / 2;
        if (n10 > 0 && dimension2 != _ZERO_SIZE) {
            this._fromListHeader.setBounds(n17, n7, n16, dimension2.height);
        }
        if (n11 > 0 && dimension3 != _ZERO_SIZE) {
            this._toListHeader.setBounds(n17, n4, n16, dimension3.height);
        }
        if (this._fromListComponent != null && this._fromListComponent.isVisible()) {
            this._fromListComponent.setBounds(n17, n8, n16, n21);
        }
        if (this._toListComponent != null && this._toListComponent.isVisible()) {
            this._toListComponent.setBounds(n17, n5, n16, n22);
        }
        if (dimension4 != _ZERO_SIZE) {
            this._fromListFooter.setBounds(n17, n6, n16, dimension4.height);
        }
        if (dimension5 != _ZERO_SIZE) {
            this._toListFooter.setBounds(n17, n3, n16, dimension5.height);
        }
        this._dummyButton.setBounds(n17 + n16, n3, 0, 0);
        if (dimension6 != _ZERO_SIZE) {
            this._shuttleControl.setBounds(n18, n26, dimension6.width, dimension6.height);
        }
        if (dimension7 != _ZERO_SIZE) {
            this._toReorderControl.setBounds(n19, n2, dimension7.width, dimension7.height);
        }
        if (dimension8 != _ZERO_SIZE) {
            this._fromReorderControl.setBounds(n19, n, dimension8.width, dimension8.height);
        }
    }

    private Dimension _calculateHorizontalSize(Dimension dimension, Dimension dimension2, Dimension dimension3, Dimension dimension4, Dimension dimension5, Dimension dimension6, Dimension dimension7, Dimension dimension8, Dimension dimension9) {
        int n;
        int n2 = this._getShuttleGap();
        int n3 = Math.max(Math.max(Math.max(Math.max(dimension.height, dimension6.height), dimension2.height), dimension5.height), dimension7.height);
        int n4 = Math.max(Math.max(dimension.width, dimension2.width), Math.max(Math.max(dimension3.width, dimension4.width), Math.max(dimension8.width, dimension9.width)));
        int n5 = Math.max(dimension3.height, dimension4.height);
        if (n5 > 0) {
            n5 += 0;
        }
        if ((n = Math.max(dimension8.height, dimension9.height)) > 0) {
            n += 0;
        }
        int n6 = 2 * n4 + 2 * n2 + dimension5.width;
        if (dimension6 != _ZERO_SIZE) {
            n6 += 5 + dimension6.width;
        }
        if (dimension7 != _ZERO_SIZE) {
            n6 += 5 + dimension7.width;
        }
        return new Dimension(n6, n5 + n3 + n);
    }

    private Dimension _calculateVerticalSize(Dimension dimension, Dimension dimension2, Dimension dimension3, Dimension dimension4, Dimension dimension5, Dimension dimension6, Dimension dimension7, Dimension dimension8, Dimension dimension9) {
        int n = this._getShuttleGap();
        int n2 = Math.max(Math.max(Math.max(dimension.height, dimension6.height), dimension2.height), dimension7.height);
        int n3 = Math.max(dimension5.width, Math.max(Math.max(dimension.width, dimension2.width), Math.max(Math.max(dimension3.width, dimension4.width), Math.max(dimension8.width, dimension9.width))));
        if (dimension3.height > 0) {
            dimension3.height += 0;
        }
        if (dimension4.height > 0) {
            dimension4.height += 0;
        }
        if (dimension8.height > 0) {
            dimension8.height += 0;
        }
        if (dimension9.height > 0) {
            dimension9.height += 0;
        }
        int n4 = dimension3.height + dimension4.height + dimension8.height + dimension9.height + n2 * 2 + n * 2 + dimension5.height;
        int n5 = n3;
        if (dimension6 != _ZERO_SIZE) {
            n5 += 5 + dimension6.width;
        } else if (dimension7 != _ZERO_SIZE) {
            n5 += 5 + dimension7.width;
        }
        return new Dimension(n5, n4);
    }

    private Dimension _getPreferredSize(Component component) {
        return component != null && component.isVisible() ? component.getPreferredSize() : _ZERO_SIZE;
    }

    private Dimension _getMinimumSize(Component component) {
        return component != null && component.isVisible() ? component.getMinimumSize() : _ZERO_SIZE;
    }

    private int _getShuttleGap() {
        return this._shuttleControl != null && this._shuttleControl.getPreferredSize().width > 0 ? 5 : 0;
    }

    private static void _sGetFocusableComps(Container container, ArrayList arrayList) {
        if (container instanceof JComponent && FocusUtils.getAcceptsFocus(container)) {
            arrayList.add(container);
        }
        int n = container.getComponentCount();
        Component component = null;
        int n2 = 0;
        while (n2 < n) {
            component = container.getComponent(n2);
            if (component instanceof Container) {
                ShuttleLayout._sGetFocusableComps((Container)component, arrayList);
            }
            ++n2;
        }
    }

    private void _linkComponents() {
        Component[] componentArray = new Component[]{this._fromListHeader, this._fromListComponent, this._fromListFooter, this._shuttleControl, this._toListHeader, this._toListComponent, this._toListFooter, this._toReorderControl, this._fromReorderControl};
        ArrayList<Component> arrayList = new ArrayList<Component>(8);
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (componentArray[n2] instanceof Container) {
                ShuttleLayout._sGetFocusableComps((Container)componentArray[n2], arrayList);
            }
            ++n2;
        }
        if (this._shuttle.getNextFocusableComponent() != null) {
            arrayList.add(this._shuttle.getNextFocusableComponent());
        } else if (this._dummyButton != null) {
            arrayList.add(this._dummyButton);
        }
        n = arrayList.size();
        int n3 = 0;
        while (n3 < n - 1) {
            ((JComponent)arrayList.get(n3)).setNextFocusableComponent((Component)arrayList.get(n3 + 1));
            ++n3;
        }
    }

    public void updateFocusCycle() {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            this._linkComponents();
        } else {
            Component[] componentArray = new Component[]{this._fromListHeader, this._fromListComponent, this._fromListFooter, this._shuttleControl, this._toListHeader, this._toListComponent, this._toListFooter, this._toReorderControl, this._fromReorderControl};
            int n = 0;
            int n2 = -1;
            while (n < componentArray.length - 1) {
                if (componentArray[n] instanceof JComponent) {
                    n2 = n;
                    int n3 = n + 1;
                    while (n3 < componentArray.length) {
                        if (componentArray[n3] instanceof JComponent) {
                            n2 = n3;
                            ((JComponent)componentArray[n]).setNextFocusableComponent(componentArray[n3]);
                            n = n3 - 1;
                            break;
                        }
                        ++n3;
                    }
                }
                ++n;
            }
            if (n2 != -1) {
                ((JComponent)componentArray[n2]).setNextFocusableComponent(this._dummyButton);
            }
            if (this._dummyButton != null) {
                this._dummyButton.setNextFocusableComponent(this._shuttle.getNextFocusableComponent());
            }
        }
    }

    private static boolean _isFocusable(Component component) {
        return component.isFocusTraversable() && component.isVisible() && component.isEnabled() && FocusUtils.isFocusable(component);
    }

    static Component __getFocusableComponent(Component component) {
        if (FocusUtils.getAcceptsFocus(component)) {
            return component;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                Component component2 = container.getComponent(n2);
                if (ShuttleLayout._isFocusTraversable(component2)) {
                    return component2;
                }
                ++n2;
            }
        }
        return null;
    }

    private static boolean _isFocusTraversable(Component component) {
        if (FocusUtils.getAcceptsFocus(component)) {
            return true;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                Component component2 = container.getComponent(n2);
                if (ShuttleLayout._isFocusTraversable(component2)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static JButton _createDummyButton() {
        JButton jButton = new JButton("");
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            FocusAdapter focusAdapter = new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    Component component = FocusUtils.getOppositeComponent(focusEvent);
                    if (component instanceof JComponent && ((JComponent)component).getNextFocusableComponent() == focusEvent.getSource()) {
                        FocusManager.getCurrentManager().focusNextComponent((Component)focusEvent.getSource());
                    } else {
                        FocusManager.getCurrentManager().focusPreviousComponent((Component)focusEvent.getSource());
                    }
                }
            };
            jButton.addFocusListener(focusAdapter);
        } else {
            jButton.setEnabled(false);
        }
        return jButton;
    }
}

