/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.shuttle;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.button.ContinuousButtonModel;
import oracle.bali.ewt.elaf.EWTShuttleUI;
import oracle.bali.ewt.layout.EqualColumnLayout;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Reorderable;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleLayout;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.bali.ewt.util.FocusUtils;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.nls.LocaleUtils;

public class Shuttle
extends LWComponent
implements Accessible {
    public static final String FROM_HEADER_COMPONENT = "FromHeader";
    public static final String TO_HEADER_COMPONENT = "ToHeader";
    public static final String FROM_FOOTER_COMPONENT = "FromFooter";
    public static final String TO_FOOTER_COMPONENT = "ToFooter";
    public static final String BUTTON_AREA_COMPONENT = "ButtonArea";
    public static final int ICON_MODE = 1;
    public static final int TEXT_MODE = 2;
    public static final int MOVE_BUTTON = 1;
    public static final int MOVE_ALL_BUTTON = 2;
    public static final int REMOVE_BUTTON = 4;
    public static final int REMOVE_ALL_BUTTON = 8;
    public static final int MOVE_MODE = 0;
    public static final int COPY_MODE = 1;
    private boolean _ignoreSelectionEvents = false;
    private LayoutManager _HORIZONTAL_BUTTON_LAYOUT;
    private LayoutManager _VERTICAL_BUTTON_LAYOUT;
    private ItemPicker _fromPicker;
    private ItemPicker _toPicker;
    private JPanel _shuttleButtons;
    private JButton _addButton;
    private JButton _removeButton;
    private JButton _addAllButton;
    private JButton _removeAllButton;
    private JButton _toReorderUp;
    private JButton _toReorderDown;
    private JButton _fromReorderUp;
    private JButton _fromReorderDown;
    private int _buttonMode;
    private int _buttonsShown;
    private int _itemsUnique;
    private boolean _horizontalLayout = true;
    private boolean _reversed;
    private boolean _actualReversed;
    private String[] _buttonLabels;
    private int[] _buttonMnemonics;
    private static Image[] _buttonImages;
    private ShuttleHandler _handler;
    private ListenerManager _shuttleListeners;
    private int[] _actionMap;
    private static final int _INTERIOR_BUTTON_GAP = 3;
    private static final LayoutManager _REORDER_LAYOUT;
    private static final int _STRINGINDEX_MOVE = 0;
    private static final int _STRINGINDEX_MOVEALL = 1;
    private static final int _STRINGINDEX_REMOVE = 2;
    private static final int _STRINGINDEX_REMOVEALL = 3;
    private static final int _STRINGINDEX_COPY = 4;
    private static final int _STRINGINDEX_COPYALL = 5;
    private static final int _STRINGINDEX_REORDER_UP = 6;
    private static final int _STRINGINDEX_REORDER_DOWN = 7;
    private static final int _LABELLED_BUTTON_COUNT = 6;
    private static final String _MOVE_KEY = "SHUTTLE.MOVE";
    private static final String _REMOVE_KEY = "SHUTTLE.REMOVE";
    private static final String _MOVE_ALL_KEY = "SHUTTLE.MOVE_ALL";
    private static final String _REMOVE_ALL_KEY = "SHUTTLE.REMOVE_ALL";
    private static final String _COPY_KEY = "SHUTTLE.COPY";
    private static final String _COPY_ALL_KEY = "SHUTTLE.COPY_ALL";
    private static final String _REORDER_UP_KEY = "SHUTTLE.REORDER_UP";
    private static final String _REORDER_DOWN_KEY = "SHUTTLE.REORDER_DOWN";

    public Shuttle() {
        ShuttleLayout shuttleLayout = this._createLayoutManager();
        super.setLayout(shuttleLayout);
        this._buttonMode = 1;
        this._buttonsShown = 15;
        this._shuttleButtons = new JPanel();
        FocusUtils.setFocusable(this._shuttleButtons, false);
        this._addButton = this._createButton(false);
        this._removeButton = this._createButton(true);
        this._addAllButton = this._createButton(false);
        this._removeAllButton = this._createButton(true);
        this._buttonLabels = this.getLocalizedLabels(LocaleUtils.getDefaultableLocale(this));
        this._updateButtonVisibility();
        this._shuttleButtons.add(this._addButton);
        this._shuttleButtons.add(this._addAllButton);
        this._shuttleButtons.add(this._removeButton);
        this._shuttleButtons.add(this._removeAllButton);
        this.add((Component)this._shuttleButtons, "ShuttleControl");
        this.updateUI();
    }

    public void dispose() {
        Enumeration enumeration;
        if (this._shuttleButtons == null) {
            return;
        }
        ItemPicker itemPicker = this._fromPicker;
        this.setFromPicker(null);
        if (itemPicker != null && itemPicker instanceof ListPicker) {
            ((ListPicker)itemPicker).dispose();
        }
        this._fromPicker = null;
        ItemPicker itemPicker2 = this._toPicker;
        this.setToPicker(null);
        if (itemPicker2 != null && itemPicker2 instanceof ListPicker) {
            ((ListPicker)itemPicker2).dispose();
        }
        this._toPicker = null;
        this._disposeReorderControls();
        this._addButton.removeActionListener(this._handler);
        this._addButton = null;
        this._removeButton.removeActionListener(this._handler);
        this._removeButton = null;
        this._addAllButton.removeActionListener(this._handler);
        this._addAllButton = null;
        this._removeAllButton.removeActionListener(this._handler);
        this._removeAllButton = null;
        this._handler = null;
        this._buttonLabels = null;
        this._buttonMnemonics = null;
        this._actionMap = null;
        if (this._shuttleListeners != null && (enumeration = this._shuttleListeners.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                this._shuttleListeners.removeListener((EventListener)enumeration.nextElement());
            }
        }
        this._shuttleListeners = null;
        this._shuttleButtons.removeAll();
        this._shuttleButtons.setLayout(null);
        this._shuttleButtons = null;
        this.removeAll();
        this.setLayout(null);
    }

    public synchronized void addShuttleListener(ShuttleListener shuttleListener) {
        if (this._shuttleListeners == null) {
            this._shuttleListeners = new ListenerManager();
        }
        this._shuttleListeners.addListener(shuttleListener);
    }

    public synchronized void removeShuttleListener(ShuttleListener shuttleListener) {
        this._shuttleListeners.removeListener(shuttleListener);
    }

    public void setFromPicker(ItemPicker itemPicker) {
        if (this._fromPicker != null) {
            this.remove(this._fromPicker.getComponent());
        }
        if (itemPicker != null) {
            this.add(itemPicker.getComponent(), "FromList");
        }
        this._setFromPicker(itemPicker);
    }

    public final ItemPicker getFromPicker() {
        return this._fromPicker;
    }

    public void setToPicker(ItemPicker itemPicker) {
        if (this._toPicker != null) {
            this.remove(this._toPicker.getComponent());
        }
        if (itemPicker != null) {
            this.add(itemPicker.getComponent(), "ToList");
        }
        this._setToPicker(itemPicker);
    }

    public final ItemPicker getToPicker() {
        return this._toPicker;
    }

    public Component getComponent(Object object) {
        return this._getLayout().getComponent(object);
    }

    public void setUseTextButtons(boolean bl) {
        if (bl) {
            this.setButtonDisplayMode(2);
        } else {
            this.setButtonDisplayMode(1);
        }
    }

    public void setButtonDisplayMode(int n) {
        if (n != this._buttonMode) {
            if (n < 1 || n > 3) {
                throw new IllegalArgumentException();
            }
            this._buttonMode = n;
            this._updateButtonContents();
        }
    }

    public int getButtonDisplayMode() {
        return this._buttonMode;
    }

    public boolean getUseTextButtons() {
        return (this._buttonMode & 2) != 0;
    }

    public boolean isHorizontalLayout() {
        return this._horizontalLayout;
    }

    public boolean isLayoutReversed() {
        return this._reversed;
    }

    public int getMode() {
        return this._itemsUnique;
    }

    public void setHorizontalLayout(boolean bl) {
        if (bl != this._horizontalLayout) {
            this._horizontalLayout = bl;
            this._getLayout().setHorizontalLayout(bl);
            if (this._horizontalLayout) {
                this._shuttleButtons.setLayout(this._HORIZONTAL_BUTTON_LAYOUT);
            } else {
                this._shuttleButtons.setLayout(this._VERTICAL_BUTTON_LAYOUT);
            }
            this._updateButtonContents();
            this.revalidate();
            AccessibleContext accessibleContext = this.accessibleContext;
            if (accessibleContext != null) {
                accessibleContext.firePropertyChange("AccessibleState", bl ? AccessibleState.VERTICAL : AccessibleState.HORIZONTAL, bl ? AccessibleState.HORIZONTAL : AccessibleState.VERTICAL);
            }
        }
    }

    public void setLayoutReversed(boolean bl) {
        this._reversed = bl;
        int n = this.getActualReadingDirection();
        if (n == 2) {
            this._setActualLayoutReversed(!bl);
        } else {
            this._setActualLayoutReversed(bl);
        }
    }

    public void setMode(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException();
        }
        if (n != this._itemsUnique) {
            this._itemsUnique = n;
            this._updateButtonContents();
            this._updateButtonMnemonics();
            this.revalidate();
        }
    }

    public void setMoveAllAllowed(boolean bl) {
        if (bl) {
            this.setButtonsShown(this._buttonsShown | 2 | 8);
        } else {
            this.setButtonsShown(this._buttonsShown & 0xFFFFFFFD & 0xFFFFFFF7);
        }
    }

    public void setMoveAllowed(boolean bl) {
        if (bl) {
            this.setButtonsShown(this._buttonsShown | 1 | 4);
        } else {
            this.setButtonsShown(this._buttonsShown & 0xFFFFFFFE & 0xFFFFFFFB);
        }
    }

    public void setButtonsShown(int n) {
        if (n != this._buttonsShown) {
            this._buttonsShown = n;
            this._updateButtonVisibility();
        }
    }

    public String[] getButtonLabels() {
        if (this._buttonLabels == null) {
            this._buttonLabels = this.getLocalizedLabels(LocaleUtils.getDefaultableLocale(this));
        }
        String[] stringArray = new String[this._buttonLabels.length];
        System.arraycopy(this._buttonLabels, 0, stringArray, 0, stringArray.length);
        return stringArray;
    }

    public void setButtonLabels(String[] stringArray) {
        if (stringArray == null) {
            this._buttonLabels = this.getLocalizedLabels(LocaleUtils.getDefaultableLocale(this));
        } else {
            if (stringArray.length < 6) {
                throw new IllegalArgumentException("Must provide all 6 button labels");
            }
            if (this._buttonLabels == null) {
                this._buttonLabels = new String[6];
            }
            this._buttonLabels[0] = stringArray[0];
            this._buttonLabels[1] = stringArray[2];
            this._buttonLabels[2] = stringArray[1];
            this._buttonLabels[3] = stringArray[3];
            this._buttonLabels[4] = stringArray[4];
            this._buttonLabels[5] = stringArray[5];
        }
        this._updateButtonContents();
    }

    public int[] getButtonMnemonics() {
        int[] nArray = new int[6];
        if (this._buttonMnemonics != null) {
            System.arraycopy(this._buttonMnemonics, 0, nArray, 0, nArray.length);
        } else {
            int n = 0;
            while (n < 6) {
                nArray[n] = 0;
                ++n;
            }
        }
        return nArray;
    }

    public void setButtonMnemonics(int[] nArray) {
        if (nArray == null || nArray.length != 6) {
            throw new IllegalArgumentException("wrong mnemonic count");
        }
        this._buttonMnemonics = nArray;
        this._updateButtonMnemonics();
    }

    public boolean isMoveAllAllowed() {
        return (this._buttonsShown & 2) != 0 && (this._buttonsShown & 8) != 0;
    }

    public boolean isMoveAllowed() {
        return (this._buttonsShown & 1) != 0 && (this._buttonsShown & 4) != 0;
    }

    public int getButtonsShown() {
        return this._buttonsShown;
    }

    public void remove(Component component) {
        if (component != null && component.getParent() == this._shuttleButtons) {
            this._shuttleButtons.remove(component);
            this._updateButtonFocus();
        } else {
            super.remove(component);
        }
    }

    protected void addImpl(Component component, Object object, int n) {
        if (object == null || object == BUTTON_AREA_COMPONENT) {
            int n2 = this._shuttleButtons.getComponentCount();
            if (this.isMoveAllowed()) {
                n2 -= 2;
            } else if (this.isMoveAllAllowed()) {
                --n2;
            }
            this._shuttleButtons.add(component, n2);
            this._updateButtonFocus();
            this.revalidate();
        } else {
            ShuttleLayout shuttleLayout = this._getLayout();
            Component component2 = this.getComponent(object);
            super.addImpl(component, object, n);
            if (component2 != null) {
                super.remove(component2);
            }
        }
    }

    public String getUIClassID() {
        return "EWTShuttleUI";
    }

    public void setLayout(LayoutManager layoutManager) {
        if (layoutManager instanceof ShuttleLayout) {
            super.setLayout(layoutManager);
        }
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this._addButton != null) {
            this._buttonLabels = this.getLocalizedLabels(locale);
            this._updateButtonContents();
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            componentArray[n].setEnabled(bl);
            ++n;
        }
        if (this._toReorderUp != null) {
            this._toReorderUp.setEnabled(bl);
            this._toReorderDown.setEnabled(bl);
        }
        if (this._fromReorderUp != null) {
            this._fromReorderUp.setEnabled(bl);
            this._fromReorderDown.setEnabled(bl);
        }
        Component[] componentArray2 = this._shuttleButtons.getComponents();
        int n2 = 0;
        while (n2 < componentArray2.length) {
            componentArray2[n2].setEnabled(bl);
            ++n2;
        }
        if (bl) {
            this._updateReorderButtonsEnabled(this._toPicker, null);
            if (this._fromPicker != null) {
                this._updateButtonsEnabled(this._fromPicker);
            }
            if (this._toPicker != null) {
                this._updateButtonsEnabled(this._toPicker);
            }
        }
    }

    public void removeAll() {
        if (this._shuttleButtons != null) {
            this._shuttleButtons.removeAll();
        }
        this._setFromPicker(null);
        this._setToPicker(null);
        super.removeAll();
    }

    public void setNextFocusableComponent(Component component) {
        super.setNextFocusableComponent(component);
        this._getLayout().updateFocusCycle();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleShuttle();
        }
        return this.accessibleContext;
    }

    public void updateUI() {
        this.setUI((EWTShuttleUI)UIManager.getUI(this));
        EWTShuttleUI eWTShuttleUI = (EWTShuttleUI)this.ui;
        this._HORIZONTAL_BUTTON_LAYOUT = eWTShuttleUI.getHorizontalButtonLayout(this);
        this._VERTICAL_BUTTON_LAYOUT = eWTShuttleUI.getVerticalButtonLayout(this);
        if (this._horizontalLayout) {
            this._shuttleButtons.setLayout(this._HORIZONTAL_BUTTON_LAYOUT);
        } else {
            this._shuttleButtons.setLayout(this._VERTICAL_BUTTON_LAYOUT);
        }
        this._updateButtonContents();
        this._updateReorderContents();
        Color color = UIManager.getColor("control");
        if (this._toReorderUp != null) {
            this._toReorderUp.setBackground(color);
            this._toReorderDown.setBackground(color);
        }
        if (this._fromReorderUp != null) {
            this._fromReorderUp.setBackground(color);
            this._fromReorderDown.setBackground(color);
        }
    }

    protected String paramString() {
        String string = super.paramString();
        string = string + ", mode=" + (this.getMode() == 0 ? "MOVE" : "COPY");
        string = string + ", horizontal=" + this.isHorizontalLayout();
        string = string + ", reverseLayout=" + this.isLayoutReversed();
        string = string + ", moveAllAllowed=" + this.isMoveAllAllowed();
        string = string + ", textLabels=" + this.getUseTextButtons();
        return string;
    }

    private void _setFromPicker(ItemPicker itemPicker) {
        ItemPicker itemPicker2 = this._fromPicker;
        this._fromPicker = itemPicker;
        this._setPicker(itemPicker2, itemPicker, this._toPicker, false);
    }

    private void _setToPicker(ItemPicker itemPicker) {
        ItemPicker itemPicker2 = this._toPicker;
        this._toPicker = itemPicker;
        this._setPicker(itemPicker2, this._toPicker, this._fromPicker, true);
    }

    private void _setPicker(ItemPicker itemPicker, ItemPicker itemPicker2, ItemPicker itemPicker3, boolean bl) {
        ShuttleHandler shuttleHandler = this._getShuttleHandler();
        if (itemPicker != itemPicker2) {
            if (itemPicker != null) {
                itemPicker.removePropertyChangeListener(shuttleHandler);
                itemPicker.removeActionListener(shuttleHandler);
                if (itemPicker instanceof Reorderable && !(itemPicker2 instanceof Reorderable)) {
                    this._removeReorderControls(bl);
                }
            }
            if (itemPicker2 != null) {
                itemPicker2.addPropertyChangeListener(shuttleHandler);
                itemPicker2.addActionListener(shuttleHandler);
                if (itemPicker2 instanceof Reorderable && !(itemPicker instanceof Reorderable)) {
                    this._createReorderControls(bl);
                }
                this._updateButtonsEnabled(itemPicker2);
            }
            if (itemPicker3 != null) {
                this._updateButtonsEnabled(itemPicker3);
            }
        }
    }

    private Component _getFromComponent() {
        return this._fromPicker != null ? this._fromPicker.getComponent() : null;
    }

    private Component _getToComponent() {
        return this._toPicker != null ? this._toPicker.getComponent() : null;
    }

    private Component _getShuttleControl() {
        return this._getLayout().getShuttleControl();
    }

    private ShuttleLayout _getLayout() {
        return (ShuttleLayout)this.getLayout();
    }

    private ShuttleLayout _createLayoutManager() {
        return new ShuttleLayout(this);
    }

    private JButton _createButton(boolean bl) {
        JButton jButton = new JButton("");
        jButton.setHorizontalTextPosition(bl ? 11 : 10);
        jButton.setVerticalTextPosition(0);
        jButton.addActionListener(this._getShuttleHandler());
        jButton.setMargin(new Insets(0, 2, 0, 2));
        return jButton;
    }

    private void _updateButtonVisibility() {
        this._addAllButton.setVisible((this._buttonsShown & 2) != 0);
        this._removeAllButton.setVisible((this._buttonsShown & 8) != 0);
        this._addButton.setVisible((this._buttonsShown & 1) != 0);
        this._removeButton.setVisible((this._buttonsShown & 4) != 0);
        this._updateButtonFocus();
    }

    private void _updateButtonFocus() {
        int n = this._shuttleButtons.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = this._shuttleButtons.getComponent(n2);
            if (component instanceof JComponent) {
                ((JComponent)component).setNextFocusableComponent(null);
            }
            ++n2;
        }
        this._getLayout().updateFocusCycle();
    }

    private void _loadButtonImage(JButton jButton, int n) {
        Image[] imageArray = _buttonImages;
        if (imageArray == null) {
            imageArray = new Image[8];
        }
        if (this._isActualLayoutReversed()) {
            n = (n + 2) % 4;
        }
        if (!this.isHorizontalLayout()) {
            n += 4;
        }
        EWTShuttleUI eWTShuttleUI = (EWTShuttleUI)this.ui;
        jButton.setIcon(eWTShuttleUI.getButtonIcon(this, n));
    }

    private void _updateButtonContents() {
        boolean bl = this.getMode() == 1;
        String[] stringArray = this._buttonLabels;
        if (this._isActualLayoutReversed()) {
            this._addButton.setHorizontalTextPosition(11);
            this._addAllButton.setHorizontalTextPosition(11);
            this._removeButton.setHorizontalTextPosition(10);
            this._removeAllButton.setHorizontalTextPosition(10);
        } else {
            this._addButton.setHorizontalTextPosition(10);
            this._addAllButton.setHorizontalTextPosition(10);
            this._removeButton.setHorizontalTextPosition(11);
            this._removeAllButton.setHorizontalTextPosition(11);
        }
        if ((this._buttonMode & 2) != 0) {
            this._addButton.setText(bl ? stringArray[4] : stringArray[0]);
            this._addAllButton.setText(bl ? stringArray[5] : stringArray[1]);
            this._removeButton.setText(stringArray[2]);
            this._removeAllButton.setText(stringArray[3]);
            this._addButton.setToolTipText(null);
            this._removeButton.setToolTipText(null);
            this._addAllButton.setToolTipText(null);
            this._removeAllButton.setToolTipText(null);
        } else {
            this._addButton.setText(null);
            this._removeButton.setText(null);
            this._addAllButton.setText(null);
            this._removeAllButton.setText(null);
            this._addButton.setToolTipText(bl ? stringArray[4] : stringArray[0]);
            this._addAllButton.setToolTipText(bl ? stringArray[5] : stringArray[1]);
            this._removeButton.setToolTipText(stringArray[2]);
            this._removeAllButton.setToolTipText(stringArray[3]);
        }
        if ((this._buttonMode & 1) != 0) {
            this._loadButtonImage(this._addButton, 0);
            this._loadButtonImage(this._removeButton, 2);
            this._loadButtonImage(this._addAllButton, 1);
            this._loadButtonImage(this._removeAllButton, 3);
        } else {
            this._addButton.setIcon(null);
            this._addAllButton.setIcon(null);
            this._removeButton.setIcon(null);
            this._removeAllButton.setIcon(null);
        }
        AccessibleContext accessibleContext = this._addButton.getAccessibleContext();
        accessibleContext.setAccessibleName(bl ? stringArray[4] : stringArray[0]);
        accessibleContext = this._addAllButton.getAccessibleContext();
        accessibleContext.setAccessibleName(bl ? stringArray[5] : stringArray[1]);
        accessibleContext = this._removeButton.getAccessibleContext();
        accessibleContext.setAccessibleName(stringArray[2]);
        accessibleContext = this._removeAllButton.getAccessibleContext();
        accessibleContext.setAccessibleName(stringArray[3]);
    }

    private void _updateReorderContents() {
        AccessibleContext accessibleContext;
        if (this._toReorderUp == null && this._fromReorderUp == null) {
            return;
        }
        EWTShuttleUI eWTShuttleUI = (EWTShuttleUI)this.ui;
        boolean bl = this._isActualLayoutReversed();
        if (this._buttonLabels == null) {
            this._buttonLabels = this.getLocalizedLabels(LocaleUtils.getDefaultableLocale(this));
        }
        Icon icon = null;
        if (this._toReorderUp != null) {
            icon = eWTShuttleUI.getButtonIcon(this, bl ? 10 : 8);
            this._toReorderUp.setIcon(icon);
            icon = eWTShuttleUI.getButtonIcon(this, bl ? 11 : 9);
            this._toReorderDown.setIcon(icon);
            accessibleContext = this._toReorderUp.getAccessibleContext();
            accessibleContext.setAccessibleName(this._buttonLabels[6]);
            this._toReorderUp.setToolTipText(this._buttonLabels[6]);
            accessibleContext = this._toReorderDown.getAccessibleContext();
            accessibleContext.setAccessibleName(this._buttonLabels[7]);
            this._toReorderDown.setToolTipText(this._buttonLabels[7]);
        }
        if (this._fromReorderUp != null) {
            icon = eWTShuttleUI.getButtonIcon(this, bl ? 8 : 10);
            this._fromReorderUp.setIcon(icon);
            icon = eWTShuttleUI.getButtonIcon(this, bl ? 9 : 11);
            this._fromReorderDown.setIcon(icon);
            accessibleContext = this._fromReorderUp.getAccessibleContext();
            accessibleContext.setAccessibleName(this._buttonLabels[6]);
            this._fromReorderUp.setToolTipText(this._buttonLabels[6]);
            accessibleContext = this._fromReorderDown.getAccessibleContext();
            accessibleContext.setAccessibleName(this._buttonLabels[7]);
            this._fromReorderDown.setToolTipText(this._buttonLabels[7]);
        }
    }

    private boolean _isActualLayoutReversed() {
        return this._actualReversed;
    }

    void _setActualLayoutReversed(boolean bl) {
        if (this._actualReversed != bl) {
            this._actualReversed = bl;
            this._getLayout().setReverseLayout(bl);
            this._updateButtonContents();
            this._updateReorderContents();
            this.revalidate();
        }
    }

    private void _updateReorderButtonsEnabled(ItemPicker itemPicker, JButton jButton) {
        if (!(itemPicker instanceof Reorderable) || this._ignoreSelectionEvents) {
            return;
        }
        Reorderable reorderable = (Reorderable)((Object)itemPicker);
        if (reorderable == this._fromPicker) {
            this._update(reorderable, this._fromPicker, this._fromReorderUp, this._fromReorderDown);
        } else {
            this._update(reorderable, this._toPicker, this._toReorderUp, this._toReorderDown);
        }
    }

    private void _update(Reorderable reorderable, ItemPicker itemPicker, JButton jButton, JButton jButton2) {
        Component component;
        Component component2 = component = SwingUtilities.findFocusOwner(this);
        boolean bl = reorderable.isSelectionUpwardlyMobile();
        boolean bl2 = reorderable.isSelectionDownwardlyMobile();
        if (component == jButton && !bl) {
            component2 = bl2 ? jButton2 : ShuttleLayout.__getFocusableComponent(itemPicker.getComponent());
        } else if (component == jButton2 && !bl2) {
            component2 = bl ? jButton : ShuttleLayout.__getFocusableComponent(itemPicker.getComponent());
        }
        jButton.setEnabled(bl);
        jButton2.setEnabled(bl2);
        if (component != component2 && component2 != null) {
            component.requestFocus();
        }
    }

    private void _updateButtonsEnabled(ItemPicker itemPicker) {
        Object object;
        JButton jButton;
        JButton jButton2;
        if (itemPicker == this._fromPicker) {
            jButton2 = this._addButton;
            jButton = this._addAllButton;
        } else {
            jButton2 = this._removeButton;
            jButton = this._removeAllButton;
        }
        this._updateReorderButtonsEnabled(itemPicker, null);
        boolean bl = itemPicker.isSelectableItemPresent();
        boolean bl2 = itemPicker.isItemSelected();
        if (itemPicker == this._fromPicker && this._toPicker != null) {
            boolean bl3 = bl2;
            object = itemPicker.getSelectionDataFlavors();
            if (bl2 && object != null) {
                bl2 = this._toPicker.canAcceptFlavors((DataFlavor[])object);
            }
            if (bl && (bl2 || !bl3)) {
                if (object != null) {
                    bl = this._toPicker.canAcceptFlavors((DataFlavor[])object);
                }
            } else {
                bl = false;
            }
        }
        Component component = SwingUtilities.findFocusOwner(this);
        jButton.setEnabled(bl);
        jButton2.setEnabled(bl2);
        object = null;
        if (component == jButton2 && !bl2) {
            if (jButton2 == this._addButton) {
                if (this._toPicker != null) {
                    object = FocusUtils.getFirstFocusableComponent((Container)this._toPicker.getComponent());
                }
            } else if (jButton2 == this._removeButton && this._fromPicker != null) {
                object = FocusUtils.getFirstFocusableComponent((Container)this._fromPicker.getComponent());
            }
        } else if (component == jButton && !bl) {
            if (jButton == this._addAllButton) {
                if (this._toPicker != null) {
                    object = FocusUtils.getFirstFocusableComponent((Container)this._toPicker.getComponent());
                }
            } else if (jButton == this._removeAllButton && this._fromPicker != null) {
                object = FocusUtils.getFirstFocusableComponent((Container)this._fromPicker.getComponent());
            }
        }
        if (object != null) {
            object.requestFocus();
        }
        this._updateButtonFocus();
    }

    private boolean _addItems() {
        boolean bl;
        ItemPicker itemPicker = this._fromPicker;
        ItemPicker itemPicker2 = this._toPicker;
        DataFlavor[] dataFlavorArray = itemPicker.getSelectionDataFlavors();
        boolean bl2 = bl = dataFlavorArray == null ? true : itemPicker2.canAcceptFlavors(dataFlavorArray);
        if (bl) {
            itemPicker2.deselectAll();
            boolean bl3 = itemPicker2.addSelectedItems(itemPicker.getSelectedItems());
            if (this._itemsUnique == 0 && bl3) {
                itemPicker.removeSelectedItems();
            }
            return true;
        }
        return false;
    }

    private boolean _removeItems() {
        ItemPicker itemPicker = this._fromPicker;
        ItemPicker itemPicker2 = this._toPicker;
        boolean bl = true;
        if (this._itemsUnique == 0) {
            bl = itemPicker.addSelectedItems(itemPicker2.getSelectedItems());
        }
        if (bl) {
            itemPicker2.removeSelectedItems();
            return true;
        }
        return false;
    }

    private ShuttleHandler _getShuttleHandler() {
        if (this._handler == null) {
            this._handler = new ShuttleHandler();
        }
        return this._handler;
    }

    protected void processShuttleEvent(ShuttleEvent shuttleEvent) {
        Enumeration enumeration;
        int n = shuttleEvent.getID();
        ListenerManager listenerManager = this._shuttleListeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                ShuttleListener shuttleListener = (ShuttleListener)enumeration.nextElement();
                switch (n) {
                    case 2000: 
                    case 2001: 
                    case 2002: 
                    case 2003: {
                        shuttleListener.shuttleItemsMoved(shuttleEvent);
                        break;
                    }
                    case 2004: 
                    case 2005: {
                        shuttleListener.shuttleItemsRemoved(shuttleEvent);
                        break;
                    }
                    case 2006: 
                    case 2007: {
                        shuttleListener.shuttleItemsReordered(shuttleEvent);
                        break;
                    }
                }
            }
        }
    }

    protected String[] getLocalizedLabels(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.bali.ewt.resource.JEWTBundle", locale);
        String[] stringArray = new String[8];
        stringArray[0] = resourceBundle.getString(_MOVE_KEY);
        stringArray[2] = resourceBundle.getString(_REMOVE_KEY);
        stringArray[1] = resourceBundle.getString(_MOVE_ALL_KEY);
        stringArray[3] = resourceBundle.getString(_REMOVE_ALL_KEY);
        stringArray[4] = resourceBundle.getString(_COPY_KEY);
        stringArray[5] = resourceBundle.getString(_COPY_ALL_KEY);
        stringArray[6] = resourceBundle.getString(_REORDER_UP_KEY);
        stringArray[7] = resourceBundle.getString(_REORDER_DOWN_KEY);
        return stringArray;
    }

    private void _disposeReorderControls() {
        ShuttleHandler shuttleHandler = this._handler;
        if (this._toReorderUp != null) {
            this._toReorderUp.removeActionListener(shuttleHandler);
            this._toReorderUp.setModel(null);
            this._toReorderUp = null;
        }
        if (this._toReorderDown != null) {
            this._toReorderDown.removeActionListener(shuttleHandler);
            this._toReorderDown.setModel(null);
            this._toReorderDown = null;
        }
        if (this._fromReorderUp != null) {
            this._fromReorderUp.removeActionListener(shuttleHandler);
            this._fromReorderUp.setModel(null);
            this._fromReorderUp = null;
        }
        if (this._fromReorderDown != null) {
            this._fromReorderDown.removeActionListener(shuttleHandler);
            this._fromReorderDown.setModel(null);
            this._fromReorderDown = null;
        }
    }

    private void _createReorderControls(boolean bl) {
        ShuttleHandler shuttleHandler = this._getShuttleHandler();
        JButton jButton = new JButton();
        jButton.setMargin(new Insets(0, 2, 0, 2));
        jButton.addActionListener(shuttleHandler);
        jButton.setModel(new ShuttleButtonModel(jButton));
        JButton jButton2 = new JButton();
        jButton2.setMargin(new Insets(0, 2, 0, 2));
        jButton2.addActionListener(shuttleHandler);
        jButton2.setModel(new ShuttleButtonModel(jButton2));
        JPanel jPanel = new JPanel(_REORDER_LAYOUT);
        FocusUtils.setFocusable(jPanel, false);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jButton.addFocusListener(shuttleHandler);
        jButton2.addFocusListener(shuttleHandler);
        if (bl) {
            this._toReorderUp = jButton;
            this._toReorderDown = jButton2;
            this.add((Component)jPanel, "ToReorderControl");
        } else {
            this._fromReorderUp = jButton;
            this._fromReorderDown = jButton2;
            this.add((Component)jPanel, "FromReorderControl");
        }
        this._updateReorderContents();
        this._updateReorderButtonsEnabled(bl ? this._toPicker : this._fromPicker, null);
    }

    private void _removeReorderControls(boolean bl) {
        Container container = null;
        if (bl) {
            container = this._toReorderUp.getParent();
            this._toReorderDown = null;
            this._toReorderUp = null;
        } else {
            container = this._fromReorderUp.getParent();
            this._fromReorderDown = null;
            this._fromReorderUp = null;
        }
        this.remove(container);
    }

    private boolean _processMove() {
        boolean bl = false;
        if (this._fromPicker == null || this._toPicker == null) {
            return bl;
        }
        if (this._fromPicker.isItemSelected()) {
            Transferable[] transferableArray = this._fromPicker.getSelectedItems();
            bl = this._addItems();
            if (bl) {
                if (this._itemsUnique == 0) {
                    this.processShuttleEvent(new ShuttleEvent(this, 2000, transferableArray));
                } else {
                    this.processShuttleEvent(new ShuttleEvent(this, 2002, transferableArray));
                }
            }
        }
        this._updateShuttleButtonsEnabled();
        return bl;
    }

    private boolean _processRemove() {
        boolean bl = false;
        if (this._fromPicker == null || this._toPicker == null) {
            return bl;
        }
        if (this._toPicker.isItemSelected()) {
            Transferable[] transferableArray = this._toPicker.getSelectedItems();
            bl = this._removeItems();
            if (bl) {
                this.processShuttleEvent(new ShuttleEvent(this, 2004, transferableArray));
            }
        }
        this._updateShuttleButtonsEnabled();
        return bl;
    }

    private boolean _processMoveAll() {
        boolean bl;
        boolean bl2 = false;
        if (this._fromPicker == null || this._toPicker == null) {
            return bl2;
        }
        DataFlavor[] dataFlavorArray = this._fromPicker.getSelectionDataFlavors();
        boolean bl3 = bl = dataFlavorArray == null ? true : this._toPicker.canAcceptFlavors(dataFlavorArray);
        if (bl) {
            this._toPicker.deselectAll();
            boolean bl4 = false;
            Transferable[] transferableArray = this._fromPicker.getAllSelectableItems();
            bl4 = this._toPicker.addSelectedItems(transferableArray);
            if (this._itemsUnique == 0 && bl4) {
                this._fromPicker.removeAllSelectableItems();
            }
            if (bl4) {
                bl2 = true;
            }
            if (this._itemsUnique == 0) {
                this.processShuttleEvent(new ShuttleEvent(this, 2001, transferableArray));
            } else {
                this.processShuttleEvent(new ShuttleEvent(this, 2003, transferableArray));
            }
        }
        this._updateShuttleButtonsEnabled();
        return bl2;
    }

    private boolean _processRemoveAll() {
        if (this._fromPicker == null || this._toPicker == null) {
            return false;
        }
        boolean bl = this._itemsUnique == 1;
        this._fromPicker.deselectAll();
        Transferable[] transferableArray = this._toPicker.getAllSelectableItems();
        if (this._itemsUnique == 0) {
            bl = this._fromPicker.addSelectedItems(transferableArray);
        }
        if (bl) {
            this._toPicker.removeAllSelectableItems();
        }
        this.processShuttleEvent(new ShuttleEvent(this, 2005, transferableArray));
        this._updateShuttleButtonsEnabled();
        return bl;
    }

    private void _updateShuttleButtonsEnabled() {
        this._updateButtonsEnabled(this._fromPicker);
        this._updateButtonsEnabled(this._toPicker);
    }

    private void _updateButtonMnemonics() {
        boolean bl;
        if (this._buttonMnemonics == null) {
            return;
        }
        boolean bl2 = bl = (this.getMode() & 1) != 0;
        if (bl) {
            this._addButton.setMnemonic(this._buttonMnemonics[4]);
            this._addAllButton.setMnemonic(this._buttonMnemonics[5]);
        } else {
            this._addButton.setMnemonic(this._buttonMnemonics[0]);
            this._addAllButton.setMnemonic(this._buttonMnemonics[2]);
        }
        this._removeButton.setMnemonic(this._buttonMnemonics[1]);
        this._removeAllButton.setMnemonic(this._buttonMnemonics[3]);
    }

    static /* synthetic */ int[] access$002(Shuttle shuttle, int[] nArray) {
        shuttle._actionMap = nArray;
        return nArray;
    }

    static /* synthetic */ String[] access$102(Shuttle shuttle, String[] stringArray) {
        shuttle._buttonLabels = stringArray;
        return stringArray;
    }

    static {
        _REORDER_LAYOUT = new EqualColumnLayout(3);
    }

    private class ShuttleButtonModel
    extends ContinuousButtonModel {
        public ShuttleButtonModel(AbstractButton abstractButton) {
            super(abstractButton);
        }

        protected void processPulse() {
            Reorderable reorderable;
            AbstractButton abstractButton = this.getButton();
            if (abstractButton == Shuttle.this._toReorderUp) {
                Reorderable reorderable2 = (Reorderable)((Object)Shuttle.this._toPicker);
                if (reorderable2.isSelectionUpwardlyMobile()) {
                    Shuttle.this._ignoreSelectionEvents = true;
                    try {
                        reorderable2.moveSelectionUp();
                        Shuttle.this.processShuttleEvent(new ShuttleEvent(Shuttle.this, 2006, Shuttle.this._toPicker.getSelectedItems()));
                        Object var4_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        Shuttle.this._ignoreSelectionEvents = false;
                        throw throwable;
                    }
                    Shuttle.this._ignoreSelectionEvents = false;
                    Shuttle.this._updateReorderButtonsEnabled(Shuttle.this._toPicker, Shuttle.this._toReorderUp);
                    Shuttle.this._updateButtonFocus();
                }
            } else if (abstractButton == Shuttle.this._toReorderDown) {
                Reorderable reorderable3 = (Reorderable)((Object)Shuttle.this._toPicker);
                if (reorderable3.isSelectionDownwardlyMobile()) {
                    Shuttle.this._ignoreSelectionEvents = true;
                    try {
                        reorderable3.moveSelectionDown();
                        Shuttle.this.processShuttleEvent(new ShuttleEvent(Shuttle.this, 2007, Shuttle.this._toPicker.getSelectedItems()));
                        Object var6_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_10 = null;
                        Shuttle.this._ignoreSelectionEvents = false;
                        throw throwable;
                    }
                    Shuttle.this._ignoreSelectionEvents = false;
                    Shuttle.this._updateReorderButtonsEnabled(Shuttle.this._toPicker, Shuttle.this._toReorderDown);
                    Shuttle.this._updateButtonFocus();
                }
            } else if (abstractButton == Shuttle.this._fromReorderUp) {
                Reorderable reorderable4 = (Reorderable)((Object)Shuttle.this._fromPicker);
                if (reorderable4.isSelectionUpwardlyMobile()) {
                    Shuttle.this._ignoreSelectionEvents = true;
                    try {
                        reorderable4.moveSelectionUp();
                        Shuttle.this.processShuttleEvent(new ShuttleEvent(Shuttle.this, 2006, Shuttle.this._fromPicker.getSelectedItems()));
                        Object var8_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_13 = null;
                        Shuttle.this._ignoreSelectionEvents = false;
                        throw throwable;
                    }
                    Shuttle.this._ignoreSelectionEvents = false;
                    Shuttle.this._updateReorderButtonsEnabled(Shuttle.this._fromPicker, Shuttle.this._fromReorderUp);
                    Shuttle.this._updateButtonFocus();
                }
            } else if (abstractButton == Shuttle.this._fromReorderDown && (reorderable = (Reorderable)((Object)Shuttle.this._fromPicker)).isSelectionDownwardlyMobile()) {
                Shuttle.this._ignoreSelectionEvents = true;
                try {
                    reorderable.moveSelectionDown();
                    Shuttle.this.processShuttleEvent(new ShuttleEvent(Shuttle.this, 2007, Shuttle.this._fromPicker.getSelectedItems()));
                    Object var10_15 = null;
                }
                catch (Throwable throwable) {
                    Object var10_16 = null;
                    Shuttle.this._ignoreSelectionEvents = false;
                    throw throwable;
                }
                Shuttle.this._ignoreSelectionEvents = false;
                Shuttle.this._updateReorderButtonsEnabled(Shuttle.this._fromPicker, Shuttle.this._fromReorderDown);
                Shuttle.this._updateButtonFocus();
            }
        }
    }

    class ShuttleHandler
    implements ActionListener,
    PropertyChangeListener,
    FocusListener {
        ShuttleHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ItemPicker itemPicker = Shuttle.this._fromPicker;
            ItemPicker itemPicker2 = Shuttle.this._toPicker;
            if (actionEvent.getSource() instanceof ItemPicker) {
                ItemPicker itemPicker3 = (ItemPicker)actionEvent.getSource();
                if (itemPicker3 == itemPicker) {
                    Shuttle.this._processMove();
                } else if (itemPicker3 == itemPicker2) {
                    Shuttle.this._processRemove();
                }
            } else if (actionEvent.getSource() instanceof Component) {
                Component component = (Component)actionEvent.getSource();
                if (component == Shuttle.this._addButton) {
                    Shuttle.this._processMove();
                } else if (component == Shuttle.this._addAllButton) {
                    Shuttle.this._processMoveAll();
                } else if (component == Shuttle.this._removeButton) {
                    Shuttle.this._processRemove();
                } else if (component == Shuttle.this._removeAllButton) {
                    Shuttle.this._processRemoveAll();
                }
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == "selection") {
                Shuttle.this._updateButtonsEnabled((ItemPicker)propertyChangeEvent.getSource());
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            Component component = focusEvent.getComponent();
            if (!component.isEnabled()) {
                if (component == Shuttle.this._fromReorderUp) {
                    Shuttle.this._fromReorderDown.requestFocus();
                } else if (component == Shuttle.this._fromReorderDown) {
                    Shuttle.this._fromReorderUp.requestFocus();
                } else if (component == Shuttle.this._toReorderUp) {
                    Shuttle.this._toReorderDown.requestFocus();
                } else if (component == Shuttle.this._toReorderDown) {
                    Shuttle.this._toReorderUp.requestFocus();
                }
            }
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    protected class AccessibleShuttle
    extends JComponent.AccessibleJComponent
    implements AccessibleAction {
        protected AccessibleShuttle() {
            super(Shuttle.this);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (Shuttle.this.isHorizontalLayout()) {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            } else {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            }
            return accessibleStateSet;
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public int getAccessibleActionCount() {
            if (Shuttle.this._actionMap == null) {
                boolean bl = Shuttle.this.isMoveAllowed();
                boolean bl2 = Shuttle.this.isMoveAllAllowed();
                int n = 0;
                if (bl) {
                    n += 2;
                }
                if (bl2) {
                    n += 2;
                }
                Shuttle.access$002(Shuttle.this, new int[n]);
                int n2 = 0;
                if (bl) {
                    ((Shuttle)Shuttle.this)._actionMap[n2] = 0;
                    ((Shuttle)Shuttle.this)._actionMap[n2 + 1] = 2;
                    n2 += 2;
                }
                if (bl2) {
                    ((Shuttle)Shuttle.this)._actionMap[n2] = 1;
                    ((Shuttle)Shuttle.this)._actionMap[n2 + 1] = 3;
                }
            }
            return Shuttle.this._actionMap.length;
        }

        public String getAccessibleActionDescription(int n) {
            if (Shuttle.this._buttonLabels == null) {
                Shuttle.access$102(Shuttle.this, Shuttle.this.getLocalizedLabels(LocaleUtils.getDefaultableLocale(Shuttle.this)));
            }
            return Shuttle.this._buttonLabels[Shuttle.this._actionMap[n]];
        }

        public boolean doAccessibleAction(int n) {
            boolean bl = false;
            int n2 = Shuttle.this._actionMap[n];
            if (n2 == 0) {
                bl = Shuttle.this._processMove();
            } else if (n2 == 2) {
                bl = Shuttle.this._processRemove();
            } else if (n2 == 1) {
                bl = Shuttle.this._processMoveAll();
            } else if (n2 == 3) {
                bl = Shuttle.this._processRemoveAll();
            }
            return bl;
        }
    }
}

