/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.shuttle;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.text.Collator;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.util.FocusUtils;
import oracle.bali.share.datatransfer.ObjectTransferable;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.Sort;
import oracle.bali.share.sort.StringComparator;

public class ListPicker
implements ItemPicker {
    private JList _list;
    private ActionListener _actionListener;
    private PropertyChangeSupport _changeSupport;
    private boolean _sort;
    private JScrollPane _pane;
    private int _lastListSize;
    private Handler _handler;

    public ListPicker(JList jList) {
        if (null == jList) {
            throw new IllegalArgumentException();
        }
        this._pane = new JScrollPane(jList){

            public boolean isFocusTraversable() {
                return false;
            }

            public JViewport createViewport() {
                return new JViewport(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public boolean isFocusTraversable() {
                        return false;
                    }
                };
            }
        };
        FocusUtils.setFocusable(this._pane.getVerticalScrollBar(), false);
        FocusUtils.setFocusable(this._pane.getHorizontalScrollBar(), false);
        this._list = jList;
        this._handler = new Handler();
        this._checkAndResetListModel();
        jList.getSelectionModel().addListSelectionListener(this._handler);
        jList.addMouseListener(this._handler);
        jList.addFocusListener(this._handler);
        if (this.getItemsSorted()) {
            this.sortItems();
        }
        this._updateLastListSize();
        this._list.getModel().addListDataListener(this._handler);
        this._list.addPropertyChangeListener(this._handler);
        this._list.addKeyListener(this._handler);
    }

    public void dispose() {
        if (this._list == null) {
            return;
        }
        this._pane.setViewportView(null);
        this._pane = null;
        this._list.getSelectionModel().removeListSelectionListener(this._handler);
        this._list.removeMouseListener(this._handler);
        this._list.getModel().removeListDataListener(this._handler);
        this._list.removeFocusListener(this._handler);
        this._list.removeKeyListener(this._handler);
        this._list.removePropertyChangeListener(this._handler);
        this._handler = null;
        this._actionListener = null;
        this._changeSupport = null;
        this._list = null;
    }

    public boolean getItemsSorted() {
        return this._sort;
    }

    public void setItemsSorted(boolean bl) {
        if (bl != this._sort) {
            this._sort = bl;
            if (bl) {
                this.sortItems();
            }
        }
    }

    public JList getList() {
        return this._list;
    }

    public boolean isSelectableItemPresent() {
        return this._list.getModel().getSize() > 0;
    }

    public boolean isItemSelected() {
        return !this._list.isSelectionEmpty();
    }

    public void deselectAll() {
        this._list.clearSelection();
    }

    public void removeSelectedItems() {
        ListModel listModel = this._list.getModel();
        if (!(listModel instanceof DefaultListModel)) {
            return;
        }
        DefaultListModel defaultListModel = (DefaultListModel)listModel;
        ListSelectionModel listSelectionModel = this._list.getSelectionModel();
        int[] nArray = this._list.getSelectedIndices();
        int n = nArray.length;
        this._list.setModel(new DefaultListModel());
        --n;
        while (n >= 0) {
            defaultListModel.remove(nArray[n]);
            --n;
        }
        this._list.setModel(defaultListModel);
    }

    public void removeAllSelectableItems() {
        ListModel listModel = this._list.getModel();
        if (!(listModel instanceof DefaultListModel)) {
            return;
        }
        DefaultListModel defaultListModel = (DefaultListModel)listModel;
        defaultListModel.removeAllElements();
    }

    public Transferable[] getSelectedItems() {
        Object[] objectArray = this._list.getSelectedValues();
        if (objectArray != null) {
            int n = objectArray.length;
            Transferable[] transferableArray = new Transferable[n];
            int n2 = 0;
            while (n2 < n) {
                transferableArray[n2] = this.createTransferable(objectArray[n2]);
                ++n2;
            }
            return transferableArray;
        }
        return null;
    }

    public Transferable[] getAllSelectableItems() {
        Object[] objectArray = this._getItems();
        if (objectArray != null) {
            int n = objectArray.length;
            Transferable[] transferableArray = new Transferable[n];
            int n2 = 0;
            while (n2 < n) {
                transferableArray[n2] = this.createTransferable(objectArray[n2]);
                ++n2;
            }
            return transferableArray;
        }
        return null;
    }

    public Component getComponent() {
        return this._pane;
    }

    public DataFlavor[] getSelectionDataFlavors() {
        return null;
    }

    public void addActionListener(ActionListener actionListener) {
        this._actionListener = AWTEventMulticaster.add(this._actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this._actionListener = AWTEventMulticaster.remove(this._actionListener, actionListener);
        if (this._actionListener == null) {
            this._list.removeMouseListener(this._handler);
        }
    }

    public boolean addSelectedItems(Transferable[] transferableArray) {
        return this._insertItems(transferableArray);
    }

    public boolean canAcceptFlavors(DataFlavor[] dataFlavorArray) {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._changeSupport == null) {
            this._changeSupport = new PropertyChangeSupport(this);
        }
        this._changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._changeSupport != null) {
            this._changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected Transferable createTransferable(Object object) {
        return ObjectTransferable.createTransferable(object);
    }

    protected synchronized void sortItems() {
        ListModel listModel = this._list.getModel();
        if (!(listModel instanceof DefaultListModel)) {
            return;
        }
        Object[] objectArray = this._getItems();
        Sort.qSort(objectArray, objectArray.length, this.getComparator());
        DefaultListModel defaultListModel = (DefaultListModel)listModel;
        this._list.setModel(new DefaultListModel());
        defaultListModel.removeAllElements();
        int n = 0;
        while (n < objectArray.length) {
            defaultListModel.addElement(objectArray[n]);
            ++n;
        }
        this._list.setModel(defaultListModel);
    }

    protected Comparator getComparator() {
        Collator collator = Collator.getInstance(LocaleUtils.getDefaultableLocale(this.getList()));
        return new StringComparator(collator);
    }

    private boolean _insertItems(Transferable[] transferableArray) {
        ListModel listModel = this._list.getModel();
        if (!(listModel instanceof DefaultListModel)) {
            return false;
        }
        if (!this._checkFlavorCompatibility(transferableArray)) {
            return false;
        }
        int n = transferableArray.length;
        DefaultListModel defaultListModel = (DefaultListModel)listModel;
        ListSelectionModel listSelectionModel = this._list.getSelectionModel();
        this._list.setSelectionModel(new DefaultListSelectionModel());
        this._list.setModel(new DefaultListModel());
        int n2 = defaultListModel.getSize();
        int n3 = 0;
        while (n3 < n) {
            Transferable transferable = transferableArray[n3];
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            if (dataFlavorArray == null || dataFlavorArray.length < 1) {
                return false;
            }
            Object object = null;
            try {
                object = transferable.getTransferData(dataFlavorArray[0]);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
            defaultListModel.addElement(object);
            listSelectionModel.addSelectionInterval(n2, n2);
            ++n2;
            ++n3;
        }
        this._list.setModel(defaultListModel);
        this._list.setSelectionModel(listSelectionModel);
        if (this.getItemsSorted()) {
            this.sortItems();
        }
        return true;
    }

    private boolean _checkFlavorCompatibility(Transferable[] transferableArray) {
        if (transferableArray == null) {
            return false;
        }
        int n = 0;
        while (n < transferableArray.length) {
            Transferable transferable = transferableArray[n];
            if (transferable != null && !this.canAcceptFlavors(transferable.getTransferDataFlavors())) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private Object[] _getItems() {
        ListModel listModel = this._list.getModel();
        int n = listModel.getSize();
        Object[] objectArray = new Object[n];
        if (listModel instanceof DefaultListModel) {
            DefaultListModel defaultListModel = (DefaultListModel)listModel;
            defaultListModel.copyInto(objectArray);
        } else {
            int n2 = 0;
            while (n2 < n) {
                objectArray[n2] = listModel.getElementAt(n2);
                ++n2;
            }
        }
        return objectArray;
    }

    private boolean _checkAndResetListModel() {
        ListModel listModel = this._list.getModel();
        if (listModel instanceof DefaultListModel) {
            return false;
        }
        int n = listModel.getSize();
        DefaultListModel defaultListModel = new DefaultListModel();
        int n2 = 0;
        while (n2 < n) {
            defaultListModel.add(n2, listModel.getElementAt(n2));
            ++n2;
        }
        this._list.setModel(defaultListModel);
        return true;
    }

    private void _firePropertyChange(String string, Object object, Object object2) {
        if (this._changeSupport != null) {
            this._changeSupport.firePropertyChange(string, object, object2);
        }
    }

    private void _checkItemCount() {
        if (this._changeSupport == null) {
            return;
        }
        int n = this._list.getModel().getSize();
        if (n > 0 && this._lastListSize == 0 || n == 0 && this._lastListSize > 0) {
            this._changeSupport.firePropertyChange("selection", Boolean.TRUE, Boolean.FALSE);
        }
        this._updateLastListSize();
    }

    private void _updateLastListSize() {
        this._lastListSize = this._list.getModel().getSize();
    }

    private class Handler
    extends MouseAdapter
    implements ListSelectionListener,
    ListDataListener,
    PropertyChangeListener,
    FocusListener,
    KeyListener {
        private Handler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                ListPicker.this._firePropertyChange("selection", null, null);
            }
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            ListPicker.this._checkItemCount();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            ListPicker.this._checkItemCount();
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            ListPicker.this._checkItemCount();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            if (mouseEvent.getClickCount() % 2 == 0 && SwingUtilities.isLeftMouseButton(mouseEvent) && (n = ListPicker.this._list.locationToIndex(mouseEvent.getPoint())) != -1) {
                ListPicker.this._actionListener.actionPerformed(new ActionEvent(ListPicker.this, mouseEvent.getID(), null, mouseEvent.getModifiers()));
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10 && keyEvent.getModifiers() == 0 && ListPicker.this._list.getSelectedIndex() != -1 && ListPicker.this._actionListener != null) {
                keyEvent.consume();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10 && keyEvent.getModifiers() == 0 && ListPicker.this._list.getSelectedIndex() != -1 && ListPicker.this._actionListener != null) {
                ListPicker.this._actionListener.actionPerformed(new ActionEvent(ListPicker.this, 1001, null));
                keyEvent.consume();
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("selectionModel".equals(string)) {
                Object object;
                Object object2 = propertyChangeEvent.getOldValue();
                if (object2 instanceof ListSelectionModel) {
                    ((ListSelectionModel)object2).removeListSelectionListener(this);
                }
                if ((object = propertyChangeEvent.getNewValue()) instanceof ListSelectionModel) {
                    ((ListSelectionModel)object).addListSelectionListener(this);
                }
            } else if ("model".equals(string)) {
                Object object;
                Object object3 = propertyChangeEvent.getOldValue();
                if (object3 instanceof ListModel) {
                    ((ListModel)object3).removeListDataListener(ListPicker.this._handler);
                }
                if ((object = propertyChangeEvent.getNewValue()) instanceof ListModel) {
                    ((ListModel)object).addListDataListener(ListPicker.this._handler);
                }
                ListPicker.this._updateLastListSize();
                if (!ListPicker.this._checkAndResetListModel()) {
                    ListPicker.this._firePropertyChange("selection", null, null);
                }
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            if (ListPicker.this._list.getSelectedIndex() == -1 && (ListPicker.this._list.getSelectionModel().getAnchorSelectionIndex() == -1 || ListPicker.this._list.getSelectionModel().getLeadSelectionIndex() == -1) && ListPicker.this._list.getModel().getSize() != 0) {
                ListPicker.this._list.getSelectionModel().setAnchorSelectionIndex(0);
                ListPicker.this._list.getSelectionModel().setLeadSelectionIndex(0);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }
}

