/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.selection;

import java.util.Vector;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.CellRange;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.Sort;

public class TwoDSelection {
    private OneDSelection _columnSelection;
    private OneDSelection _rowSelection;
    private CellRange[] _cellRanges;
    private static TwoDSelection _emptySelection;
    private static CellRangeComparator _cellRangeComparator;

    public TwoDSelection() {
    }

    public TwoDSelection(int n, boolean bl) {
        OneDSelection oneDSelection = new OneDSelection(n);
        this._init(bl ? null : oneDSelection, bl ? oneDSelection : null, null);
    }

    public TwoDSelection(OneDSelection oneDSelection, OneDSelection oneDSelection2) {
        this._init(oneDSelection, oneDSelection2, null);
    }

    public TwoDSelection(OneDSelection oneDSelection, OneDSelection oneDSelection2, CellRange[] cellRangeArray) {
        this._init(oneDSelection, oneDSelection2, cellRangeArray);
    }

    public TwoDSelection(Cell cell) {
        this(null, null, cell.column, cell.row);
    }

    public TwoDSelection(int n, int n2) {
        this(null, null, n, n2);
    }

    public TwoDSelection(OneDSelection oneDSelection, OneDSelection oneDSelection2, CellRange cellRange) {
        this(oneDSelection, oneDSelection2, cellRange.getLowerLimit(), cellRange.getUpperLimit());
    }

    public TwoDSelection(OneDSelection oneDSelection, OneDSelection oneDSelection2, Cell cell) {
        this(oneDSelection, oneDSelection2, cell.column, cell.row, cell.column, cell.row);
    }

    public TwoDSelection(OneDSelection oneDSelection, OneDSelection oneDSelection2, Cell cell, Cell cell2) {
        this(oneDSelection, oneDSelection2, cell.column, cell.row, cell2.column, cell2.row);
    }

    public TwoDSelection(OneDSelection oneDSelection, OneDSelection oneDSelection2, int n, int n2) {
        this(oneDSelection, oneDSelection2, n, n2, n, n2);
    }

    public TwoDSelection(OneDSelection oneDSelection, OneDSelection oneDSelection2, int n, int n2, int n3, int n4) {
        CellRange[] cellRangeArray = new CellRange[1];
        Cell cell = new Cell(n, n2);
        Cell cell2 = new Cell(n3, n4);
        cellRangeArray[0] = new CellRange(cell, cell2);
        this._init(oneDSelection, oneDSelection2, cellRangeArray);
    }

    public CellRange[] getCellRanges() {
        return this._cellRanges;
    }

    public OneDSelection getColumnSelection() {
        if (this._columnSelection == null) {
            return OneDSelection.getEmptySelection();
        }
        return this._columnSelection;
    }

    public OneDSelection getRowSelection() {
        if (this._rowSelection == null) {
            return OneDSelection.getEmptySelection();
        }
        return this._rowSelection;
    }

    public final Cell getSingleCell() {
        CellRange[] cellRangeArray = this.getCellRanges();
        if (cellRangeArray != null && cellRangeArray.length > 0) {
            Cell cell = cellRangeArray[0].getLowerLimit();
            return new Cell(cell.column, cell.row);
        }
        return null;
    }

    public final int getSingleRow() {
        return this.getRowSelection().getSingleItem();
    }

    public final int getSingleColumn() {
        return this.getColumnSelection().getSingleItem();
    }

    public TwoDSelection add(TwoDSelection twoDSelection) {
        CellRange[] cellRangeArray = CellRange.addCellRanges(this.getCellRanges(), twoDSelection.getCellRanges());
        OneDSelection oneDSelection = this.getColumnSelection().add(twoDSelection.getColumnSelection());
        OneDSelection oneDSelection2 = this.getRowSelection().add(twoDSelection.getRowSelection());
        return new TwoDSelection(oneDSelection, oneDSelection2, cellRangeArray);
    }

    public TwoDSelection subtract(TwoDSelection twoDSelection) {
        CellRange[] cellRangeArray = CellRange.subtractCellRanges(this.getCellRanges(), twoDSelection.getCellRanges());
        OneDSelection oneDSelection = this.getColumnSelection().subtract(twoDSelection.getColumnSelection());
        OneDSelection oneDSelection2 = this.getRowSelection().subtract(twoDSelection.getRowSelection());
        return new TwoDSelection(oneDSelection, oneDSelection2, cellRangeArray);
    }

    public TwoDSelection addColumns(int n, int n2) {
        OneDSelection oneDSelection = this.getColumnSelection().addItems(n, n2);
        OneDSelection oneDSelection2 = this.getRowSelection();
        CellRange[] cellRangeArray = this.getCellRanges();
        Object[] objectArray = null;
        if (cellRangeArray != null && cellRangeArray.length > 0) {
            Vector<CellRange> vector = new Vector<CellRange>();
            int n3 = 0;
            while (n3 < cellRangeArray.length) {
                int n4 = cellRangeArray[n3].getLowerLimit().row;
                int n5 = cellRangeArray[n3].getUpperLimit().row;
                int n6 = cellRangeArray[n3].getLowerLimit().column;
                int n7 = cellRangeArray[n3].getUpperLimit().column;
                if (n <= n6) {
                    vector.addElement(new CellRange(n6 + n2, n4, n7 + n2, n5));
                } else if (n > n7) {
                    vector.addElement(new CellRange(n6, n4, n7, n5));
                } else {
                    vector.addElement(new CellRange(n6, n4, n - 1, n5));
                    vector.addElement(new CellRange(n + n2, n4, n7 + n2, n5));
                }
                ++n3;
            }
            objectArray = new CellRange[vector.size()];
            vector.copyInto(objectArray);
        }
        return new TwoDSelection(oneDSelection, oneDSelection2, (CellRange[])objectArray);
    }

    public TwoDSelection removeColumns(int n, int n2) {
        OneDSelection oneDSelection = this.getColumnSelection().removeItems(n, n2);
        OneDSelection oneDSelection2 = this.getRowSelection();
        CellRange[] cellRangeArray = this.getCellRanges();
        Object[] objectArray = null;
        if (cellRangeArray != null && cellRangeArray.length > 0) {
            Vector<CellRange> vector = new Vector<CellRange>();
            int n3 = 0;
            while (n3 < cellRangeArray.length) {
                int n4 = cellRangeArray[n3].getLowerLimit().row;
                int n5 = cellRangeArray[n3].getUpperLimit().row;
                int n6 = cellRangeArray[n3].getLowerLimit().column;
                int n7 = cellRangeArray[n3].getUpperLimit().column;
                if (n + n2 <= n6) {
                    vector.addElement(new CellRange(n6 - n2, n4, n7 - n2, n5));
                } else if (n > n7) {
                    vector.addElement(new CellRange(n6, n4, n7, n5));
                } else if (n > n6 || n + n2 - 1 < n7) {
                    if (n > n6 && n + n2 - 1 < n7) {
                        vector.addElement(new CellRange(n6, n4, n - 1, n5));
                        vector.addElement(new CellRange(n, n4, n7 - n2, n5));
                    } else if (n > n6) {
                        vector.addElement(new CellRange(n6, n4, n - 1, n5));
                    } else if (n + n2 - 1 < n7) {
                        vector.addElement(new CellRange(n, n4, n7 - n2, n5));
                    }
                }
                ++n3;
            }
            objectArray = new CellRange[vector.size()];
            vector.copyInto(objectArray);
        }
        return new TwoDSelection(oneDSelection, oneDSelection2, (CellRange[])objectArray);
    }

    public TwoDSelection addRows(int n, int n2) {
        OneDSelection oneDSelection = this.getColumnSelection();
        OneDSelection oneDSelection2 = this.getRowSelection().addItems(n, n2);
        CellRange[] cellRangeArray = this.getCellRanges();
        Object[] objectArray = null;
        if (cellRangeArray != null && cellRangeArray.length > 0) {
            Vector<CellRange> vector = new Vector<CellRange>();
            int n3 = 0;
            while (n3 < cellRangeArray.length) {
                int n4 = cellRangeArray[n3].getLowerLimit().column;
                int n5 = cellRangeArray[n3].getUpperLimit().column;
                int n6 = cellRangeArray[n3].getLowerLimit().row;
                int n7 = cellRangeArray[n3].getUpperLimit().row;
                if (n <= n6) {
                    vector.addElement(new CellRange(n4, n6 + n2, n5, n7 + n2));
                } else if (n > n7) {
                    vector.addElement(new CellRange(n4, n6, n5, n7));
                } else {
                    vector.addElement(new CellRange(n4, n6, n5, n - 1));
                    vector.addElement(new CellRange(n4, n + n2, n5, n7 + n2));
                }
                ++n3;
            }
            objectArray = new CellRange[vector.size()];
            vector.copyInto(objectArray);
        }
        return new TwoDSelection(oneDSelection, oneDSelection2, (CellRange[])objectArray);
    }

    public TwoDSelection removeRows(int n, int n2) {
        OneDSelection oneDSelection = this.getColumnSelection();
        OneDSelection oneDSelection2 = this.getRowSelection().removeItems(n, n2);
        CellRange[] cellRangeArray = this.getCellRanges();
        Object[] objectArray = null;
        if (cellRangeArray != null && cellRangeArray.length > 0) {
            Vector<CellRange> vector = new Vector<CellRange>();
            int n3 = 0;
            while (n3 < cellRangeArray.length) {
                int n4 = cellRangeArray[n3].getLowerLimit().column;
                int n5 = cellRangeArray[n3].getUpperLimit().column;
                int n6 = cellRangeArray[n3].getLowerLimit().row;
                int n7 = cellRangeArray[n3].getUpperLimit().row;
                if (n + n2 <= n6) {
                    vector.addElement(new CellRange(n4, n6 - n2, n5, n7 - n2));
                } else if (n > n7) {
                    vector.addElement(new CellRange(n4, n6, n5, n7));
                } else if (n > n6 || n + n2 - 1 < n7) {
                    if (n > n6 && n + n2 - 1 < n7) {
                        vector.addElement(new CellRange(n4, n6, n5, n - 1));
                        vector.addElement(new CellRange(n4, n, n5, n7 - n2));
                    } else if (n > n6) {
                        vector.addElement(new CellRange(n4, n6, n5, n - 1));
                    } else if (n + n2 - 1 < n7) {
                        vector.addElement(new CellRange(n4, n, n5, n7 - n2));
                    }
                }
                ++n3;
            }
            objectArray = new CellRange[vector.size()];
            vector.copyInto(objectArray);
        }
        return new TwoDSelection(oneDSelection, oneDSelection2, (CellRange[])objectArray);
    }

    public boolean contains(TwoDSelection twoDSelection) {
        return CellRange.cellRangesContain(this.getCellRanges(), twoDSelection.getCellRanges()) && this.getColumnSelection().contains(twoDSelection.getColumnSelection()) && this.getRowSelection().contains(twoDSelection.getRowSelection());
    }

    public boolean containsCell(Cell cell) {
        return this.containsCell(cell.column, cell.row);
    }

    public boolean containsCell(int n, int n2) {
        return CellRange.cellRangesContain(this.getCellRanges(), n, n2) || this.containsRow(n2) || this.containsColumn(n);
    }

    public boolean containsRow(int n) {
        return this.getRowSelection().contains(n);
    }

    public boolean containsColumn(int n) {
        return this.getColumnSelection().contains(n);
    }

    public boolean isEmpty() {
        return (this._cellRanges == null || this._cellRanges.length == 0) && this.getColumnSelection().isEmpty() && this.getRowSelection().isEmpty();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TwoDSelection)) {
            return false;
        }
        TwoDSelection twoDSelection = this.subtract((TwoDSelection)object);
        TwoDSelection twoDSelection2 = ((TwoDSelection)object).subtract(this);
        return twoDSelection.isEmpty() && twoDSelection2.isEmpty();
    }

    public int getSelectedCellCount() {
        CellRange[] cellRangeArray = this.getCellRanges();
        if (cellRangeArray == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < cellRangeArray.length) {
            Cell cell = cellRangeArray[n2].getUpperLimit();
            Cell cell2 = cellRangeArray[n2].getLowerLimit();
            n += (cell.column - cell2.column + 1) * (cell.row - cell2.row + 1);
            ++n2;
        }
        return n;
    }

    public Cell getSelectedCellAtIndex(int n) {
        CellRange[] cellRangeArray = this.getCellRanges();
        if (cellRangeArray == null) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < cellRangeArray.length) {
            Cell cell = cellRangeArray[n3].getUpperLimit();
            Cell cell2 = cellRangeArray[n3].getLowerLimit();
            int n4 = cell.column - cell2.column + 1;
            int n5 = cell.row - cell2.row + 1;
            if (n2 + n4 * n5 >= n + 1) {
                return new Cell(cell2.column + (n - n2) % n4, cell2.row + (n - n2) / n4);
            }
            n2 += n4 * n5;
            ++n3;
        }
        return null;
    }

    public String toString() {
        CellRange[] cellRangeArray;
        OneDSelection oneDSelection;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        boolean bl = false;
        OneDSelection oneDSelection2 = this.getColumnSelection();
        if (!oneDSelection2.isEmpty()) {
            stringBuffer.append("columns = " + oneDSelection2);
            bl = true;
        }
        if (!(oneDSelection = this.getRowSelection()).isEmpty()) {
            if (bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("rows = " + oneDSelection);
            bl = true;
        }
        if ((cellRangeArray = this.getCellRanges()) != null && cellRangeArray.length > 0) {
            if (bl) {
                stringBuffer.append(", ");
            }
            bl = true;
            stringBuffer.append("cells = [");
            int n = 0;
            while (n < cellRangeArray.length) {
                CellRange cellRange = cellRangeArray[n];
                stringBuffer.append("[" + cellRange.getLowerLimit() + ", " + cellRange.getUpperLimit() + "]");
                if (n != cellRangeArray.length - 1) {
                    stringBuffer.append(",");
                }
                ++n;
            }
            stringBuffer.append("]");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static final TwoDSelection getEmptySelection() {
        if (_emptySelection == null) {
            _emptySelection = new TwoDSelection();
        }
        return _emptySelection;
    }

    private void _setCellRanges(CellRange[] cellRangeArray) {
        this._cellRanges = cellRangeArray;
    }

    private void _setColumnSelection(OneDSelection oneDSelection) {
        this._columnSelection = oneDSelection;
    }

    private void _setRowSelection(OneDSelection oneDSelection) {
        this._rowSelection = oneDSelection;
    }

    private void _init(OneDSelection oneDSelection, OneDSelection oneDSelection2, CellRange[] cellRangeArray) {
        this._setColumnSelection(oneDSelection);
        this._setRowSelection(oneDSelection2);
        Object[] objectArray = null;
        if (cellRangeArray != null && cellRangeArray.length > 0) {
            objectArray = this._duplicateCellRangeArray(cellRangeArray);
            Sort.qSort(objectArray, objectArray.length, TwoDSelection._getCellRangeComparator());
        }
        this._setCellRanges((CellRange[])objectArray);
    }

    private static Comparator _getCellRangeComparator() {
        if (_cellRangeComparator == null) {
            _cellRangeComparator = new CellRangeComparator();
        }
        return _cellRangeComparator;
    }

    private CellRange[] _duplicateCellRangeArray(CellRange[] cellRangeArray) {
        if (cellRangeArray == null) {
            return null;
        }
        CellRange[] cellRangeArray2 = new CellRange[cellRangeArray.length];
        int n = 0;
        while (n < cellRangeArray.length) {
            try {
                if (cellRangeArray[n] instanceof CellRange) {
                    cellRangeArray2[n] = (CellRange)cellRangeArray[n].clone();
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            ++n;
        }
        return cellRangeArray2;
    }

    private static class CellRangeComparator
    implements Comparator {
        private CellRangeComparator() {
        }

        public int compare(Object object, Object object2) {
            CellRange cellRange = (CellRange)object;
            CellRange cellRange2 = (CellRange)object2;
            if (this._cellLT(cellRange.getLowerLimit(), cellRange2.getLowerLimit())) {
                return -1;
            }
            if (this._cellGT(cellRange.getLowerLimit(), cellRange2.getLowerLimit())) {
                return 1;
            }
            return 0;
        }

        private boolean _cellLT(Cell cell, Cell cell2) {
            return cell.row < cell2.row || cell.row == cell2.row && cell.column < cell2.column;
        }

        private boolean _cellGT(Cell cell, Cell cell2) {
            return cell.row > cell2.row || cell.row == cell2.row && cell.column > cell2.column;
        }
    }
}

