/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.selection;

import java.util.Enumeration;
import java.util.Vector;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.share.collection.Range;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.Sort;

public final class CellRange
implements Cloneable {
    private Cell _min;
    private Cell _max;
    private static CellRangeComparator _cellRangeComparator;

    public CellRange(int n, int n2) {
        this._init(n, n2, n, n2);
    }

    public CellRange(Cell cell) {
        this._init(cell.column, cell.row, cell.column, cell.row);
    }

    public CellRange(int n, int n2, int n3, int n4) {
        this._init(n, n2, n3, n4);
    }

    public CellRange(Cell cell, Cell cell2) {
        this._init(cell.column, cell.row, cell2.column, cell2.row);
    }

    public Object clone() throws CloneNotSupportedException {
        return new CellRange(this.getLowerLimit(), this.getUpperLimit());
    }

    public boolean equals(CellRange cellRange) {
        return this == cellRange || cellRange != null && cellRange.getLowerLimit().equals(this.getLowerLimit()) && cellRange.getUpperLimit().equals(this.getUpperLimit());
    }

    public Cell getLowerLimit() {
        return this._min;
    }

    public Cell getUpperLimit() {
        return this._max;
    }

    public final boolean inRange(Cell cell) {
        return this.inRange(cell.column, cell.row);
    }

    public boolean inRange(int n, int n2) {
        return n2 >= this._min.row && n2 <= this._max.row && n >= this._min.column && n <= this._max.column;
    }

    public String toString() {
        return "[[" + this._min.column + "," + this._min.row + "],[" + this._max.column + "," + this._max.row + "]]";
    }

    public static CellRange[] addCellRanges(CellRange[] cellRangeArray, CellRange[] cellRangeArray2) {
        Object object;
        int n;
        int n2 = cellRangeArray == null ? 0 : cellRangeArray.length;
        int n3 = n = cellRangeArray2 == null ? 0 : cellRangeArray2.length;
        if (n2 == 0 && n == 0) {
            return null;
        }
        if (n == 0) {
            CellRange[] cellRangeArray3 = new CellRange[n2];
            System.arraycopy(cellRangeArray, 0, cellRangeArray3, 0, n2);
            return cellRangeArray3;
        }
        if (n2 == 0) {
            CellRange[] cellRangeArray4 = new CellRange[n];
            System.arraycopy(cellRangeArray2, 0, cellRangeArray4, 0, n);
            return cellRangeArray4;
        }
        List list = new List();
        list.addArray(cellRangeArray);
        list.addArray(cellRangeArray2);
        Vector<CellRange> vector = new Vector<CellRange>();
        Node node = list.first;
        while (node != null) {
            CellRange cellRange = node.cellRange;
            Node node2 = node.next;
            while (node2 != null) {
                CellRange cellRange2 = node2.cellRange;
                CellRange._cellRangeDecompose(cellRange, cellRange2, vector);
                if (vector.size() == 0) {
                    list.remove(node);
                    vector.removeAllElements();
                    break;
                }
                if (vector.size() == 1) {
                    object = (CellRange)vector.elementAt(0);
                    vector.removeAllElements();
                    if (!((CellRange)object).equals(cellRange)) {
                        list.add(new Node((CellRange)object));
                        list.remove(node);
                        break;
                    }
                } else {
                    list.addVector(vector);
                    list.remove(node);
                    vector.removeAllElements();
                }
                node2 = node2.next;
            }
            node = node.next;
        }
        vector.removeAllElements();
        node = list.first;
        while (node != null) {
            vector.addElement(node.cellRange);
            node = node.next;
        }
        object = new CellRange[vector.size()];
        vector.copyInto((Object[])object);
        int n4 = ((Object[])object).length;
        Sort.qSort((Object[])object, n4, CellRange._getCellRangeComparator());
        return object;
    }

    public static CellRange[] subtractCellRanges(CellRange[] cellRangeArray, CellRange[] cellRangeArray2) {
        Object[] objectArray;
        int n;
        int n2 = cellRangeArray == null ? 0 : cellRangeArray.length;
        int n3 = n = cellRangeArray2 == null ? 0 : cellRangeArray2.length;
        if (n2 == 0 && n == 0) {
            return null;
        }
        if (n2 == 0) {
            return null;
        }
        if (n == 0) {
            CellRange[] cellRangeArray3 = new CellRange[n2];
            System.arraycopy(cellRangeArray, 0, cellRangeArray3, 0, n2);
            return cellRangeArray3;
        }
        Vector<CellRange> vector = new Vector<CellRange>();
        int n4 = 0;
        while (n4 < n2) {
            vector.addElement(cellRangeArray[n4]);
            ++n4;
        }
        int n5 = 0;
        while (n5 < cellRangeArray2.length) {
            objectArray = cellRangeArray2[n5];
            Vector vector2 = new Vector();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                CellRange cellRange = (CellRange)enumeration.nextElement();
                CellRange._cellRangeDecompose(cellRange, (CellRange)objectArray, vector2);
            }
            vector = vector2;
            ++n5;
        }
        objectArray = new CellRange[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static boolean cellRangesContain(CellRange[] cellRangeArray, int n, int n2) {
        if (cellRangeArray == null) {
            return false;
        }
        int n3 = 0;
        while (n3 < cellRangeArray.length) {
            if (cellRangeArray[n3].inRange(n, n2)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public static boolean cellRangesContain(CellRange[] cellRangeArray, CellRange[] cellRangeArray2) {
        if (cellRangeArray2 == null || cellRangeArray2.length == 0) {
            return true;
        }
        if (cellRangeArray == null || cellRangeArray.length == 0) {
            return false;
        }
        CellRange[] cellRangeArray3 = CellRange.subtractCellRanges(cellRangeArray2, cellRangeArray);
        return cellRangeArray3 == null || cellRangeArray3.length == 0;
    }

    public static Range[] columnRangesFromCellRanges(CellRange[] cellRangeArray) {
        Range[] rangeArray = null;
        if (cellRangeArray != null && cellRangeArray.length > 0) {
            rangeArray = new Range[cellRangeArray.length];
            int n = 0;
            while (n < cellRangeArray.length) {
                rangeArray[n] = new Range(cellRangeArray[n].getLowerLimit().column, cellRangeArray[n].getUpperLimit().column);
                ++n;
            }
        }
        return rangeArray;
    }

    public static Range[] rowRangesFromCellRanges(CellRange[] cellRangeArray) {
        Range[] rangeArray = null;
        if (cellRangeArray != null && cellRangeArray.length > 0) {
            rangeArray = new Range[cellRangeArray.length];
            int n = 0;
            while (n < cellRangeArray.length) {
                rangeArray[n] = new Range(cellRangeArray[n].getLowerLimit().row, cellRangeArray[n].getUpperLimit().row);
                ++n;
            }
        }
        return rangeArray;
    }

    private void _init(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        if (n3 < n) {
            n8 = n3;
            n7 = n;
        } else {
            n8 = n;
            n7 = n3;
        }
        if (n4 < n2) {
            n6 = n4;
            n5 = n2;
        } else {
            n5 = n4;
            n6 = n2;
        }
        this._min = new Cell(n8, n6);
        this._max = n5 == n6 && n7 == n8 ? this._min : new Cell(n7, n5);
    }

    private static CellRange _getValidRect(int n, int n2, int n3, int n4) {
        if (n <= n3 && n2 <= n4) {
            return new CellRange(n, n2, n3, n4);
        }
        return null;
    }

    private static void _cellRangeDecompose(CellRange cellRange, CellRange cellRange2, Vector vector) {
        Cell cell = cellRange.getLowerLimit();
        Cell cell2 = cellRange.getUpperLimit();
        Cell cell3 = cellRange2.getLowerLimit();
        Cell cell4 = cellRange2.getUpperLimit();
        if (cell2.column < cell3.column || cell2.row < cell3.row || cell.column > cell4.column || cell.row > cell4.row) {
            vector.addElement(new CellRange(cell, cell2));
        } else {
            CellRange cellRange3 = CellRange._getValidRect(cell.column, cell.row, cell2.column, cell3.row - 1);
            CellRange cellRange4 = CellRange._getValidRect(cell.column, cell4.row + 1, cell2.column, cell2.row);
            CellRange cellRange5 = CellRange._getValidRect(cell.column, cell3.row, cell3.column - 1, cell4.row);
            CellRange cellRange6 = CellRange._getValidRect(cell4.column + 1, cell3.row, cell2.column, cell4.row);
            if (cellRange3 != null) {
                vector.addElement(cellRange3);
            }
            if (cellRange4 != null) {
                vector.addElement(cellRange4);
            }
            if (cellRange5 != null) {
                vector.addElement(cellRange5);
            }
            if (cellRange6 != null) {
                vector.addElement(cellRange6);
            }
        }
    }

    private static Comparator _getCellRangeComparator() {
        if (_cellRangeComparator == null) {
            _cellRangeComparator = new CellRangeComparator();
        }
        return _cellRangeComparator;
    }

    private static class CellRangeComparator
    implements Comparator {
        private CellRangeComparator() {
        }

        public int compare(Object object, Object object2) {
            CellRange cellRange = (CellRange)object;
            CellRange cellRange2 = (CellRange)object2;
            if (this._cellLT(cellRange.getLowerLimit(), cellRange2.getLowerLimit())) {
                return -1;
            }
            if (this._cellGT(cellRange.getLowerLimit(), cellRange2.getLowerLimit())) {
                return 1;
            }
            return 0;
        }

        private boolean _cellLT(Cell cell, Cell cell2) {
            return cell.row < cell2.row || cell.row == cell2.row && cell.column < cell2.column;
        }

        private boolean _cellGT(Cell cell, Cell cell2) {
            return cell.row > cell2.row || cell.row == cell2.row && cell.column > cell2.column;
        }
    }

    private static class List {
        Node first;
        Node last;

        public void addArray(CellRange[] cellRangeArray) {
            int n = 0;
            while (n < cellRangeArray.length) {
                this.add(new Node(cellRangeArray[n]));
                ++n;
            }
        }

        public void addVector(Vector vector) {
            int n = 0;
            while (n < vector.size()) {
                this.add(new Node((CellRange)vector.elementAt(n)));
                ++n;
            }
        }

        public void add(Node node) {
            if (this.last == null || this.first == null) {
                this.last = node;
                this.first = node;
            } else {
                this.last.next = node;
                node.prev = this.last;
                node.next = null;
                this.last = node;
            }
        }

        public void remove(Node node) {
            if (this.first == null || this.last == null) {
                return;
            }
            if (this.first == node) {
                this.first = this.first.next;
                if (this.first != null) {
                    this.first.prev = null;
                }
            }
            if (this.last == node) {
                this.last = this.last.prev;
                if (this.last != null) {
                    this.last.next = null;
                }
            }
            if (node.prev != null) {
                node.prev.next = node.next;
            }
            if (node.next != null) {
                node.next.prev = node.prev;
            }
        }
    }

    private static class Node {
        CellRange cellRange;
        Node next;
        Node prev;

        public Node(CellRange cellRange) {
            this.cellRange = cellRange;
        }
    }
}

