/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.scrolling;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Dictionary;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.dnd.Autoscroll;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.util.ImmInsets;

public abstract class ScrollableComponent
extends LWComponent
implements Scrollable,
Autoscroll {
    private transient JViewport _viewport;
    private boolean _preferredSizeSet;

    protected ScrollableComponent() {
        this.setOpaque(true);
    }

    public final void invalidateCanvas() {
        boolean bl = this.isValid();
        if (!bl && !this.isShowing()) {
            return;
        }
        this.revalidate();
        this.repaint();
    }

    public void printPage(PaintContext paintContext, Dictionary dictionary, Graphics graphics) {
        this.paintCanvasInterior(graphics);
    }

    public Dimension getDocumentSize(PaintContext paintContext, Dictionary dictionary) {
        return this.getCanvasSize();
    }

    public final void repaintCanvas(int n, int n2, int n3, int n4) {
        this.repaintInterior(n, n2, n3, n4);
    }

    public final void paintImmediateCanvas(int n, int n2, int n3, int n4) {
        this.paintImmediateInterior(n, n2, n3, n4);
    }

    public final Point convertOuterToCanvas(int n, int n2) {
        ImmInsets immInsets = this.getBorderInsets();
        return new Point(n - immInsets.left, n2 - immInsets.top);
    }

    public final Point convertCanvasToOuter(int n, int n2) {
        ImmInsets immInsets = this.getBorderInsets();
        return new Point(n + immInsets.left, n2 + immInsets.top);
    }

    public final Point convertOuterToInterior(int n, int n2) {
        ImmInsets immInsets = this.getBorderInsets();
        return new Point(n - immInsets.left, n2 - immInsets.top);
    }

    public final Point convertInteriorToOuter(int n, int n2) {
        ImmInsets immInsets = this.getBorderInsets();
        return new Point(n + immInsets.left, n2 + immInsets.top);
    }

    public final Dimension convertInnerToOuterSize(Dimension dimension) {
        ImmInsets immInsets = this.getBorderInsets();
        dimension.width += immInsets.left + immInsets.right;
        dimension.height += immInsets.top + immInsets.bottom;
        return dimension;
    }

    public final Dimension convertInnerToOuterSize(int n, int n2) {
        return this.convertInnerToOuterSize(new Dimension(n, n2));
    }

    public final int getInnerWidth() {
        JViewport jViewport = this.getViewport();
        int n = jViewport != null ? jViewport.getWidth() : this.getWidth();
        ImmInsets immInsets = this.getBorderInsets();
        if ((n -= immInsets.left + immInsets.right) < 0) {
            n = 0;
        }
        return n;
    }

    public final int getInnerHeight() {
        JViewport jViewport = this.getViewport();
        int n = jViewport != null ? jViewport.getHeight() : this.getHeight();
        ImmInsets immInsets = this.getBorderInsets();
        if ((n -= immInsets.top + immInsets.bottom) < 0) {
            n = 0;
        }
        return n;
    }

    public final Dimension getInnerSize() {
        JViewport jViewport = this.getViewport();
        if (jViewport != null) {
            return jViewport.getExtentSize();
        }
        return new Dimension(this.getInnerWidth(), this.getInnerHeight());
    }

    public final Point getInnerOrigin() {
        ImmInsets immInsets = this.getBorderInsets();
        return new Point(immInsets.left, immInsets.top);
    }

    public final Rectangle getInnerBounds() {
        ImmInsets immInsets = this.getBorderInsets();
        return new Rectangle(immInsets.left, immInsets.top, this.getInnerWidth(), this.getInnerHeight());
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            int n3 = this.getVValueOfOffset(-rectangle.y);
            if (n2 < 0) {
                if (n3 > 0) {
                    --n3;
                }
            } else {
                ++n3;
            }
            if (n3 >= this.getVMaximum()) {
                n3 = this.getVMaximum() - 1;
            }
            int n4 = -this.getVOffsetOfValue(n3) - rectangle.y;
            if (n2 < 0) {
                n4 = -n4;
            }
            return n4;
        }
        int n5 = this.getHValueOfOffset(-rectangle.x);
        if (n2 < 0) {
            if (n5 > 0) {
                --n5;
            }
        } else {
            ++n5;
        }
        if (n5 >= this.getHMaximum()) {
            n5 = this.getHMaximum() - 1;
        }
        int n6 = -this.getHOffsetOfValue(n5) - rectangle.x;
        if (n2 < 0) {
            n6 = -n6;
        }
        return n6;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            int n3 = rectangle.height;
            n3 = n2 < 0 ? Math.min(rectangle.y, n3) : Math.min(this.getCanvasHeight() - (rectangle.height + rectangle.y), n3);
            return n3;
        }
        int n4 = rectangle.width;
        n4 = n2 < 0 ? Math.min(rectangle.x, n4) : Math.min(this.getCanvasWidth() - (rectangle.width + rectangle.x), n4);
        return n4;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (!this.isHScrollable()) {
            return true;
        }
        JViewport jViewport = this.getViewport();
        if (jViewport != null) {
            return jViewport.getWidth() >= this.getPreferredSize().width;
        }
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (!this.isVScrollable()) {
            return true;
        }
        JViewport jViewport = this.getViewport();
        if (jViewport != null) {
            return jViewport.getHeight() >= this.getPreferredSize().height;
        }
        return false;
    }

    public JViewport getViewport() {
        return this._viewport;
    }

    public final Rectangle getCanvasBounds() {
        return this.getScrollParent().getBounds();
    }

    public final Point getCanvasOrigin() {
        JViewport jViewport = this.getViewport();
        if (jViewport != null) {
            return this.getScrollParent().getLocation();
        }
        return new Point();
    }

    public final int getCanvasOriginX() {
        JViewport jViewport = this.getViewport();
        if (jViewport != null && this.isHScrollable()) {
            Component component = this.getScrollParent();
            if (component == this) {
                return this.getX();
            }
            return component.getLocation().x;
        }
        return 0;
    }

    public final int getCanvasOriginY() {
        JViewport jViewport = this.getViewport();
        if (jViewport != null && this.isVScrollable()) {
            Component component = this.getScrollParent();
            if (component == this) {
                return this.getY();
            }
            return component.getLocation().y;
        }
        return 0;
    }

    public final int getCanvasWidth() {
        return this.getWidth();
    }

    public final int getCanvasHeight() {
        return this.getHeight();
    }

    public final Dimension getCanvasSize() {
        return this.getSize();
    }

    public boolean isHScrollable() {
        return false;
    }

    public boolean isVScrollable() {
        return false;
    }

    public void setCanvasOrigin(int n, int n2) {
        JViewport jViewport = this.getViewport();
        if (jViewport != null) {
            jViewport.setViewPosition(new Point(-n, -n2));
        }
    }

    public void setCanvasBounds(int n, int n2, int n3, int n4) {
        JViewport jViewport = this.getViewport();
        if (jViewport != null) {
            this.setCanvasOrigin(n, n2);
            this.setCanvasSize(n3, n4);
        }
    }

    public final void clipCanvasToParents(Rectangle rectangle) {
        int n;
        ImmInsets immInsets = this.getBorderInsets();
        int n2 = this.getCanvasOriginX();
        int n3 = this.getCanvasOriginY();
        rectangle.x += n2 + immInsets.left;
        rectangle.y += n3 + immInsets.top;
        this.computeVisibleRect(rectangle);
        if (rectangle.x < immInsets.left) {
            rectangle.width -= immInsets.left - rectangle.x;
            rectangle.x = immInsets.left;
        }
        if (rectangle.y < immInsets.top) {
            rectangle.height -= immInsets.top - rectangle.y;
            rectangle.y = immInsets.top;
        }
        Dimension dimension = this.getInnerSize();
        int n4 = dimension.width - (rectangle.x - immInsets.left);
        if (rectangle.width > n4) {
            rectangle.width = n4;
        }
        if (rectangle.height > (n = dimension.height - (rectangle.y - immInsets.top))) {
            rectangle.height = n;
        }
        rectangle.x -= n2 + immInsets.left;
        rectangle.y -= n3 + immInsets.top;
    }

    public void addNotify() {
        Container container;
        super.addNotify();
        if ((this.isHScrollable() || this.isVScrollable()) && (container = this.getScrollParent().getParent()) instanceof JViewport) {
            this._viewport = (JViewport)container;
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this._viewport = null;
    }

    public void setPreferredSize(Dimension dimension) {
        this._preferredSizeSet = dimension != null;
        super.setPreferredSize(dimension);
    }

    public Dimension getPreferredSize() {
        if (this._preferredSizeSet) {
            return super.getPreferredSize();
        }
        Dimension dimension = this.layoutCanvas();
        ImmInsets immInsets = this.getBorderInsets();
        dimension.width += immInsets.left + immInsets.right;
        dimension.height += immInsets.top + immInsets.bottom;
        return dimension;
    }

    public final void layout() {
        super.layout();
        this.layoutCanvas();
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        ImmInsets immInsets = this.getBorderInsets();
        int n = immInsets.left;
        int n2 = immInsets.top;
        Shape shape = null;
        if (n != 0 || n2 != 0) {
            graphics.translate(n, n2);
        }
        if (!immInsets.equals(ImmInsets.getEmptyInsets())) {
            shape = graphics.getClip();
            graphics.clipRect(0, 0, this.getWidth() - n - immInsets.right, this.getHeight() - n2 - immInsets.bottom);
        }
        this.paintCanvasInterior(graphics);
        if (shape != null) {
            graphics.setClip(shape);
        }
        if (n != 0 || n2 != 0) {
            graphics.translate(-n, -n2);
        }
    }

    public Insets getAutoscrollInsets() {
        Insets insets = new Insets(0, 0, 0, 0);
        if (this.isHScrollable()) {
            insets.left = 8;
            insets.right = 8;
        }
        if (this.isVScrollable()) {
            insets.top = 8;
            insets.bottom = 8;
        }
        return insets;
    }

    public void autoscroll(Point point) {
        int n;
        int n2;
        Insets insets = this.getAutoscrollInsets();
        Dimension dimension = this.getSize();
        Point point2 = this.getCanvasOrigin();
        Rectangle rectangle = this.getInnerBounds();
        rectangle.x = -point2.x;
        rectangle.y = -point2.y;
        int n3 = point.x < insets.left ? -1 : (point.x >= dimension.width - insets.right ? 1 : 0);
        if (n3 != 0) {
            n2 = this.getScrollableUnitIncrement(rectangle, 0, n3);
            point2.x -= n3 * n2;
            point2.x = Math.max(point2.x, rectangle.width - this.getCanvasWidth());
        }
        if ((n = point.y < insets.top ? -1 : (point.y >= dimension.height - insets.bottom ? 1 : 0)) != 0) {
            n2 = this.getScrollableUnitIncrement(rectangle, 1, n);
            point2.y -= n * n2;
            point2.y = Math.max(point2.y, rectangle.height - this.getCanvasHeight());
        }
        this.setCanvasOrigin(point2.x, point2.y);
    }

    protected void paintCanvasInterior(Graphics graphics) {
    }

    protected int getHMaximum() {
        return this.getCanvasSize().width;
    }

    protected int getHValueOfOffset(int n) {
        return -n;
    }

    protected int getHOffsetOfValue(int n) {
        return -n;
    }

    protected int getVMaximum() {
        return this.getCanvasSize().height;
    }

    protected int getVOffsetOfValue(int n) {
        return -n;
    }

    protected int getVValueOfOffset(int n) {
        return -n;
    }

    protected Dimension layoutCanvas() {
        return new Dimension(0, 0);
    }

    public void setCanvasSize(int n, int n2) {
        JViewport jViewport = this.getViewport();
        if (jViewport != null) {
            jViewport.setViewSize(new Dimension(Math.max(n, this.getInnerWidth()), Math.max(n2, this.getInnerHeight())));
        }
    }

    protected final void makeCanvasGraphics(Graphics graphics) {
        if (graphics != null) {
            Rectangle rectangle = this.getInnerBounds();
            this.computeVisibleRect(rectangle);
            int n = this.getCanvasOriginX();
            int n2 = this.getCanvasOriginY();
            graphics.translate(rectangle.x + n, rectangle.y + n2);
            graphics.clipRect(-n, -n2, rectangle.width, rectangle.height);
        }
    }

    public final Graphics getCanvasGraphics() {
        Graphics graphics = this.getGraphics();
        this.makeCanvasGraphics(graphics);
        return graphics;
    }

    protected Component getScrollParent() {
        return this;
    }

    private boolean _isContainedBy(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle.x >= rectangle2.x && rectangle.y >= rectangle2.y && rectangle.x + rectangle.width <= rectangle2.x + rectangle2.width && rectangle.y + rectangle.height <= rectangle2.y + rectangle2.height;
    }

    private boolean _isDamaged() {
        return false;
    }
}

