/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.scrolling;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.button.ContinuousButtonModel;
import oracle.bali.ewt.elaf.EWTArrowBoxUI;
import oracle.bali.ewt.util.ImmInsets;

public class ArrowBox
extends LWComponent
implements Accessible {
    public static final int DISPLAY_AS_NEEDED = 0;
    public static final int DISPLAY_ALWAYS = 1;
    private static final ImmInsets _sBUTTON_INSETS = new ImmInsets(2, 2, 0, 0);
    private JViewport _viewPort;
    private Component _view;
    private Scrollable _scrollable;
    private int _orientation = -1;
    private int _displayPolicy = -1;
    private boolean _together;
    private AbstractButton _upButton;
    private AbstractButton _downButton;
    private ChangeListener _viewListener;

    public ArrowBox() {
        this(null);
    }

    public ArrowBox(Component component) {
        this(component, 0, 0, true);
    }

    public ArrowBox(Component component, int n, int n2, boolean bl) {
        this.setLayout(null);
        this._viewListener = new ViewListen();
        this.setOrientation(n);
        this.setViewportView(component);
        this.setDisplayPolicy(n2);
        this.setArrowsTogether(bl);
        this.updateUI();
    }

    public int getDisplayPolicy() {
        return this._displayPolicy;
    }

    public void setDisplayPolicy(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException();
        }
        this._displayPolicy = n;
        this._setButtonsVisible();
    }

    public int getOrientation() {
        return this._orientation;
    }

    public void setOrientation(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException();
        }
        if (this._orientation != n) {
            this._orientation = n;
            this._setButtonContents();
            this.revalidate();
            this.repaint();
        }
    }

    public void setViewportView(Component component) {
        if (component == this._view) {
            return;
        }
        this.getViewport().setView(null);
        this.getViewport().setView(component);
        this._view = component;
        this._scrollable = this._view instanceof Scrollable ? (Scrollable)((Object)component) : null;
        this.revalidate();
        this.repaint();
    }

    public Component getViewportView() {
        return this._view;
    }

    public JViewport getViewport() {
        if (this._viewPort == null) {
            this._viewPort = this.createViewport();
            this._viewPort.addChangeListener(this._viewListener);
            this.add(this._viewPort);
        }
        return this._viewPort;
    }

    public void setViewport(JViewport jViewport) {
        if (jViewport == this._viewPort) {
            return;
        }
        if (this._viewPort != null) {
            this.remove(this._viewPort);
            this._viewPort.setView(null);
            this._viewPort.removeChangeListener(this._viewListener);
        }
        this._viewPort = null;
        if (jViewport == null) {
            jViewport = this.createViewport();
        }
        this._viewPort = jViewport;
        if (this._viewPort != null) {
            this._viewPort.setView(this._view);
            this._viewPort.addChangeListener(this._viewListener);
            this.add(this._viewPort);
        }
        this.revalidate();
        this.repaint();
    }

    public boolean getArrowsTogether() {
        return this._together;
    }

    public void setArrowsTogether(boolean bl) {
        if (this._together != bl) {
            this._together = bl;
            this.revalidate();
            this.repaint();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleArrowBox();
        }
        return this.accessibleContext;
    }

    public void updateUI() {
        this.setUI((EWTArrowBoxUI)UIManager.getUI(this));
        this._setButtonContents();
    }

    public String getUIClassID() {
        return "EWTArrowBoxUI";
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this._view == null ? new Dimension() : this._view.getPreferredSize();
        return this._preferredSize(dimension);
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this._view == null ? new Dimension() : this._view.getMinimumSize();
        return this._preferredSize(dimension);
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        ImmInsets immInsets = this.getBorderInsets();
        dimension.width -= immInsets.left + immInsets.right;
        dimension.height -= immInsets.top + immInsets.bottom;
        this._setButtonsVisible();
        boolean bl = this._upButton.isVisible();
        if (!bl) {
            this._viewPort.setBounds(immInsets.left, immInsets.top, dimension.width, dimension.height);
        } else {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            ImmInsets immInsets2 = _sBUTTON_INSETS;
            Dimension dimension2 = this._upButton.getPreferredSize();
            if (this.getOrientation() == 0) {
                n10 = dimension2.width;
                n9 = dimension.height;
                n8 = dimension.width - 2 * n10 - immInsets2.left;
                n7 = dimension.height;
                n5 = n6 = immInsets.top;
                n4 = immInsets.top;
                if (this.getArrowsTogether()) {
                    n3 = immInsets.left;
                    if (this.getActualReadingDirection() == 1) {
                        n2 = n3 + n8 + immInsets2.left;
                        n = n2 + n10 + immInsets2.right;
                    } else {
                        n = n8 + immInsets2.left;
                        n2 = n + n10 + immInsets2.right;
                    }
                } else if (this.getActualReadingDirection() == 1) {
                    n2 = immInsets.left;
                    n3 = n2 + n10 + immInsets2.right;
                    n = n3 + n8 + immInsets2.left;
                } else {
                    n = immInsets2.left;
                    n3 = n + n10 + immInsets2.right;
                    n2 = dimension.width - immInsets2.left - n10;
                }
            } else {
                n10 = dimension.width;
                n9 = dimension2.height;
                n8 = dimension.width;
                n7 = dimension.height - 2 * n9 - immInsets2.top;
                n2 = n = immInsets.left;
                n3 = immInsets.left;
                if (this.getArrowsTogether()) {
                    n4 = immInsets.top;
                    n5 = n4 + n7 + immInsets2.top;
                    n6 = n5 + n9 + immInsets2.bottom;
                } else {
                    n5 = immInsets.top;
                    n4 = n5 + n9 + immInsets2.bottom;
                    n6 = n4 + n7 + immInsets2.top;
                }
            }
            this._upButton.setBounds(n2, n5, n10, n9);
            this._downButton.setBounds(n, n6, n10, n9);
            this._viewPort.setBounds(n3, n4, n8, n7);
        }
        if (!this._view.isValid()) {
            this._view.doLayout();
        }
    }

    protected JViewport createViewport() {
        return new JViewport();
    }

    private void _configureButtons() {
        JViewport jViewport = this.getViewport();
        Rectangle rectangle = jViewport.getViewRect();
        Dimension dimension = jViewport.getView().getPreferredSize();
        if (this.getOrientation() == 0) {
            this._upButton.setEnabled(rectangle.x != 0);
            this._downButton.setEnabled(rectangle.x + rectangle.width < dimension.width);
        } else {
            this._upButton.setEnabled(rectangle.y != 0);
            this._downButton.setEnabled(rectangle.y + rectangle.height < dimension.height);
        }
    }

    private void _setButtonsVisible() {
        boolean bl;
        if (this._upButton == null) {
            return;
        }
        if (this.getDisplayPolicy() == 1) {
            bl = true;
        } else {
            Dimension dimension;
            Component component = this.getViewportView();
            Dimension dimension2 = dimension = component == null ? new Dimension() : component.getPreferredSize();
            boolean bl2 = this.getOrientation() == 0 ? dimension.width >= this.getWidth() : (bl = dimension.height >= this.getHeight());
        }
        if (bl != this._upButton.isVisible()) {
            this._upButton.setVisible(bl);
            this._downButton.setVisible(bl);
            this.revalidate();
            this.repaint();
        }
    }

    private Dimension _preferredSize(Dimension dimension) {
        Dimension dimension2 = new Dimension();
        Dimension dimension3 = this._upButton.getPreferredSize();
        ImmInsets immInsets = _sBUTTON_INSETS;
        dimension3.width += immInsets.left + immInsets.right;
        dimension3.height += immInsets.top + immInsets.bottom;
        if (this.getOrientation() == 0) {
            dimension2.width = 2 * dimension3.width + dimension.width;
            dimension2.height = Math.max(dimension3.height, dimension.height);
        } else {
            dimension2.width = Math.max(dimension3.width, dimension.width);
            dimension2.height = 2 * dimension3.height + dimension.height;
        }
        ImmInsets immInsets2 = this.getBorderInsets();
        dimension2.width += immInsets2.left + immInsets2.right;
        dimension2.height += immInsets2.top + immInsets2.bottom;
        return dimension2;
    }

    private EWTArrowBoxUI _getEWTArrowBoxUI() {
        return (EWTArrowBoxUI)this.ui;
    }

    private void _setButtonContents() {
        if (this._getEWTArrowBoxUI() == null) {
            return;
        }
        if (this._upButton != null) {
            this.remove(this._upButton);
        }
        if (this._downButton != null) {
            this.remove(this._downButton);
        }
        this._upButton = this._getEWTArrowBoxUI().getDecrementButton(this);
        this._upButton.setModel(new Pulser(this._upButton));
        this._downButton = this._getEWTArrowBoxUI().getIncrementButton(this);
        this._downButton.setModel(new Pulser(this._downButton));
        this.add(this._upButton);
        this.add(this._downButton);
    }

    private void _scrollView(boolean bl) {
        JViewport jViewport = this.getViewport();
        Component component = jViewport.getView();
        Dimension dimension = component.getPreferredSize();
        Rectangle rectangle = jViewport.getViewRect();
        if (this.getOrientation() == 0) {
            if (bl) {
                rectangle.x = this._scrollable == null ? --rectangle.x : (rectangle.x -= this._scrollable.getScrollableUnitIncrement(rectangle, 0, -1));
                if (rectangle.x < 0) {
                    rectangle.x = 0;
                }
            } else {
                rectangle.x = this._scrollable == null ? ++rectangle.x : (rectangle.x += this._scrollable.getScrollableUnitIncrement(rectangle, 0, 1));
                if (rectangle.x + rectangle.width > dimension.width) {
                    rectangle.x = dimension.width - rectangle.width;
                }
            }
        } else if (bl) {
            rectangle.y = this._scrollable == null ? --rectangle.y : (rectangle.y -= this._scrollable.getScrollableUnitIncrement(rectangle, 1, -1));
            if (rectangle.y < 0) {
                rectangle.y = 0;
            }
        } else {
            rectangle.y = this._scrollable == null ? ++rectangle.y : (rectangle.y += this._scrollable.getScrollableUnitIncrement(rectangle, 1, 1));
            if (rectangle.y + rectangle.height > dimension.height) {
                rectangle.y = dimension.height - rectangle.height;
            }
        }
        jViewport.setViewPosition(new Point(rectangle.x, rectangle.y));
    }

    private class AccessibleArrowBox
    extends JComponent.AccessibleJComponent {
        private AccessibleArrowBox() {
            super(ArrowBox.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SCROLL_PANE;
        }
    }

    private class ViewListen
    implements ChangeListener {
        private ViewListen() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ArrowBox.this._configureButtons();
        }
    }

    private class Pulser
    extends ContinuousButtonModel {
        protected Pulser(AbstractButton abstractButton) {
            super(abstractButton);
        }

        protected void processPulse() {
            boolean bl = this.getButton() == ArrowBox.this._upButton;
            ArrowBox.this._scrollView(bl);
        }
    }
}

