/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.print;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Dictionary;
import javax.swing.JComponent;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.painter.JPaintContext;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.PaintContextProxy;
import oracle.bali.ewt.print.PrinterUtils;
import oracle.bali.share.util.IntegerUtils;

public class PrintPaintContext
extends PaintContextProxy {
    private JComponent _printee;
    private Dictionary _printProperties;
    private transient PaintContext _printContext;
    private transient Graphics _printGraphics;
    private transient int _currPage;
    private transient int _currXPage;
    private transient int _currYPage;

    public PrintPaintContext(JComponent jComponent, Dictionary dictionary) {
        this._printee = jComponent;
        this._printProperties = dictionary;
    }

    public void updatePage(Graphics graphics, int n, int n2, int n3) {
        if (graphics == null) {
            throw new IllegalArgumentException();
        }
        this._printContext = this._printee instanceof LWComponent ? ((LWComponent)this._printee).getPrintPaintContext(graphics) : new JPaintContext(this._printee);
        this._printGraphics = graphics;
        this._currPage = n;
        this._currXPage = n2;
        this._currYPage = n3;
    }

    public Color getSurroundingColor() {
        return Color.white;
    }

    public Object getPaintData(Object object) {
        if (object == PrinterUtils.PAGE_KEY) {
            return IntegerUtils.getInteger(this._currPage);
        }
        if (object == PrinterUtils.XYPAGE_KEY) {
            return new Point(this._currXPage, this._currYPage);
        }
        Object object2 = null;
        if (this._printProperties != null) {
            object2 = this._printProperties.get(object);
        }
        if (object2 == null) {
            object2 = this.getPaintContext().getPaintData(object);
        }
        return object2;
    }

    protected PaintContext getPaintContext() {
        return this._printContext;
    }
}

