/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.print;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JTabbedPane;
import oracle.bali.ewt.imageCanvas.ImageCanvas;
import oracle.bali.ewt.print.DebugPrintGraphics;
import oracle.bali.ewt.scrolling.EWTScrollPane;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.util.IntegerUtils;

public class DebugPrintJob
extends PrintJob {
    private static final double _PAGE_WIDTH_INCHES = 8.5;
    private static final double _PAGE_HEIGHT_INCHES = 11.0;
    private static final double _END_HARDWARE_MARGIN_INCHES = 0.125;
    private static final double _EDGE_HARDWARE_MARGIN_INCHES = 0.125;
    private Frame _parentFrame;
    private String _jobName;
    private Vector _pageVector = new Vector();
    private boolean _isEnded;

    public DebugPrintJob(Frame frame, String string) {
        this._parentFrame = frame;
        this._jobName = string;
    }

    public Graphics getGraphics() {
        if (this._isEnded) {
            throw new IllegalStateException();
        }
        Dimension dimension = this.getPageDimension();
        DebugPrintGraphics debugPrintGraphics = new DebugPrintGraphics(dimension.width, dimension.height, this);
        this._pageVector.addElement(debugPrintGraphics);
        int n = this.getPageResolution();
        int n2 = (int)((double)n * 0.125);
        int n3 = (int)((double)n * 0.125);
        ((Graphics)debugPrintGraphics).clipRect(n2, n3, dimension.width - 2 * n2, dimension.height - 2 * n3);
        return debugPrintGraphics;
    }

    public Dimension getPageDimension() {
        return new Dimension((int)(8.5 * (double)this.getPageResolution()), (int)(11.0 * (double)this.getPageResolution()));
    }

    public int getPageResolution() {
        return Toolkit.getDefaultToolkit().getScreenResolution();
    }

    public boolean lastPageFirst() {
        return false;
    }

    public void end() {
        if (!this._isEnded) {
            Object object;
            this._isEnded = true;
            JTabbedPane jTabbedPane = new JTabbedPane();
            Vector vector = this._pageVector;
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                object = (DebugPrintGraphics)vector.elementAt(n2);
                ImageCanvas imageCanvas = new ImageCanvas(((DebugPrintGraphics)object).getGraphicsImage());
                jTabbedPane.addTab(IntegerUtils.getString(n2 + 1), new EWTScrollPane(imageCanvas));
                ++n2;
            }
            object = new JDialog(this._parentFrame, this._jobName);
            ((JDialog)object).getContentPane().add("Center", jTabbedPane);
            ((Window)object).pack();
            ((JDialog)object).setDefaultCloseOperation(2);
            WindowUtils.centerWindow((Window)object, this._parentFrame);
            ((Component)object).setVisible(true);
        }
    }
}

